/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Random;
import org.z3950.zing.cql.CQLAndNode;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLNotNode;
import org.z3950.zing.cql.CQLOrNode;
import org.z3950.zing.cql.CQLRelation;
import org.z3950.zing.cql.CQLTermNode;
import org.z3950.zing.cql.MissingParameterException;
import org.z3950.zing.cql.ModifierSet;

public class CQLGenerator {
    private Properties params;
    private Random rnd;
    private static boolean DEBUG = false;

    public CQLGenerator(Properties params) {
        this.params = params;
        String seed = params.getProperty("seed");
        this.rnd = seed != null ? new Random(new Long(seed)) : new Random();
    }

    private static void debug(String str) {
        if (DEBUG) {
            System.err.println("DEBUG: " + str);
        }
    }

    public CQLNode generate() throws MissingParameterException {
        return this.generate_cql_query();
    }

    private CQLNode generate_cql_query() throws MissingParameterException {
        if (!this.maybe("complexQuery")) {
            return this.generate_search_clause();
        }
        CQLNode node1 = this.generate_cql_query();
        CQLNode node2 = this.generate_search_clause();
        if (!this.maybe("proxOp")) {
            switch (this.rnd.nextInt(3)) {
                case 0: {
                    return new CQLAndNode(node1, node2, new ModifierSet("and"));
                }
                case 1: {
                    return new CQLOrNode(node1, node2, new ModifierSet("or"));
                }
                case 2: {
                    return new CQLNotNode(node1, node2, new ModifierSet("not"));
                }
            }
        }
        return this.generate_search_clause();
    }

    private CQLNode generate_search_clause() throws MissingParameterException {
        if (this.maybe("complexClause")) {
            return this.generate_cql_query();
        }
        String index = this.generate_index();
        CQLRelation relation = this.generate_relation();
        String term = this.generate_term();
        return new CQLTermNode(index, relation, term);
    }

    private String generate_index() {
        String index = "";
        if (this.rnd.nextInt(2) == 0) {
            switch (this.rnd.nextInt(3)) {
                case 0: {
                    index = "dc.author";
                    break;
                }
                case 1: {
                    index = "dc.title";
                    break;
                }
                case 2: {
                    index = "dc.subject";
                }
            }
        } else {
            switch (this.rnd.nextInt(4)) {
                case 0: {
                    index = "bath.author";
                    break;
                }
                case 1: {
                    index = "bath.title";
                    break;
                }
                case 2: {
                    index = "bath.subject";
                    break;
                }
                case 3: {
                    index = "foo>bar";
                }
            }
        }
        return index;
    }

    private CQLRelation generate_relation() throws MissingParameterException {
        String base = this.generate_base_relation();
        CQLRelation rel = new CQLRelation(base);
        return rel;
    }

    private String generate_base_relation() throws MissingParameterException {
        if (this.maybe("equalsRelation")) {
            return "=";
        }
        if (this.maybe("numericRelation")) {
            return this.generate_numeric_relation();
        }
        switch (this.rnd.nextInt(3)) {
            case 0: {
                return "within";
            }
            case 1: {
                return "all";
            }
            case 2: {
                return "any";
            }
        }
        return "";
    }

    private String generate_term() {
        switch (this.rnd.nextInt(10)) {
            case 0: {
                return "cat";
            }
            case 1: {
                return "\"cat\"";
            }
            case 2: {
                return "comp.os.linux";
            }
            case 3: {
                return "xml:element";
            }
            case 4: {
                return "<xml.element>";
            }
            case 5: {
                return "prox/word/>=/5";
            }
            case 6: {
                return "";
            }
            case 7: {
                return "frog fish";
            }
            case 8: {
                return "the complete dinosaur";
            }
            case 9: {
                return "foo*bar";
            }
        }
        return "";
    }

    private String generate_numeric_relation() {
        switch (this.rnd.nextInt(6)) {
            case 0: {
                return "<";
            }
            case 1: {
                return ">";
            }
            case 2: {
                return "<=";
            }
            case 3: {
                return ">=";
            }
            case 4: {
                return "<>";
            }
            case 5: {
                return "=";
            }
        }
        return "";
    }

    boolean maybe(String param) throws MissingParameterException {
        double threshhold;
        String probability = this.params.getProperty(param);
        if (probability == null) {
            throw new MissingParameterException(param);
        }
        double dice = this.rnd.nextDouble();
        boolean res = dice < (threshhold = new Double(probability).doubleValue());
        CQLGenerator.debug("dice=" + String.valueOf(dice).substring(0, 8) + " vs. " + threshhold + "='" + param + "': " + res);
        return res;
    }

    public static void main(String[] args) throws Exception {
        String configFile;
        FileInputStream f;
        if (args.length % 2 != 1) {
            System.err.println("Usage: CQLGenerator <props-file> [<name> <value>]...");
            System.exit(1);
        }
        if ((f = new FileInputStream(configFile = args[0])) == null) {
            throw new FileNotFoundException(configFile);
        }
        Properties params = new Properties();
        params.load(f);
        ((InputStream)f).close();
        for (int i = 1; i < args.length; i += 2) {
            params.setProperty(args[i], args[i + 1]);
        }
        CQLGenerator generator = new CQLGenerator(params);
        CQLNode tree = generator.generate();
        System.out.println(tree.toCQL());
    }
}

