/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;

class CQLLexer
extends StreamTokenizer {
    public static final int TT_LE = 1000;
    public static final int TT_GE = 1001;
    public static final int TT_NE = 1002;
    public static final int TT_EQEQ = 1003;
    public static final int TT_AND = 1004;
    public static final int TT_OR = 1005;
    public static final int TT_NOT = 1006;
    public static final int TT_PROX = 1007;
    public static final int TT_SORTBY = 1008;
    private Keyword[] keywords = new Keyword[]{new Keyword(1004, "and"), new Keyword(1005, "or"), new Keyword(1006, "not"), new Keyword(1007, "prox"), new Keyword(1008, "sortby")};
    private static int TT_UNDEFINED = -1000;
    private int saved_ttype = TT_UNDEFINED;
    private double saved_nval;
    private String saved_sval;
    private static boolean DEBUG;

    CQLLexer(String cql, boolean lexdebug) {
        this(new StringReader(cql), lexdebug);
    }

    CQLLexer(Reader cql, boolean lexdebug) {
        super(cql);
        this.wordChars(33, 64);
        this.wordChars(91, 96);
        this.quoteChar(34);
        this.ordinaryChar(61);
        this.ordinaryChar(60);
        this.ordinaryChar(62);
        this.ordinaryChar(47);
        this.ordinaryChar(40);
        this.ordinaryChar(41);
        this.ordinaryChar(46);
        this.wordChars(46, 46);
        this.wordChars(39, 39);
        this.ordinaryChar(45);
        this.wordChars(45, 45);
        this.ordinaryChars(48, 57);
        this.wordChars(48, 57);
        DEBUG = lexdebug;
    }

    private static void debug(String str) {
        if (DEBUG) {
            System.err.println("LEXDEBUG: " + str);
        }
    }

    private void halfDecentPushBack() {
        this.saved_ttype = this.ttype;
        this.saved_nval = this.nval;
        this.saved_sval = this.sval;
    }

    @Override
    public int nextToken() throws IOException {
        if (this.saved_ttype != TT_UNDEFINED) {
            this.ttype = this.saved_ttype;
            this.nval = this.saved_nval;
            this.sval = this.saved_sval;
            this.saved_ttype = TT_UNDEFINED;
            CQLLexer.debug("using saved ttype=" + this.ttype + ", " + "nval=" + this.nval + ", sval='" + this.sval + "'");
            return this.ttype;
        }
        this.underlyingNextToken();
        if (this.ttype == 60) {
            CQLLexer.debug("token starts with '<' ...");
            this.underlyingNextToken();
            if (this.ttype == 61) {
                CQLLexer.debug("token continues with '=' - it's '<='");
                this.ttype = 1000;
            } else if (this.ttype == 62) {
                CQLLexer.debug("token continues with '>' - it's '<>'");
                this.ttype = 1002;
            } else {
                CQLLexer.debug("next token is " + this.render() + " (pushed back)");
                this.halfDecentPushBack();
                this.ttype = 60;
                CQLLexer.debug("AFTER: ttype is now " + this.ttype + " - " + this.render());
            }
        } else if (this.ttype == 62) {
            CQLLexer.debug("token starts with '>' ...");
            this.underlyingNextToken();
            if (this.ttype == 61) {
                CQLLexer.debug("token continues with '=' - it's '>='");
                this.ttype = 1001;
            } else {
                CQLLexer.debug("next token is " + this.render() + " (pushed back)");
                this.halfDecentPushBack();
                this.ttype = 62;
                CQLLexer.debug("AFTER: ttype is now " + this.ttype + " - " + this.render());
            }
        } else if (this.ttype == 61) {
            CQLLexer.debug("token starts with '=' ...");
            this.underlyingNextToken();
            if (this.ttype == 61) {
                CQLLexer.debug("token continues with '=' - it's '=='");
                this.ttype = 1003;
            } else {
                CQLLexer.debug("next token is " + this.render() + " (pushed back)");
                this.halfDecentPushBack();
                this.ttype = 61;
                CQLLexer.debug("AFTER: ttype is now " + this.ttype + " - " + this.render());
            }
        }
        CQLLexer.debug("done nextToken(): ttype=" + this.ttype + ", " + "nval=" + this.nval + ", " + "sval='" + this.sval + "'" + " (" + this.render() + ")");
        return this.ttype;
    }

    public int underlyingNextToken() throws IOException {
        super.nextToken();
        if (this.ttype == -3) {
            for (int i = 0; i < this.keywords.length; ++i) {
                if (!this.sval.equalsIgnoreCase(this.keywords[i].keyword)) continue;
                this.ttype = this.keywords[i].token;
            }
        }
        return this.ttype;
    }

    String render() {
        return this.render(this.ttype, true);
    }

    String render(int token, boolean quoteChars) {
        if (token == -1) {
            return "EOF";
        }
        if (token == -2) {
            if (this.nval == (double)((int)this.nval)) {
                return new Integer((int)this.nval).toString();
            }
            return new Double(this.nval).toString();
        }
        if (token == -3) {
            return "word: " + this.sval;
        }
        if (token == 34) {
            return "string: \"" + this.sval + "\"";
        }
        if (token == 1000) {
            return "<=";
        }
        if (token == 1001) {
            return ">=";
        }
        if (token == 1002) {
            return "<>";
        }
        if (token == 1003) {
            return "==";
        }
        for (int i = 0; i < this.keywords.length; ++i) {
            if (token != this.keywords[i].token) continue;
            return this.keywords[i].keyword;
        }
        String res = String.valueOf((char)token);
        if (quoteChars) {
            res = "'" + res + "'";
        }
        return res;
    }

    public static void main(String[] args) throws Exception {
        int token;
        String cql;
        if (args.length > 1) {
            System.err.println("Usage: CQLLexer [<CQL-query>]");
            System.err.println("If unspecified, query is read from stdin");
            System.exit(1);
        }
        if (args.length == 1) {
            cql = args[0];
        } else {
            byte[] bytes = new byte[10000];
            try {
                int nbytes = System.in.read(bytes);
            }
            catch (IOException ex) {
                System.err.println("Can't read query: " + ex.getMessage());
                System.exit(2);
            }
            cql = new String(bytes);
        }
        CQLLexer lexer = new CQLLexer(cql, true);
        while ((token = lexer.nextToken()) != -1) {
        }
    }

    private class Keyword {
        int token;
        String keyword;

        Keyword(int token, String keyword) {
            this.token = token;
            this.keyword = keyword;
        }
    }
}

