/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.z3950.zing.cql.CQLPrefix;
import org.z3950.zing.cql.ModifierSet;
import org.z3950.zing.cql.PQFTranslationException;
import org.z3950.zing.cql.XCQLBuilder;

public abstract class CQLNode {
    protected static final int UNIVERSAL = 0;
    protected static final int APPLICATION = 1;
    protected static final int CONTEXT = 2;
    protected static final int PRIVATE = 3;
    protected static final int PRIMITIVE = 0;
    protected static final int CONSTRUCTED = 1;
    public static final byte BOOLEAN = 1;
    public static final byte INTEGER = 2;
    public static final byte BITSTRING = 3;
    public static final byte OCTETSTRING = 4;
    public static final byte NULL = 5;
    public static final byte OBJECTIDENTIFIER = 6;
    public static final byte OBJECTDESCRIPTOR = 7;
    public static final byte EXTERNAL = 8;
    public static final byte ENUMERATED = 10;
    public static final byte SEQUENCE = 16;
    public static final byte SET = 17;
    public static final byte VISIBLESTRING = 26;
    public static final byte GENERALSTRING = 27;
    private static final Map<String, byte[]> madeOIDs = new HashMap<String, byte[]>(10);

    public String getResultSetName() {
        return null;
    }

    public String toXCQL() {
        StringBuilder sb = new StringBuilder();
        this.toXCQLInternal(new XCQLBuilder(sb), 0);
        return sb.toString();
    }

    void toXCQLInternal(XCQLBuilder b, int level) {
        this.toXCQLInternal(b, level, null, null);
    }

    abstract void toXCQLInternal(XCQLBuilder var1, int var2, List<CQLPrefix> var3, List<ModifierSet> var4);

    static void renderPrefixes(XCQLBuilder b, int level, List<CQLPrefix> prefixes) {
        if (prefixes == null || prefixes.size() == 0) {
            return;
        }
        b.indent(level).append("<prefixes>\n");
        for (int i = 0; i < prefixes.size(); ++i) {
            CQLPrefix p = prefixes.get(i);
            b.indent(level + 1).append("<prefix>\n");
            if (p.name != null) {
                b.indent(level + 2).append("<name>").append(p.name).append("</name>\n");
            }
            b.indent(level + 2).append("<identifier>").append(p.identifier).append("</identifier>\n");
            b.indent(level + 1).append("</prefix>\n");
        }
        b.indent(level).append("</prefixes>\n");
    }

    static void renderSortKeys(XCQLBuilder b, int level, List<ModifierSet> sortkeys) {
        if (sortkeys == null || sortkeys.size() == 0) {
            return;
        }
        b.indent(level).append("<sortKeys>\n");
        for (int i = 0; i < sortkeys.size(); ++i) {
            ModifierSet key = sortkeys.get(i);
            key.toXCQLInternal(b, level + 1, "key", "index");
        }
        b.indent(level).append("</sortKeys>\n");
    }

    public abstract String toCQL();

    public abstract String toPQF(Properties var1) throws PQFTranslationException;

    public abstract byte[] toType1BER(Properties var1) throws PQFTranslationException;

    protected static final int putTag(int asn1class, int fldid, int form, byte[] record, int offset) {
        if (fldid < 31) {
            record[offset++] = (byte)(fldid + asn1class * 64 + form * 32);
        } else {
            record[offset++] = (byte)(31 + asn1class * 64 + form * 32);
            if (fldid < 128) {
                record[offset++] = (byte)fldid;
            } else {
                record[offset++] = (byte)(128 + fldid / 128);
                record[offset++] = (byte)(fldid % 128);
            }
        }
        return offset;
    }

    static final int putLen(int len, byte[] record, int offset) {
        if (len < 128) {
            record[offset++] = (byte)len;
        } else {
            int t;
            record[offset] = (byte)(CQLNode.lenLen(len) - 1);
            for (t = record[offset]; t > 0; --t) {
                record[offset + t] = (byte)(len & 0xFF);
                len >>= 8;
            }
            t = offset;
            offset += (record[offset] & 0xFF) + 1;
            int n = t;
            record[n] = (byte)(record[n] + 128);
        }
        return offset;
    }

    protected static final int lenLen(int length) {
        return length < 128 ? 1 : (length < 256 ? 2 : ((long)length < 65536L ? 3 : 4));
    }

    protected static final int numLen(long num) {
        long l = num = num < 0L ? -num : num;
        return num < 128L ? 1 : (num < 32768L ? 2 : (num < 0x800000L ? 3 : (num < 0x80000000L ? 4 : (num < 0x8000000000L ? 5 : (num < 0x800000000000L ? 6 : (num < 0x80000000000000L ? 7 : 8))))));
    }

    protected static final int putNum(long num, byte[] record, int offset) {
        int cnt = CQLNode.numLen(num);
        for (int count = cnt - 1; count >= 0; --count) {
            record[offset + count] = (byte)(num & 0xFFL);
            num >>= 8;
        }
        return offset + cnt;
    }

    protected static final byte[] makeOID(String oid) {
        int offset = 0;
        int oidOffset = 0;
        byte[] o = madeOIDs.get(oid);
        if (o == null) {
            o = new byte[100];
            while (oidOffset < oid.length() && Character.isDigit(oid.charAt(oidOffset))) {
                if (offset > 90) {
                    return null;
                }
                int dot = oid.indexOf(46, oidOffset);
                if (dot == -1) {
                    dot = oid.length();
                }
                int value = Integer.parseInt(oid.substring(oidOffset, dot));
                if (offset == 0) {
                    if (dot == -1) {
                        return null;
                    }
                    oidOffset = dot + 1;
                    if ((dot = oid.indexOf(46, oidOffset)) == -1) {
                        dot = oid.length();
                    }
                    value = value * 40 + Integer.parseInt(oid.substring(oidOffset, dot));
                }
                if (value < 128) {
                    o[offset++] = (byte)value;
                } else {
                    int count = 0;
                    byte[] bits = new byte[12];
                    while (value != 0) {
                        bits[count++] = (byte)(value & 0x7F);
                        value >>= 7;
                    }
                    while (--count > 0) {
                        o[offset++] = (byte)(bits[count] | 0x80);
                    }
                    o[offset++] = bits[count];
                }
                dot = oid.indexOf(46, oidOffset);
                if (dot == -1) break;
                oidOffset = dot + 1;
            }
            byte[] ptr = new byte[offset];
            System.arraycopy(o, 0, ptr, 0, offset);
            madeOIDs.put(oid, ptr);
            return ptr;
        }
        return o;
    }

    public static final byte[] makeQuery(CQLNode root, Properties properties) throws PQFTranslationException {
        byte[] rpnStructure = root.toType1BER(properties);
        byte[] qry = new byte[rpnStructure.length + 100];
        int offset = 0;
        offset = CQLNode.putTag(2, 1, 1, qry, offset);
        qry[offset++] = -128;
        offset = CQLNode.putTag(0, 6, 0, qry, offset);
        byte[] oid = CQLNode.makeOID("1.2.840.10003.3.1");
        offset = CQLNode.putLen(oid.length, qry, offset);
        System.arraycopy(oid, 0, qry, offset, oid.length);
        System.arraycopy(rpnStructure, 0, qry, offset += oid.length, rpnStructure.length);
        offset += rpnStructure.length;
        qry[offset++] = 0;
        qry[offset++] = 0;
        byte[] q = new byte[offset];
        System.arraycopy(qry, 0, q, 0, offset);
        return q;
    }

    public String toString() {
        return this.toCQL();
    }
}

