/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.z3950.zing.cql.CQLAndNode;
import org.z3950.zing.cql.CQLLexer;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLNotNode;
import org.z3950.zing.cql.CQLOrNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLPrefixNode;
import org.z3950.zing.cql.CQLProxNode;
import org.z3950.zing.cql.CQLRelation;
import org.z3950.zing.cql.CQLSortNode;
import org.z3950.zing.cql.CQLTermNode;
import org.z3950.zing.cql.ModifierSet;
import org.z3950.zing.cql.PQFTranslationException;
import org.z3950.zing.cql.PositionAwareReader;
import org.z3950.zing.cql.UnknownIndexException;
import org.z3950.zing.cql.UnknownPositionException;
import org.z3950.zing.cql.UnknownRelationException;
import org.z3950.zing.cql.UnknownRelationModifierException;

public class CQLParser {
    private CQLLexer lexer;
    private PositionAwareReader par;
    private final int compat;
    private final Set<String> customRelations = new HashSet<String>();
    public static final int V1POINT1 = 12368;
    public static final int V1POINT2 = 12369;
    public static final int V1POINT1SORT = 12370;
    public final boolean allowKeywordTerms;
    private static boolean DEBUG = false;
    private static boolean LEXDEBUG = false;

    public CQLParser(int compat) {
        this.compat = compat;
        this.allowKeywordTerms = true;
    }

    public CQLParser(int compat, boolean allowKeywordTerms) {
        this.compat = 12369;
        this.allowKeywordTerms = allowKeywordTerms;
    }

    public CQLParser() {
        this.compat = 12369;
        this.allowKeywordTerms = true;
    }

    private static void debug(String str) {
        if (DEBUG) {
            System.err.println("PARSEDEBUG: " + str);
        }
    }

    public boolean registerCustomRelation(String relation) {
        return this.customRelations.add(relation);
    }

    public boolean unregisterCustomRelation(String relation) {
        return this.customRelations.remove(relation);
    }

    public CQLNode parse(String cql) throws CQLParseException, IOException {
        return this.parse(new StringReader(cql));
    }

    public CQLNode parse(Reader cql) throws CQLParseException, IOException {
        this.par = new PositionAwareReader(cql);
        this.lexer = new CQLLexer(this.par, LEXDEBUG);
        this.lexer.nextToken();
        CQLParser.debug("about to parseQuery()");
        CQLNode root = this.parseTopLevelPrefixes("cql.serverChoice", new CQLRelation(this.compat == 12369 ? "=" : "scr"));
        if (this.lexer.ttype != -1) {
            throw new CQLParseException("junk after end: " + this.lexer.render(), this.par.getPosition());
        }
        return root;
    }

    private CQLNode parseTopLevelPrefixes(String index, CQLRelation relation) throws CQLParseException, IOException {
        CQLParser.debug("top-level prefix mapping");
        if (this.lexer.ttype == 62) {
            return this.parsePrefix(index, relation, true);
        }
        CQLNode node = this.parseQuery(index, relation);
        if ((this.compat == 12369 || this.compat == 12370) && this.lexer.ttype == 1008) {
            this.match(this.lexer.ttype);
            CQLParser.debug("sortspec");
            CQLSortNode sortnode = new CQLSortNode(node);
            while (this.lexer.ttype != -1) {
                String sortindex = this.matchSymbol("sort index");
                ModifierSet ms = this.gatherModifiers(sortindex);
                sortnode.addSortIndex(ms);
            }
            if (sortnode.keys.size() == 0) {
                throw new CQLParseException("no sort keys", this.par.getPosition());
            }
            node = sortnode;
        }
        return node;
    }

    private CQLNode parseQuery(String index, CQLRelation relation) throws CQLParseException, IOException {
        CQLParser.debug("in parseQuery()");
        CQLNode term = this.parseTerm(index, relation);
        while (this.lexer.ttype != -1 && this.lexer.ttype != 41 && this.lexer.ttype != 1008) {
            if (this.lexer.ttype == 1004 || this.lexer.ttype == 1005 || this.lexer.ttype == 1006 || this.lexer.ttype == 1007) {
                int type = this.lexer.ttype;
                String val = this.lexer.sval;
                this.match(type);
                ModifierSet ms = this.gatherModifiers(val);
                CQLNode term2 = this.parseTerm(index, relation);
                term = type == 1004 ? new CQLAndNode(term, term2, ms) : (type == 1005 ? new CQLOrNode(term, term2, ms) : (type == 1006 ? new CQLNotNode(term, term2, ms) : new CQLProxNode(term, term2, ms)));
                continue;
            }
            throw new CQLParseException("expected boolean, got " + this.lexer.render(), this.par.getPosition());
        }
        CQLParser.debug("no more ops");
        return term;
    }

    private ModifierSet gatherModifiers(String base) throws CQLParseException, IOException {
        CQLParser.debug("in gatherModifiers()");
        ModifierSet ms = new ModifierSet(base);
        while (this.lexer.ttype == 47) {
            this.match(47);
            if (this.lexer.ttype != -3) {
                throw new CQLParseException("expected modifier, got " + this.lexer.render(), this.par.getPosition());
            }
            String type = this.lexer.sval.toLowerCase();
            this.match(this.lexer.ttype);
            if (!this.isSymbolicRelation()) {
                ms.addModifier(type);
                continue;
            }
            String comparision = this.lexer.render(this.lexer.ttype, false);
            this.match(this.lexer.ttype);
            String value = this.matchSymbol("modifier value");
            ms.addModifier(type, comparision, value);
        }
        return ms;
    }

    private CQLNode parseTerm(String index, CQLRelation relation) throws CQLParseException, IOException {
        String word;
        CQLParser.debug("in parseTerm()");
        while (true) {
            ModifierSet ms;
            if (this.lexer.ttype == 40) {
                CQLParser.debug("parenthesised term");
                this.match(40);
                CQLNode expr = this.parseQuery(index, relation);
                this.match(41);
                return expr;
            }
            if (this.lexer.ttype == 62) {
                return this.parsePrefix(index, relation, false);
            }
            CQLParser.debug("non-parenthesised term");
            word = this.matchSymbol("index or term");
            while (this.lexer.ttype == -3 && !this.isRelation()) {
                word = word + " " + this.lexer.sval;
                this.match(-3);
            }
            if (!this.isRelation()) break;
            index = word;
            String relstr = this.lexer.ttype == -3 ? this.lexer.sval : this.lexer.render(this.lexer.ttype, false);
            relation = new CQLRelation(relstr);
            this.match(this.lexer.ttype);
            relation.ms = ms = this.gatherModifiers(relstr);
            CQLParser.debug("index='" + index + ", " + "relation='" + relation.toCQL() + "'");
        }
        CQLTermNode node = new CQLTermNode(index, relation, word);
        CQLParser.debug("made term node " + node.toCQL());
        return node;
    }

    private CQLNode parsePrefix(String index, CQLRelation relation, boolean topLevel) throws CQLParseException, IOException {
        CQLParser.debug("prefix mapping");
        this.match(62);
        String name = null;
        String identifier = this.matchSymbol("prefix-name");
        if (this.lexer.ttype == 61) {
            this.match(61);
            name = identifier;
            identifier = this.matchSymbol("prefix-identifer");
        }
        CQLNode node = topLevel ? this.parseTopLevelPrefixes(index, relation) : this.parseQuery(index, relation);
        return new CQLPrefixNode(name, identifier, node);
    }

    private boolean isRelation() {
        CQLParser.debug("isRelation: checking ttype=" + this.lexer.ttype + " (" + this.lexer.render() + ")");
        if (this.lexer.ttype == -3 && (this.lexer.sval.indexOf(46) >= 0 || this.lexer.sval.equals("any") || this.lexer.sval.equals("all") || this.lexer.sval.equals("within") || this.lexer.sval.equals("encloses") || this.lexer.sval.equals("exact") && this.compat != 12369 || this.lexer.sval.equals("scr") && this.compat != 12369 || this.lexer.sval.equals("adj") && this.compat == 12369 || this.customRelations.contains(this.lexer.sval))) {
            return true;
        }
        return this.isSymbolicRelation();
    }

    private boolean isSymbolicRelation() {
        CQLParser.debug("isSymbolicRelation: checking ttype=" + this.lexer.ttype + " (" + this.lexer.render() + ")");
        return this.lexer.ttype == 60 || this.lexer.ttype == 62 || this.lexer.ttype == 61 || this.lexer.ttype == 1000 || this.lexer.ttype == 1001 || this.lexer.ttype == 1002 || this.lexer.ttype == 1003;
    }

    private void match(int token) throws CQLParseException, IOException {
        CQLParser.debug("in match(" + this.lexer.render(token, true) + ")");
        if (this.lexer.ttype != token) {
            throw new CQLParseException("expected " + this.lexer.render(token, true) + ", " + "got " + this.lexer.render(), this.par.getPosition());
        }
        int tmp = this.lexer.nextToken();
        CQLParser.debug("match() got token=" + this.lexer.ttype + ", " + "nval=" + this.lexer.nval + ", sval='" + this.lexer.sval + "'" + " (tmp=" + tmp + ")");
    }

    private String matchSymbol(String expected) throws CQLParseException, IOException {
        CQLParser.debug("in matchSymbol()");
        if (this.lexer.ttype == -3 || this.lexer.ttype == -2 || this.lexer.ttype == 34 || this.allowKeywordTerms && this.lexer.ttype == 1004 || this.lexer.ttype == 1005 || this.lexer.ttype == 1006 || this.lexer.ttype == 1007 || this.lexer.ttype == 1008) {
            String symbol = this.lexer.ttype == -2 ? this.lexer.render() : this.lexer.sval;
            this.match(this.lexer.ttype);
            return symbol;
        }
        throw new CQLParseException("expected " + expected + ", " + "got " + this.lexer.render(), this.par.getPosition());
    }

    public static void main(String[] args) {
        String cql;
        int mode = 120;
        String pfile = null;
        ArrayList<String> argv = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            argv.add(args[i]);
        }
        int compat = 12369;
        if (argv.size() > 0 && ((String)argv.get(0)).equals("-1")) {
            compat = 12368;
            argv.remove(0);
        }
        if (argv.size() > 0 && ((String)argv.get(0)).equals("-d")) {
            DEBUG = true;
            argv.remove(0);
        }
        if (argv.size() > 0 && ((String)argv.get(0)).equals("-c")) {
            mode = 99;
            argv.remove(0);
        } else if (argv.size() > 1 && ((String)argv.get(0)).equals("-p")) {
            mode = 112;
            argv.remove(0);
            pfile = (String)argv.get(0);
            argv.remove(0);
        }
        if (argv.size() > 1) {
            System.err.println("Usage: CQLParser [-1] [-d] [-c] [-p <pqf-properties> [<CQL-query>]");
            System.err.println("If unspecified, query is read from stdin");
            System.exit(1);
        }
        if (argv.size() == 1) {
            cql = (String)argv.get(0);
        } else {
            byte[] bytes = new byte[10000];
            try {
                int nbytes = System.in.read(bytes);
            }
            catch (IOException ex) {
                System.err.println("Can't read query: " + ex.getMessage());
                System.exit(2);
            }
            cql = new String(bytes);
        }
        CQLParser parser = new CQLParser(compat);
        CQLNode root = null;
        try {
            root = parser.parse(cql);
        }
        catch (CQLParseException ex) {
            System.err.println("Syntax error: " + ex.getMessage());
            System.exit(3);
        }
        catch (IOException ex) {
            System.err.println("Can't compile query: " + ex.getMessage());
            System.exit(4);
        }
        try {
            if (mode == 99) {
                System.out.println(root.toCQL());
            } else if (mode == 112) {
                FileInputStream f = new FileInputStream(pfile);
                if (f == null) {
                    throw new FileNotFoundException(pfile);
                }
                Properties config = new Properties();
                config.load(f);
                ((InputStream)f).close();
                System.out.println(root.toPQF(config));
            } else {
                System.out.print(root.toXCQL());
            }
        }
        catch (IOException ex) {
            System.err.println("Can't render query: " + ex.getMessage());
            System.exit(5);
        }
        catch (UnknownIndexException ex) {
            System.err.println("Unknown index: " + ex.getMessage());
            System.exit(6);
        }
        catch (UnknownRelationException ex) {
            System.err.println("Unknown relation: " + ex.getMessage());
            System.exit(7);
        }
        catch (UnknownRelationModifierException ex) {
            System.err.println("Unknown relation modifier: " + ex.getMessage());
            System.exit(8);
        }
        catch (UnknownPositionException ex) {
            System.err.println("Unknown position: " + ex.getMessage());
            System.exit(9);
        }
        catch (PQFTranslationException ex) {
            throw new Error("can't get a PQFTranslationException");
        }
    }
}

