/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLPrefix;
import org.z3950.zing.cql.ModifierSet;
import org.z3950.zing.cql.PQFTranslationException;
import org.z3950.zing.cql.XCQLBuilder;

public class CQLPrefixNode
extends CQLNode {
    private CQLPrefix prefix;
    private CQLNode subtree;

    public CQLPrefix getPrefix() {
        return this.prefix;
    }

    public CQLNode getSubtree() {
        return this.subtree;
    }

    public CQLPrefixNode(String name, String identifier, CQLNode subtree) {
        this.prefix = new CQLPrefix(name, identifier);
        this.subtree = subtree;
    }

    @Override
    void toXCQLInternal(XCQLBuilder b, int level, List<CQLPrefix> prefixes, List<ModifierSet> sortkeys) {
        ArrayList<CQLPrefix> tmp = prefixes == null ? new ArrayList<CQLPrefix>() : new ArrayList<CQLPrefix>(prefixes);
        tmp.add(this.prefix);
        this.subtree.toXCQLInternal(b, level, tmp, sortkeys);
    }

    @Override
    public String toCQL() {
        if (this.prefix.name == null) {
            return ">\"" + this.prefix.identifier + "\" " + "(" + this.subtree.toCQL() + ")";
        }
        return ">" + this.prefix.name + "=\"" + this.prefix.identifier + "\" " + "(" + this.subtree.toCQL() + ")";
    }

    @Override
    public String toPQF(Properties config) throws PQFTranslationException {
        return this.subtree.toPQF(config);
    }

    @Override
    public byte[] toType1BER(Properties config) throws PQFTranslationException {
        return this.subtree.toType1BER(config);
    }
}

