/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLPrefix;
import org.z3950.zing.cql.ModifierSet;
import org.z3950.zing.cql.PQFTranslationException;
import org.z3950.zing.cql.XCQLBuilder;

public class CQLSortNode
extends CQLNode {
    private CQLNode subtree;
    List<ModifierSet> keys;

    public CQLNode getSubtree() {
        return this.subtree;
    }

    public CQLSortNode(CQLNode subtree) {
        this.subtree = subtree;
        this.keys = new ArrayList<ModifierSet>();
    }

    public void addSortIndex(ModifierSet key) {
        this.keys.add(key);
    }

    public List<ModifierSet> getSortIndexes() {
        return this.keys;
    }

    @Override
    void toXCQLInternal(XCQLBuilder b, int level, List<CQLPrefix> prefixes, List<ModifierSet> sortkeys) {
        if (sortkeys != null) {
            throw new Error("CQLSortNode.toXCQL() called with sortkeys");
        }
        this.subtree.toXCQLInternal(b, level, prefixes, this.keys);
    }

    @Override
    public String toCQL() {
        StringBuilder buf = new StringBuilder(this.subtree.toCQL());
        if (this.keys != null) {
            buf.append(" sortby");
            for (int i = 0; i < this.keys.size(); ++i) {
                ModifierSet key = this.keys.get(i);
                buf.append(" ").append(key.toCQL());
            }
        }
        return buf.toString();
    }

    @Override
    public String toPQF(Properties config) throws PQFTranslationException {
        return "@attr 1=oops \"###\"";
    }

    @Override
    public byte[] toType1BER(Properties config) throws PQFTranslationException {
        return this.subtree.toType1BER(config);
    }
}

