/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLPrefix;
import org.z3950.zing.cql.CQLRelation;
import org.z3950.zing.cql.Modifier;
import org.z3950.zing.cql.ModifierSet;
import org.z3950.zing.cql.PQFTranslationException;
import org.z3950.zing.cql.UnknownIndexException;
import org.z3950.zing.cql.UnknownPositionException;
import org.z3950.zing.cql.UnknownRelationException;
import org.z3950.zing.cql.UnknownRelationModifierException;
import org.z3950.zing.cql.XCQLBuilder;

public class CQLTermNode
extends CQLNode {
    private String index;
    private CQLRelation relation;
    private String term;

    public CQLTermNode(String index, CQLRelation relation, String term) {
        this.index = index;
        this.relation = relation;
        this.term = term;
    }

    public String getIndex() {
        return this.index;
    }

    public CQLRelation getRelation() {
        return this.relation;
    }

    public String getTerm() {
        return this.term;
    }

    private static boolean isResultSetIndex(String qual) {
        return qual.equals("srw.resultSet") || qual.equals("srw.resultSetId") || qual.equals("srw.resultSetName") || qual.equals("cql.resultSet") || qual.equals("cql.resultSetId") || qual.equals("cql.resultSetName");
    }

    @Override
    public String getResultSetName() {
        if (CQLTermNode.isResultSetIndex(this.index)) {
            return this.term;
        }
        return null;
    }

    @Override
    void toXCQLInternal(XCQLBuilder b, int level, List<CQLPrefix> prefixes, List<ModifierSet> sortkeys) {
        b.indent(level).append("<searchClause>\n");
        CQLTermNode.renderPrefixes(b, level + 1, prefixes);
        b.indent(level + 1).append("<index>").xq(this.index).append("</index>\n");
        this.relation.toXCQLInternal(b, level + 1);
        b.indent(level + 1).append("<term>").xq(this.term).append("</term>\n");
        CQLTermNode.renderSortKeys(b, level + 1, sortkeys);
        b.indent(level).append("</searchClause>\n");
    }

    @Override
    public String toCQL() {
        String quotedTerm;
        String quotedIndex = CQLTermNode.maybeQuote(this.index);
        String res = quotedTerm = CQLTermNode.maybeQuote(this.term);
        if (this.index != null && !this.index.equalsIgnoreCase("srw.serverChoice") && !this.index.equalsIgnoreCase("cql.serverChoice")) {
            res = quotedIndex + " " + this.relation.toCQL() + " " + quotedTerm;
        }
        return res;
    }

    private List<String> getAttrs(Properties config) throws PQFTranslationException {
        int len;
        ArrayList<String> attrs = new ArrayList<String>();
        String attr = config.getProperty("always");
        if (attr != null) {
            attrs.add(attr);
        }
        if ((attr = config.getProperty("index." + this.index)) == null) {
            attr = config.getProperty("qualifier." + this.index);
        }
        if (attr == null) {
            throw new UnknownIndexException(this.index);
        }
        attrs.add(attr);
        String rel = this.relation.getBase();
        if (rel.equals("=")) {
            rel = "eq";
        } else if (rel.equals("<=")) {
            rel = "le";
        } else if (rel.equals(">=")) {
            rel = "ge";
        }
        attr = config.getProperty("relation." + rel);
        if (attr == null) {
            throw new UnknownRelationException(rel);
        }
        attrs.add(attr);
        List<Modifier> mods = this.relation.getModifiers();
        for (int i = 0; i < mods.size(); ++i) {
            String type = mods.get((int)i).type;
            attr = config.getProperty("relationModifier." + type);
            if (attr == null) {
                throw new UnknownRelationModifierException(type);
            }
            attrs.add(attr);
        }
        String pos = "any";
        String text = this.term;
        if (text.length() > 0 && text.substring(0, 1).equals("^")) {
            text = text.substring(1);
            pos = "first";
        }
        if ((len = text.length()) > 0 && text.substring(len - 1, len).equals("^")) {
            text = text.substring(0, len - 1);
            String string = pos = pos.equals("first") ? "firstAndLast" : "last";
        }
        if ((attr = config.getProperty("position." + pos)) == null) {
            throw new UnknownPositionException(pos);
        }
        attrs.add(attr);
        attr = config.getProperty("structure." + rel);
        if (attr == null) {
            attr = config.getProperty("structure.*");
        }
        attrs.add(attr);
        return attrs;
    }

    @Override
    public String toPQF(Properties config) throws PQFTranslationException {
        int len;
        if (CQLTermNode.isResultSetIndex(this.index)) {
            return "@set " + CQLTermNode.maybeQuote(this.term);
        }
        List<String> attrs = this.getAttrs(config);
        String s = "";
        for (int i = 0; i < attrs.size(); ++i) {
            String attr = attrs.get(i);
            s = s + "@attr " + attr.replace(" ", " @attr ") + " ";
        }
        String text = this.term;
        if (text.length() > 0 && text.substring(0, 1).equals("^")) {
            text = text.substring(1);
        }
        if ((len = text.length()) > 0 && text.substring(len - 1, len).equals("^")) {
            text = text.substring(0, len - 1);
        }
        return s + CQLTermNode.maybeQuote(text);
    }

    static String maybeQuote(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0 || str.indexOf(34) != -1 || str.indexOf(32) != -1 || str.indexOf(9) != -1 || str.indexOf(61) != -1 || str.indexOf(60) != -1 || str.indexOf(62) != -1 || str.indexOf(47) != -1 || str.indexOf(40) != -1 || str.indexOf(41) != -1) {
            str = '\"' + str.replace("\"", "\\\"") + '\"';
        }
        return str;
    }

    @Override
    public byte[] toType1BER(Properties config) throws PQFTranslationException {
        int len;
        if (CQLTermNode.isResultSetIndex(this.index)) {
            byte[] operand = new byte[this.term.length() + 100];
            int offset = CQLTermNode.putTag(2, 0, 1, operand, 0);
            operand[offset++] = -128;
            offset = CQLTermNode.putTag(2, 31, 0, operand, offset);
            byte[] t = this.term.getBytes();
            offset = CQLTermNode.putLen(t.length, operand, offset);
            System.arraycopy(t, 0, operand, offset, t.length);
            offset += t.length;
            operand[offset++] = 0;
            operand[offset++] = 0;
            byte[] o = new byte[offset];
            System.arraycopy(operand, 0, o, 0, offset);
            return o;
        }
        String text = this.term;
        if (text.length() > 0 && text.substring(0, 1).equals("^")) {
            text = text.substring(1);
        }
        if ((len = text.length()) > 0 && text.substring(len - 1, len).equals("^")) {
            text = text.substring(0, len - 1);
        }
        byte[] operand = new byte[text.length() + 100];
        int offset = CQLTermNode.putTag(2, 0, 1, operand, 0);
        operand[offset++] = -128;
        offset = CQLTermNode.putTag(2, 102, 1, operand, offset);
        operand[offset++] = -128;
        offset = CQLTermNode.putTag(2, 44, 1, operand, offset);
        operand[offset++] = -128;
        List<String> attrs = this.getAttrs(config);
        for (int i = 0; i < attrs.size(); ++i) {
            String attrList = attrs.get(i);
            StringTokenizer st = new StringTokenizer(attrList);
            while (st.hasMoreTokens()) {
                String attr = st.nextToken();
                int j = attr.indexOf(61);
                offset = CQLTermNode.putTag(0, 16, 1, operand, offset);
                operand[offset++] = -128;
                offset = CQLTermNode.putTag(2, 120, 0, operand, offset);
                int type = Integer.parseInt(attr.substring(0, j));
                offset = CQLTermNode.putLen(CQLTermNode.numLen(type), operand, offset);
                offset = CQLTermNode.putNum(type, operand, offset);
                offset = CQLTermNode.putTag(2, 121, 0, operand, offset);
                int value = Integer.parseInt(attr.substring(j + 1));
                offset = CQLTermNode.putLen(CQLTermNode.numLen(value), operand, offset);
                offset = CQLTermNode.putNum(value, operand, offset);
                operand[offset++] = 0;
                operand[offset++] = 0;
            }
        }
        operand[offset++] = 0;
        operand[offset++] = 0;
        offset = CQLTermNode.putTag(2, 45, 0, operand, offset);
        byte[] t = text.getBytes();
        offset = CQLTermNode.putLen(t.length, operand, offset);
        System.arraycopy(t, 0, operand, offset, t.length);
        offset += t.length;
        operand[offset++] = 0;
        operand[offset++] = 0;
        operand[offset++] = 0;
        operand[offset++] = 0;
        byte[] o = new byte[offset];
        System.arraycopy(operand, 0, o, 0, offset);
        return o;
    }
}

