/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.util.ArrayList;
import java.util.List;
import org.z3950.zing.cql.Modifier;
import org.z3950.zing.cql.XCQLBuilder;

public class ModifierSet {
    private String base;
    private List<Modifier> modifiers;

    public ModifierSet(String base) {
        this.base = base;
        this.modifiers = new ArrayList<Modifier>();
    }

    public String getBase() {
        return this.base;
    }

    public void addModifier(String type, String comparison, String value) {
        Modifier modifier = new Modifier(type, comparison, value);
        this.modifiers.add(modifier);
    }

    public void addModifier(String type) {
        Modifier modifier = new Modifier(type);
        this.modifiers.add(modifier);
    }

    public String modifier(String type) {
        int n = this.modifiers.size();
        for (int i = 0; i < n; ++i) {
            Modifier mod = this.modifiers.get(i);
            if (!mod.type.equals(type)) continue;
            return mod.value;
        }
        return null;
    }

    public List<Modifier> getModifiers() {
        return this.modifiers;
    }

    void toXCQLInternal(XCQLBuilder b, int level, String topLevelElement, String valueElement) {
        b.indent(level).append("<").append(topLevelElement).append(">\n").indent(level + 1).append("<").append(valueElement).append(">").xq(this.base).append("</").append(valueElement).append(">\n");
        if (this.modifiers.size() > 0) {
            b.indent(level + 1).append("<modifiers>\n");
            for (int i = 0; i < this.modifiers.size(); ++i) {
                this.modifiers.get(i).toXCQLInternal(b, level + 2, "comparison");
            }
            b.indent(level + 1).append("</modifiers>\n");
        }
        b.indent(level).append("</").append(topLevelElement).append(">\n");
    }

    public String toCQL() {
        StringBuilder buf = new StringBuilder(this.base);
        for (int i = 0; i < this.modifiers.size(); ++i) {
            buf.append("/").append(this.modifiers.get(i).toCQL());
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: ModifierSet <base> [<type> <comparison> <name>]...");
            System.exit(1);
        }
        ModifierSet res = new ModifierSet(args[0]);
        for (int i = 1; i < args.length; i += 3) {
            res.addModifier(args[i], args[i + 1], args[i + 2]);
        }
        System.out.println(res.toCQL());
    }
}

