/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public class PositionAwareReader
extends Reader {
    protected Reader reader;
    protected int pos = -1;

    public PositionAwareReader(Reader reader) {
        this.reader = reader;
    }

    public int getPosition() {
        return this.pos;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.reader.mark(readAheadLimit);
    }

    @Override
    public boolean markSupported() {
        return this.reader.markSupported();
    }

    @Override
    public int read() throws IOException {
        int c = this.reader.read();
        if (c != -1) {
            ++this.pos;
        }
        return c;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        int c = this.reader.read(cbuf);
        if (c != -1) {
            this.pos += c;
        }
        return c;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        int c = this.reader.read(target);
        if (c != -1) {
            this.pos += c;
        }
        return c;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int c = this.reader.read(cbuf, off, len);
        if (c != -1) {
            this.pos += c;
        }
        return c;
    }

    @Override
    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.reader.skip(n);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public void reset() throws IOException {
        this.reader.reset();
    }

    public boolean equals(Object obj) {
        return this.reader.equals(obj);
    }

    public String toString() {
        return this.reader.toString();
    }

    public int hashCode() {
        return this.reader.hashCode();
    }
}

