/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Vector;
import org.z3950.zing.cql.CQLAndNode;
import org.z3950.zing.cql.CQLLexer;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLNotNode;
import org.z3950.zing.cql.CQLOrNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLPrefixNode;
import org.z3950.zing.cql.CQLProxNode;
import org.z3950.zing.cql.CQLRelation;
import org.z3950.zing.cql.CQLSortNode;
import org.z3950.zing.cql.CQLTermNode;
import org.z3950.zing.cql.ModifierSet;
import org.z3950.zing.cql.PQFTranslationException;
import org.z3950.zing.cql.UnknownIndexException;
import org.z3950.zing.cql.UnknownPositionException;
import org.z3950.zing.cql.UnknownRelationException;
import org.z3950.zing.cql.UnknownRelationModifierException;

public class CQLParser {
    private CQLLexer lexer;
    private int compat;
    public static int V1POINT1 = 12368;
    public static int V1POINT2 = 12369;
    public static int V1POINT1SORT = 12370;
    private static boolean DEBUG = false;
    private static boolean LEXDEBUG = false;

    public CQLParser(int n) {
        this.compat = n;
    }

    public CQLParser() {
        this.compat = V1POINT2;
    }

    private static void debug(String string) {
        if (DEBUG) {
            System.err.println("PARSEDEBUG: " + string);
        }
    }

    public CQLNode parse(String string) throws CQLParseException, IOException {
        this.lexer = new CQLLexer(string, LEXDEBUG);
        this.lexer.nextToken();
        CQLParser.debug("about to parseQuery()");
        CQLNode cQLNode = this.parseTopLevelPrefixes("cql.serverChoice", new CQLRelation(this.compat == V1POINT2 ? "=" : "scr"));
        if (this.lexer.ttype != -1) {
            throw new CQLParseException("junk after end: " + this.lexer.render());
        }
        return cQLNode;
    }

    private CQLNode parseTopLevelPrefixes(String string, CQLRelation cQLRelation) throws CQLParseException, IOException {
        CQLParser.debug("top-level prefix mapping");
        if (this.lexer.ttype == 62) {
            return this.parsePrefix(string, cQLRelation, true);
        }
        CQLNode cQLNode = this.parseQuery(string, cQLRelation);
        if (this.compat == V1POINT2 || this.compat == V1POINT1SORT) {
            if (this.lexer.ttype == CQLLexer.TT_SORTBY) {
                this.match(this.lexer.ttype);
                CQLParser.debug("sortspec");
                CQLSortNode cQLSortNode = new CQLSortNode(cQLNode);
                while (true) {
                    if (this.lexer.ttype == -1) break;
                    String string2 = this.matchSymbol("sort index");
                    ModifierSet modifierSet = this.gatherModifiers(string2);
                    cQLSortNode.addSortIndex(modifierSet);
                }
                if (cQLSortNode.keys.size() == 0) {
                    throw new CQLParseException("no sort keys");
                }
                cQLNode = cQLSortNode;
            }
        }
        return cQLNode;
    }

    private CQLNode parseQuery(String string, CQLRelation cQLRelation) throws CQLParseException, IOException {
        CQLNode cQLNode;
        block4: {
            CQLParser.debug("in parseQuery()");
            cQLNode = this.parseTerm(string, cQLRelation);
            while (true) {
                if (this.lexer.ttype == -1 || this.lexer.ttype == 41) break block4;
                if (this.lexer.ttype == CQLLexer.TT_SORTBY) break block4;
                if (this.lexer.ttype != CQLLexer.TT_AND) {
                    if (this.lexer.ttype != CQLLexer.TT_OR) {
                        if (this.lexer.ttype != CQLLexer.TT_NOT) {
                            if (this.lexer.ttype != CQLLexer.TT_PROX) break;
                        }
                    }
                }
                int n = this.lexer.ttype;
                String string2 = this.lexer.sval;
                this.match(n);
                ModifierSet modifierSet = this.gatherModifiers(string2);
                CQLNode cQLNode2 = this.parseTerm(string, cQLRelation);
                cQLNode = n == CQLLexer.TT_AND ? new CQLAndNode(cQLNode, cQLNode2, modifierSet) : (n == CQLLexer.TT_OR ? new CQLOrNode(cQLNode, cQLNode2, modifierSet) : (n == CQLLexer.TT_NOT ? new CQLNotNode(cQLNode, cQLNode2, modifierSet) : new CQLProxNode(cQLNode, cQLNode2, modifierSet)));
            }
            throw new CQLParseException("expected boolean, got " + this.lexer.render());
        }
        CQLParser.debug("no more ops");
        return cQLNode;
    }

    private ModifierSet gatherModifiers(String string) throws CQLParseException, IOException {
        CQLParser.debug("in gatherModifiers()");
        ModifierSet modifierSet = new ModifierSet(string);
        while (this.lexer.ttype == 47) {
            this.match(47);
            if (this.lexer.ttype != -3) {
                throw new CQLParseException("expected modifier, got " + this.lexer.render());
            }
            String string2 = this.lexer.sval.toLowerCase();
            this.match(this.lexer.ttype);
            if (!this.isRelation()) {
                modifierSet.addModifier(string2);
                continue;
            }
            String string3 = this.lexer.render(this.lexer.ttype, false);
            this.match(this.lexer.ttype);
            String string4 = this.matchSymbol("modifier value");
            modifierSet.addModifier(string2, string3, string4);
        }
        return modifierSet;
    }

    private CQLNode parseTerm(String string, CQLRelation cQLRelation) throws CQLParseException, IOException {
        String string2;
        Object object;
        CQLParser.debug("in parseTerm()");
        while (true) {
            if (this.lexer.ttype == 40) {
                CQLParser.debug("parenthesised term");
                this.match(40);
                object = this.parseQuery(string, cQLRelation);
                this.match(41);
                return object;
            }
            if (this.lexer.ttype == 62) {
                return this.parsePrefix(string, cQLRelation, false);
            }
            CQLParser.debug("non-parenthesised term");
            string2 = this.matchSymbol("index or term");
            if (!this.isRelation()) {
                if (this.lexer.ttype != -3) break;
            }
            string = string2;
            object = this.lexer.ttype == -3 ? this.lexer.sval : this.lexer.render(this.lexer.ttype, false);
            cQLRelation = new CQLRelation((String)object);
            this.match(this.lexer.ttype);
            ModifierSet modifierSet = this.gatherModifiers((String)object);
            cQLRelation.setModifiers(modifierSet);
            CQLParser.debug("index='" + string + ", " + "relation='" + cQLRelation.toCQL() + "'");
        }
        object = new CQLTermNode(string, cQLRelation, string2);
        CQLParser.debug("made term node " + ((CQLTermNode)object).toCQL());
        return object;
    }

    private CQLNode parsePrefix(String string, CQLRelation cQLRelation, boolean bl) throws CQLParseException, IOException {
        CQLParser.debug("prefix mapping");
        this.match(62);
        String string2 = null;
        String string3 = this.matchSymbol("prefix-name");
        if (this.lexer.ttype == 61) {
            this.match(61);
            string2 = string3;
            string3 = this.matchSymbol("prefix-identifer");
        }
        CQLNode cQLNode = bl ? this.parseTopLevelPrefixes(string, cQLRelation) : this.parseQuery(string, cQLRelation);
        return new CQLPrefixNode(string2, string3, cQLNode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isRelation() {
        CQLParser.debug("isRelation: checking ttype=" + this.lexer.ttype + " (" + this.lexer.render() + ")");
        if (this.lexer.ttype == 60) return true;
        if (this.lexer.ttype == 62) return true;
        if (this.lexer.ttype == 61) return true;
        if (this.lexer.ttype == CQLLexer.TT_LE) return true;
        if (this.lexer.ttype == CQLLexer.TT_GE) return true;
        if (this.lexer.ttype == CQLLexer.TT_NE) return true;
        if (this.lexer.ttype != CQLLexer.TT_EQEQ) return false;
        return true;
    }

    private void match(int n) throws CQLParseException, IOException {
        CQLParser.debug("in match(" + this.lexer.render(n, true) + ")");
        if (this.lexer.ttype != n) {
            throw new CQLParseException("expected " + this.lexer.render(n, true) + ", " + "got " + this.lexer.render());
        }
        int n2 = this.lexer.nextToken();
        CQLParser.debug("match() got token=" + this.lexer.ttype + ", " + "nval=" + this.lexer.nval + ", sval='" + this.lexer.sval + "'" + " (tmp=" + n2 + ")");
    }

    private String matchSymbol(String string) throws CQLParseException, IOException {
        block3: {
            block2: {
                CQLParser.debug("in matchSymbol()");
                if (this.lexer.ttype == -3) break block2;
                if (this.lexer.ttype == -2 || this.lexer.ttype == 34) break block2;
                if (this.lexer.ttype == CQLLexer.TT_AND) break block2;
                if (this.lexer.ttype == CQLLexer.TT_OR) break block2;
                if (this.lexer.ttype == CQLLexer.TT_NOT) break block2;
                if (this.lexer.ttype == CQLLexer.TT_PROX) break block2;
                if (this.lexer.ttype != CQLLexer.TT_SORTBY) break block3;
            }
            String string2 = this.lexer.ttype == -2 ? this.lexer.render() : this.lexer.sval;
            this.match(this.lexer.ttype);
            return string2;
        }
        throw new CQLParseException("expected " + string + ", " + "got " + this.lexer.render());
    }

    public static void main(String[] stringArray) {
        Object object;
        String string;
        int n;
        int n2 = 120;
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < stringArray.length; ++n) {
            vector.add(stringArray[n]);
        }
        n = V1POINT2;
        if (vector.size() > 0 && ((String)vector.get(0)).equals("-1")) {
            n = V1POINT1;
            vector.remove(0);
        }
        if (vector.size() > 0 && ((String)vector.get(0)).equals("-d")) {
            DEBUG = true;
            vector.remove(0);
        }
        if (vector.size() > 0 && ((String)vector.get(0)).equals("-c")) {
            n2 = 99;
            vector.remove(0);
        } else if (vector.size() > 1 && ((String)vector.get(0)).equals("-p")) {
            n2 = 112;
            vector.remove(0);
            string2 = (String)vector.get(0);
            vector.remove(0);
        }
        if (vector.size() > 1) {
            System.err.println("Usage: CQLParser [-1] [-d] [-c] [-p <pqf-properties> [<CQL-query>]");
            System.err.println("If unspecified, query is read from stdin");
            System.exit(1);
        }
        if (vector.size() == 1) {
            string = (String)vector.get(0);
        } else {
            object = new byte[10000];
            try {
                int n3 = System.in.read((byte[])object);
            }
            catch (IOException iOException) {
                System.err.println("Can't read query: " + iOException.getMessage());
                System.exit(2);
            }
            string = new String((byte[])object);
        }
        object = new CQLParser(n);
        CQLNode cQLNode = null;
        try {
            cQLNode = ((CQLParser)object).parse(string);
        }
        catch (CQLParseException cQLParseException) {
            System.err.println("Syntax error: " + cQLParseException.getMessage());
            System.exit(3);
        }
        catch (IOException iOException) {
            System.err.println("Can't compile query: " + iOException.getMessage());
            System.exit(4);
        }
        try {
            if (n2 == 99) {
                System.out.println(cQLNode.toCQL());
            } else if (n2 == 112) {
                FileInputStream fileInputStream = new FileInputStream(string2);
                if (fileInputStream == null) {
                    throw new FileNotFoundException(string2);
                }
                Properties properties = new Properties();
                properties.load(fileInputStream);
                ((InputStream)fileInputStream).close();
                System.out.println(cQLNode.toPQF(properties));
            } else {
                System.out.print(cQLNode.toXCQL(0));
            }
        }
        catch (IOException iOException) {
            System.err.println("Can't render query: " + iOException.getMessage());
            System.exit(5);
        }
        catch (UnknownIndexException unknownIndexException) {
            System.err.println("Unknown index: " + unknownIndexException.getMessage());
            System.exit(6);
        }
        catch (UnknownRelationException unknownRelationException) {
            System.err.println("Unknown relation: " + unknownRelationException.getMessage());
            System.exit(7);
        }
        catch (UnknownRelationModifierException unknownRelationModifierException) {
            System.err.println("Unknown relation modifier: " + unknownRelationModifierException.getMessage());
            System.exit(8);
        }
        catch (UnknownPositionException unknownPositionException) {
            System.err.println("Unknown position: " + unknownPositionException.getMessage());
            System.exit(9);
        }
        catch (PQFTranslationException pQFTranslationException) {
            throw new Error("can't get a PQFTranslationException");
        }
    }
}

