/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLPrefix;
import org.z3950.zing.cql.CQLRelation;
import org.z3950.zing.cql.Modifier;
import org.z3950.zing.cql.ModifierSet;
import org.z3950.zing.cql.PQFTranslationException;
import org.z3950.zing.cql.UnknownIndexException;
import org.z3950.zing.cql.UnknownPositionException;
import org.z3950.zing.cql.UnknownRelationException;
import org.z3950.zing.cql.UnknownRelationModifierException;
import org.z3950.zing.cql.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CQLTermNode
extends CQLNode {
    private String index;
    private CQLRelation relation;
    private String term;

    public CQLTermNode(String string, CQLRelation cQLRelation, String string2) {
        this.index = string;
        this.relation = cQLRelation;
        this.term = string2;
    }

    public String getIndex() {
        return this.index;
    }

    public CQLRelation getRelation() {
        return this.relation;
    }

    public String getTerm() {
        return this.term;
    }

    private static boolean isResultSetIndex(String string) {
        return string.equals("srw.resultSet") || string.equals("srw.resultSetId") || string.equals("srw.resultSetName") || string.equals("cql.resultSet") || string.equals("cql.resultSetId") || string.equals("cql.resultSetName");
    }

    @Override
    public String getResultSetName() {
        if (CQLTermNode.isResultSetIndex(this.index)) {
            return this.term;
        }
        return null;
    }

    @Override
    public String toXCQL(int n, Vector<CQLPrefix> vector, Vector<ModifierSet> vector2) {
        return CQLTermNode.indent(n) + "<searchClause>\n" + CQLTermNode.renderPrefixes(n + 1, vector) + CQLTermNode.indent(n + 1) + "<index>" + CQLTermNode.xq(this.index) + "</index>\n" + this.relation.toXCQL(n + 1) + CQLTermNode.indent(n + 1) + "<term>" + CQLTermNode.xq(this.term) + "</term>\n" + CQLTermNode.renderSortKeys(n + 1, vector2) + CQLTermNode.indent(n) + "</searchClause>\n";
    }

    @Override
    public String toCQL() {
        String string;
        String string2 = CQLTermNode.maybeQuote(this.index);
        String string3 = string = CQLTermNode.maybeQuote(this.term);
        if (this.index != null && !this.index.equalsIgnoreCase("srw.serverChoice") && !this.index.equalsIgnoreCase("cql.serverChoice")) {
            string3 = string2 + " " + this.relation.toCQL() + " " + string;
        }
        return string3;
    }

    private Vector getAttrs(Properties properties) throws PQFTranslationException {
        int n;
        String string;
        Vector<String> vector = new Vector<String>();
        String string2 = properties.getProperty("always");
        if (string2 != null) {
            vector.add(string2);
        }
        if ((string2 = properties.getProperty("index." + this.index)) == null) {
            throw new UnknownIndexException(this.index);
        }
        vector.add(string2);
        String string3 = this.relation.getBase();
        if (string3.equals("=")) {
            string3 = "eq";
        } else if (string3.equals("<=")) {
            string3 = "le";
        } else if (string3.equals(">=")) {
            string3 = "ge";
        }
        string2 = properties.getProperty("relation." + string3);
        if (string2 == null) {
            throw new UnknownRelationException(string3);
        }
        vector.add(string2);
        Vector<Modifier> vector2 = this.relation.getModifiers();
        for (int i = 0; i < vector2.size(); ++i) {
            string = vector2.get((int)i).type;
            string2 = properties.getProperty("relationModifier." + string);
            if (string2 == null) {
                throw new UnknownRelationModifierException(string);
            }
            vector.add(string2);
        }
        String string4 = "any";
        string = this.term;
        if (string.length() > 0 && string.substring(0, 1).equals("^")) {
            string = string.substring(1);
            string4 = "first";
        }
        if ((n = string.length()) > 0 && string.substring(n - 1, n).equals("^")) {
            string = string.substring(0, n - 1);
            String string5 = string4 = string4.equals("first") ? "firstAndLast" : "last";
        }
        if ((string2 = properties.getProperty("position." + string4)) == null) {
            throw new UnknownPositionException(string4);
        }
        vector.add(string2);
        string2 = properties.getProperty("structure." + string3);
        if (string2 == null) {
            string2 = properties.getProperty("structure.*");
        }
        vector.add(string2);
        return vector;
    }

    @Override
    public String toPQF(Properties properties) throws PQFTranslationException {
        int n;
        if (CQLTermNode.isResultSetIndex(this.index)) {
            return "@set " + CQLTermNode.maybeQuote(this.term);
        }
        Vector vector = this.getAttrs(properties);
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.get(i);
            string = string + "@attr " + Utils.replaceString(string2, " ", " @attr ") + " ";
        }
        String string3 = this.term;
        if (string3.length() > 0 && string3.substring(0, 1).equals("^")) {
            string3 = string3.substring(1);
        }
        if ((n = string3.length()) > 0 && string3.substring(n - 1, n).equals("^")) {
            string3 = string3.substring(0, n - 1);
        }
        return string + CQLTermNode.maybeQuote(string3);
    }

    static String maybeQuote(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0 || string.indexOf(34) != -1 || string.indexOf(32) != -1 || string.indexOf(9) != -1 || string.indexOf(61) != -1 || string.indexOf(60) != -1 || string.indexOf(62) != -1 || string.indexOf(47) != -1 || string.indexOf(40) != -1 || string.indexOf(41) != -1) {
            string = '\"' + Utils.replaceString(string, "\"", "\\\"") + '\"';
        }
        return string;
    }

    @Override
    public byte[] toType1BER(Properties properties) throws PQFTranslationException {
        Object object;
        int n;
        if (CQLTermNode.isResultSetIndex(this.index)) {
            byte[] byArray = new byte[this.term.length() + 100];
            int n2 = CQLTermNode.putTag(2, 0, 1, byArray, 0);
            byArray[n2++] = -128;
            n2 = CQLTermNode.putTag(2, 31, 0, byArray, n2);
            byte[] byArray2 = this.term.getBytes();
            n2 = CQLTermNode.putLen(byArray2.length, byArray, n2);
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            n2 += byArray2.length;
            byArray[n2++] = 0;
            byArray[n2++] = 0;
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, 0, byArray3, 0, n2);
            return byArray3;
        }
        String string = this.term;
        if (string.length() > 0 && string.substring(0, 1).equals("^")) {
            string = string.substring(1);
        }
        if ((n = string.length()) > 0 && string.substring(n - 1, n).equals("^")) {
            string = string.substring(0, n - 1);
        }
        String string2 = string;
        byte[] byArray = new byte[string.length() + 100];
        int n3 = CQLTermNode.putTag(2, 0, 1, byArray, 0);
        byArray[n3++] = -128;
        n3 = CQLTermNode.putTag(2, 102, 1, byArray, n3);
        byArray[n3++] = -128;
        n3 = CQLTermNode.putTag(2, 44, 1, byArray, n3);
        byArray[n3++] = -128;
        Vector vector = this.getAttrs(properties);
        for (int i = 0; i < vector.size(); ++i) {
            String string3 = (String)vector.get(i);
            object = new StringTokenizer(string3);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string4 = ((StringTokenizer)object).nextToken();
                int n4 = string4.indexOf(61);
                n3 = CQLTermNode.putTag(0, 16, 1, byArray, n3);
                byArray[n3++] = -128;
                n3 = CQLTermNode.putTag(2, 120, 0, byArray, n3);
                int n5 = Integer.parseInt(string4.substring(0, n4));
                n3 = CQLTermNode.putLen(CQLTermNode.numLen(n5), byArray, n3);
                n3 = CQLTermNode.putNum(n5, byArray, n3);
                n3 = CQLTermNode.putTag(2, 121, 0, byArray, n3);
                int n6 = Integer.parseInt(string4.substring(n4 + 1));
                n3 = CQLTermNode.putLen(CQLTermNode.numLen(n6), byArray, n3);
                n3 = CQLTermNode.putNum(n6, byArray, n3);
                byArray[n3++] = 0;
                byArray[n3++] = 0;
            }
        }
        byArray[n3++] = 0;
        byArray[n3++] = 0;
        n3 = CQLTermNode.putTag(2, 45, 0, byArray, n3);
        object = string2.getBytes();
        n3 = CQLTermNode.putLen(((Object)object).length, byArray, n3);
        System.arraycopy(object, 0, byArray, n3, ((Object)object).length);
        n3 += ((Object)object).length;
        byArray[n3++] = 0;
        byArray[n3++] = 0;
        byArray[n3++] = 0;
        byArray[n3++] = 0;
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray, 0, byArray4, 0, n3);
        return byArray4;
    }
}

