/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.util.Vector;
import org.z3950.zing.cql.Modifier;
import org.z3950.zing.cql.Utils;

public class ModifierSet {
    String base;
    Vector<Modifier> modifiers;

    public ModifierSet(String string) {
        this.base = string;
        this.modifiers = new Vector();
    }

    public String getBase() {
        return this.base;
    }

    public void addModifier(String string, String string2, String string3) {
        Modifier modifier = new Modifier(string, string2, string3);
        this.modifiers.add(modifier);
    }

    public void addModifier(String string) {
        Modifier modifier = new Modifier(string);
        this.modifiers.add(modifier);
    }

    public String modifier(String string) {
        int n = this.modifiers.size();
        for (int i = 0; i < n; ++i) {
            Modifier modifier = this.modifiers.get(i);
            if (!modifier.type.equals(string)) continue;
            return modifier.value;
        }
        return null;
    }

    public Vector<Modifier> getModifiers() {
        return this.modifiers;
    }

    public String toXCQL(int n, String string) {
        return this.underlyingToXCQL(n, string, "value");
    }

    public String sortKeyToXCQL(int n) {
        return this.underlyingToXCQL(n, "key", "index");
    }

    private String underlyingToXCQL(int n, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Utils.indent(n) + "<" + string + ">\n");
        stringBuffer.append(Utils.indent(n + 1) + "<" + string2 + ">" + Utils.xq(this.base) + "</" + string2 + ">\n");
        if (this.modifiers.size() > 0) {
            stringBuffer.append(Utils.indent(n + 1) + "<modifiers>\n");
            for (int i = 0; i < this.modifiers.size(); ++i) {
                stringBuffer.append(this.modifiers.get(i).toXCQL(n + 2, "comparison"));
            }
            stringBuffer.append(Utils.indent(n + 1) + "</modifiers>\n");
        }
        stringBuffer.append(Utils.indent(n) + "</" + string + ">\n");
        return stringBuffer.toString();
    }

    public String toCQL() {
        StringBuffer stringBuffer = new StringBuffer(this.base);
        for (int i = 0; i < this.modifiers.size(); ++i) {
            stringBuffer.append("/" + this.modifiers.get(i).toCQL());
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: ModifierSet <base> [<type> <comparison> <name>]...");
            System.exit(1);
        }
        ModifierSet modifierSet = new ModifierSet(stringArray[0]);
        for (int i = 1; i < stringArray.length; i += 3) {
            modifierSet.addModifier(stringArray[i], stringArray[i + 1], stringArray[i + 2]);
        }
        System.out.println(modifierSet.toCQL());
    }
}

