/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.util.LinkedList;

public class ZMQ {
    public static final int NOBLOCK = 1;
    public static final int SNDMORE = 2;
    public static final int PAIR = 0;
    public static final int PUB = 1;
    public static final int SUB = 2;
    public static final int REQ = 3;
    public static final int REP = 4;
    public static final int XREQ = 5;
    public static final int XREP = 6;
    public static final int PULL = 7;
    public static final int PUSH = 8;
    public static final int STREAMER = 1;
    public static final int FORWARDER = 2;
    public static final int QUEUE = 3;
    @Deprecated
    public static final int UPSTREAM = 7;
    @Deprecated
    public static final int DOWNSTREAM = 8;

    protected static native int version_full();

    protected static native int version_major();

    protected static native int version_minor();

    protected static native int version_patch();

    protected static native int make_version(int var0, int var1, int var2);

    protected static native long ENOTSUP();

    protected static native long EPROTONOSUPPORT();

    protected static native long ENOBUFS();

    protected static native long ENETDOWN();

    protected static native long EADDRINUSE();

    protected static native long EADDRNOTAVAIL();

    protected static native long ECONNREFUSED();

    protected static native long EINPROGRESS();

    protected static native long EMTHREAD();

    protected static native long EFSM();

    protected static native long ENOCOMPATPROTO();

    protected static native long ETERM();

    public static Context context(int n) {
        return new Context(n);
    }

    static {
        System.loadLibrary("jzmq");
    }

    public static class Poller {
        public static final int POLLIN = 1;
        public static final int POLLOUT = 2;
        public static final int POLLERR = 4;
        private Context context = null;
        private long timeout = -2L;
        private int size = 0;
        private int next = 0;
        private int used = 0;
        private Socket[] sockets = null;
        private short[] events = null;
        private short[] revents = null;
        private LinkedList<Integer> freeSlots = null;
        private static final int SIZE_DEFAULT = 32;
        private static final int SIZE_INCREMENT = 16;

        public int register(Socket socket) {
            return this.register(socket, 7);
        }

        public int register(Socket socket, int n) {
            int n2 = -1;
            if (!this.freeSlots.isEmpty()) {
                n2 = this.freeSlots.remove();
            } else {
                if (this.next >= this.size) {
                    int n3 = this.size + 16;
                    Socket[] socketArray = new Socket[n3];
                    short[] sArray = new short[n3];
                    short[] sArray2 = new short[n3];
                    for (int i = 0; i < this.next; ++i) {
                        socketArray[i] = this.sockets[i];
                        sArray[i] = this.events[i];
                        sArray2[i] = this.revents[i];
                    }
                    this.size = n3;
                    this.sockets = socketArray;
                    this.events = sArray;
                    this.revents = sArray2;
                }
                n2 = this.next++;
            }
            this.sockets[n2] = socket;
            this.events[n2] = (short)n;
            ++this.used;
            return n2;
        }

        public void unregister(Socket socket) {
            for (int i = 0; i < this.next; ++i) {
                if (this.sockets[i] != socket) continue;
                this.sockets[i] = null;
                this.events[i] = 0;
                this.revents[i] = 0;
                this.freeSlots.add(i);
                --this.used;
                break;
            }
        }

        public Socket getSocket(int n) {
            if (n < 0 || n >= this.next) {
                return null;
            }
            return this.sockets[n];
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long l) {
            if (l < -1L) {
                return;
            }
            this.timeout = l;
        }

        public int getSize() {
            return this.size;
        }

        public int getNext() {
            return this.next;
        }

        public long poll() {
            long l = -1L;
            if (this.timeout > -1L) {
                l = this.timeout;
            }
            return this.poll(l);
        }

        public long poll(long l) {
            if (l < -1L) {
                return 0L;
            }
            if (this.size <= 0 || this.next <= 0) {
                return 0L;
            }
            for (int i = 0; i < this.next; ++i) {
                this.revents[i] = 0;
            }
            return this.run_poll(this.used, this.sockets, this.events, this.revents, l);
        }

        public boolean pollin(int n) {
            return this.poll_mask(n, 1);
        }

        public boolean pollout(int n) {
            return this.poll_mask(n, 2);
        }

        public boolean pollerr(int n) {
            return this.poll_mask(n, 4);
        }

        protected Poller(Context context) {
            this(context, 32);
        }

        protected Poller(Context context, int n) {
            this.context = context;
            this.size = n;
            this.next = 0;
            this.sockets = new Socket[this.size];
            this.events = new short[this.size];
            this.revents = new short[this.size];
            this.freeSlots = new LinkedList();
        }

        private native long run_poll(int var1, Socket[] var2, short[] var3, short[] var4, long var5);

        private boolean poll_mask(int n, int n2) {
            if (n2 <= 0 || n < 0 || n >= this.next) {
                return false;
            }
            return (this.revents[n] & n2) > 0;
        }
    }

    public static class Socket {
        private long socketHandle;
        private Context context = null;
        private static final int HWM = 1;
        private static final int SWAP = 3;
        private static final int AFFINITY = 4;
        private static final int IDENTITY = 5;
        private static final int SUBSCRIBE = 6;
        private static final int UNSUBSCRIBE = 7;
        private static final int RATE = 8;
        private static final int RECOVERY_IVL = 9;
        private static final int MCAST_LOOP = 10;
        private static final int SNDBUF = 11;
        private static final int RCVBUF = 12;
        private static final int RCVMORE = 13;
        private static final int FD = 14;
        private static final int EVENTS = 15;
        private static final int TYPE = 16;
        private static final int LINGER = 17;

        public void close() {
            this.finalize();
        }

        public long getType() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 0)) {
                return -1L;
            }
            return this.getLongSockopt(16);
        }

        public long getLinger() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 0)) {
                return -1L;
            }
            return this.getLongSockopt(17);
        }

        public long getHWM() {
            return this.getLongSockopt(1);
        }

        public long getSwap() {
            return this.getLongSockopt(3);
        }

        public long getAffinity() {
            return this.getLongSockopt(4);
        }

        public byte[] getIdentity() {
            return this.getBytesSockopt(5);
        }

        public long getRate() {
            return this.getLongSockopt(8);
        }

        public long getRecoveryInterval() {
            return this.getLongSockopt(9);
        }

        public boolean hasMulticastLoop() {
            return this.getLongSockopt(10) != 0L;
        }

        public long getSendBufferSize() {
            return this.getLongSockopt(11);
        }

        public long getReceiveBufferSize() {
            return this.getLongSockopt(12);
        }

        public boolean hasReceiveMore() {
            return this.getLongSockopt(13) != 0L;
        }

        public long getFD() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 0)) {
                return -1L;
            }
            return this.getLongSockopt(14);
        }

        public long getEvents() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 0)) {
                return -1L;
            }
            return this.getLongSockopt(15);
        }

        public void setLinger(long l) {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 0)) {
                return;
            }
            this.setLongSockopt(17, l);
        }

        public void setHWM(long l) {
            this.setLongSockopt(1, l);
        }

        public void setSwap(long l) {
            this.setLongSockopt(3, l);
        }

        public void setAffinity(long l) {
            this.setLongSockopt(4, l);
        }

        public void setIdentity(byte[] byArray) {
            this.setBytesSockopt(5, byArray);
        }

        public void subscribe(byte[] byArray) {
            this.setBytesSockopt(6, byArray);
        }

        public void unsubscribe(byte[] byArray) {
            this.setBytesSockopt(7, byArray);
        }

        public void setRate(long l) {
            this.setLongSockopt(8, l);
        }

        public void setRecoveryInterval(long l) {
            this.setLongSockopt(9, l);
        }

        public void setMulticastLoop(boolean bl) {
            this.setLongSockopt(10, bl ? 1L : 0L);
        }

        public void setSendBufferSize(long l) {
            this.setLongSockopt(11, l);
        }

        public void setReceiveBufferSize(long l) {
            this.setLongSockopt(12, l);
        }

        public native void bind(String var1);

        public native void connect(String var1);

        public native boolean send(byte[] var1, int var2);

        public native byte[] recv(int var1);

        protected Socket(Context context, int n) {
            this.context = context;
            this.construct(context, n);
        }

        protected native void construct(Context var1, int var2);

        protected native void finalize();

        protected native long getLongSockopt(int var1);

        protected native byte[] getBytesSockopt(int var1);

        protected native void setLongSockopt(int var1, long var2);

        protected native void setBytesSockopt(int var1, byte[] var2);

        private long getSocketHandle() {
            return this.socketHandle;
        }
    }

    public static class Context {
        private long contextHandle;

        public void term() {
            this.finalize();
        }

        public Socket socket(int n) {
            return new Socket(this, n);
        }

        public Poller poller() {
            return new Poller(this);
        }

        public Poller poller(int n) {
            return new Poller(this, n);
        }

        protected Context(int n) {
            this.construct(n);
        }

        protected native void construct(int var1);

        protected native void finalize();

        private long getContextHandle() {
            return this.contextHandle;
        }
    }

    public static enum Error {
        ENOTSUP(ZMQ.ENOTSUP()),
        EPROTONOSUPPORT(ZMQ.EPROTONOSUPPORT()),
        ENOBUFS(ZMQ.ENOBUFS()),
        ENETDOWN(ZMQ.ENETDOWN()),
        EADDRINUSE(ZMQ.EADDRINUSE()),
        EADDRNOTAVAIL(ZMQ.EADDRNOTAVAIL()),
        ECONNREFUSED(ZMQ.ECONNREFUSED()),
        EINPROGRESS(ZMQ.EINPROGRESS()),
        EMTHREAD(ZMQ.EMTHREAD()),
        EFSM(ZMQ.EFSM()),
        ENOCOMPATPROTO(ZMQ.ENOCOMPATPROTO()),
        ETERM(ZMQ.ETERM());

        private final long code;

        private Error(long l) {
            this.code = l;
        }

        public long getCode() {
            return this.code;
        }

        public static Error findByCode(int n) {
            for (Error error : (Error[])Error.class.getEnumConstants()) {
                if (error.getCode() != (long)n) continue;
                return error;
            }
            throw new IllegalArgumentException("Unknown " + Error.class.getName() + " enum code:" + n);
        }
    }
}

