/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.timeline;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import org.zkforge.json.simple.JSONArray;
import org.zkforge.timeline.BandScrollCommand;
import org.zkforge.timeline.Hotzone;
import org.zkforge.timeline.OccurEventSelectCommand;
import org.zkforge.timeline.Timeline;
import org.zkforge.timeline.data.OccurEvent;
import org.zkforge.timeline.decorator.HighlightDecorator;
import org.zkforge.timeline.event.BandScrollEvent;
import org.zkforge.timeline.impl.TimelineComponent;
import org.zkforge.timeline.util.TimelineUtil;
import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;

public class Bandinfo
extends TimelineComponent {
    private ListModel _model;
    private SortedSet _events = new TreeSet();
    private ArrayList _eventList = new ArrayList();
    private Date _min;
    private Date _max;
    private transient ListDataListener _dataListener;
    private String _width = "70%";
    private String _intervalUnit = "month";
    private int _intervalPixels = 100;
    private boolean _highlight = true;
    private boolean _showEventText = true;
    private String _syncWith;
    private TimeZone _timeZone = TimeZone.getDefault();
    private float _trackHeight = 1.5f;
    private float _trackGap = 0.5f;
    private Date _date = new Date();
    private String _eventSourceUrl;
    private boolean bubbleVisible = true;

    public String getInnerAttrs() {
        String attrs = super.getInnerAttrs();
        StringBuffer sb = new StringBuffer(64);
        if (attrs != null) {
            sb.append(attrs);
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pid", (String)this.getParent().getUuid());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.highlight", (boolean)this.isHighlight());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.width", (String)this.getWidth());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.intervalUnit", (String)TimelineUtil.convertIntervalUnitFromName(this._intervalUnit));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.intervalPixels", (int)this.getIntervalPixels());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.showEventText", (boolean)this.isShowEventText());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.timeZone", (int)(this._timeZone.getRawOffset() / 3600000));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.trackHeight", (String)String.valueOf(this.getTrackHeight()));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.syncWith", (String)this.findSyncWithIndex(this._syncWith));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.trackGap", (String)String.valueOf(this.getTrackGap()));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.date", (String)TimelineUtil.formatDateTime(this.getDate()));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.eventSourceUrl", (String)this._eventSourceUrl);
        return sb.toString();
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Timeline)) {
            throw new UiException("Unsupported parent for bandinfo: " + parent);
        }
        super.setParent(parent);
    }

    public String getWidth() {
        return this._width;
    }

    public void setWidth(String width) {
        if (!Objects.equals((Object)this._width, (Object)width)) {
            this._width = width;
            this.invalidate();
        }
    }

    public int getIntervalPixels() {
        return this._intervalPixels;
    }

    public void setIntervalPixels(int intervalPixels) {
        if (intervalPixels != this._intervalPixels) {
            this._intervalPixels = intervalPixels;
            this.invalidate();
        }
    }

    public String getIntervalUnit() {
        return this._intervalUnit;
    }

    public void setIntervalUnit(String intervalUnit) {
        if (!Objects.equals((Object)intervalUnit, (Object)this._intervalUnit)) {
            this._intervalUnit = intervalUnit;
            this.invalidate();
        }
    }

    public boolean isShowEventText() {
        return this._showEventText;
    }

    public void setShowEventText(boolean showEventText) {
        if (showEventText != this._showEventText) {
            this._showEventText = showEventText;
            this.invalidate();
        }
    }

    private String findSyncWithIndex(String id) {
        Timeline parent = (Timeline)this.getParent();
        List l = parent.getChildren();
        for (int i = 0; i < l.size(); ++i) {
            Bandinfo b = (Bandinfo)((Object)l.get(i));
            if (!b.getId().equals(id)) continue;
            return String.valueOf(i);
        }
        return "";
    }

    public String getSyncWith() {
        return this._syncWith;
    }

    public void setSyncWith(String syncWith) {
        if (!Objects.equals((Object)syncWith, (Object)this._syncWith)) {
            this._syncWith = syncWith;
            this.invalidate();
        }
    }

    public boolean isHighlight() {
        return this._highlight;
    }

    public void setHighlight(boolean highlight) {
        if (highlight != this._highlight) {
            this._highlight = highlight;
            this.invalidate();
        }
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (!Objects.equals((Object)timeZone, (Object)this._timeZone)) {
            this._timeZone = timeZone;
            this.invalidate();
        }
    }

    public float getTrackGap() {
        return this._trackGap;
    }

    public void setTrackGap(float trackGap) {
        if (trackGap != this._trackGap) {
            this._trackGap = trackGap;
            this.invalidate();
        }
    }

    public float getTrackHeight() {
        return this._trackHeight;
    }

    public void setTrackHeight(float trackHeight) {
        if (trackHeight != this._trackHeight) {
            this._trackHeight = trackHeight;
            this.invalidate();
        }
    }

    public Date getDate() {
        return this._date;
    }

    public void setDate(Date date) {
        if (!Objects.equals((Object)date, (Object)this._date)) {
            this._date = date;
            this.invalidate();
        }
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (!(child instanceof Hotzone)) {
            throw new UiException("Unsupported child for timeline: " + child);
        }
        return super.insertBefore(child, insertBefore);
    }

    public void addOccurEvent(OccurEvent event) {
        if (event == null) {
            return;
        }
        this.response("addOccurEvent" + event.getId(), (AuResponse)new AuScript((Component)this, "zkBandInfo.addOccurEvent(\"" + this.getUuid() + "\"" + "," + event.toString() + ")"));
    }

    public void removeOccurEvent(OccurEvent event) {
        if (event == null) {
            return;
        }
        this.response("removeOccurEvent" + event.getId(), (AuResponse)new AuScript((Component)this, "zkBandInfo.removeOccurEvent(\"" + this.getUuid() + "\"" + "," + "\"" + event.getId() + "\")"));
    }

    public void modifyOccurEvent(OccurEvent event) {
        if (event == null) {
            return;
        }
        this.response("modifyOccurEvent" + event.getId(), (AuResponse)new AuScript((Component)this, "zkBandInfo.modifyOccurEvent(\"" + this.getUuid() + "\"" + "," + event.toString() + ")"));
    }

    public String getEventSourceUrl() {
        return this._eventSourceUrl;
    }

    public void setEventSourceUrl(String eventSourceUrl) {
        if (!Objects.equals((Object)eventSourceUrl, (Object)this._eventSourceUrl)) {
            this._eventSourceUrl = eventSourceUrl;
            this.smartUpdate("z.eventSourceUrl", eventSourceUrl);
        }
    }

    public void invalidate() {
        super.invalidate();
        if (this.getParent() != null) {
            this.getParent().invalidate();
        }
    }

    public void addManyOccurEvents(Iterator iter) {
        if (iter == null) {
            return;
        }
        JSONArray list = new JSONArray();
        while (iter.hasNext()) {
            OccurEvent e = (OccurEvent)iter.next();
            list.add(e);
        }
        this.response("addManyOccurEvent" + iter.hashCode(), (AuResponse)new AuScript((Component)this, "zkBandInfo.addManyOccurEvent(\"" + this.getUuid() + "\"" + "," + list.toString() + ")"));
    }

    public void addHighlightDecorator(HighlightDecorator hd) {
        if (hd == null) {
            return;
        }
        this.response("addHighlightDecorator" + hd.getId(), (AuResponse)new AuScript((Component)this, "zkBandInfo.addHighlightDecorator(\"" + this.getUuid() + "\"" + "," + hd.toString() + ")"));
    }

    public void removeHighlightDecorator(HighlightDecorator hd) {
        if (hd == null) {
            return;
        }
        this.response("removeHighlightDecorator" + hd.getId(), (AuResponse)new AuScript((Component)this, "zkBandInfo.removeHighlightDecorator(\"" + this.getUuid() + "\"" + "," + hd.getId() + ")"));
    }

    public void showLoadingMessage(boolean show) {
        if (show) {
            this.response("showLoadingMessage", (AuResponse)new AuScript((Component)this, "zkTimeline.showLoadingMessage(\"" + this.getParent().getUuid() + "\"" + ")"));
        } else {
            this.response("hideLoadingMessage", (AuResponse)new AuScript((Component)this, "zkTimeline.hideLoadingMessage(\"" + this.getParent().getUuid() + "\"" + ")"));
        }
    }

    public void scrollToCenter(Date date) {
        if (date == null) {
            return;
        }
        this.response("scrollToCenter", (AuResponse)new AuScript((Component)this, "zkBandInfo.scrollToCenter(\"" + this.getUuid() + "\"" + ",\"" + date.toString() + "\")"));
    }

    public ListModel getModel() {
        return this._model;
    }

    public void setModel(ListModel model) {
        if (this._model != null) {
            this._model.removeListDataListener(this._dataListener);
        }
        this._model = model;
        if (this._model != null) {
            this._dataListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    Bandinfo.this.onListDataChange(event);
                }
            };
            this._model.addListDataListener(this._dataListener);
            this._events.clear();
            this._eventList.clear();
            this.invalidate();
            int count = this._model.getSize();
            for (int i = 0; i < count; ++i) {
                Object o = this._model.getElementAt(i);
                this._events.add(o);
                this._eventList.add(o);
            }
        }
        this.addEventListener("onBandScroll", new BandScrollListener());
    }

    protected void syncModel(Date min, Date max) {
        OccurEvent e1 = new OccurEvent();
        e1.setStart(min);
        OccurEvent e2 = new OccurEvent();
        e2.setStart(max);
        SortedSet<OccurEvent> ss = this._events.subSet(e1, e2);
        Iterator iter = ss.iterator();
        this.addManyOccurEvents(iter);
    }

    protected void onListDataChange(ListDataEvent event) {
        int lower = event.getIndex0();
        int upper = event.getIndex1();
        OccurEvent e1 = new OccurEvent();
        e1.setStart(this._min);
        OccurEvent e2 = new OccurEvent();
        e2.setStart(this._max);
        switch (event.getType()) {
            case 1: {
                for (int i = lower; i <= upper; ++i) {
                    OccurEvent oe = (OccurEvent)this._model.getElementAt(i);
                    this._events.add(oe);
                    this._eventList.add(oe);
                    if (oe.compareTo(e1) < 0 || oe.compareTo(e2) > 0) continue;
                    this.addOccurEvent(oe);
                }
                break;
            }
            case 2: {
                for (int i = upper; i >= lower; --i) {
                    OccurEvent oe = (OccurEvent)this._eventList.get(i);
                    this._events.remove(oe);
                    this._eventList.remove(oe);
                    this.removeOccurEvent(oe);
                    oe = null;
                }
                break;
            }
            case 0: {
                for (int i = lower; i <= upper; ++i) {
                    OccurEvent oe = (OccurEvent)this._model.getElementAt(i);
                    OccurEvent e = (OccurEvent)this._eventList.get(i);
                    this._eventList.set(i, oe);
                    this._events.remove(e);
                    this._events.add(oe);
                    this.removeOccurEvent(e);
                    if (oe.compareTo(e1) < 0 || oe.compareTo(e2) > 0) continue;
                    this.addOccurEvent(oe);
                }
                break;
            }
        }
    }

    public void setShowBubble(boolean showBubble) {
    }

    public void setBubbleVisible(boolean bubbleVisible) {
        if (this.bubbleVisible != bubbleVisible) {
            this.bubbleVisible = bubbleVisible;
            this.smartUpdate("z.showBubble", this.bubbleVisible);
        }
    }

    public boolean isBubbleVisible() {
        return this.bubbleVisible;
    }

    static {
        new BandScrollCommand("onBandScroll", 8);
        new OccurEventSelectCommand("onOccurEventSelect", 8);
    }

    private class BandScrollListener
    implements EventListener {
        private BandScrollListener() {
        }

        public boolean isAsap() {
            return true;
        }

        public void onEvent(Event event) {
            BandScrollEvent e = (BandScrollEvent)event;
            Date newmin = e.getMin();
            Date newmax = e.getMax();
            if (Bandinfo.this._min == null && Bandinfo.this._max == null) {
                Bandinfo.this._min = newmin;
                Bandinfo.this._max = newmax;
                Bandinfo.this.syncModel(Bandinfo.this._min, Bandinfo.this._max);
            }
            if (newmin.compareTo(Bandinfo.this._min) < 0) {
                Bandinfo.this.syncModel(newmin, Bandinfo.this._min);
                Bandinfo.this._min = newmin;
            }
            if (newmax.compareTo(Bandinfo.this._max) > 0) {
                Bandinfo.this.syncModel(Bandinfo.this._max, newmax);
                Bandinfo.this._max = newmax;
            }
        }
    }
}

