/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.timeline;

import java.util.Date;
import org.zkforge.timeline.Bandinfo;
import org.zkforge.timeline.impl.TimelineComponent;
import org.zkforge.timeline.util.TimelineUtil;
import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

public class Hotzone
extends TimelineComponent {
    private Date _start = new Date();
    private Date _end = new Date();
    private int _magnify = 7;
    private String _unit = "week";
    private int _multiple = 1;

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Bandinfo)) {
            throw new UiException("Unsupported parent for hotzone: " + parent);
        }
        super.setParent(parent);
    }

    public String getInnerAttrs() {
        String attrs = super.getInnerAttrs();
        StringBuffer sb = new StringBuffer(128);
        if (attrs != null) {
            sb.append(attrs);
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pid", (String)this.getParent().getUuid());
        if (this.getStart() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.start", (String)TimelineUtil.formatDateTime(this.getStart()));
        }
        if (this.getEnd() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.end", (String)TimelineUtil.formatDateTime(this.getEnd()));
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.magnify", (int)this.getMagnify());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.unit", (String)TimelineUtil.convertIntervalUnitFromName(this.getUnit()));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.multiple", (int)this.getMultiple());
        return sb.toString();
    }

    public Date getEnd() {
        return this._end;
    }

    public void setEnd(Date end) {
        if (!Objects.equals((Object)end, (Object)this._end)) {
            this._end = end;
            this.invalidate();
        }
    }

    public int getMagnify() {
        return this._magnify;
    }

    public void setMagnify(int magnify) {
        if (magnify != this._magnify) {
            this._magnify = magnify;
            this.invalidate();
        }
    }

    public Date getStart() {
        return this._start;
    }

    public void setStart(Date start) {
        if (!Objects.equals((Object)start, (Object)this._start)) {
            this._start = start;
            this.invalidate();
        }
    }

    public String getUnit() {
        return this._unit;
    }

    public void setUnit(String unit) {
        if (!Objects.equals((Object)unit, (Object)this._unit)) {
            this._unit = unit;
            this.invalidate();
        }
    }

    public String getContent() {
        return "";
    }

    public int getMultiple() {
        return this._multiple;
    }

    public void setMultiple(int multiple) {
        if (multiple != this._multiple) {
            this._multiple = multiple;
            this.invalidate();
        }
    }

    public void invalidate() {
        super.invalidate();
        if (this.getParent() != null) {
            this.getParent().invalidate();
        }
    }
}

