/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Objects;
import org.zkoss.util.Cache;

public class CacheMap
implements Map,
Cache,
Serializable,
Cloneable {
    private static final long serialVersionUID = 20070907L;
    public static final int DEFAULT_MAXSIZE = 1024;
    private Map _map;
    private int _lifetime = 1800000;
    private int _maxsize = 512;
    private transient ReferenceQueue _que;
    private transient WeakReference _ref;
    private transient boolean _inExpunge;
    protected static final int EXPUNGE_NO = 0;
    protected static final int EXPUNGE_YES = 1;
    protected static final int EXPUNGE_CONTINUE = 0;
    protected static final int EXPUNGE_STOP = 2;
    static /* synthetic */ Class class$org$zkoss$util$CacheMap;

    protected void onExpunge(Value v) {
    }

    protected boolean shallExpunge() {
        return this._que == null || this._que.poll() != null;
    }

    protected int canExpunge(Value v) {
        return this._map.size() > this.getMaxSize() || System.currentTimeMillis() - v.access > (long)this.getLifetime() ? 1 : 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryExpunge() {
        if (this.shallExpunge()) {
            if (this._inExpunge) {
                throw new IllegalStateException("expung in expung?");
            }
            try {
                this.expunge();
            }
            finally {
                this.newRef();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int expunge() {
        if (this._inExpunge || this._map.isEmpty()) {
            return this._map.size();
        }
        this._inExpunge = true;
        try {
            Iterator it = this._map.values().iterator();
            while (it.hasNext()) {
                Value v = (Value)it.next();
                int result = this.canExpunge(v);
                if ((result & 1) != 0) {
                    it.remove();
                    this.onExpunge(v);
                }
                if ((result & 2) == 0) continue;
                break;
            }
            int n = this._map.size();
            return n;
        }
        finally {
            this._inExpunge = false;
        }
    }

    protected ReferenceQueue newQueue() {
        return new ReferenceQueue();
    }

    private void newRef() {
        if (this._que != null) {
            this._ref = new WeakReference<X>(new X(), this._que);
        }
    }

    public CacheMap(int maxSize, int lifetime) {
        this();
        this.setMaxSize(maxSize);
        this.setLifetime(lifetime);
    }

    public CacheMap() {
        this._map = new LinkedHashMap(16, 0.75f, true);
        this.init();
    }

    public CacheMap(int cap) {
        this._map = new LinkedHashMap(cap, 0.75f, true);
        this.init();
    }

    public CacheMap(int cap, float load) {
        this._map = new LinkedHashMap(cap, load, true);
        this.init();
    }

    private void init() {
        this._que = this.newQueue();
        this.newRef();
    }

    public int getLifetime() {
        return this._lifetime;
    }

    public void setLifetime(int lifetime) {
        this._lifetime = lifetime;
    }

    public int getMaxSize() {
        return this._maxsize;
    }

    public void setMaxSize(int maxsize) {
        this._maxsize = maxsize;
    }

    public boolean isEmpty() {
        this.tryExpunge();
        return this._map.isEmpty();
    }

    public boolean isEmptyWithoutExpunge() {
        return this._map.isEmpty();
    }

    public int size() {
        this.tryExpunge();
        return this._map.size();
    }

    public int sizeWithoutExpunge() {
        return this._map.size();
    }

    public void clear() {
        this._map.clear();
    }

    public Object remove(Object key) {
        this.tryExpunge();
        Value v = (Value)this._map.remove(key);
        return v != null ? v.value : null;
    }

    public Object get(Object key) {
        this.tryExpunge();
        return this.getWithoutExpunge(key);
    }

    public Object getWithoutExpunge(Object key) {
        Value v = (Value)this._map.get(key);
        if (v != null) {
            v.updateAccessTime();
            return v.value;
        }
        return null;
    }

    public boolean containsKey(Object key) {
        this.tryExpunge();
        return this._map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        this.tryExpunge();
        Iterator it = this._map.values().iterator();
        while (it.hasNext()) {
            Value v = (Value)it.next();
            if (!Objects.equals(v.value, value)) continue;
            return true;
        }
        return false;
    }

    public Object put(Object key, Object value) {
        this.tryExpunge();
        Value v = this._map.put(key, new Value(value));
        return v != null ? v.value : null;
    }

    public void putAll(Map map) {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            this.put(me.getKey(), me.getValue());
        }
    }

    public Set entrySet() {
        this.tryExpunge();
        return new EntrySet();
    }

    public Set keySet() {
        this.tryExpunge();
        return new KeySet();
    }

    public Collection values() {
        this.tryExpunge();
        return new Values();
    }

    public int hashCode() {
        this.tryExpunge();
        return ((Object)this._map).hashCode();
    }

    public boolean equals(Object o) {
        this.tryExpunge();
        return o == this || o instanceof CacheMap && ((Object)this._map).equals(((CacheMap)o)._map) || o instanceof Map && ((Object)this._map).equals((Map)o);
    }

    public String toString() {
        this.tryExpunge();
        StringBuffer sb = new StringBuffer(128).append('{');
        if (!this._map.isEmpty()) {
            Iterator it = this._map.entrySet().iterator();
            while (true) {
                Map.Entry me = it.next();
                sb.append(me.getKey()).append('=').append(Objects.toString(((Value)me.getValue()).value));
                if (!it.hasNext()) break;
                sb.append(", ");
            }
        }
        return sb.append('}').toString();
    }

    public Object clone() {
        CacheMap clone;
        try {
            clone = (CacheMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone._map = new LinkedHashMap(clone._map);
        Iterator it = clone._map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            me.setValue(((Value)me.getValue()).clone());
        }
        clone.init();
        return clone;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public Iterator iterator() {
            return new ValueIter(CacheMap.this._map.values().iterator());
        }

        public int size() {
            return CacheMap.this.size();
        }

        public boolean contains(Object o) {
            return CacheMap.this.containsValue(o);
        }

        public void clear() {
            CacheMap.this.clear();
        }
    }

    private class ValueIter
    extends KeyIter {
        private ValueIter(Iterator it) {
            super(it);
        }

        public Object next() {
            return ((Value)this._it.next()).value;
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            CacheMap.this.tryExpunge();
            return new KeyIter(CacheMap.this._map.keySet().iterator());
        }

        public boolean contains(Object o) {
            return CacheMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            return CacheMap.this.remove(o) != null;
        }

        public int size() {
            return CacheMap.this.size();
        }

        public void clear() {
            CacheMap.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            CacheMap.this.tryExpunge();
            return new EntryIter(CacheMap.this._map.entrySet().iterator());
        }

        public boolean contains(Object o) {
            return o instanceof Map.Entry && CacheMap.this.containsKey(((Map.Entry)o).getKey());
        }

        public boolean remove(Object o) {
            return o instanceof Map.Entry && CacheMap.this.remove(((Map.Entry)o).getKey()) != null;
        }

        public int size() {
            return CacheMap.this.size();
        }

        public void clear() {
            CacheMap.this.clear();
        }
    }

    private class EntryIter
    extends KeyIter {
        private EntryIter(Iterator it) {
            super(it);
        }

        public Object next() {
            return new Entry((Map.Entry)this._it.next());
        }
    }

    private class KeyIter
    implements Iterator {
        protected Iterator _it;

        private KeyIter(Iterator it) {
            this._it = it;
        }

        public boolean hasNext() {
            return this._it.hasNext();
        }

        public void remove() {
            this._it.remove();
        }

        public Object next() {
            return this._it.next();
        }
    }

    private class Entry
    implements Map.Entry {
        final Map.Entry _me;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Entry(Map.Entry me) {
            this._me = me;
        }

        public Object getKey() {
            return this._me.getKey();
        }

        public Object getValue() {
            return ((Value)this._me.getValue()).value;
        }

        public Object setValue(Object o) {
            if (!$assertionsDisabled && o instanceof Value) {
                throw new AssertionError();
            }
            Value v = (Value)this._me.getValue();
            Object old = v.value;
            v.value = o;
            return old;
        }

        public int hashCode() {
            return ((Object)this._me).hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof Entry && ((Object)this._me).equals(((Entry)o)._me);
        }

        static {
            $assertionsDisabled = !(class$org$zkoss$util$CacheMap == null ? (class$org$zkoss$util$CacheMap = CacheMap.class$("org.zkoss.util.CacheMap")) : class$org$zkoss$util$CacheMap).desiredAssertionStatus();
        }
    }

    protected static final class Value
    implements Serializable,
    Cloneable {
        private Object value;
        private long access;

        private Value(Object value) {
            this.value = value;
            this.updateAccessTime();
        }

        private final void updateAccessTime() {
            this.access = System.currentTimeMillis();
        }

        public final Object getValue() {
            return this.value;
        }

        public final long getAccessTime() {
            return this.access;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        public final String toString() {
            return "(" + this.value + '@' + this.access + ')';
        }
    }

    private static class X {
        private X() {
        }
    }
}

