/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.lang.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.zkoss.lang.Classes;

public class FacadeInvoker
implements InvocationHandler {
    private Object _target;

    public static final Object newInstance(Object target, Class[] interfaces, ClassLoader clsLoader) {
        return Proxy.newProxyInstance(clsLoader, interfaces, (InvocationHandler)new FacadeInvoker(target));
    }

    public static final Object newInstance(Object target, Class[] interfaces) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return FacadeInvoker.newInstance(target, interfaces, cl != null ? cl : FacadeInvoker.class.getClassLoader());
    }

    protected FacadeInvoker(Object target) {
        this._target = target;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> cls = this._target.getClass();
        if (!method.getDeclaringClass().isAssignableFrom(cls)) {
            method = Classes.getMethodInPublic(cls, method.getName(), method.getParameterTypes());
        }
        try {
            return method.invoke(this._target, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getCause();
        }
    }
}

