/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.zkoss.lang.Strings;

public class CollectionsX {
    public static final Iterator EMPTY_ITERATOR;
    public static final Enumeration EMPTY_ENUMERATION;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static final Object[] toArray(Collection col, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        Object[] result = new Object[newLength];
        int i = 0;
        int j = 0;
        Iterator it = col.iterator();
        while (it.hasNext() && i < result.length) {
            if (j++ < from) {
                it.next();
                continue;
            }
            result[i++] = it.next();
        }
        return result;
    }

    public static final int addAll(Collection col, Iterator iter) {
        int cnt = 0;
        if (iter != null) {
            while (iter.hasNext()) {
                col.add(iter.next());
                ++cnt;
            }
        }
        return cnt;
    }

    public static final int addAll(Collection col, Enumeration enm) {
        int cnt = 0;
        if (enm != null) {
            while (enm.hasMoreElements()) {
                col.add(enm.nextElement());
                ++cnt;
            }
        }
        return cnt;
    }

    public static final int addAll(Collection col, Object[] ary) {
        int cnt;
        if (ary != null) {
            for (cnt = 0; cnt < ary.length; ++cnt) {
                col.add(ary[cnt]);
            }
        }
        return cnt;
    }

    public static final boolean isIntersected(Set a, Set b) {
        Set small;
        Set large;
        int szb;
        int sza = a != null ? a.size() : 0;
        int n = szb = b != null ? b.size() : 0;
        if (sza == 0 || szb == 0) {
            return false;
        }
        if (sza > szb) {
            large = a;
            small = b;
        } else {
            large = b;
            small = a;
        }
        Iterator it = small.iterator();
        while (it.hasNext()) {
            if (!large.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    public static final Collection parse(Collection c, String src, char separator) {
        return CollectionsX.parse(c, src, separator, true);
    }

    public static final Collection parse(Collection c, String src, char separator, boolean escBackslash) {
        return CollectionsX.parse(c, src, separator, escBackslash, false);
    }

    public static final Collection parse(Collection c, String src, char separator, boolean escBackslash, boolean parenthesis) {
        Strings.Result res;
        if (c == null) {
            c = new LinkedList<String>();
        }
        char[] seps = new char[]{separator};
        int j = 0;
        while ((res = Strings.nextToken(src, j, seps, escBackslash, true, parenthesis)) != null) {
            if (!$assertionsDisabled && res.token == null) {
                throw new AssertionError();
            }
            c.add(res.token);
            j = res.next;
        }
        return c;
    }

    public static final Iterator iterator(Object obj) {
        if (obj instanceof Object[]) {
            return new ArrayIterator((Object[])obj);
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).iterator();
        }
        if (obj instanceof Map) {
            return ((Map)obj).entrySet().iterator();
        }
        throw new IllegalArgumentException("obj must be a Collection, a Map, or an Object array. obj: " + obj);
    }

    static {
        $assertionsDisabled = !CollectionsX.class.desiredAssertionStatus();
        EMPTY_ITERATOR = new Iterator(){

            public final boolean hasNext() {
                return false;
            }

            public final Object next() {
                throw new NoSuchElementException();
            }

            public final void remove() {
                throw new IllegalStateException();
            }
        };
        EMPTY_ENUMERATION = new Enumeration(){

            public final boolean hasMoreElements() {
                return false;
            }

            public final Object nextElement() {
                throw new NoSuchElementException();
            }
        };
    }

    public static final class EnumerationIterator
    implements Iterator {
        private final Enumeration _enm;

        public EnumerationIterator(Enumeration enm) {
            this._enm = enm;
        }

        public final boolean hasNext() {
            return this._enm != null && this._enm.hasMoreElements();
        }

        public final Object next() {
            if (this._enm == null) {
                throw new NoSuchElementException();
            }
            return this._enm.nextElement();
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class OneIterator
    implements Iterator {
        private boolean _nomore;
        private final Object _one;

        public OneIterator(Object one) {
            this._one = one;
        }

        public final boolean hasNext() {
            return !this._nomore;
        }

        public final Object next() {
            if (this._nomore) {
                throw new NoSuchElementException();
            }
            this._nomore = true;
            return this._one;
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class OneCollection
    extends AbstractCollection {
        private final Object _one;

        public OneCollection(Object one) {
            this._one = one;
        }

        public final int size() {
            return 1;
        }

        public Iterator iterator() {
            return new OneIterator(this._one);
        }
    }

    public static class ArrayListIterator
    extends ArrayIterator
    implements ListIterator {
        public ArrayListIterator(Object[] ary) {
            super(ary);
        }

        public ArrayListIterator(Object[] ary, int index) {
            super(ary);
            int len;
            this._cursor = index;
            int n = len = this._ary != null ? this._ary.length : 0;
            if (this._cursor < 0 || this._cursor > len) {
                throw new IndexOutOfBoundsException("index=" + index + " but len=" + len);
            }
        }

        public final boolean hasPrevious() {
            return this._ary != null && this._cursor > 0;
        }

        public final Object previous() {
            if (this.hasPrevious()) {
                this._last = --this._cursor;
                return this._ary[this._cursor];
            }
            throw new NoSuchElementException("cursor=" + this._cursor);
        }

        public final int nextIndex() {
            return this._cursor;
        }

        public final int previousIndex() {
            return this._cursor - 1;
        }

        public final void set(Object o) {
            if (this._last < 0) {
                throw new IllegalStateException("neither next nor previous have been called");
            }
            this._ary[this._last] = o;
        }

        public final void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    public static class ArrayIterator
    implements Iterator {
        final Object[] _ary;
        int _cursor = 0;
        int _last = -1;

        public ArrayIterator(Object[] ary) {
            this._ary = ary;
        }

        public final boolean hasNext() {
            return this._ary != null && this._cursor < this._ary.length;
        }

        public final Object next() {
            if (this.hasNext()) {
                this._last = this._cursor++;
                return this._ary[this._last];
            }
            throw new NoSuchElementException("cursor=" + this._cursor);
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class ArrayList
    extends AbstractList {
        private final Object[] _ary;

        public ArrayList(Object[] ary) {
            this._ary = ary;
        }

        public final int size() {
            return this._ary != null ? this._ary.length : 0;
        }

        public final Object get(int index) {
            return this._ary[index];
        }
    }

    public static final class ArrayCollection
    extends AbstractCollection {
        private final Object[] _ary;

        public ArrayCollection(Object[] ary) {
            this._ary = ary;
        }

        public final int size() {
            return this._ary != null ? this._ary.length : 0;
        }

        public Iterator iterator() {
            return new ArrayIterator(this._ary);
        }
    }

    public static final class OneEnumeration
    implements Enumeration {
        private boolean _nomore;
        private final Object _one;

        public OneEnumeration(Object one) {
            this._one = one;
        }

        public final boolean hasMoreElements() {
            return !this._nomore;
        }

        public final Object nextElement() {
            if (this._nomore) {
                throw new NoSuchElementException();
            }
            this._nomore = true;
            return this._one;
        }
    }

    public static final class ArrayEnumeration
    implements Enumeration {
        private final Object[] _ary;
        private int _cursor = 0;

        public ArrayEnumeration(Object[] ary) {
            this._ary = ary;
        }

        public final boolean hasMoreElements() {
            return this._ary != null && this._cursor < this._ary.length;
        }

        public final Object nextElement() {
            if (this.hasMoreElements()) {
                return this._ary[this._cursor++];
            }
            throw new NoSuchElementException();
        }
    }

    public static final class CollectionEnumeration
    implements Enumeration {
        private final Iterator _iter;

        public CollectionEnumeration(Collection c) {
            this(c != null ? c.iterator() : null);
        }

        public CollectionEnumeration(Iterator iter) {
            this._iter = iter;
        }

        public final boolean hasMoreElements() {
            return this._iter != null && this._iter.hasNext();
        }

        public final Object nextElement() {
            if (this._iter != null) {
                return this._iter.next();
            }
            throw new NoSuchElementException();
        }
    }
}

