/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.logging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.zkoss.io.FileWatchdog;
import org.zkoss.io.Files;
import org.zkoss.lang.Classes;
import org.zkoss.lang.SystemException;
import org.zkoss.mesg.MCommon;
import org.zkoss.util.logging.Log;

public class LogService {
    private static final Log log = Log.lookup(LogService.class);
    private static final Map _svcs = new HashMap(5);
    private static final String SERVICE_NAME = "logging";
    protected final String _root;
    private FileWatchdog _logwdog;
    private File _logfn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isInited(String rootnm) {
        Map map = _svcs;
        synchronized (map) {
            return _svcs.containsKey(rootnm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LogService init(String rootnm, Class cls) {
        if (rootnm == null) {
            throw new IllegalArgumentException("null");
        }
        Log.setHierarchy(true);
        Logger root = Logger.getLogger(rootnm);
        Map map = _svcs;
        synchronized (map) {
            LogService svc = (LogService)_svcs.get(root);
            if (svc != null) {
                log.warning("Already started: " + rootnm);
            } else {
                try {
                    svc = (LogService)Classes.newInstance(cls != null ? cls : LogService.class, new Class[]{String.class}, new Object[]{rootnm});
                }
                catch (Exception ex) {
                    throw SystemException.Aide.wrap(ex);
                }
                _svcs.put(root, svc);
            }
            return svc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void stop(String rootnm) {
        LogService svc;
        if (rootnm == null) {
            throw new IllegalArgumentException("null");
        }
        Logger root = Logger.getLogger(rootnm);
        Map map = _svcs;
        synchronized (map) {
            svc = (LogService)_svcs.get(root);
            if (svc == null) {
                return;
            }
        }
        svc.stop();
    }

    public LogService(String root) {
        if (root == null) {
            throw new IllegalArgumentException("null");
        }
        this._root = root;
        try {
            this._logfn = new File(Files.getConfigDirectory(), "i3-log.conf");
            if (this._logfn.exists()) {
                log.info("Monitor " + this._logfn);
            } else {
                log.info("File not found: " + this._logfn);
            }
            this._logwdog = this.configureAndWatch(this._logfn, 10000L);
        }
        catch (Exception ex) {
            log.warning(ex);
        }
        log.debug(MCommon.SERVICE_INIT_OK, SERVICE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        System.out.println("Stopping logging...");
        Logger root = Logger.getLogger(this._root);
        Map map = _svcs;
        synchronized (map) {
            Object o = _svcs.remove(root);
            if (o != this) {
                _svcs.put(root, this);
                throw new IllegalStateException("LogService has beeing stopped");
            }
        }
        if (this._logwdog != null) {
            this._logwdog.cease();
        }
    }

    public final void configure(Properties props) {
        Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
        while (it.hasNext()) {
            Level level;
            Map.Entry<Object, Object> me = it.next();
            String key = (String)me.getKey();
            String val = (String)me.getValue();
            if (val != null) {
                val = val.trim();
            }
            if ((level = Log.getLevel(val)) != null || val != null && (val.equalsIgnoreCase("NULL") || val.equalsIgnoreCase("INHERIT"))) {
                Logger.getLogger(key).setLevel(level);
                continue;
            }
            log.warning("Illegal log level, " + val + ", for " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void configure(File file) throws FileNotFoundException, IOException {
        log.info(MCommon.FILE_OPENING, file);
        Properties props = new Properties();
        FileInputStream is = new FileInputStream(file);
        try {
            props.load(is);
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable ex) {}
        }
        this.configure(props);
    }

    public final void configure(String filename) throws FileNotFoundException, IOException {
        this.configure(new File(filename));
    }

    public final FileWatchdog configureAndWatch(File file, long delay) {
        FileWatchdog wg = new FileWatchdog(file, delay, (FileWatchdog.Callback)new WatchdogCallback());
        wg.start();
        return wg;
    }

    public class WatchdogCallback
    implements FileWatchdog.Callback {
        private WatchdogCallback() {
        }

        public final void onModified(File file) {
            try {
                LogService.this.configure(file);
            }
            catch (Exception ex) {
                log.warning(MCommon.FILE_READ_FAILED, file, (Throwable)ex);
            }
        }
    }
}

