/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au;

import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.util.DeferredValue;

public class AuResponse {
    protected String _cmd;
    private final Object _depends;
    protected Object[] _data;
    private String[] _evdata;

    protected AuResponse(String cmd) {
        this(cmd, (Component)null, (String[])null);
    }

    protected AuResponse(String cmd, String data) {
        this(cmd, (Component)null, data);
    }

    protected AuResponse(String cmd, String[] data) {
        this(cmd, (Component)null, data);
    }

    protected AuResponse(String cmd, Component depends, String data) {
        String[] stringArray;
        if (data != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = data;
        } else {
            stringArray = null;
        }
        this(cmd, depends, stringArray);
    }

    protected AuResponse(String cmd, Component depends, String[] data) {
        this(cmd, depends, (Object[])data);
    }

    protected AuResponse(String cmd, Page depends, String data) {
        String[] stringArray;
        if (data != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = data;
        } else {
            stringArray = null;
        }
        this(cmd, depends, stringArray);
    }

    protected AuResponse(String cmd, Page depends, String[] data) {
        this(cmd, depends, (Object[])data);
    }

    protected AuResponse(String cmd, DeferredValue data) {
        this(cmd, (Component)null, data);
    }

    protected AuResponse(String cmd, Object[] data) {
        this(cmd, (Component)null, data);
    }

    protected AuResponse(String cmd, Component depends, DeferredValue data) {
        DeferredValue[] deferredValueArray;
        if (data != null) {
            DeferredValue[] deferredValueArray2 = new DeferredValue[1];
            deferredValueArray = deferredValueArray2;
            deferredValueArray2[0] = data;
        } else {
            deferredValueArray = null;
        }
        this(cmd, depends, deferredValueArray);
    }

    protected AuResponse(String cmd, Component depends, Object[] data) {
        if (cmd == null || cmd.length() == 0) {
            throw new IllegalArgumentException("cmd");
        }
        AuResponse.checkData(data);
        this._cmd = cmd;
        this._depends = depends;
        this._data = data;
    }

    protected AuResponse(String cmd, Page depends, DeferredValue data) {
        DeferredValue[] deferredValueArray;
        if (data != null) {
            DeferredValue[] deferredValueArray2 = new DeferredValue[1];
            deferredValueArray = deferredValueArray2;
            deferredValueArray2[0] = data;
        } else {
            deferredValueArray = null;
        }
        this(cmd, depends, deferredValueArray);
    }

    protected AuResponse(String cmd, Page depends, Object[] data) {
        if (cmd == null || cmd.length() == 0) {
            throw new IllegalArgumentException("cmd");
        }
        AuResponse.checkData(data);
        this._cmd = cmd;
        this._depends = depends;
        this._data = data;
    }

    private static void checkData(Object[] data) {
        if (data != null && !(data instanceof String[]) && !(data instanceof DeferredValue[])) {
            int j = data.length;
            while (--j >= 0) {
                if (data[j] == null || data[j] instanceof String || data[j] instanceof DeferredValue) continue;
                throw new IllegalArgumentException("Data " + j + " cannot be " + data[j].getClass());
            }
        }
    }

    public String getCommand() {
        return this._cmd;
    }

    public String[] getData() {
        if (this._data == null || this._data instanceof String[]) {
            return (String[])this._data;
        }
        if (this._evdata == null) {
            this._evdata = new String[this._data.length];
            for (int j = 0; j < this._data.length; ++j) {
                Object d = this._data[j];
                this._evdata[j] = d instanceof DeferredValue ? ((DeferredValue)d).getValue() : (String)d;
            }
        }
        return this._evdata;
    }

    public Object[] getRawData() {
        return this._data;
    }

    public final Object getDepends() {
        return this._depends;
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(60).append("[cmd=").append(this._cmd);
        if (this._data != null && this._data.length > 0) {
            sb.append(", data0=").append(this._data[0]);
            if (this._data.length > 1) {
                sb.append(", data1=").append(AuResponse.trimOutput(this._data[1]));
                if (this._data.length > 2) {
                    sb.append(", data2=").append(AuResponse.trimOutput(this._data[2]));
                }
            }
        }
        return sb.append(']').toString();
    }

    private static String trimOutput(Object data) {
        String s = Objects.toString((Object)data);
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() <= 36 ? s : s.substring(0, 36) + "...";
    }
}

