/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au.in;

import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.Command;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.MaximizeEvent;
import org.zkoss.zk.ui.event.MinimizeEvent;
import org.zkoss.zk.ui.ext.client.Maximizable;
import org.zkoss.zk.ui.ext.client.Minimizable;
import org.zkoss.zk.ui.sys.ComponentCtrl;

public class MinMaximizeCommand
extends Command {
    public MinMaximizeCommand(String evtnm, int flags) {
        super(evtnm, flags);
    }

    protected void process(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, this);
        }
        String[] data = request.getData();
        if (data == null || data.length != 5) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), this});
        }
        if (Objects.equals((Object)this.getId(), (Object)"onMinimize")) {
            Minimizable min = (Minimizable)((ComponentCtrl)((Object)comp)).getExtraCtrl();
            boolean minimized = "true".equals(data[4]);
            min.setLeftByClient(data[0]);
            min.setTopByClient(data[1]);
            min.setWidthByClient(data[2]);
            min.setHeightByClient(data[3]);
            min.setMinimizedByClient(minimized);
            Events.postEvent(new MinimizeEvent(this.getId(), comp, data[0], data[1], data[2], data[3], minimized));
        } else {
            Maximizable max = (Maximizable)((ComponentCtrl)((Object)comp)).getExtraCtrl();
            boolean maximized = "true".equals(data[4]);
            max.setLeftByClient(data[0]);
            max.setTopByClient(data[1]);
            max.setWidthByClient(data[2]);
            max.setHeightByClient(data[3]);
            max.setMaximizedByClient(maximized);
            Events.postEvent(new MaximizeEvent(this.getId(), comp, data[0], data[1], data[2], data[3], maximized));
        }
    }
}

