/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au.in;

import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.Command;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.URIEvent;

public class URIChangedCommand
extends Command {
    public URIChangedCommand(String evtnm, int flags) {
        super(evtnm, flags);
    }

    protected void process(AuRequest request) {
        int urilen;
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, this);
        }
        String[] data = request.getData();
        if (data == null || data.length != 1) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), this});
        }
        String uri = data[0];
        int n = urilen = uri != null ? uri.length() : 0;
        if (urilen > 0 && uri.charAt(0) == '/') {
            int ctxlen;
            String ctx = Executions.getCurrent().getContextPath();
            int n2 = ctxlen = ctx != null ? ctx.length() : 0;
            if (ctxlen > 0 && !"/".equals(ctx)) {
                if (ctx.charAt(0) != '/') {
                    ctx = '/' + ctx;
                    ++ctxlen;
                }
                if (uri.startsWith(ctx) && (urilen == ctxlen || uri.charAt(ctxlen) == '/')) {
                    uri = uri.substring(ctxlen);
                }
            }
        }
        Events.postEvent(new URIEvent(this.getId(), comp, uri));
    }
}

