/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.device;

import org.zkoss.zk.device.Device;
import org.zkoss.zk.device.DeviceConfig;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.sys.ServerPush;

public abstract class GenericDevice
implements Device {
    private String _type;
    private String _uamsg;
    private String _tmoutURI;
    private Class _spushcls;
    private String _embed;

    public boolean isSupported(int func) {
        return false;
    }

    public String getType() {
        return this._type;
    }

    public boolean isCacheable() {
        return true;
    }

    public Boolean isCompatible(String userAgent) {
        return null;
    }

    public String getUnavailableMessage() {
        return this._uamsg;
    }

    public String setUnavailableMessage(String msg) {
        String old = this._uamsg;
        this._uamsg = msg != null && msg.length() > 0 ? msg : null;
        return old;
    }

    public String getTimeoutURI() {
        return this._tmoutURI;
    }

    public String setTimeoutURI(String timeoutURI) {
        String old = this._tmoutURI;
        this._tmoutURI = timeoutURI;
        return old;
    }

    public Class setServerPushClass(Class cls) {
        if (cls != null && !ServerPush.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("ServerPush not implemented: " + cls);
        }
        Class old = this._spushcls;
        this._spushcls = cls;
        return old;
    }

    public Class getServerPushClass() {
        return this._spushcls;
    }

    public String getDocType() {
        return null;
    }

    public void addEmbedded(String content) {
        if (content != null && content.length() > 0) {
            this._embed = this._embed != null ? this._embed + '\n' + content : content;
        }
    }

    public String getEmbedded() {
        return this._embed;
    }

    public void init(String type, DeviceConfig config) {
        this._type = type;
        this._uamsg = config.getUnavailableMessage();
        this._tmoutURI = config.getTimeoutURI();
        this._spushcls = config.getServerPushClass();
        this._embed = config.getEmbedded();
    }

    public void sessionWillPassivate(Desktop desktop) {
    }

    public void sessionDidActivate(Desktop desktop) {
    }
}

