/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.fn;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import org.zkoss.lang.Strings;
import org.zkoss.util.logging.Log;
import org.zkoss.web.fn.ServletFns;
import org.zkoss.web.servlet.JavaScript;
import org.zkoss.web.servlet.StyleSheet;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.device.Device;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.fn.DspFns;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.sys.PageCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.ThemeProvider;

public class ZkFns
extends DspFns {
    private static final Log log = Log.lookup((Class)ZkFns.class);
    private static final String ATTR_LANG_CSS_GENED = "javax.zkoss.zk.lang.css.generated";
    private static final String ATTR_LANG_JS_GENED = "javax.zkoss.zk.lang.js.generated";
    private static final String ATTR_DESKTOP_INFO_GENED = "javax.zkoss.zk.desktopInfo.generated";
    private static final String ATTR_UNAVAILABLE_GENED = "javax.zkoss.zk.unavail.generated";

    protected ZkFns() {
    }

    public static final void redraw(Component comp, Writer out) throws IOException {
        if (comp == null) {
            return;
        }
        if (out == null) {
            out = ZkFns.getCurrentOut();
        }
        try {
            comp.redraw(out);
        }
        catch (Throwable ex) {
            log.realCauseBriefly("Failed to redraw " + comp, ex);
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw UiException.Aide.wrap(ex);
        }
    }

    public static final Writer getCurrentOut() throws IOException {
        return ServletFns.getCurrentOut();
    }

    public static final String outResponseJavaScripts(Collection responses) {
        if (responses == null || responses.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer(256).append("\n<script type=\"text/javascript\">\n").append("zk.addInit(function(){\n");
        Iterator it = responses.iterator();
        while (it.hasNext()) {
            AuResponse response = (AuResponse)it.next();
            sb.append("zk.process('").append(response.getCommand()).append("'");
            String[] data = response.getData();
            int datanum = data != null ? data.length : 0;
            for (int j = 0; j < datanum; ++j) {
                sb.append(",\"");
                if (data[j] != null) {
                    sb.append(Strings.escape((String)data[j], (String)"\"\\\n\r"));
                }
                sb.append('\"');
            }
            sb.append(");\n");
        }
        return sb.append("});\n</script>\n").toString();
    }

    public static final String outLangJavaScripts(String dummy) {
        return ZkFns.outLangJavaScripts(Executions.getCurrent(), null, null);
    }

    private static final String outLangJavaScripts(Execution exec, WebApp wapp, String deviceType) {
        ServletRequest request = ServletFns.getCurrentRequest();
        if (WebManager.getRequestLocal(request, ATTR_LANG_JS_GENED) != null) {
            return "";
        }
        WebManager.setRequestLocal(request, ATTR_LANG_JS_GENED, Boolean.TRUE);
        if (wapp == null) {
            wapp = exec.getDesktop().getWebApp();
        }
        if (deviceType == null) {
            deviceType = exec.getDesktop().getDeviceType();
        }
        Configuration config = wapp.getConfiguration();
        StringBuffer sb = new StringBuffer(1536);
        LinkedHashSet jses = new LinkedHashSet(32);
        Iterator it = LanguageDefinition.getByDeviceType(deviceType).iterator();
        while (it.hasNext()) {
            jses.addAll(((LanguageDefinition)it.next()).getJavaScripts());
        }
        it = jses.iterator();
        while (it.hasNext()) {
            ZkFns.append(sb, (JavaScript)it.next());
        }
        sb.append("\n<script type=\"text/javascript\">\n").append("zk_ver='").append(wapp.getVersion()).append("';\nzk.build='").append(wapp.getBuild()).append("';\nzk_procto=").append(config.getProcessingPromptDelay()).append(";\nzk_tipto=").append(config.getTooltipDelay()).append(";\nzk_resndto=").append(config.getResendDelay()).append(";\nzk_clkflto=").append(config.getClickFilterDelay()).append(";\n");
        if (config.isDebugJS()) {
            sb.append("zk.debugJS=true;\n");
        }
        if (config.isDisableBehindModalEnabled()) {
            sb.append("zk.dbModal=true;\n");
        }
        if (config.isKeepDesktopAcrossVisits() || request.getAttribute("zk_desktop_no_cache") == null) {
            sb.append("zk.keepDesktop=true;\n");
        }
        if (config.getPerformanceMeter() != null) {
            sb.append("zk.pfmeter=true;\n");
        }
        sb.append("zk.eru={");
        int[] cers = config.getClientErrorReloadCodes();
        boolean first = true;
        for (int j = 0; j < cers.length; ++j) {
            String uri = config.getClientErrorReload(cers[j]);
            if (uri == null) continue;
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append("e").append(cers[j]).append(":'").append(Strings.escape((String)uri, (String)"'\\")).append('\'');
        }
        sb.append("};\n");
        Iterator it2 = LanguageDefinition.getByDeviceType(deviceType).iterator();
        while (it2.hasNext()) {
            LanguageDefinition langdef = (LanguageDefinition)it2.next();
            Set mods = langdef.getJavaScriptModules().entrySet();
            if (mods.isEmpty()) continue;
            Iterator e = mods.iterator();
            while (e.hasNext()) {
                Map.Entry me = e.next();
                sb.append("\nzk.mods[\"").append(me.getKey()).append("\"]=\"").append(me.getValue()).append("\";");
            }
        }
        sb.append("\n</script>\n");
        Device device = Devices.getDevice(deviceType);
        String s = device.getEmbedded();
        if (s != null) {
            sb.append(s).append('\n');
        }
        return sb.toString();
    }

    public static String outHtmlUnavailable(Page page) {
        ServletRequest request = ServletFns.getCurrentRequest();
        if (WebManager.getRequestLocal(request, ATTR_UNAVAILABLE_GENED) != null) {
            return "";
        }
        WebManager.setRequestLocal(request, ATTR_UNAVAILABLE_GENED, Boolean.TRUE);
        Device device = page.getDesktop().getDevice();
        String s = device.getUnavailableMessage();
        return s != null ? "<noscript>" + s + "</noscript>" : "";
    }

    private static void append(StringBuffer sb, JavaScript js) {
        sb.append("\n<script type=\"text/javascript\"");
        if (js.getSrc() != null) {
            String url;
            try {
                url = ServletFns.encodeURL((String)js.getSrc());
            }
            catch (ServletException ex) {
                throw new UiException(ex);
            }
            int j = url.lastIndexOf(59);
            if (j > 0 && url.indexOf(46, j + 1) < 0 && url.indexOf(47, j + 1) < 0) {
                url = url.substring(0, j);
            }
            sb.append(" src=\"").append(url).append('\"');
            String charset = js.getCharset();
            if (charset != null) {
                sb.append(" charset=\"").append(charset).append('\"');
            }
            sb.append('>');
        } else {
            sb.append(">\n").append(js.getContent());
        }
        sb.append("\n</script>");
    }

    public static final String outLangStyleSheets() {
        return ZkFns.outLangStyleSheets(Executions.getCurrent(), null, null);
    }

    private static final String outLangStyleSheets(Execution exec, WebApp wapp, String deviceType) {
        ServletRequest request = ServletFns.getCurrentRequest();
        if (WebManager.getRequestLocal(request, ATTR_LANG_CSS_GENED) != null) {
            return "";
        }
        WebManager.setRequestLocal(request, ATTR_LANG_CSS_GENED, Boolean.TRUE);
        StringBuffer sb = new StringBuffer(512);
        Iterator it = ZkFns.getStyleSheets(exec, wapp, deviceType).iterator();
        while (it.hasNext()) {
            ZkFns.append(sb, (StyleSheet)it.next(), exec, null);
        }
        if (sb.length() > 0) {
            sb.append('\n');
        }
        return sb.toString();
    }

    static final String outDeviceStyleSheets(Execution exec, WebApp wapp, String deviceType) {
        ServletRequest request = ServletFns.getCurrentRequest();
        if (WebManager.getRequestLocal(request, ATTR_LANG_CSS_GENED) != null) {
            return "";
        }
        WebManager.setRequestLocal(request, ATTR_LANG_CSS_GENED, Boolean.TRUE);
        StringBuffer sb = new StringBuffer(256);
        List ss = ZkFns.getStyleSheets(exec, wapp, deviceType);
        Iterator it = ss.iterator();
        while (it.hasNext()) {
            ZkFns.append(sb, (StyleSheet)it.next(), exec, null);
        }
        return sb.toString();
    }

    public static final List getStyleSheets(Execution exec) {
        Desktop desktop = exec.getDesktop();
        return ZkFns.getStyleSheets(exec, null, null);
    }

    private static final List getStyleSheets(Execution exec, WebApp wapp, String deviceType) {
        LinkedList<StyleSheet> sses;
        block9: {
            Configuration config;
            block8: {
                StyleSheet ss;
                if (wapp == null) {
                    wapp = exec.getDesktop().getWebApp();
                }
                if (deviceType == null) {
                    deviceType = exec.getDesktop().getDeviceType();
                }
                config = wapp.getConfiguration();
                Set disabled = config.getDisabledThemeURIs();
                sses = new LinkedList<StyleSheet>();
                Iterator it = LanguageDefinition.getByDeviceType(deviceType).iterator();
                while (it.hasNext()) {
                    LanguageDefinition langdef = (LanguageDefinition)it.next();
                    Iterator e = langdef.getStyleSheets().iterator();
                    while (e.hasNext()) {
                        ss = (StyleSheet)e.next();
                        if (disabled.contains(ss.getHref())) continue;
                        sses.add(ss);
                    }
                }
                ThemeProvider themeProvider = config.getThemeProvider();
                if (themeProvider == null) break block8;
                LinkedList<String> org = new LinkedList<String>();
                Iterator it2 = sses.iterator();
                while (it2.hasNext()) {
                    ss = (StyleSheet)it2.next();
                    org.add(ss.getHref());
                }
                String[] hrefs = config.getThemeURIs();
                for (int j = 0; j < hrefs.length; ++j) {
                    org.add(hrefs[j]);
                }
                sses.clear();
                Collection res = themeProvider.getThemeURIs(exec, org);
                if (res == null) break block9;
                Iterator it3 = res.iterator();
                while (it3.hasNext()) {
                    sses.add(new StyleSheet((String)it3.next(), "text/css"));
                }
                break block9;
            }
            String[] hrefs = config.getThemeURIs();
            for (int j = 0; j < hrefs.length; ++j) {
                sses.add(new StyleSheet(hrefs[j], "text/css"));
            }
        }
        return sses;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void append(StringBuffer sb, StyleSheet ss, Execution exec, Page page) {
        String href = ss.getHref();
        if (href != null) {
            try {
                if (exec != null) {
                    href = (String)exec.evaluate(page, href, String.class);
                }
                if (href == null || href.length() <= 0) return;
                sb.append("\n<link rel=\"stylesheet\" type=\"").append(ss.getType()).append("\" href=\"").append(ServletFns.encodeURL((String)href)).append("\"/>");
                return;
            }
            catch (ServletException ex) {
                throw new UiException(ex);
            }
        } else {
            sb.append("\n<style");
            if (ss.getType() != null) {
                sb.append(" type=\"").append(ss.getType()).append('\"');
            }
            sb.append(">\n").append(ss.getContent()).append("\n</style>");
        }
    }

    public static String toAbsoluteURI(String uri, boolean skipInclude) {
        return Executions.getCurrent().toAbsoluteURI(uri, skipInclude);
    }

    public static String toAbsoluteURI(String uri) {
        return ZkFns.toAbsoluteURI(uri, true);
    }

    public static final String outHeaders(Page page) {
        return ((PageCtrl)((Object)page)).getHeaders();
    }

    public static final String outRootAttributes(Page page) {
        return ((PageCtrl)((Object)page)).getRootAttributes();
    }

    public static final String outContentType(Page page) {
        String cs;
        int j;
        String contentType = ((PageCtrl)((Object)page)).getContentType();
        if (contentType == null && (contentType = page.getDesktop().getDevice().getContentType()) == null) {
            contentType = "";
        }
        if ((j = contentType.indexOf(59)) < 0 && (cs = page.getDesktop().getWebApp().getConfiguration().getResponseCharset()) != null && cs.length() > 0) {
            contentType = contentType + ";charset=" + cs;
        }
        return contentType;
    }

    public static final String outDocType(Page page) {
        String docType = ((PageCtrl)((Object)page)).getDocType();
        return ZkFns.trimAndLF(docType != null ? docType : page.getDesktop().getDevice().getDocType());
    }

    private static final String trimAndLF(String s) {
        int len;
        if (s != null && (len = (s = s.trim()).length()) > 0 && s.charAt(len - 1) != '\n') {
            s = s + '\n';
        }
        return s;
    }

    public static final String outFirstLine(Page page) {
        return ZkFns.trimAndLF(((PageCtrl)((Object)page)).getFirstLine());
    }

    public static final String outPageAttrs(Page page) {
        Desktop desktop = page.getDesktop();
        PageCtrl pageCtrl = (PageCtrl)((Object)page);
        Component owner = pageCtrl.getOwner();
        boolean contained = false;
        if (owner == null) {
            Execution exec = Executions.getCurrent();
            contained = exec != null && exec.getAttribute("org.zkoss.zk.ui.page.included") != null;
        }
        ServletRequest request = ServletFns.getCurrentRequest();
        WebManager.setRequestLocal(request, ATTR_DESKTOP_INFO_GENED, Boolean.TRUE);
        String style = page.getStyle();
        if (style == null || style.length() == 0) {
            String wd = null;
            String hgh = null;
            if (owner instanceof HtmlBasedComponent) {
                HtmlBasedComponent hbc = (HtmlBasedComponent)owner;
                wd = hbc.getWidth();
                hgh = hbc.getHeight();
            }
            StringBuffer sb = new StringBuffer(32);
            HTMLs.appendStyle((StringBuffer)sb, (String)"width", (String)(wd != null ? wd : "100%"));
            HTMLs.appendStyle((StringBuffer)sb, (String)"height", (String)(hgh != null ? hgh : (contained ? null : "100%")));
            style = sb.toString();
        }
        StringBuffer sb = new StringBuffer(100).append(" class=\"zk\"");
        HTMLs.appendAttribute((StringBuffer)sb, (String)"id", (String)page.getUuid());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.dtid", (String)desktop.getId());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"style", (String)style);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.zidsp", (String)(contained ? "ctpage" : "page"));
        if (owner == null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.au", (String)desktop.getUpdateURI(null));
        }
        return sb.toString();
    }

    public static final String outDesktopInfo(Desktop desktop) {
        ServletRequest request = ServletFns.getCurrentRequest();
        if (WebManager.getRequestLocal(request, ATTR_DESKTOP_INFO_GENED) != null) {
            return "";
        }
        WebManager.setRequestLocal(request, ATTR_DESKTOP_INFO_GENED, Boolean.TRUE);
        return "<script type=\"text/javascript\">\nzkau.addDesktop(\"" + desktop.getId() + "\");" + "zkau.addURI(\"" + desktop.getId() + "\",\"" + desktop.getUpdateURI(null) + "\");\n</script>\n";
    }

    public static String outZkHtmlTags() {
        Execution exec = Executions.getCurrent();
        return exec != null ? ZkFns.outZkHtmlTags(exec, null, null) : "";
    }

    static final String outZkHtmlTags(Execution exec, WebApp wapp, String deviceType) {
        ServletRequest request = ServletFns.getCurrentRequest();
        if (WebManager.getRequestLocal(request, "zkHtmlTagsGened") != null) {
            return null;
        }
        WebManager.setRequestLocal(request, "zkHtmlTagsGened", Boolean.TRUE);
        StringBuffer sb = new StringBuffer(512).append('\n').append(ZkFns.outLangStyleSheets(exec, wapp, deviceType)).append(ZkFns.outLangJavaScripts(exec, wapp, deviceType));
        Desktop desktop = exec.getDesktop();
        if (desktop != null) {
            sb.append(ZkFns.outDesktopInfo(desktop));
        }
        String ATTR_RESPONSES = "zk_argResponses";
        sb.append(ZkFns.outResponseJavaScripts((Collection)exec.getAttribute("zk_argResponses")));
        exec.removeAttribute("zk_argResponses");
        return sb.toString();
    }

    public static final String noCSSAttrs(String attrs) {
        int end;
        if (attrs == null || attrs.length() == 0) {
            return attrs;
        }
        String CSS = "class=\"";
        String STYLE = "style=\"";
        StringBuffer sb = null;
        int start = attrs.indexOf("class=\"");
        if (start >= 0) {
            sb = new StringBuffer(attrs);
            end = sb.indexOf("\"", start + "class=\"".length());
            if (end >= 0) {
                sb.delete(start, end + 1);
            }
            start = sb.indexOf("style=\"");
        } else {
            start = attrs.indexOf("style=\"");
        }
        if (start >= 0) {
            if (sb == null) {
                sb = new StringBuffer(attrs);
            }
            if ((end = sb.indexOf("\"", start + "style=\"".length())) >= 0) {
                sb.delete(start, end + 1);
            }
        }
        return sb != null ? sb.toString() : attrs;
    }

    public static final String outCSSAttrs(String attrs) {
        int end;
        if (attrs == null || attrs.length() == 0) {
            return attrs;
        }
        String CSS = "class=\"";
        String STYLE = "style=\"";
        StringBuffer sb = null;
        int start = attrs.indexOf("class=\"");
        if (start >= 0 && (end = attrs.indexOf("\"", start + "class=\"".length())) >= 0) {
            sb = new StringBuffer().append(' ').append(attrs.substring(start, end + 1));
        }
        if ((start = attrs.indexOf("style=\"")) >= 0 && (end = attrs.indexOf("\"", start + "style=\"".length())) >= 0) {
            if (sb == null) {
                sb = new StringBuffer();
            }
            sb.append(' ').append(attrs.substring(start, end + 1));
        }
        return sb != null ? sb.toString() : "";
    }
}

