/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.scripting;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.scripting.Namespace;
import org.zkoss.zk.scripting.util.SimpleNamespace;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;

public class Namespaces {
    private static final Log log = Log.lookup((Class)Namespaces.class);
    private static final Object VOID = new Object();
    private static final ThreadLocal _curnss = new ThreadLocal();

    public static final Namespace beforeInterpret(Map backup, Component comp, boolean pushNS) {
        Namespace ns = comp.getNamespace();
        if (ns == null) {
            ns = new SimpleNamespace();
        }
        Namespaces.backupVariable(backup, ns, "self");
        Namespaces.backupVariable(backup, ns, "componentScope");
        Namespaces.backupVariable(backup, ns, "arg");
        ns.setVariable("self", comp, true);
        ns.setVariable("componentScope", comp.getAttributes(0), true);
        Execution exec = Executions.getCurrent();
        Map arg = exec != null ? exec.getArg() : null;
        ns.setVariable("arg", arg, true);
        if (pushNS) {
            Namespaces.push(ns);
        }
        return ns;
    }

    public static final Namespace beforeInterpret(Map backup, Page page, boolean pushNS) {
        Namespace ns = page.getNamespace();
        Namespaces.backupVariable(backup, ns, "arg");
        Execution exec = Executions.getCurrent();
        Map arg = exec != null ? exec.getArg() : null;
        ns.setVariable("arg", arg, true);
        if (pushNS) {
            Namespaces.push(ns);
        }
        return ns;
    }

    public static final void afterInterpret(Map backup, Namespace ns, boolean popNS) {
        Iterator it = backup.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            String name = (String)me.getKey();
            Object val = me.getValue();
            if (val != VOID) {
                ns.setVariable(name, val, true);
                continue;
            }
            ns.unsetVariable(name, true);
        }
        if (popNS) {
            Namespaces.pop(ns);
        }
    }

    public static final void backupVariable(Map backup, Namespace ns, String name) {
        Object val = ns.getVariable(name, true);
        backup.put(name, val != null || ns.getVariableNames().contains(name) ? val : VOID);
    }

    public static final Namespace getCurrent(Page page) {
        List nss = (List)_curnss.get();
        Namespace ns = nss != null && !nss.isEmpty() ? (Namespace)nss.get(0) : null;
        return ns != null ? ns : page.getNamespace();
    }

    private static final void push(Namespace ns) {
        LinkedList<Namespace> nss = (LinkedList<Namespace>)_curnss.get();
        if (nss == null) {
            nss = new LinkedList<Namespace>();
            _curnss.set(nss);
        }
        nss.add(0, ns);
    }

    private static final void pop(Namespace ns) {
        List nss = (List)_curnss.get();
        if (nss.remove(0) != ns) {
            log.realCauseBriefly((Throwable)new IllegalStateException("Unmatched pop the current namespace"));
        }
    }
}

