/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.zkoss.util.CollectionsX;
import org.zkoss.web.servlet.xel.AttributesMap;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.impl.AbstractWebApp;
import org.zkoss.zk.ui.util.Configuration;

public class SimpleWebApp
extends AbstractWebApp {
    private ServletContext _ctx;
    private final Map _attrs = new AttributesMap(){

        protected Enumeration getKeys() {
            return SimpleWebApp.this._ctx.getAttributeNames();
        }

        protected Object getValue(String key) {
            return SimpleWebApp.this._ctx.getAttribute(key);
        }

        protected void setValue(String key, Object val) {
            SimpleWebApp.this._ctx.setAttribute(key, val);
        }

        protected void removeValue(String key) {
            SimpleWebApp.this._ctx.removeAttribute(key);
        }
    };

    public void init(Object context, Configuration config) {
        if (context == null) {
            throw new IllegalArgumentException("context");
        }
        this._ctx = (ServletContext)context;
        super.init(context, config);
    }

    public Object getAttribute(String name) {
        return this._ctx.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this._ctx.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this._ctx.removeAttribute(name);
    }

    public Map getAttributes() {
        return this._attrs;
    }

    public WebApp getWebApp(String uripath) {
        WebManager webman;
        ServletContext another = this._ctx.getContext(uripath);
        if (another != null && (webman = WebManager.getWebManagerIfAny(another)) != null) {
            return webman.getWebApp();
        }
        return null;
    }

    public String getDirectory() {
        return null;
    }

    public URL getResource(String path) {
        try {
            return this._ctx.getResource(path);
        }
        catch (MalformedURLException ex) {
            throw new UiException("Failed to retrieve " + path, (Throwable)ex);
        }
    }

    public InputStream getResourceAsStream(String path) {
        return this._ctx.getResourceAsStream(path);
    }

    public String getInitParameter(String name) {
        return this._ctx.getInitParameter(name);
    }

    public Iterator getInitParameterNames() {
        return new CollectionsX.EnumerationIterator(this._ctx.getInitParameterNames());
    }

    public String getRealPath(String path) {
        return this._ctx.getRealPath(path);
    }

    public String getMimeType(String file) {
        return this._ctx.getMimeType(file);
    }

    public Set getResourcePaths(String path) {
        return this._ctx.getResourcePaths(path);
    }

    public Object getNativeContext() {
        return this._ctx;
    }
}

