/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.zkoss.idom.Document;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.Visualizer;
import org.zkoss.zk.ui.sys.WebAppCtrl;

public abstract class AbstractExecution
implements Execution,
ExecutionCtrl {
    private Desktop _desktop;
    private Page _curpage;
    private PageDefinition _curpgdef;
    private Visualizer _ei;
    private final List _evtInfos = new LinkedList();
    private List _args;
    private final Page _creating;
    private String _reqId;
    private boolean _piggybacked;

    protected AbstractExecution(Desktop desktop, Page creating) {
        Iterator it;
        this._desktop = desktop;
        this._creating = creating;
        if (desktop != null && (it = desktop.getPages().iterator()).hasNext()) {
            this._curpage = (Page)it.next();
        }
    }

    public final boolean isAsyncUpdate(Page page) {
        return this._creating == null || page != null && this._creating != page;
    }

    public Desktop getDesktop() {
        return this._desktop;
    }

    public void postEvent(Event evt) {
        this.postEvent(0, evt);
    }

    public void postEvent(int priority, Event evt) {
        EventInfo ei;
        if (evt == null) {
            throw new IllegalArgumentException("null");
        }
        if ((evt = ((DesktopCtrl)((Object)this._desktop)).beforePostEvent(evt)) == null) {
            return;
        }
        ListIterator<EventInfo> it = this._evtInfos.listIterator(this._evtInfos.size());
        do {
            EventInfo eventInfo = ei = it.hasPrevious() ? (EventInfo)it.previous() : null;
        } while (ei != null && ei.priority < priority);
        if (ei != null) {
            it.next();
        }
        it.add(new EventInfo(priority, evt));
    }

    public final Page getCurrentPage() {
        if (this._curpage != null) {
            return this._curpage;
        }
        Iterator it = this._desktop.getPages().iterator();
        return it.hasNext() ? (Page)it.next() : null;
    }

    public final void setCurrentPage(Page curpage) {
        if (this._curpage != null && curpage != null && this._curpage != curpage) {
            Desktop _curdt = this._curpage.getDesktop();
            Desktop curdt = curpage.getDesktop();
            if (_curdt != null && curdt != null && _curdt != curdt) {
                throw new IllegalStateException("Change current page to another desktop? " + curpage);
            }
        }
        this._curpage = curpage;
    }

    public PageDefinition getCurrentPageDefinition() {
        return this._curpgdef;
    }

    public void setCurrentPageDefinition(PageDefinition pgdef) {
        this._curpgdef = pgdef;
    }

    public Event getNextEvent() {
        if (!this._evtInfos.isEmpty()) {
            return ((EventInfo)this._evtInfos.remove(0)).event;
        }
        if (!this._piggybacked) {
            ((DesktopCtrl)((Object)this._desktop)).onPiggyback();
            this._piggybacked = true;
            if (!this._evtInfos.isEmpty()) {
                return ((EventInfo)this._evtInfos.remove(0)).event;
            }
        }
        return null;
    }

    public boolean isActivated() {
        return this._ei != null;
    }

    public void onActivate() {
    }

    public void onDeactivate() {
    }

    public boolean isRecovering() {
        return this._ei != null && this._ei.isRecovering();
    }

    public void setVisualizer(Visualizer ei) {
        this._ei = ei;
    }

    public Visualizer getVisualizer() {
        return this._ei;
    }

    public String toAbsoluteURI(String uri, boolean skipInclude) {
        String dir;
        char cc;
        if (!(uri == null || uri.length() <= 0 || (cc = uri.charAt(0)) == '/' || cc == '~' || skipInclude && this.isIncluded() || Servlets.isUniversalURL((String)uri) || (dir = this.getDesktop().getCurrentDirectory()) == null)) {
            return dir + uri;
        }
        return uri;
    }

    private final UiEngine getUiEngine() {
        return ((WebAppCtrl)((Object)this._desktop.getWebApp())).getUiEngine();
    }

    public Component createComponents(String uri, Component parent, Map arg) {
        Component[] cs = this.getUiEngine().createComponents(this, this.getPageDefinition(uri), this.getCurrentPage(), parent, arg);
        return cs.length > 0 ? cs[0] : null;
    }

    public Component createComponents(PageDefinition pagedef, Component parent, Map arg) {
        if (pagedef == null) {
            throw new IllegalArgumentException("pagedef cannot be null");
        }
        Component[] cs = this.getUiEngine().createComponents(this, pagedef, this.getCurrentPage(), parent, arg);
        return cs.length > 0 ? cs[0] : null;
    }

    public Component createComponentsDirectly(String content, String ext, Component parent, Map arg) {
        Component[] cs = this.getUiEngine().createComponents(this, this.getPageDefinitionDirectly(content, ext), this.getCurrentPage(), parent, arg);
        return cs.length > 0 ? cs[0] : null;
    }

    public Component createComponentsDirectly(Document content, String ext, Component parent, Map arg) {
        Component[] cs = this.getUiEngine().createComponents(this, this.getPageDefinitionDirectly(content, ext), this.getCurrentPage(), parent, arg);
        return cs.length > 0 ? cs[0] : null;
    }

    public Component createComponentsDirectly(Reader reader, String ext, Component parent, Map arg) throws IOException {
        Component[] cs = this.getUiEngine().createComponents(this, this.getPageDefinitionDirectly(reader, ext), this.getCurrentPage(), parent, arg);
        return cs.length > 0 ? cs[0] : null;
    }

    public Component[] createComponents(String uri, Map arg) {
        return this.getUiEngine().createComponents(this, this.getPageDefinition(uri), null, null, arg);
    }

    public Component[] createComponents(PageDefinition pagedef, Map arg) {
        if (pagedef == null) {
            throw new IllegalArgumentException("pagedef cannot be null");
        }
        return this.getUiEngine().createComponents(this, pagedef, null, null, arg);
    }

    public Component[] createComponentsDirectly(String content, String ext, Map arg) {
        return this.getUiEngine().createComponents(this, this.getPageDefinitionDirectly(content, ext), null, null, arg);
    }

    public Component[] createComponentsDirectly(Document content, String ext, Map arg) {
        return this.getUiEngine().createComponents(this, this.getPageDefinitionDirectly(content, ext), null, null, arg);
    }

    public Component[] createComponentsDirectly(Reader reader, String ext, Map arg) throws IOException {
        return this.getUiEngine().createComponents(this, this.getPageDefinitionDirectly(reader, ext), null, null, arg);
    }

    public void sendRedirect(String uri) {
        this.getUiEngine().sendRedirect(uri, null);
    }

    public void sendRedirect(String uri, String target) {
        this.getUiEngine().sendRedirect(uri, target);
    }

    public Map getArg() {
        return this._args != null ? (Map)this._args.get(0) : Collections.EMPTY_MAP;
    }

    public void pushArg(Map arg) {
        if (this._args == null) {
            this._args = new LinkedList();
        }
        this._args.add(0, arg);
    }

    public void popArg() {
        if (this._args != null) {
            if (this._args.size() == 1) {
                this._args = null;
            } else {
                this._args.remove(0);
            }
        }
    }

    public void addAuResponse(String key, AuResponse response) {
        this.getUiEngine().addResponse(key, response);
    }

    public void setDesktop(Desktop desktop) {
        if (desktop == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._desktop != null && this._desktop != desktop) {
            throw new IllegalStateException("assign diff desktop");
        }
        this._desktop = desktop;
    }

    public void setRequestId(String reqId) {
        this._reqId = reqId;
    }

    public String getRequestId() {
        return this._reqId;
    }

    public String toString() {
        return "[Exec" + System.identityHashCode(this) + ": " + this._desktop + ']';
    }

    private static class EventInfo {
        private final int priority;
        private final Event event;

        private EventInfo(int priority, Event event) {
            this.priority = priority;
            this.event = event;
        }

        public String toString() {
            return "[" + this.priority + ": " + this.event.toString() + "]";
        }
    }
}

