/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.lang.reflect.Method;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.zkoss.zk.scripting.Namespace;
import org.zkoss.zk.scripting.Namespaces;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Express;
import org.zkoss.zk.ui.metainfo.ZScript;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.EventProcessingThread;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;
import org.zkoss.zk.ui.sys.SessionsCtrl;

public class EventProcessor {
    private final Desktop _desktop;
    private final Component _comp;
    private Event _event;
    private static ThreadLocal _inEvt;
    private static final EventListener RETRY;

    public static final boolean inEventListener() {
        return Thread.currentThread() instanceof EventProcessingThread || _inEvt != null && _inEvt.get() != null;
    }

    static final void inEventListener(boolean in) {
        if (in) {
            if (_inEvt == null) {
                _inEvt = new ThreadLocal();
            }
            _inEvt.set(Boolean.TRUE);
        } else if (_inEvt != null) {
            _inEvt.set(null);
        }
    }

    public EventProcessor(Desktop desktop, Component comp, Event event) {
        if (desktop == null || comp == null || event == null) {
            throw new IllegalArgumentException("null");
        }
        Desktop dt = comp.getDesktop();
        if (dt != null && desktop != dt) {
            throw new IllegalStateException("Process events for another desktop? " + comp);
        }
        this._desktop = desktop;
        this._comp = comp;
        this._event = event;
    }

    public final Desktop getDesktop() {
        return this._desktop;
    }

    public final Event getEvent() {
        return this._event;
    }

    public final Component getComponent() {
        return this._comp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws Exception {
        HashMap backup = new HashMap();
        Namespace ns = Namespaces.beforeInterpret(backup, this._comp, true);
        try {
            Namespaces.backupVariable(backup, ns, "event");
            ns.setVariable("event", this._event, true);
            this._event = ((DesktopCtrl)((Object)this._desktop)).beforeProcessEvent(this._event);
            if (this._event != null) {
                ns.setVariable("event", this._event, true);
                this.process0(ns);
                ((DesktopCtrl)((Object)this._desktop)).afterProcessEvent(this._event);
            }
        }
        finally {
            Namespaces.afterInterpret(backup, ns, true);
        }
    }

    private void process0(Namespace ns) throws Exception {
        EventListener el;
        EventListener el2;
        EventListener el3;
        Page page = this.getPage();
        String evtnm = this._event.getName();
        HashSet<EventListener> listenerCalled = new HashSet<EventListener>();
        boolean retry = false;
        Iterator it = this._comp.getListenerIterator(evtnm);
        while ((el3 = EventProcessor.nextListener(it)) != null) {
            if (el3 == RETRY) {
                retry = true;
                it = this._comp.getListenerIterator(evtnm);
                continue;
            }
            if (!(el3 instanceof Express) || retry && listenerCalled.contains(el3)) continue;
            listenerCalled.add(el3);
            el3.onEvent(this._event);
            if (this._event.isPropagatable()) continue;
            return;
        }
        ZScript zscript = ((ComponentCtrl)((Object)this._comp)).getEventHandler(evtnm);
        if (zscript != null) {
            page.interpret(zscript.getLanguage(), zscript.getContent(page, this._comp), ns);
            if (!this._event.isPropagatable()) {
                return;
            }
        }
        retry = false;
        listenerCalled.clear();
        Iterator it2 = this._comp.getListenerIterator(evtnm);
        while ((el2 = EventProcessor.nextListener(it2)) != null) {
            if (el2 == RETRY) {
                retry = true;
                it2 = this._comp.getListenerIterator(evtnm);
                continue;
            }
            if (el2 instanceof Express || retry && listenerCalled.contains(el2)) continue;
            listenerCalled.add(el2);
            el2.onEvent(this._event);
            if (this._event.isPropagatable()) continue;
            return;
        }
        Method mtd = ComponentsCtrl.getEventMethod(this._comp.getClass(), evtnm);
        if (mtd != null) {
            if (mtd.getParameterTypes().length == 0) {
                mtd.invoke((Object)this._comp, null);
            } else {
                mtd.invoke((Object)this._comp, this._event);
            }
            if (!this._event.isPropagatable()) {
                return;
            }
        }
        retry = false;
        listenerCalled.clear();
        Iterator it3 = page.getListenerIterator(evtnm);
        while ((el = EventProcessor.nextListener(it3)) != null) {
            if (el == RETRY) {
                retry = true;
                it3 = page.getListenerIterator(evtnm);
                continue;
            }
            if (retry && listenerCalled.contains(el)) continue;
            listenerCalled.add(el);
            el.onEvent(this._event);
            if (this._event.isPropagatable()) continue;
            return;
        }
    }

    private static EventListener nextListener(Iterator it) {
        try {
            return it.hasNext() ? (EventListener)it.next() : null;
        }
        catch (ConcurrentModificationException ex) {
            return RETRY;
        }
    }

    public void setup() {
        SessionsCtrl.setCurrent(this._desktop.getSession());
        Execution exec = this._desktop.getExecution();
        ExecutionsCtrl.setCurrent(exec);
        ((ExecutionCtrl)((Object)exec)).setCurrentPage(this.getPage());
    }

    public void cleanup() {
        ExecutionsCtrl.setCurrent(null);
        SessionsCtrl.setCurrent(null);
    }

    private Page getPage() {
        Page page = this._comp.getPage();
        if (page != null) {
            return page;
        }
        Iterator it = this._desktop.getPages().iterator();
        return it.hasNext() ? (Page)it.next() : null;
    }

    public String toString() {
        return "[comp: " + this._comp + ", event: " + this._event + ']';
    }

    static {
        RETRY = new EventListener(){

            public void onEvent(Event event) {
            }
        };
    }
}

