/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import org.xml.sax.SAXException;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Expectable;
import org.zkoss.lang.Objects;
import org.zkoss.util.ArraysX;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuWriter;
import org.zkoss.zk.au.out.AuAlert;
import org.zkoss.zk.au.out.AuEcho;
import org.zkoss.zk.au.out.AuWrongValue;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.scripting.Namespace;
import org.zkoss.zk.scripting.Namespaces;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.SuspendNotAllowedException;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.WrongValuesException;
import org.zkoss.zk.ui.event.CreateEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.Express;
import org.zkoss.zk.ui.event.FulfillEvent;
import org.zkoss.zk.ui.ext.AfterCompose;
import org.zkoss.zk.ui.ext.Native;
import org.zkoss.zk.ui.ext.render.PrologAllowed;
import org.zkoss.zk.ui.impl.AbortBySendRedirect;
import org.zkoss.zk.ui.impl.EventProcessingThreadImpl;
import org.zkoss.zk.ui.impl.EventProcessor;
import org.zkoss.zk.ui.impl.Initiators;
import org.zkoss.zk.ui.impl.PageImpl;
import org.zkoss.zk.ui.impl.PhantomExecution;
import org.zkoss.zk.ui.impl.UiVisualizer;
import org.zkoss.zk.ui.metainfo.AttributesInfo;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.NativeInfo;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.Property;
import org.zkoss.zk.ui.metainfo.PropertyNotFoundException;
import org.zkoss.zk.ui.metainfo.TextInfo;
import org.zkoss.zk.ui.metainfo.VariablesInfo;
import org.zkoss.zk.ui.metainfo.ZScript;
import org.zkoss.zk.ui.metainfo.ZkInfo;
import org.zkoss.zk.ui.sys.AbortingReason;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.EventProcessingThread;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;
import org.zkoss.zk.ui.sys.FailoverManager;
import org.zkoss.zk.ui.sys.PageConfig;
import org.zkoss.zk.ui.sys.PageCtrl;
import org.zkoss.zk.ui.sys.RequestQueue;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zk.ui.util.ComponentSerializationListener;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ComposerExt;
import org.zkoss.zk.ui.util.Condition;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.DeferredValue;
import org.zkoss.zk.ui.util.ForEach;
import org.zkoss.zk.ui.util.Monitor;
import org.zkoss.zk.ui.util.PerformanceMeter;
import org.zkoss.zk.xel.Evaluators;

public class UiEngineImpl
implements UiEngine {
    private static final Log log;
    private WebApp _wapp;
    private final List _idles = new LinkedList();
    private final Map _suspended = new HashMap();
    private final Map _resumed = new HashMap();
    private int _suspCnt;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void start(WebApp wapp) {
        this._wapp = wapp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(WebApp wapp) {
        Iterator<Object> i2;
        Object object;
        Iterator<Object> it;
        Object object2 = this._idles;
        synchronized (object2) {
            it = this._idles.iterator();
            while (it.hasNext()) {
                ((EventProcessingThreadImpl)it.next()).cease("Stop application");
            }
            this._idles.clear();
        }
        object2 = this._suspended;
        synchronized (object2) {
            it = this._suspended.values().iterator();
            while (it.hasNext()) {
                Map map = (Map)it.next();
                object = map;
                synchronized (object) {
                    i2 = map.values().iterator();
                    while (i2.hasNext()) {
                        List list = (List)i2.next();
                        Iterator i3 = list.iterator();
                        while (i3.hasNext()) {
                            ((EventProcessingThreadImpl)i3.next()).cease("Stop application");
                        }
                    }
                }
            }
            this._suspended.clear();
        }
        object2 = this._resumed;
        synchronized (object2) {
            it = this._resumed.values().iterator();
            while (it.hasNext()) {
                List list = (List)it.next();
                object = list;
                synchronized (object) {
                    i2 = list.iterator();
                    while (i2.hasNext()) {
                        ((EventProcessingThreadImpl)i2.next()).cease("Stop application");
                    }
                }
            }
            this._resumed.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSuspendedThread() {
        if (!this._suspended.isEmpty()) {
            Map map = this._suspended;
            synchronized (map) {
                Iterator it = this._suspended.values().iterator();
                while (it.hasNext()) {
                    Map map2 = (Map)it.next();
                    if (map2.isEmpty()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getSuspendedThreads(Desktop desktop) {
        Map map;
        Map map2 = this._suspended;
        synchronized (map2) {
            map = (Map)this._suspended.get(desktop);
        }
        return map == null || map.isEmpty() ? Collections.EMPTY_LIST : Collections.synchronizedMap(map).values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ceaseSuspendedThread(Desktop desktop, EventProcessingThread evtthd, String cause) {
        Map map;
        Map map2 = this._suspended;
        synchronized (map2) {
            map = (Map)this._suspended.get(desktop);
        }
        if (map == null) {
            return false;
        }
        boolean found = false;
        Map map3 = map;
        synchronized (map3) {
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                List list = (List)me.getValue();
                found = list.remove(evtthd);
                if (!found) continue;
                if (!list.isEmpty()) break;
                it.remove();
                break;
            }
        }
        if (found) {
            ((EventProcessingThreadImpl)evtthd).cease(cause);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void desktopDestroyed(Desktop desktop) {
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            exec = new PhantomExecution(desktop);
            this.activate(exec);
            try {
                this.desktopDestroyed0(desktop);
            }
            finally {
                this.deactivate(exec);
            }
        } else {
            this.desktopDestroyed0(desktop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void desktopDestroyed0(Desktop desktop) {
        List list;
        Map map;
        Configuration config = this._wapp.getConfiguration();
        Map map2 = this._suspended;
        synchronized (map2) {
            map = (Map)this._suspended.remove(desktop);
        }
        if (map != null) {
            map2 = map;
            synchronized (map2) {
                Iterator it = map.values().iterator();
                while (it.hasNext()) {
                    List list2 = (List)it.next();
                    Iterator i2 = list2.iterator();
                    while (i2.hasNext()) {
                        EventProcessingThreadImpl evtthd = (EventProcessingThreadImpl)i2.next();
                        evtthd.ceaseSilently("Destroy desktop " + desktop);
                        config.invokeEventThreadResumeAborts(evtthd.getComponent(), evtthd.getEvent());
                    }
                }
            }
        }
        Object object = this._resumed;
        synchronized (object) {
            list = (List)this._resumed.remove(desktop);
        }
        if (list != null) {
            object = list;
            synchronized (object) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    EventProcessingThreadImpl evtthd = (EventProcessingThreadImpl)it.next();
                    evtthd.ceaseSilently("Destroy desktop " + desktop);
                    config.invokeEventThreadResumeAborts(evtthd.getComponent(), evtthd.getEvent());
                }
            }
        }
        ((DesktopCtrl)((Object)desktop)).destroy();
    }

    private static UiVisualizer getCurrentVisualizer() {
        ExecutionCtrl execCtrl = ExecutionsCtrl.getCurrentCtrl();
        if (execCtrl == null) {
            throw new IllegalStateException("Components can be accessed only in event listeners");
        }
        return (UiVisualizer)execCtrl.getVisualizer();
    }

    public void pushOwner(Component comp) {
        UiEngineImpl.getCurrentVisualizer().pushOwner(comp);
    }

    public void popOwner() {
        UiEngineImpl.getCurrentVisualizer().popOwner();
    }

    public boolean isInvalidated(Component comp) {
        return UiEngineImpl.getCurrentVisualizer().isInvalidated(comp);
    }

    public void addInvalidate(Page page) {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        UiEngineImpl.getCurrentVisualizer().addInvalidate(page);
    }

    public void addInvalidate(Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        UiEngineImpl.getCurrentVisualizer().addInvalidate(comp);
    }

    public void addSmartUpdate(Component comp, String attr, String value) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        UiEngineImpl.getCurrentVisualizer().addSmartUpdate(comp, attr, value);
    }

    public void addSmartUpdate(Component comp, String attr, DeferredValue value) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        UiEngineImpl.getCurrentVisualizer().addSmartUpdate(comp, attr, value);
    }

    public void addSmartUpdate(Component comp, String attr, Object[] values) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        UiEngineImpl.getCurrentVisualizer().addSmartUpdate(comp, attr, values);
    }

    public void addResponse(String key, AuResponse response) {
        UiEngineImpl.getCurrentVisualizer().addResponse(key, response);
    }

    public void addMoved(Component comp, Component oldparent, Page oldpg, Page newpg) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        UiEngineImpl.getCurrentVisualizer().addMoved(comp, oldparent, oldpg, newpg);
    }

    public void addUuidChanged(Component comp, boolean addOnlyMoved) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        UiEngineImpl.getCurrentVisualizer().addUuidChanged(comp, addOnlyMoved);
    }

    public void execNewPage(Execution exec, Richlet richlet, Page page, Writer out) throws IOException {
        this.execNewPage0(exec, null, richlet, page, out);
    }

    public void execNewPage(Execution exec, PageDefinition pagedef, Page page, Writer out) throws IOException {
        this.execNewPage0(exec, pagedef, null, page, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execNewPage0(Execution exec, PageDefinition pagedef, Richlet richlet, Page page, Writer out) throws IOException {
        block49: {
            block46: {
                block44: {
                    block45: {
                        desktop = exec.getDesktop();
                        desktopCtrl = (DesktopCtrl)desktop;
                        v0 = pagedef != null ? pagedef.getLanguageDefinition() : (langdef = richlet != null ? richlet.getLanguageDefinition() : null);
                        if (langdef != null) {
                            desktop.setDeviceType(langdef.getDeviceType());
                        }
                        startTime = (pfmeter = (config = (wapp = desktop.getWebApp()).getConfiguration()).getPerformanceMeter()) != null ? System.currentTimeMillis() : 0L;
                        oldexec = Executions.getCurrent();
                        oldexecCtrl = (ExecutionCtrl)oldexec;
                        v1 = olduv = oldexecCtrl != null ? (UiVisualizer)oldexecCtrl.getVisualizer() : null;
                        if (olduv != null) {
                            uv = UiEngineImpl.doReactivate(exec, olduv);
                            pfmeter = null;
                        } else {
                            uv = UiEngineImpl.doActivate(exec, false, false);
                        }
                        execCtrl = (ExecutionCtrl)exec;
                        old = execCtrl.getCurrentPage();
                        olddef = execCtrl.getCurrentPageDefinition();
                        execCtrl.setCurrentPage(page);
                        execCtrl.setCurrentPageDefinition(pagedef);
                        pfReqId = pfmeter != null ? UiEngineImpl.meterLoadStart(pfmeter, exec, startTime) : null;
                        abrn = null;
                        cleaned = false;
                        try {
                            try {
                                config.invokeExecutionInits(exec, oldexec);
                                desktopCtrl.invokeExecutionInits(exec, oldexec);
                                if (olduv != null && (owner = olduv.getOwner()) != null) {
                                    ((PageCtrl)page).setOwner(owner);
                                }
                                if (pagedef != null) {
                                    ((PageCtrl)page).preInit();
                                    pagedef.initXelContext(page);
                                    inits = Initiators.doInit(pagedef, page);
                                    try {
                                        try {
                                            pagedef.init(page, uv.isEverAsyncUpdate() == false && uv.isAborting() == false);
                                            uri = pagedef.getForwardURI(page);
                                            if (uri != null) {
                                                comps = new Component[]{};
                                                exec.forward(uri);
                                            } else {
                                                comps = uv.isAborting() != false || exec.isVoided() != false ? null : UiEngineImpl.execCreate(new CreateInfo(((WebAppCtrl)wapp).getUiFactory(), exec, page), pagedef, null);
                                            }
                                            inits.doAfterCompose(page, comps);
                                        }
                                        catch (Throwable ex) {
                                            if (!inits.doCatch(ex)) {
                                                throw UiException.Aide.wrap(ex);
                                            }
                                            var28_30 = null;
                                            inits.doFinally();
                                        }
                                        var28_30 = null;
                                        inits.doFinally();
                                    }
                                    catch (Throwable var27_32) {
                                        var28_31 = null;
                                        inits.doFinally();
                                        throw var27_32;
                                    }
                                } else {
                                    ((PageCtrl)page).preInit();
                                    ((PageCtrl)page).init(new PageConfig(){

                                        public String getId() {
                                            return null;
                                        }

                                        public String getUuid() {
                                            return null;
                                        }

                                        public String getTitle() {
                                            return null;
                                        }

                                        public String getStyle() {
                                            return null;
                                        }

                                        public String getHeaders() {
                                            return null;
                                        }
                                    });
                                    richlet.service(page);
                                }
                                if (exec.isVoided()) {
                                    var30_33 = null;
                                    if (!cleaned) {
                                        desktopCtrl.invokeExecutionCleanups(exec, oldexec, null);
                                        config.invokeExecutionCleanups(exec, oldexec, null);
                                    }
                                    if (abrn == null) break block44;
                                    break block45;
                                }
                                event = UiEngineImpl.nextEvent(uv);
                                while (true) {
                                    if (event != null) {
                                        this.process(desktop, event);
                                        event = UiEngineImpl.nextEvent(uv);
                                        continue;
                                    }
                                    this.resumeAll(desktop, uv, null);
                                    event = UiEngineImpl.nextEvent(uv);
                                    if (event == null) break;
                                }
                                abrn = uv.getAbortingReason();
                                if (abrn != null) {
                                    abrn.execute();
                                }
                                responses = uv.getResponses();
                                if (olduv != null && olduv.addToFirstAsyncUpdate(responses)) {
                                    responses = null;
                                }
                                ((PageCtrl)page).redraw(responses, out);
                                break block46;
                            }
                            catch (Throwable ex) {
                                cleaned = true;
                                errs = new LinkedList<Throwable>();
                                errs.add(ex);
                                desktopCtrl.invokeExecutionCleanups(exec, oldexec, errs);
                                config.invokeExecutionCleanups(exec, oldexec, errs);
                                if (!errs.isEmpty()) {
                                    ex = (Throwable)errs.get(0);
                                    if (ex instanceof IOException == false) throw UiException.Aide.wrap(ex);
                                    throw (IOException)ex;
                                }
                                var30_35 = null;
                                if (!cleaned) {
                                    desktopCtrl.invokeExecutionCleanups(exec, oldexec, null);
                                    config.invokeExecutionCleanups(exec, oldexec, null);
                                }
                                if (abrn != null) {
                                    try {
                                        abrn.finish();
                                    }
                                    catch (Throwable t) {
                                        UiEngineImpl.log.warning(t);
                                    }
                                }
                                execCtrl.setCurrentPage(old);
                                execCtrl.setCurrentPageDefinition(olddef);
                                if (olduv != null) {
                                    UiEngineImpl.doDereactivate(exec, olduv);
                                } else {
                                    UiEngineImpl.doDeactivate(exec);
                                }
                                if (pfmeter == null) return;
                                UiEngineImpl.meterLoadServerComplete(pfmeter, pfReqId, exec);
                                return;
                            }
                        }
                        catch (Throwable var29_41) {
                            block48: {
                                var30_36 = null;
                                if (!cleaned) {
                                    desktopCtrl.invokeExecutionCleanups(exec, oldexec, null);
                                    config.invokeExecutionCleanups(exec, oldexec, null);
                                }
                                if (abrn != null) {
                                    ** try [egrp 4[TRYBLOCK] [10 : 762->772)] { 
lbl126:
                                    // 1 sources

                                    abrn.finish();
                                    break block48;
lbl128:
                                    // 1 sources

                                    catch (Throwable t) {
                                        UiEngineImpl.log.warning(t);
                                    }
                                }
                            }
                            execCtrl.setCurrentPage(old);
                            execCtrl.setCurrentPageDefinition(olddef);
                            if (olduv != null) {
                                UiEngineImpl.doDereactivate(exec, olduv);
                            } else {
                                UiEngineImpl.doDeactivate(exec);
                            }
                            if (pfmeter == null) throw var29_41;
                            UiEngineImpl.meterLoadServerComplete(pfmeter, pfReqId, exec);
                            throw var29_41;
                        }
                    }
                    ** try [egrp 4[TRYBLOCK] [10 : 762->772)] { 
lbl142:
                    // 1 sources

                    abrn.finish();
                    break block44;
lbl144:
                    // 1 sources

                    catch (Throwable t) {
                        UiEngineImpl.log.warning(t);
                    }
                }
                execCtrl.setCurrentPage(old);
                execCtrl.setCurrentPageDefinition(olddef);
                if (olduv != null) {
                    UiEngineImpl.doDereactivate(exec, olduv);
                } else {
                    UiEngineImpl.doDeactivate(exec);
                }
                if (pfmeter == null) return;
                UiEngineImpl.meterLoadServerComplete(pfmeter, pfReqId, exec);
                return;
            }
            var30_34 = null;
            if (!cleaned) {
                desktopCtrl.invokeExecutionCleanups(exec, oldexec, null);
                config.invokeExecutionCleanups(exec, oldexec, null);
            }
            if (abrn != null) {
                ** try [egrp 4[TRYBLOCK] [10 : 762->772)] { 
lbl163:
                // 1 sources

                abrn.finish();
                break block49;
lbl165:
                // 1 sources

                catch (Throwable t) {
                    UiEngineImpl.log.warning(t);
                }
            }
        }
        execCtrl.setCurrentPage(old);
        execCtrl.setCurrentPageDefinition(olddef);
        if (olduv != null) {
            UiEngineImpl.doDereactivate(exec, olduv);
        } else {
            UiEngineImpl.doDeactivate(exec);
        }
        if (pfmeter == null) return;
        UiEngineImpl.meterLoadServerComplete(pfmeter, pfReqId, exec);
    }

    private static final Event nextEvent(UiVisualizer uv) {
        Event evt = ((ExecutionCtrl)((Object)uv.getExecution())).getNextEvent();
        return evt != null && !uv.isAborting() ? evt : null;
    }

    private static final Component[] execCreate(CreateInfo ci, NodeInfo parentInfo, Component parent) {
        Component c;
        ComponentInfo pi;
        String fulfill;
        String fulfillURI = null;
        if (parentInfo instanceof ComponentInfo && (fulfill = (pi = (ComponentInfo)parentInfo).getFulfill()) != null && (fulfill = fulfill.trim()).length() > 0) {
            if (fulfill.startsWith("=")) {
                fulfillURI = fulfill.substring(1).trim();
            } else {
                new FulfillListener(fulfill, pi, parent);
                return new Component[0];
            }
        }
        Component[] cs = UiEngineImpl.execCreate0(ci, parentInfo, parent);
        if (fulfillURI != null && (fulfillURI = (String)Evaluators.evaluate(((ComponentInfo)parentInfo).getEvaluator(), parent, fulfillURI, String.class)) != null && (c = ci.exec.createComponents(fulfillURI, parent, null)) != null) {
            cs = (Component[])ArraysX.resize((Object)cs, (int)(cs.length + 1));
            cs[cs.length - 1] = c;
        }
        return cs;
    }

    private static final Component[] execCreate0(CreateInfo ci, NodeInfo parentInfo, Component parent) {
        LinkedList<Component> created = new LinkedList<Component>();
        Page page = ci.page;
        PageDefinition pagedef = parentInfo.getPageDefinition();
        ReplaceableText replaceableText = new ReplaceableText();
        Iterator it = parentInfo.getChildren().iterator();
        while (it.hasNext()) {
            Object meta = it.next();
            if (meta instanceof ComponentInfo) {
                int j;
                Component[] children;
                ComponentInfo childInfo = (ComponentInfo)meta;
                ForEach forEach = childInfo.resolveForEach(page, parent);
                if (forEach == null) {
                    if (!UiEngineImpl.isEffective(childInfo, page, parent)) continue;
                    children = UiEngineImpl.execCreateChild(ci, parent, childInfo, replaceableText);
                    for (j = 0; j < children.length; ++j) {
                        created.add(children[j]);
                    }
                    continue;
                }
                while (forEach.next()) {
                    if (!UiEngineImpl.isEffective(childInfo, page, parent)) continue;
                    children = UiEngineImpl.execCreateChild(ci, parent, childInfo, replaceableText);
                    for (j = 0; j < children.length; ++j) {
                        created.add(children[j]);
                    }
                }
                continue;
            }
            if (meta instanceof TextInfo) {
                String s = ((TextInfo)meta).getValue(parent);
                if (s == null || s.length() <= 0) continue;
                parent.appendChild(((Native)((Object)parent)).getHelper().newNative(s));
                continue;
            }
            UiEngineImpl.execNonComponent(ci, parent, meta);
        }
        return created.toArray(new Component[created.size()]);
    }

    private static Component[] execCreateChild(CreateInfo ci, Component parent, ComponentInfo childInfo, ReplaceableText replaceableText) {
        Component[] componentArray;
        Component child;
        if (childInfo instanceof ZkInfo) {
            ZkInfo zkInfo = (ZkInfo)childInfo;
            return zkInfo.withSwitch() ? UiEngineImpl.execSwitch(ci, zkInfo, parent) : UiEngineImpl.execCreate0(ci, childInfo, parent);
        }
        ComponentDefinition childdef = childInfo.getComponentDefinition();
        if (childdef.isInlineMacro()) {
            HashMap<String, Component> props = new HashMap<String, Component>();
            props.put("includer", parent);
            childInfo.evalProperties(props, ci.page, parent, true);
            return new Component[]{ci.exec.createComponents(childdef.getMacroURI(), parent, props)};
        }
        String rt = null;
        if (replaceableText != null) {
            rt = replaceableText.text;
            replaceableText.text = childInfo.getReplaceableText();
            if (replaceableText.text != null) {
                return new Component[0];
            }
        }
        if ((child = UiEngineImpl.execCreateChild0(ci, parent, childInfo, rt)) != null) {
            Component[] componentArray2 = new Component[1];
            componentArray = componentArray2;
            componentArray2[0] = child;
        } else {
            componentArray = new Component[]{};
        }
        return componentArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Component execCreateChild0(CreateInfo ci, Component parent, ComponentInfo childInfo, String replaceableText) {
        Object xc;
        ComposerExt composerExt;
        block23: {
            Component component;
            block22: {
                Composer composer = childInfo.resolveComposer(ci.page, parent);
                composerExt = composer instanceof ComposerExt ? (ComposerExt)((Object)composer) : null;
                Component child = null;
                try {
                    try {
                        if (composerExt != null && (childInfo = composerExt.doBeforeCompose(ci.page, parent, childInfo)) == null) {
                            component = null;
                            Object var11_10 = null;
                            if (composerExt == null) return component;
                            break block22;
                        }
                        child = ci.uf.newComponent(ci.page, parent, childInfo);
                        boolean bNative = childInfo instanceof NativeInfo;
                        if (bNative) {
                            UiEngineImpl.setProlog(ci, child, (NativeInfo)childInfo);
                        } else if (replaceableText != null && (xc = ((ComponentCtrl)((Object)child)).getExtraCtrl()) instanceof PrologAllowed) {
                            ((PrologAllowed)xc).setPrologContent(replaceableText);
                        }
                        if (composerExt != null) {
                            composerExt.doBeforeComposeChildren(child);
                        }
                        UiEngineImpl.execCreate(ci, childInfo, child);
                        if (bNative) {
                            UiEngineImpl.setEpilog(ci, child, (NativeInfo)childInfo);
                        }
                        if (child instanceof AfterCompose) {
                            ((AfterCompose)((Object)child)).afterCompose();
                        }
                        if (composer != null) {
                            composer.doAfterCompose(child);
                        }
                        ComponentsCtrl.applyForward(child, childInfo.getForward());
                        if (Events.isListened(child, "onCreate", false)) {
                            Events.postEvent(new CreateEvent("onCreate", child, ci.exec.getArg()));
                        }
                        xc = child;
                        break block23;
                    }
                    catch (Throwable ex) {
                        boolean ignore = false;
                        if (composerExt != null) {
                            try {
                                ignore = composerExt.doCatch(ex);
                            }
                            catch (Throwable t) {
                                log.error("Failed to invoke doCatch for " + childInfo, t);
                            }
                        }
                        if (!ignore) {
                            throw UiException.Aide.wrap(ex);
                        }
                        Component component2 = child != null && child.getPage() != null ? child : null;
                        Object var11_12 = null;
                        if (composerExt == null) return component2;
                        try {
                            composerExt.doFinally();
                            return component2;
                        }
                        catch (Throwable ex2) {
                            throw UiException.Aide.wrap(ex2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    if (composerExt == null) throw throwable;
                    try {}
                    catch (Throwable ex2) {
                        throw UiException.Aide.wrap(ex2);
                    }
                    composerExt.doFinally();
                    throw throwable;
                }
            }
            try {}
            catch (Throwable ex2) {
                throw UiException.Aide.wrap(ex2);
            }
            composerExt.doFinally();
            return component;
        }
        Object var11_11 = null;
        if (composerExt == null) return xc;
        try {}
        catch (Throwable ex2) {
            throw UiException.Aide.wrap(ex2);
        }
        composerExt.doFinally();
        return xc;
    }

    private static Component[] execSwitch(CreateInfo ci, ZkInfo switchInfo, Component parent) {
        Page page = ci.page;
        Object switchCond = switchInfo.resolveSwitch(page, parent);
        Iterator it = switchInfo.getChildren().iterator();
        while (it.hasNext()) {
            ZkInfo caseInfo = (ZkInfo)it.next();
            ForEach forEach = caseInfo.resolveForEach(page, parent);
            if (forEach == null) {
                if (!UiEngineImpl.isEffective(caseInfo, page, parent) || !UiEngineImpl.isCaseMatched(caseInfo, page, parent, switchCond)) continue;
                return UiEngineImpl.execCreateChild(ci, parent, caseInfo, null);
            }
            LinkedList<Component> created = new LinkedList<Component>();
            while (forEach.next()) {
                if (!UiEngineImpl.isEffective(caseInfo, page, parent) || !UiEngineImpl.isCaseMatched(caseInfo, page, parent, switchCond)) continue;
                Component[] children = UiEngineImpl.execCreateChild(ci, parent, caseInfo, null);
                for (int j = 0; j < children.length; ++j) {
                    created.add(children[j]);
                }
                return created.toArray(new Component[created.size()]);
            }
        }
        return new Component[0];
    }

    private static boolean isCaseMatched(ZkInfo caseInfo, Page page, Component parent, Object switchCond) {
        if (!caseInfo.withCase()) {
            return true;
        }
        Object[] caseValues = caseInfo.resolveCase(page, parent);
        for (int j = 0; j < caseValues.length; ++j) {
            String casev;
            int len;
            if (!(caseValues[j] instanceof String && switchCond instanceof String && (len = (casev = (String)caseValues[j]).length()) >= 2 && casev.charAt(0) == '/' && casev.charAt(len - 1) == '/' ? Pattern.compile(casev.substring(1, len - 1)).matcher((String)switchCond).matches() : Objects.equals((Object)switchCond, (Object)caseValues[j]))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void execNonComponent(CreateInfo ci, Component comp, Object meta) {
        Page page = ci.page;
        if (meta instanceof ZScript) {
            ZScript zscript = (ZScript)meta;
            if (zscript.isDeferred()) {
                ((PageCtrl)((Object)page)).addDeferredZScript(comp, zscript);
            } else if (UiEngineImpl.isEffective(zscript, page, comp)) {
                HashMap backup = new HashMap();
                Namespace ns = comp != null ? Namespaces.beforeInterpret(backup, comp, false) : Namespaces.beforeInterpret(backup, page, false);
                try {
                    page.interpret(zscript.getLanguage(), zscript.getContent(page, comp), ns);
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    Namespaces.afterInterpret(backup, ns, false);
                    throw throwable;
                }
                Namespaces.afterInterpret(backup, ns, false);
                {
                }
            }
        } else if (meta instanceof AttributesInfo) {
            AttributesInfo attrs = (AttributesInfo)meta;
            if (comp != null) {
                attrs.apply(comp);
            } else {
                attrs.apply(page);
            }
        } else if (meta instanceof VariablesInfo) {
            VariablesInfo vars = (VariablesInfo)meta;
            if (comp != null) {
                vars.apply(comp);
            } else {
                vars.apply(page);
            }
        } else {
            throw new IllegalStateException(meta + " not allowed in " + comp);
        }
    }

    private static final boolean isEffective(Condition cond, Page page, Component comp) {
        return comp != null ? cond.isEffective(comp) : cond.isEffective(page);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Component[] createComponents(Execution exec, PageDefinition pagedef, Page page, Component parent, Map arg) {
        Component[] componentArray;
        boolean fakepg;
        if (pagedef == null) {
            throw new IllegalArgumentException("pagedef");
        }
        ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)exec);
        if (parent != null) {
            if (parent.getPage() != null) {
                page = parent.getPage();
            }
            if (page == null) {
                page = execCtrl.getCurrentPage();
            }
        } else if (page != null) {
            parent = ((PageCtrl)((Object)page)).getDefaultParent();
        }
        if (!execCtrl.isActivated()) {
            throw new IllegalStateException("Not activated yet");
        }
        boolean bl = fakepg = page == null;
        if (fakepg) {
            page = new PageImpl(pagedef);
        }
        Desktop desktop = exec.getDesktop();
        Page old = execCtrl.getCurrentPage();
        if (page != null && page != old) {
            execCtrl.setCurrentPage(page);
        }
        PageDefinition olddef = execCtrl.getCurrentPageDefinition();
        execCtrl.setCurrentPageDefinition(pagedef);
        exec.pushArg(arg != null ? arg : Collections.EMPTY_MAP);
        if (fakepg) {
            ((PageCtrl)((Object)page)).preInit();
        }
        pagedef.initXelContext(page);
        Initiators inits = Initiators.doInit(pagedef, page);
        try {
            try {
                if (fakepg) {
                    pagedef.init(page, false);
                }
                Component[] comps = UiEngineImpl.execCreate(new CreateInfo(((WebAppCtrl)((Object)desktop.getWebApp())).getUiFactory(), exec, page), pagedef, parent);
                inits.doAfterCompose(page, comps);
                if (fakepg) {
                    for (int j = 0; j < comps.length; ++j) {
                        comps[j].detach();
                        if (parent == null) continue;
                        parent.appendChild(comps[j]);
                    }
                }
                componentArray = comps;
                Object var15_16 = null;
                exec.popArg();
                execCtrl.setCurrentPage(old);
                execCtrl.setCurrentPageDefinition(olddef);
                inits.doFinally();
                if (!fakepg) return componentArray;
            }
            catch (Throwable ex) {
                inits.doCatch(ex);
                throw UiException.Aide.wrap(ex);
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            exec.popArg();
            execCtrl.setCurrentPage(old);
            execCtrl.setCurrentPageDefinition(olddef);
            inits.doFinally();
            if (!fakepg) throw throwable;
            try {
                ((DesktopCtrl)((Object)desktop)).removePage(page);
                throw throwable;
            }
            catch (Throwable ex2) {
                log.warningBriefly(ex2);
                throw throwable;
            }
        }
        try {}
        catch (Throwable ex2) {
            log.warningBriefly(ex2);
            return componentArray;
        }
        ((DesktopCtrl)((Object)desktop)).removePage(page);
        return componentArray;
    }

    public void sendRedirect(String uri, String target) {
        if (uri != null && uri.length() == 0) {
            uri = null;
        }
        UiVisualizer uv = UiEngineImpl.getCurrentVisualizer();
        uv.setAbortingReason(new AbortBySendRedirect(uri != null ? uv.getExecution().encodeURL(uri) : "", target));
    }

    public void setAbortingReason(AbortingReason aborting) {
        UiVisualizer uv = UiEngineImpl.getCurrentVisualizer();
        uv.setAbortingReason(aborting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execRecover(Execution exec, FailoverManager failover) {
        Desktop desktop = exec.getDesktop();
        Session sess = desktop.getSession();
        UiEngineImpl.doActivate(exec, false, true);
        try {
            failover.recover(sess, exec, desktop);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            UiEngineImpl.doDeactivate(exec);
            throw throwable;
        }
        UiEngineImpl.doDeactivate(exec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRequestDuplicate(Execution exec, AuWriter out) throws IOException {
        String sid = ((ExecutionCtrl)((Object)exec)).getRequestId();
        if (sid != null) {
            boolean bl;
            UiEngineImpl.doActivate(exec, true, false);
            try {
                bl = this.isReqDup0(exec, out, sid);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                UiEngineImpl.doDeactivate(exec);
                throw throwable;
            }
            UiEngineImpl.doDeactivate(exec);
            return bl;
        }
        return false;
    }

    private boolean isReqDup0(Execution exec, AuWriter out, String sid) throws IOException {
        Object[] resInfo = (Object[])((DesktopCtrl)((Object)exec.getDesktop())).getLastResponse(out.getChannel(), sid);
        if (resInfo != null) {
            if (log.debugable()) {
                Object req = exec.getNativeRequest();
                log.debug("Repeat request\n" + (req instanceof ServletRequest ? Servlets.getDetail((ServletRequest)((ServletRequest)req)) : "sid: " + sid));
            }
            out.writeResponseId((Integer)resInfo[0]);
            out.write((Collection)resInfo[1]);
            return true;
        }
        return false;
    }

    public void beginUpdate(Execution exec) {
        UiVisualizer uv = UiEngineImpl.doActivate(exec, true, false);
        Desktop desktop = exec.getDesktop();
        desktop.getWebApp().getConfiguration().invokeExecutionInits(exec, null);
        ((DesktopCtrl)((Object)desktop)).invokeExecutionInits(exec, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endUpdate(Execution exec, AuWriter out) throws IOException {
        boolean cleaned = false;
        Desktop desktop = exec.getDesktop();
        DesktopCtrl desktopCtrl = (DesktopCtrl)((Object)desktop);
        Configuration config = desktop.getWebApp().getConfiguration();
        ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)exec);
        UiVisualizer uv = (UiVisualizer)execCtrl.getVisualizer();
        try {
            Event event = UiEngineImpl.nextEvent(uv);
            while (true) {
                if (event != null) {
                    this.process(desktop, event);
                    event = UiEngineImpl.nextEvent(uv);
                    continue;
                }
                this.resumeAll(desktop, uv, null);
                event = UiEngineImpl.nextEvent(uv);
                if (event == null) break;
            }
            List responses = uv.getResponses();
            int resId = desktopCtrl.getResponseId(true);
            desktopCtrl.responseSent(out.getChannel(), execCtrl.getRequestId(), new Object[]{new Integer(resId), responses});
            out.writeResponseId(resId);
            out.write(responses);
            cleaned = true;
            desktopCtrl.invokeExecutionCleanups(exec, null, null);
            config.invokeExecutionCleanups(exec, null, null);
            Object var13_12 = null;
            if (!cleaned) {
                desktopCtrl.invokeExecutionCleanups(exec, null, null);
                config.invokeExecutionCleanups(exec, null, null);
            }
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (!cleaned) {
                desktopCtrl.invokeExecutionCleanups(exec, null, null);
                config.invokeExecutionCleanups(exec, null, null);
            }
            UiEngineImpl.doDeactivate(exec);
            throw throwable;
        }
        UiEngineImpl.doDeactivate(exec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execUpdate(Execution exec, List requests, AuWriter out) throws IOException {
        block53: {
            boolean cleaned;
            AbortingReason abrn;
            Collection doneReqIds;
            Monitor monitor;
            PerformanceMeter pfmeter;
            Configuration config;
            DesktopCtrl desktopCtrl;
            Desktop desktop;
            block49: {
                LinkedList<AuResponse> responses;
                AuRequest request;
                if (requests == null) {
                    throw new IllegalArgumentException();
                }
                if (!$assertionsDisabled && ExecutionsCtrl.getCurrentCtrl() != null) {
                    throw new AssertionError((Object)("Impossible to re-activate for update: old=" + ExecutionsCtrl.getCurrentCtrl() + ", new=" + exec));
                }
                desktop = exec.getDesktop();
                desktopCtrl = (DesktopCtrl)((Object)desktop);
                config = desktop.getWebApp().getConfiguration();
                pfmeter = config.getPerformanceMeter();
                long startTime = 0L;
                if (pfmeter != null) {
                    startTime = System.currentTimeMillis();
                    UiEngineImpl.meterAuClientComplete(pfmeter, exec);
                }
                UiVisualizer uv = UiEngineImpl.doActivate(exec, true, false);
                String sid = ((ExecutionCtrl)((Object)exec)).getRequestId();
                if (sid != null && this.isReqDup0(exec, out, sid)) {
                    UiEngineImpl.doDeactivate(exec);
                    return;
                }
                monitor = config.getMonitor();
                if (monitor != null) {
                    try {
                        monitor.beforeUpdate(desktop, requests);
                    }
                    catch (Throwable ex) {
                        log.error(ex);
                    }
                }
                String pfReqId = pfmeter != null ? UiEngineImpl.meterAuStart(pfmeter, exec, startTime) : null;
                doneReqIds = null;
                abrn = null;
                cleaned = false;
                RequestQueue rque = desktopCtrl.getRequestQueue();
                rque.addRequests(requests);
                config.invokeExecutionInits(exec, null);
                desktopCtrl.invokeExecutionInits(exec, null);
                if (pfReqId != null) {
                    rque.addPerfRequestId(pfReqId);
                }
                LinkedList errs = new LinkedList();
                long tmexpired = System.currentTimeMillis() + (long)config.getMaxProcessTime();
                while (System.currentTimeMillis() < tmexpired && (request = rque.nextRequest()) != null) {
                    try {
                        this.process(exec, request, !errs.isEmpty());
                    }
                    catch (ComponentNotFoundException ex) {
                    }
                    catch (Throwable ex) {
                        UiEngineImpl.handleError(ex, uv, errs);
                    }
                    Event event = UiEngineImpl.nextEvent(uv);
                    while (true) {
                        block48: {
                            if (event != null) {
                                try {
                                    this.process(desktop, event);
                                }
                                catch (Throwable ex) {
                                    UiEngineImpl.handleError(ex, uv, errs);
                                    break block48;
                                }
                                event = UiEngineImpl.nextEvent(uv);
                                continue;
                            }
                        }
                        this.resumeAll(desktop, uv, errs);
                        event = UiEngineImpl.nextEvent(uv);
                        if (event == null) break;
                    }
                }
                abrn = uv.getAbortingReason();
                if (abrn != null) {
                    abrn.execute();
                }
                try {
                    if (!errs.isEmpty()) {
                        this.visualizeErrors(exec, uv, errs);
                    }
                    responses = uv.getResponses();
                }
                catch (Throwable ex) {
                    responses = new LinkedList<AuResponse>();
                    responses.add(new AuAlert(Exceptions.getMessage((Throwable)ex)));
                    log.error(ex);
                }
                if (rque.isEmpty()) {
                    doneReqIds = rque.clearPerfRequestIds();
                } else {
                    responses.add(new AuEcho(desktop));
                }
                int resId = desktopCtrl.getResponseId(true);
                desktopCtrl.responseSent(out.getChannel(), sid, new Object[]{new Integer(resId), responses});
                out.writeResponseId(resId);
                out.write(responses);
                cleaned = true;
                desktopCtrl.invokeExecutionCleanups(exec, null, errs);
                config.invokeExecutionCleanups(exec, null, errs);
                Object var25_30 = null;
                if (!cleaned) {
                    desktopCtrl.invokeExecutionCleanups(exec, null, null);
                    config.invokeExecutionCleanups(exec, null, null);
                }
                if (abrn == null) break block49;
                try {
                    abrn.finish();
                }
                catch (Throwable t) {
                    log.warning(t);
                }
            }
            if (monitor != null) {
                try {
                    monitor.afterUpdate(desktop);
                }
                catch (Throwable ex2) {
                    log.error(ex2);
                }
            }
            UiEngineImpl.doDeactivate(exec);
            if (pfmeter != null && doneReqIds != null) {
                UiEngineImpl.meterAuServerComplete(pfmeter, doneReqIds, exec);
            }
            break block53;
            {
                catch (Throwable ex) {
                    if (!cleaned) {
                        cleaned = true;
                        LinkedList<Throwable> errs = new LinkedList<Throwable>();
                        errs.add(ex);
                        desktopCtrl.invokeExecutionCleanups(exec, null, errs);
                        config.invokeExecutionCleanups(exec, null, errs);
                        Throwable throwable = ex = errs.isEmpty() ? null : (Throwable)errs.get(0);
                    }
                    if (ex != null) {
                        if (ex instanceof IOException) {
                            throw (IOException)ex;
                        }
                        throw UiException.Aide.wrap(ex);
                    }
                    Object var25_31 = null;
                    if (!cleaned) {
                        desktopCtrl.invokeExecutionCleanups(exec, null, null);
                        config.invokeExecutionCleanups(exec, null, null);
                    }
                    if (abrn != null) {
                        try {
                            abrn.finish();
                        }
                        catch (Throwable t) {
                            log.warning(t);
                        }
                    }
                    if (monitor != null) {
                        try {
                            monitor.afterUpdate(desktop);
                        }
                        catch (Throwable ex2) {
                            log.error(ex2);
                        }
                    }
                    UiEngineImpl.doDeactivate(exec);
                    if (pfmeter != null && doneReqIds != null) {
                        UiEngineImpl.meterAuServerComplete(pfmeter, doneReqIds, exec);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var25_32 = null;
                if (!cleaned) {
                    desktopCtrl.invokeExecutionCleanups(exec, null, null);
                    config.invokeExecutionCleanups(exec, null, null);
                }
                if (abrn != null) {
                    try {
                        abrn.finish();
                    }
                    catch (Throwable t) {
                        log.warning(t);
                    }
                }
                if (monitor != null) {
                    try {
                        monitor.afterUpdate(desktop);
                    }
                    catch (Throwable ex2) {
                        log.error(ex2);
                    }
                }
                UiEngineImpl.doDeactivate(exec);
                if (pfmeter != null && doneReqIds != null) {
                    UiEngineImpl.meterAuServerComplete(pfmeter, doneReqIds, exec);
                }
                throw throwable;
            }
        }
    }

    private static final void handleError(Throwable ex, UiVisualizer uv, List errs) {
        Throwable err = ex;
        Throwable t = Exceptions.findCause((Throwable)ex, (Class)Expectable.class);
        if (t == null) {
            if (ex instanceof SAXException || ex instanceof PropertyNotFoundException) {
                log.error(Exceptions.getMessage((Throwable)ex));
            } else {
                log.realCauseBriefly(ex);
            }
        } else {
            ex = t;
            if (log.debugable()) {
                log.debug(Exceptions.getRealCause((Throwable)ex));
            }
        }
        if (ex instanceof WrongValueException) {
            WrongValueException wve = (WrongValueException)((Object)ex);
            Component comp = wve.getComponent();
            if (comp != null) {
                if ((wve = ((ComponentCtrl)((Object)comp)).onWrongValue(wve)) != null) {
                    uv.addResponse("wrongValue", new AuWrongValue(comp, Exceptions.getMessage((Throwable)((Object)wve))));
                }
                return;
            }
        } else if (ex instanceof WrongValuesException) {
            WrongValuesException wve = (WrongValuesException)((Object)ex);
            WrongValueException[] wves = wve.getWrongValueExceptions();
            StringBuffer uuids = new StringBuffer();
            LinkedList<String> msgs = new LinkedList<String>();
            for (int i = 0; i < wves.length; ++i) {
                Component comp = wves[i].getComponent();
                if (comp == null) continue;
                wves[i] = ((ComponentCtrl)((Object)comp)).onWrongValue(wves[i]);
                if (wves[i] == null) continue;
                uuids.append(comp.getUuid()).append(",");
                msgs.add(Exceptions.getMessage((Throwable)((Object)wves[i])));
            }
            if (uuids.length() > 0) {
                uuids.delete(uuids.length() - 1, uuids.length());
            }
            msgs.addFirst(uuids.toString());
            uv.addResponse("wrongValue", new AuWrongValue(msgs.toArray(new String[0])));
            return;
        }
        errs.add(err);
    }

    private final void visualizeErrors(Execution exec, UiVisualizer uv, List errs) {
        StringBuffer sb = new StringBuffer(128);
        Iterator it = errs.iterator();
        while (it.hasNext()) {
            Throwable t = (Throwable)it.next();
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(Exceptions.getMessage((Throwable)t));
        }
        String msg = sb.toString();
        Throwable err = (Throwable)errs.get(0);
        Desktop desktop = exec.getDesktop();
        Configuration config = desktop.getWebApp().getConfiguration();
        String location = config.getErrorPage(desktop.getDeviceType(), err);
        if (location != null) {
            try {
                exec.setAttribute("javax.servlet.error.message", msg);
                exec.setAttribute("javax.servlet.error.exception", err);
                exec.setAttribute("javax.servlet.error.exception_type", err.getClass());
                exec.setAttribute("javax.servlet.error.status_code", new Integer(500));
                exec.setAttribute("javax.servlet.error.error_page", location);
                Richlet richlet = config.getRichletByPath(location);
                if (richlet != null) {
                    richlet.service(((ExecutionCtrl)((Object)exec)).getCurrentPage());
                } else {
                    exec.createComponents(location, null, null);
                }
                Event event = UiEngineImpl.nextEvent(uv);
                while (true) {
                    if (event != null) {
                        try {
                            this.process(desktop, event);
                        }
                        catch (SuspendNotAllowedException ex) {
                            // empty catch block
                        }
                        event = UiEngineImpl.nextEvent(uv);
                        continue;
                    }
                    this.resumeAll(desktop, uv, null);
                    event = UiEngineImpl.nextEvent(uv);
                    if (event == null) break;
                }
                return;
            }
            catch (Throwable ex) {
                log.realCause("Unable to generate custom error page, " + location, ex);
            }
        }
        uv.addResponse(null, new AuAlert(msg));
    }

    private void process(Execution exec, AuRequest request, boolean everError) {
        ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)exec);
        execCtrl.setCurrentPage(request.getPage());
        request.getCommand().process(request, everError);
    }

    private void process(Desktop desktop, Event event) {
        Component comp = event.getTarget();
        if (comp != null) {
            this.processEvent(desktop, comp, event);
        } else {
            LinkedList roots = new LinkedList();
            Iterator it = desktop.getPages().iterator();
            while (it.hasNext()) {
                roots.addAll(((Page)it.next()).getRoots());
            }
            it = roots.iterator();
            while (it.hasNext()) {
                Component c = (Component)it.next();
                if (c.getPage() == null) continue;
                this.processEvent(desktop, c, event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wait(Object mutex) throws InterruptedException, SuspendNotAllowedException {
        IdentityHashMap<Object, LinkedList<EventProcessingThreadImpl>> map;
        if (mutex == null) {
            throw new IllegalArgumentException("null mutex");
        }
        Thread thd = Thread.currentThread();
        if (!(thd instanceof EventProcessingThreadImpl)) {
            throw new UiException("This method can be called only in an event listener, not in paging loading.");
        }
        EventProcessingThreadImpl evtthd = (EventProcessingThreadImpl)thd;
        evtthd.newEventThreadSuspends(mutex);
        Execution exec = Executions.getCurrent();
        Desktop desktop = exec.getDesktop();
        this.incSuspended();
        Map map2 = this._suspended;
        synchronized (map2) {
            map = (IdentityHashMap<Object, LinkedList<EventProcessingThreadImpl>>)this._suspended.get(desktop);
            if (map == null) {
                map = new IdentityHashMap<Object, LinkedList<EventProcessingThreadImpl>>(3);
                this._suspended.put(desktop, map);
            }
        }
        map2 = map;
        synchronized (map2) {
            LinkedList<EventProcessingThreadImpl> list = (LinkedList<EventProcessingThreadImpl>)map.get(mutex);
            if (list == null) {
                list = new LinkedList<EventProcessingThreadImpl>();
                map.put(mutex, list);
            }
            list.add(evtthd);
        }
        try {
            try {
                EventProcessingThreadImpl.doSuspend(mutex);
            }
            catch (Throwable ex) {
                IdentityHashMap<Object, LinkedList<EventProcessingThreadImpl>> identityHashMap = map;
                synchronized (identityHashMap) {
                    List list = (List)map.get(mutex);
                    if (list != null) {
                        list.remove(evtthd);
                        if (list.isEmpty()) {
                            map.remove(mutex);
                        }
                    }
                }
                if (ex instanceof InterruptedException) {
                    throw (InterruptedException)ex;
                }
                throw UiException.Aide.wrap(ex, "Unable to suspend " + evtthd);
            }
            Object var12_13 = null;
            this.decSuspended();
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.decSuspended();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incSuspended() {
        int v = this._wapp.getConfiguration().getMaxSuspendedThreads();
        UiEngineImpl uiEngineImpl = this;
        synchronized (uiEngineImpl) {
            if (v >= 0 && this._suspCnt >= v) {
                throw new SuspendNotAllowedException(MZk.TOO_MANY_SUSPENDED);
            }
            ++this._suspCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decSuspended() {
        UiEngineImpl uiEngineImpl = this;
        synchronized (uiEngineImpl) {
            --this._suspCnt;
        }
    }

    public void notify(Object mutex) {
        this.notify(Executions.getCurrent().getDesktop(), mutex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Desktop desktop, Object mutex) {
        EventProcessingThreadImpl evtthd;
        Map map;
        if (desktop == null || mutex == null) {
            throw new IllegalArgumentException("desktop and mutex cannot be null");
        }
        Map map2 = this._suspended;
        synchronized (map2) {
            map = (Map)this._suspended.get(desktop);
        }
        if (map == null) {
            return;
        }
        Map map3 = map;
        synchronized (map3) {
            List list = (List)map.get(mutex);
            if (list == null) {
                return;
            }
            evtthd = (EventProcessingThreadImpl)list.remove(0);
            if (list.isEmpty()) {
                map.remove(mutex);
            }
        }
        this.addResumed(desktop, evtthd);
    }

    public void notifyAll(Object mutex) {
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new UiException("resume can be called only in processing a request");
        }
        this.notifyAll(exec.getDesktop(), mutex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAll(Desktop desktop, Object mutex) {
        List list;
        Map map;
        if (desktop == null || mutex == null) {
            throw new IllegalArgumentException("desktop and mutex cannot be null");
        }
        Map map2 = this._suspended;
        synchronized (map2) {
            map = (Map)this._suspended.get(desktop);
        }
        if (map == null) {
            return;
        }
        Map map3 = map;
        synchronized (map3) {
            list = (List)map.remove(mutex);
            if (list == null) {
                return;
            }
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.addResumed(desktop, (EventProcessingThreadImpl)it.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResumed(Desktop desktop, EventProcessingThreadImpl evtthd) {
        LinkedList<EventProcessingThreadImpl> list;
        Object object = this._resumed;
        synchronized (object) {
            list = (LinkedList<EventProcessingThreadImpl>)this._resumed.get(desktop);
            if (list == null) {
                list = new LinkedList<EventProcessingThreadImpl>();
                this._resumed.put(desktop, list);
            }
        }
        object = list;
        synchronized (object) {
            list.add(evtthd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeAll(Desktop desktop, UiVisualizer uv, List errs) {
        while (true) {
            List list;
            Object object = this._resumed;
            synchronized (object) {
                list = (List)this._resumed.remove(desktop);
                if (list == null) {
                    return;
                }
            }
            object = list;
            synchronized (object) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    EventProcessingThreadImpl evtthd = (EventProcessingThreadImpl)it.next();
                    if (uv.isAborting()) {
                        evtthd.ceaseSilently("Resume aborted");
                        continue;
                    }
                    try {
                        if (!evtthd.doResume()) continue;
                        this.recycleEventThread(evtthd);
                    }
                    catch (Throwable ex) {
                        this.recycleEventThread(evtthd);
                        if (errs == null) {
                            log.error("Unable to resume " + evtthd, ex);
                            throw UiException.Aide.wrap(ex);
                        }
                        UiEngineImpl.handleError(ex, uv, errs);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void processEvent(Desktop desktop, Component comp, Event event) {
        Configuration config = desktop.getWebApp().getConfiguration();
        if (config.isEventThreadEnabled()) {
            EventProcessingThreadImpl evtthd = null;
            List list = this._idles;
            // MONITORENTER : list
            if (!this._idles.isEmpty()) {
                evtthd = (EventProcessingThreadImpl)this._idles.remove(0);
            }
            // MONITOREXIT : list
            if (evtthd == null) {
                evtthd = new EventProcessingThreadImpl();
            }
            try {
                if (!evtthd.processEvent(desktop, comp, event)) return;
                this.recycleEventThread(evtthd);
                return;
            }
            catch (Throwable ex) {
                this.recycleEventThread(evtthd);
                throw UiException.Aide.wrap(ex);
            }
        }
        EventProcessor proc = new EventProcessor(desktop, comp, event);
        List cleanups = null;
        LinkedList<Throwable> errs = null;
        try {
            block15: {
                try {
                    List inits = config.newEventThreadInits(comp, event);
                    EventProcessor.inEventListener(true);
                    if (!config.invokeEventThreadInits(inits, comp, event)) break block15;
                    proc.process();
                }
                catch (Throwable ex) {
                    errs = new LinkedList<Throwable>();
                    errs.add(ex);
                    cleanups = config.newEventThreadCleanups(comp, event, errs);
                    if (!errs.isEmpty()) {
                        throw UiException.Aide.wrap((Throwable)errs.get(0));
                    }
                    Object var10_14 = null;
                    EventProcessor.inEventListener(false);
                    if (errs == null) {
                        cleanups = config.newEventThreadCleanups(comp, event, null);
                    }
                    config.invokeEventThreadCompletes(cleanups, comp, event, errs);
                    return;
                }
            }
            Object var10_13 = null;
            EventProcessor.inEventListener(false);
            if (errs == null) {
                cleanups = config.newEventThreadCleanups(comp, event, null);
            }
            config.invokeEventThreadCompletes(cleanups, comp, event, errs);
            return;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            EventProcessor.inEventListener(false);
            if (errs == null) {
                cleanups = config.newEventThreadCleanups(comp, event, null);
            }
            config.invokeEventThreadCompletes(cleanups, comp, event, errs);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleEventThread(EventProcessingThreadImpl evtthd) {
        if (!evtthd.isCeased()) {
            if (evtthd.isIdle()) {
                int max = this._wapp.getConfiguration().getMaxSpareThreads();
                List list = this._idles;
                synchronized (list) {
                    if (max < 0 || this._idles.size() < max) {
                        this._idles.add(evtthd);
                        return;
                    }
                }
            }
            evtthd.ceaseSilently("Recycled");
        }
    }

    public void activate(Execution exec) {
        if (!$assertionsDisabled && ExecutionsCtrl.getCurrentCtrl() != null) {
            throw new AssertionError((Object)("Impossible to re-activate for update: old=" + ExecutionsCtrl.getCurrentCtrl() + ", new=" + exec));
        }
        UiEngineImpl.doActivate(exec, false, false);
    }

    public void deactivate(Execution exec) {
        UiEngineImpl.doDeactivate(exec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UiVisualizer doActivate(Execution exec, boolean asyncupd, boolean recovering) {
        UiVisualizer uv;
        Map eis;
        if (Executions.getCurrent() != null) {
            throw new IllegalStateException("Use doReactivate instead");
        }
        if (!$assertionsDisabled && recovering && asyncupd) {
            throw new AssertionError();
        }
        Desktop desktop = exec.getDesktop();
        Session sess = desktop.getSession();
        Map map = eis = UiEngineImpl.getVisualizers(sess);
        synchronized (map) {
            UiVisualizer old;
            while ((old = (UiVisualizer)eis.get(desktop)) != null) {
                try {
                    eis.wait(120000L);
                }
                catch (InterruptedException ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
            uv = new UiVisualizer(exec, asyncupd, recovering);
            eis.put(desktop, uv);
            ((DesktopCtrl)((Object)desktop)).setExecution(exec);
        }
        ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)exec);
        execCtrl.setVisualizer(uv);
        ExecutionsCtrl.setCurrent(exec);
        execCtrl.onActivate();
        return uv;
    }

    private static final boolean isRecovering(Desktop desktop) {
        Execution exec = desktop.getExecution();
        return exec != null && ((ExecutionCtrl)((Object)exec)).isRecovering();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doDeactivate(Execution exec) {
        Desktop desktop = exec.getDesktop();
        Session sess = desktop.getSession();
        ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)exec);
        try {
            Map eis;
            Map map = eis = UiEngineImpl.getVisualizers(sess);
            synchronized (map) {
                Object o = eis.remove(desktop);
                if (!$assertionsDisabled && o == null) {
                    throw new AssertionError();
                }
                ((DesktopCtrl)((Object)desktop)).setExecution(null);
                eis.notify();
            }
            Object var9_8 = null;
            execCtrl.onDeactivate();
            execCtrl.setCurrentPage(null);
            execCtrl.setVisualizer(null);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            execCtrl.onDeactivate();
            execCtrl.setCurrentPage(null);
            execCtrl.setVisualizer(null);
            ExecutionsCtrl.setCurrent(null);
            throw throwable;
        }
        ExecutionsCtrl.setCurrent(null);
        SessionCtrl sessCtrl = (SessionCtrl)((Object)sess);
        if (sessCtrl.isInvalidated()) {
            sessCtrl.invalidateNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UiVisualizer doReactivate(Execution curExec, UiVisualizer olduv) {
        Map eis;
        Desktop desktop = curExec.getDesktop();
        Session sess = desktop.getSession();
        if (!$assertionsDisabled && olduv.getExecution().getDesktop() != desktop) {
            throw new AssertionError((Object)("old dt: " + olduv.getExecution().getDesktop() + ", new:" + desktop));
        }
        UiVisualizer uv = new UiVisualizer(olduv, curExec);
        Map map = eis = UiEngineImpl.getVisualizers(sess);
        synchronized (map) {
            UiVisualizer o = eis.put(desktop, uv);
            if (o != olduv) {
                throw new InternalError();
            }
            ((DesktopCtrl)((Object)desktop)).setExecution(curExec);
        }
        ExecutionCtrl curCtrl = (ExecutionCtrl)((Object)curExec);
        curCtrl.setVisualizer(uv);
        ExecutionsCtrl.setCurrent(curExec);
        curCtrl.onActivate();
        return uv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doDereactivate(Execution curExec, UiVisualizer olduv) {
        Map eis;
        if (olduv == null) {
            throw new IllegalArgumentException("null");
        }
        Desktop desktop = curExec.getDesktop();
        Session sess = desktop.getSession();
        ExecutionCtrl curCtrl = (ExecutionCtrl)((Object)curExec);
        curCtrl.onDeactivate();
        curCtrl.setCurrentPage(null);
        curCtrl.setVisualizer(null);
        Execution oldexec = olduv.getExecution();
        Map map = eis = UiEngineImpl.getVisualizers(sess);
        synchronized (map) {
            eis.put(desktop, olduv);
            ((DesktopCtrl)((Object)desktop)).setExecution(oldexec);
        }
        ExecutionsCtrl.setCurrent(oldexec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getVisualizers(Session sess) {
        Session session = sess;
        synchronized (session) {
            String attr = "org.zkoss.zk.ui.Visualizers";
            HashMap eis = (HashMap)sess.getAttribute("org.zkoss.zk.ui.Visualizers");
            if (eis == null) {
                eis = new HashMap();
                sess.setAttribute("org.zkoss.zk.ui.Visualizers", eis);
            }
            return eis;
        }
    }

    private static final void setProlog(CreateInfo ci, Component comp, NativeInfo compInfo) {
        NativeInfo splitInfo;
        Native nc = (Native)((Object)comp);
        Native.Helper helper = nc.getHelper();
        StringBuffer sb = null;
        List prokids = compInfo.getPrologChildren();
        if (!prokids.isEmpty()) {
            sb = new StringBuffer(256);
            UiEngineImpl.getNativeContent(ci, sb, comp, prokids, helper);
        }
        if ((splitInfo = compInfo.getSplitChild()) != null && splitInfo.isEffective(comp)) {
            if (sb == null) {
                sb = new StringBuffer(256);
            }
            UiEngineImpl.getNativeFirstHalf(ci, sb, comp, splitInfo, helper);
        }
        if (sb != null && sb.length() > 0) {
            nc.setPrologContent(sb.insert(0, nc.getPrologContent()).toString());
        }
    }

    private static final void setEpilog(CreateInfo ci, Component comp, NativeInfo compInfo) {
        List epikids;
        Native nc = (Native)((Object)comp);
        Native.Helper helper = nc.getHelper();
        StringBuffer sb = null;
        NativeInfo splitInfo = compInfo.getSplitChild();
        if (splitInfo != null && splitInfo.isEffective(comp)) {
            sb = new StringBuffer(256);
            UiEngineImpl.getNativeSecondHalf(ci, sb, comp, splitInfo, helper);
        }
        if (!(epikids = compInfo.getEpilogChildren()).isEmpty()) {
            if (sb == null) {
                sb = new StringBuffer(256);
            }
            UiEngineImpl.getNativeContent(ci, sb, comp, epikids, helper);
        }
        if (sb != null && sb.length() > 0) {
            nc.setEpilogContent(sb.append(nc.getEpilogContent()).toString());
        }
    }

    public String getNativeContent(Component comp, List children, Native.Helper helper) {
        StringBuffer sb = new StringBuffer(256);
        UiEngineImpl.getNativeContent(new CreateInfo(((WebAppCtrl)((Object)this._wapp)).getUiFactory(), Executions.getCurrent(), comp.getPage()), sb, comp, children, helper);
        return sb.toString();
    }

    private static final void getNativeContent(CreateInfo ci, StringBuffer sb, Component comp, List children, Native.Helper helper) {
        Iterator it = children.iterator();
        while (it.hasNext()) {
            ForEach forEach;
            Object meta = it.next();
            if (meta instanceof NativeInfo) {
                NativeInfo childInfo = (NativeInfo)meta;
                forEach = childInfo.resolveForEach(ci.page, comp);
                if (forEach == null) {
                    if (!childInfo.isEffective(comp)) continue;
                    UiEngineImpl.getNativeFirstHalf(ci, sb, comp, childInfo, helper);
                    UiEngineImpl.getNativeSecondHalf(ci, sb, comp, childInfo, helper);
                    continue;
                }
                while (forEach.next()) {
                    if (!childInfo.isEffective(comp)) continue;
                    UiEngineImpl.getNativeFirstHalf(ci, sb, comp, childInfo, helper);
                    UiEngineImpl.getNativeSecondHalf(ci, sb, comp, childInfo, helper);
                }
                continue;
            }
            if (meta instanceof TextInfo) {
                String s = ((TextInfo)meta).getValue(comp);
                if (s == null) continue;
                helper.appendText(sb, s);
                continue;
            }
            if (meta instanceof ZkInfo) {
                ZkInfo zkInfo = (ZkInfo)meta;
                if (zkInfo.withSwitch()) {
                    throw new UnsupportedOperationException("<zk switch> in native not allowed yet");
                }
                forEach = zkInfo.resolveForEach(ci.page, comp);
                if (forEach == null) {
                    if (!UiEngineImpl.isEffective(zkInfo, ci.page, comp)) continue;
                    UiEngineImpl.getNativeContent(ci, sb, comp, zkInfo.getChildren(), helper);
                    continue;
                }
                while (forEach.next()) {
                    if (!UiEngineImpl.isEffective(zkInfo, ci.page, comp)) continue;
                    UiEngineImpl.getNativeContent(ci, sb, comp, zkInfo.getChildren(), helper);
                }
                continue;
            }
            UiEngineImpl.execNonComponent(ci, comp, meta);
        }
    }

    private static final void getNativeFirstHalf(CreateInfo ci, StringBuffer sb, Component comp, NativeInfo childInfo, Native.Helper helper) {
        NativeInfo splitInfo;
        helper.getFirstHalf(sb, childInfo.getTag(), UiEngineImpl.evalProperties(comp, childInfo.getProperties()), childInfo.getDeclaredNamespaces());
        List prokids = childInfo.getPrologChildren();
        if (!prokids.isEmpty()) {
            UiEngineImpl.getNativeContent(ci, sb, comp, prokids, helper);
        }
        if ((splitInfo = childInfo.getSplitChild()) != null && splitInfo.isEffective(comp)) {
            UiEngineImpl.getNativeFirstHalf(ci, sb, comp, splitInfo, helper);
        }
    }

    private static final void getNativeSecondHalf(CreateInfo ci, StringBuffer sb, Component comp, NativeInfo childInfo, Native.Helper helper) {
        List epikids;
        NativeInfo splitInfo = childInfo.getSplitChild();
        if (splitInfo != null && splitInfo.isEffective(comp)) {
            UiEngineImpl.getNativeSecondHalf(ci, sb, comp, splitInfo, helper);
        }
        if (!(epikids = childInfo.getEpilogChildren()).isEmpty()) {
            UiEngineImpl.getNativeContent(ci, sb, comp, epikids, helper);
        }
        helper.getSecondHalf(sb, childInfo.getTag());
    }

    private static final Map evalProperties(Component comp, List props) {
        if (props == null || props.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(props.size() * 2);
        Iterator it = props.iterator();
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            if (!prop.isEffective(comp)) continue;
            map.put(prop.getName(), Classes.coerce((Class)(class$java$lang$String == null ? UiEngineImpl.class$("java.lang.String") : class$java$lang$String), (Object)prop.getValue(comp)));
        }
        return map;
    }

    private static void meterAuClientComplete(PerformanceMeter pfmeter, Execution exec) {
        String hdr = exec.getHeader("ZK-Client-Receive");
        if (hdr != null) {
            UiEngineImpl.meterAuClient(pfmeter, exec, hdr, false);
        }
        if ((hdr = exec.getHeader("ZK-Client-Complete")) != null) {
            UiEngineImpl.meterAuClient(pfmeter, exec, hdr, true);
        }
    }

    private static void meterAuClient(PerformanceMeter pfmeter, Execution exec, String hdr, boolean complete) {
        int j = 0;
        while (true) {
            int k;
            block9: {
                String ids;
                int x;
                if ((x = (ids = (k = hdr.indexOf(44, j)) >= 0 ? hdr.substring(j, k) : (j == 0 ? hdr : hdr.substring(j))).lastIndexOf(61)) > 0) {
                    try {
                        long time = Long.parseLong(ids.substring(x + 1));
                        ids = ids.substring(0, x);
                        int y = 0;
                        while (true) {
                            String pfReqId;
                            int z;
                            String string = (z = ids.indexOf(32, y)) >= 0 ? ids.substring(y, z) : (pfReqId = y == 0 ? ids : ids.substring(y));
                            if (complete) {
                                pfmeter.requestCompleteAtClient(pfReqId, exec, time);
                            } else {
                                pfmeter.requestReceiveAtClient(pfReqId, exec, time);
                            }
                            if (z >= 0) {
                                y = z + 1;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (NumberFormatException ex) {
                        log.warning("Ingored: unable to parse " + ids);
                    }
                    catch (Throwable ex) {
                        if (!complete && ex instanceof AbstractMethodError) break block9;
                        log.warning("Ingored: failed to invoke " + pfmeter, ex);
                    }
                }
            }
            if (k < 0) break;
            j = k + 1;
        }
    }

    private static String meterAuStart(PerformanceMeter pfmeter, Execution exec, long startTime) {
        int j;
        String hdr = exec.getHeader("ZK-Client-Start");
        if (hdr != null && (j = hdr.lastIndexOf(61)) > 0) {
            String pfReqId = hdr.substring(0, j);
            try {
                pfmeter.requestStartAtClient(pfReqId, exec, Long.parseLong(hdr.substring(j + 1)));
                pfmeter.requestStartAtServer(pfReqId, exec, startTime);
            }
            catch (NumberFormatException ex) {
                log.warning("Ingored: failed to parse ZK-Client-Start, " + hdr);
            }
            catch (Throwable ex) {
                log.warning("Ingored: failed to invoke " + pfmeter, ex);
            }
            return pfReqId;
        }
        return null;
    }

    private static void meterAuServerComplete(PerformanceMeter pfmeter, Collection pfReqIds, Execution exec) {
        StringBuffer sb = new StringBuffer(256);
        long time = System.currentTimeMillis();
        Iterator it = pfReqIds.iterator();
        while (it.hasNext()) {
            String pfReqId = (String)it.next();
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(pfReqId);
            try {
                pfmeter.requestCompleteAtServer(pfReqId, exec, time);
            }
            catch (Throwable ex) {
                log.warning("Ingored: failed to invoke " + pfmeter, ex);
            }
        }
        exec.setResponseHeader("ZK-Client-Complete", sb.toString());
    }

    private static String meterLoadStart(PerformanceMeter pfmeter, Execution exec, long startTime) {
        String pfReqId = exec.getDesktop().getId();
        try {
            pfmeter.requestStartAtServer(pfReqId, exec, startTime);
        }
        catch (Throwable ex) {
            log.warning("Ingored: failed to invoke " + pfmeter, ex);
        }
        return pfReqId;
    }

    private static void meterLoadServerComplete(PerformanceMeter pfmeter, String pfReqId, Execution exec) {
        try {
            pfmeter.requestCompleteAtServer(pfReqId, exec, System.currentTimeMillis());
        }
        catch (Throwable ex) {
            log.warning("Ingored: failed to invoke " + pfmeter, ex);
        }
    }

    static {
        $assertionsDisabled = !UiEngineImpl.class.desiredAssertionStatus();
        log = Log.lookup((Class)UiEngineImpl.class);
    }

    private static class ReplaceableText {
        private String text;

        private ReplaceableText() {
        }
    }

    private static class CreateInfo {
        private final Execution exec;
        private final Page page;
        private final UiFactory uf;

        private CreateInfo(UiFactory uf, Execution exec, Page page) {
            this.exec = exec;
            this.page = page;
            this.uf = uf;
        }
    }

    private static class FulfillListener
    implements EventListener,
    Express,
    Serializable,
    Cloneable,
    ComponentSerializationListener,
    ComponentCloneListener {
        private transient String[] _evtnms;
        private transient Component[] _targets;
        private transient Component _comp;
        private final ComponentInfo _compInfo;
        private final String _fulfill;
        private transient String _uri;

        private FulfillListener(String fulfill, ComponentInfo compInfo, Component comp) {
            this._fulfill = fulfill;
            this._compInfo = compInfo;
            this._comp = comp;
            this.init();
            int j = this._targets.length;
            while (--j >= 0) {
                this._targets[j].addEventListener(this._evtnms[j], this);
            }
        }

        private void init() {
            int k;
            this._uri = null;
            LinkedList<Object[]> results = new LinkedList<Object[]>();
            int j = 0;
            int len = this._fulfill.length();
            do {
                String sub;
                int elcnt = 0;
                for (k = j; k < len; ++k) {
                    char cc = this._fulfill.charAt(k);
                    if (elcnt == 0) {
                        if (cc == ',') break;
                        if (cc != '=') continue;
                        this._uri = this._fulfill.substring(k + 1).trim();
                        break;
                    }
                    if (cc == '{') {
                        ++elcnt;
                        continue;
                    }
                    if (cc != '}' || elcnt <= 0) continue;
                    --elcnt;
                }
                if ((sub = (k >= 0 ? this._fulfill.substring(j, k) : this._fulfill.substring(j)).trim()).length() <= 0) continue;
                results.add(ComponentsCtrl.parseEventExpression(this._comp, sub, this._comp, false));
            } while (this._uri == null && k >= 0 && (j = k + 1) < len);
            j = results.size();
            this._targets = new Component[j];
            this._evtnms = new String[j];
            j = 0;
            Iterator it = results.iterator();
            while (it.hasNext()) {
                Object[] result = (Object[])it.next();
                this._targets[j] = (Component)result[0];
                this._evtnms[j] = (String)result[1];
                ++j;
            }
        }

        public void onEvent(Event evt) throws Exception {
            String uri;
            int j = this._targets.length;
            while (--j >= 0) {
                this._targets[j].removeEventListener(this._evtnms[j], this);
            }
            Execution exec = Executions.getCurrent();
            UiEngineImpl.execCreate0(new CreateInfo(((WebAppCtrl)((Object)exec.getDesktop().getWebApp())).getUiFactory(), exec, this._comp.getPage()), this._compInfo, this._comp);
            if (this._uri != null && (uri = (String)Evaluators.evaluate(this._compInfo.getEvaluator(), this._comp, this._uri, class$java$lang$String == null ? (class$java$lang$String = UiEngineImpl.class$("java.lang.String")) : class$java$lang$String)) != null) {
                exec.createComponents(uri, this._comp, null);
            }
            Events.sendEvent(new FulfillEvent("onFulfill", this._comp, evt));
        }

        public void willSerialize(Component comp) {
        }

        public void didDeserialize(Component comp) {
            this._comp = comp;
            this.init();
        }

        public Object clone(Component comp) {
            FulfillListener clone;
            try {
                clone = (FulfillListener)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
            clone._comp = comp;
            clone.init();
            return clone;
        }
    }
}

