/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.zkoss.idom.Attribute;
import org.zkoss.idom.Document;
import org.zkoss.idom.Element;
import org.zkoss.idom.ProcessingInstruction;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.ClassLocator;
import org.zkoss.util.resource.Locator;
import org.zkoss.web.servlet.JavaScript;
import org.zkoss.web.servlet.StyleSheet;
import org.zkoss.xel.taglib.Taglib;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.DefinitionNotFoundException;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.impl.ComponentDefinitionImpl;
import org.zkoss.zk.ui.sys.ConfigParser;

public class DefinitionLoaders {
    private static final Log log = Log.lookup((Class)DefinitionLoaders.class);
    private static List _addons;
    private static Map _exts;
    private static boolean _loaded;
    private static boolean _loading;

    public static void addAddon(Locator locator, URL url) {
        if (locator == null || url == null) {
            throw new IllegalArgumentException("null");
        }
        if (_loaded) {
            DefinitionLoaders.loadAddon(locator, url);
        } else {
            if (_addons == null) {
                _addons = new LinkedList();
            }
            _addons.add(new Object[]{locator, url});
        }
    }

    public static final void addExtension(String ext, String lang) {
        if (_loaded) {
            LanguageDefinition.addExtension(ext, lang);
        } else {
            if (lang == null || ext == null) {
                throw new IllegalArgumentException("null");
            }
            if (_exts == null) {
                _exts = new HashMap();
            }
            _exts.put(ext, lang);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void load() throws IOException {
        if (!_loaded) {
            Class clazz = DefinitionLoaders.class;
            synchronized (clazz) {
                if (!_loaded && !_loading) {
                    try {
                        _loading = true;
                        DefinitionLoaders.load0();
                        Object var2_1 = null;
                        _loaded = true;
                        _loading = false;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        _loaded = true;
                        _loading = false;
                        throw throwable;
                    }
                }
            }
        }
    }

    private static void load0() throws IOException {
        ClassLocator locator = new ClassLocator();
        ConfigParser parser = new ConfigParser();
        parser.parseConfigXml(null);
        Enumeration en = locator.getResources("metainfo/zk/lang.xml");
        while (en.hasMoreElements()) {
            URL url = (URL)en.nextElement();
            if (log.debugable()) {
                log.debug("Loading " + url);
            }
            try {
                Document doc = new SAXBuilder(true, false, true).build(url);
                if (!ConfigParser.checkVersion(url, doc)) continue;
                DefinitionLoaders.parseLang(doc, (Locator)locator, url, false);
            }
            catch (Exception ex) {
                log.error("Failed to load " + url, (Throwable)ex);
                throw UiException.Aide.wrap((Throwable)ex, "Failed to load " + url);
            }
        }
        List xmls = locator.getDependentXMLResources("metainfo/zk/lang-addon.xml", "addon-name", "depends");
        Iterator<Object> it = xmls.iterator();
        while (it.hasNext()) {
            ClassLocator.Resource res = (ClassLocator.Resource)it.next();
            try {
                if (!ConfigParser.checkVersion(res.url, res.document)) continue;
                DefinitionLoaders.parseLang(res.document, (Locator)locator, res.url, true);
            }
            catch (Exception ex) {
                log.realCauseBriefly("Failed to load " + res.url, (Throwable)ex);
            }
        }
        if (_addons != null) {
            it = _addons.iterator();
            while (it.hasNext()) {
                Object[] p = (Object[])it.next();
                DefinitionLoaders.loadAddon((Locator)p[0], (URL)p[1]);
            }
            _addons = null;
        }
        if (_exts != null) {
            it = _exts.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = (Map.Entry)it.next();
                String ext = (String)me.getKey();
                String lang = (String)me.getValue();
                try {
                    LanguageDefinition.addExtension(ext, lang);
                }
                catch (DefinitionNotFoundException ex) {
                    log.warning("Extension " + ext + " ignored since language " + lang + " not found");
                }
            }
            _exts = null;
        }
    }

    private static void loadAddon(Locator locator, URL url) {
        try {
            DefinitionLoaders.parseLang(new SAXBuilder(true, false, true).build(url), locator, url, true);
        }
        catch (Exception ex) {
            log.error("Failed to load addon: " + url, (Throwable)ex);
        }
    }

    private static void parseLang(Document doc, Locator locator, URL url, boolean addon) throws Exception {
        String ctn;
        String val;
        String nm;
        Element el;
        LanguageDefinition langdef;
        Element root = doc.getRootElement();
        String lang = IDOMs.getRequiredElementValue((Element)root, (String)"language-name");
        if (addon) {
            if (log.debugable()) {
                log.debug("Addon language to " + lang + " from " + root.getElementValue("addon-name", true));
            }
            langdef = LanguageDefinition.lookup(lang);
            if (root.getElement("case-insensitive") != null) {
                throw new UiException("case-insensitive not allowed in addon");
            }
        } else {
            String ns = IDOMs.getRequiredElementValue((Element)root, (String)"namespace");
            String deviceType = IDOMs.getRequiredElementValue((Element)root, (String)"device-type");
            Map pagemolds = DefinitionLoaders.parseSimpleMolds(root);
            String desktopURI = (String)pagemolds.get("desktop");
            String pageURI = (String)pagemolds.get("page");
            if (desktopURI == null || desktopURI.length() == 0 || pageURI == null || pageURI.length() == 0) {
                throw new UiException("Both desktop and page molds must be specified, " + root.getLocator());
            }
            if (desktopURI.startsWith("class:") || pageURI.startsWith("class:")) {
                throw new UiException("Both desktop and page molds don't support 'class:', " + root.getLocator());
            }
            String completeURI = (String)pagemolds.get("complete");
            if (completeURI == null) {
                completeURI = desktopURI;
            } else if (completeURI.length() == 0) {
                throw new UiException("Empty complete mold not allowed");
            }
            List exts = DefinitionLoaders.parseExtensions(root);
            if (exts.isEmpty()) {
                throw new UiException("The extension must be specified for " + lang);
            }
            String ignoreCase = root.getElementValue("case-insensitive", true);
            String bNative = root.getElementValue("native-namespace", true);
            langdef = new LanguageDefinition(deviceType, lang, ns, exts, completeURI, desktopURI, pageURI, "true".equals(ignoreCase), "true".equals(bNative), locator);
        }
        DefinitionLoaders.parsePI(langdef, doc);
        DefinitionLoaders.parseLabelTemplate(langdef, root);
        DefinitionLoaders.parseDynamicTag(langdef, root);
        DefinitionLoaders.parseMacroTemplate(langdef, root);
        DefinitionLoaders.parseNativeTemplate(langdef, root);
        Iterator it = root.getElements("library-property").iterator();
        while (it.hasNext()) {
            el = (Element)it.next();
            nm = IDOMs.getRequiredElementValue((Element)el, (String)"name");
            val = IDOMs.getRequiredElementValue((Element)el, (String)"value");
            Library.setProperty((String)nm, (String)val);
        }
        it = root.getElements("system-property").iterator();
        while (it.hasNext()) {
            el = (Element)it.next();
            nm = IDOMs.getRequiredElementValue((Element)el, (String)"name");
            val = IDOMs.getRequiredElementValue((Element)el, (String)"value");
            System.setProperty(nm, val);
        }
        it = root.getElements("javascript").iterator();
        while (it.hasNext()) {
            JavaScript js;
            el = (Element)it.next();
            String src = el.getAttributeValue("src");
            ctn = el.getText(true);
            if (src != null && src.length() > 0) {
                if (ctn != null && ctn.length() > 0) {
                    throw new UiException("You cannot specify the content if the src attribute is specified, " + el.getLocator());
                }
                String charset = el.getAttributeValue("charset");
                js = new JavaScript(src, charset);
            } else if (ctn != null && ctn.length() > 0) {
                js = new JavaScript(ctn);
            } else {
                throw new UiException("You must specify either the src attribute or the content, " + el.getLocator());
            }
            langdef.addJavaScript(js);
        }
        it = root.getElements("javascript-module").iterator();
        while (it.hasNext()) {
            el = (Element)it.next();
            langdef.addJavaScriptModule(IDOMs.getRequiredAttributeValue((Element)el, (String)"name"), IDOMs.getRequiredAttributeValue((Element)el, (String)"version"));
        }
        it = root.getElements("stylesheet").iterator();
        while (it.hasNext()) {
            StyleSheet ss;
            el = (Element)it.next();
            String href = el.getAttributeValue("href");
            ctn = el.getText(true);
            if (href != null && href.length() > 0) {
                if (ctn != null && ctn.length() > 0) {
                    throw new UiException("You cannot specify the content if the href attribute is specified, " + el.getLocator());
                }
                ss = new StyleSheet(href, el.getAttributeValue("type"));
            } else if (ctn != null && ctn.length() > 0) {
                ss = new StyleSheet(ctn, el.getAttributeValue("type"), true);
            } else {
                throw new UiException("You must specify either the href attribute or the content, " + el.getLocator());
            }
            langdef.addStyleSheet(ss);
        }
        it = root.getElements("zscript").iterator();
        while (it.hasNext()) {
            String zslang;
            el = (Element)it.next();
            Attribute attr = el.getAttributeItem("language");
            if (attr == null) {
                zslang = "Java";
            } else {
                zslang = attr.getValue();
                if (zslang == null || zslang.length() == 0) {
                    throw new UiException("The language attribute cannot be empty, " + attr.getLocator());
                }
            }
            String s = el.getText(true);
            String eachTime = el.getAttributeValue("each-time");
            if ("true".equals(eachTime)) {
                langdef.addEachTimeScript(zslang, s);
                continue;
            }
            langdef.addInitScript(zslang, s);
        }
        it = root.getElements("component").iterator();
        while (it.hasNext()) {
            Map.Entry me;
            ComponentDefinitionImpl compdef;
            String macroURI;
            el = (Element)it.next();
            String name = IDOMs.getRequiredElementValue((Element)el, (String)"component-name");
            String clsnm = el.getElementValue("component-class", true);
            Class cls = null;
            if (clsnm != null) {
                if (clsnm.length() > 0) {
                    DefinitionLoaders.noEL("component-class", clsnm, el);
                    try {
                        cls = DefinitionLoaders.locateClass(clsnm);
                    }
                    catch (Throwable ex) {
                        log.warning("Component " + name + " ignored. Reason: unable to load " + clsnm + " due to " + ex.getClass().getName() + ": " + ex.getMessage() + (ex instanceof NoClassDefFoundError ? "" : "\n" + el.getLocator()));
                        log.debug(ex);
                    }
                } else {
                    clsnm = null;
                }
            }
            if ((macroURI = el.getElementValue("macro-uri", true)) != null && macroURI.length() != 0) {
                if (log.finerable()) {
                    log.finer("macro component definition: " + name);
                }
                String inline = el.getElementValue("inline", true);
                compdef = (ComponentDefinitionImpl)langdef.getMacroDefinition(name, macroURI, "true".equals(inline), null);
                if (cls != null) {
                    compdef.setImplementationClass(cls);
                } else if (clsnm != null) {
                    compdef.setImplementationClass(clsnm);
                }
                compdef.setDeclarationURL(url);
                langdef.addComponentDefinition(compdef);
            } else if (el.getElement("extends") != null) {
                String extnm;
                ComponentDefinition ref;
                if (log.finerable()) {
                    log.finer("Override component definition: " + name);
                }
                if ((ref = langdef.getComponentDefinitionIfAny(extnm = el.getElementValue("extends", true))) == null) {
                    log.warning("Component " + name + " ignored. Reason: override a non-existent component " + extnm + ".\n" + el.getLocator());
                    continue;
                }
                if (ref.isMacro()) {
                    throw new UiException("Unable to extend from a macro component, " + el.getLocator());
                }
                if (extnm.equals(name)) {
                    compdef = (ComponentDefinitionImpl)ref;
                } else {
                    compdef = (ComponentDefinitionImpl)ref.clone(ref.getLanguageDefinition(), name);
                    compdef.setDeclarationURL(url);
                    langdef.addComponentDefinition(compdef);
                }
                if (cls != null) {
                    compdef.setImplementationClass(cls);
                } else if (clsnm != null) {
                    compdef.setImplementationClass(clsnm);
                }
            } else {
                if (log.finerable()) {
                    log.finer("Add component definition: name=" + name);
                }
                if (cls == null && clsnm == null) {
                    throw new UiException("component-class is required, " + el.getLocator());
                }
                compdef = cls != null ? new ComponentDefinitionImpl(langdef, null, name, cls) : new ComponentDefinitionImpl(langdef, null, name, clsnm);
                compdef.setDeclarationURL(url);
                langdef.addComponentDefinition(compdef);
            }
            String s = el.getElementValue("text-as", true);
            if (s != null) {
                DefinitionLoaders.noEL("text-as", s, el);
                compdef.setTextAs(s);
            }
            if ((s = el.getElementValue("preserve-blank", true)) != null && !"false".equals(s)) {
                compdef.setBlankPreserved(true);
            }
            compdef.setApply(el.getElementValue("apply", true));
            Iterator i = el.getElements("mold").iterator();
            while (i.hasNext()) {
                Element e = (Element)i.next();
                String nm2 = IDOMs.getRequiredElementValue((Element)e, (String)"mold-name");
                String val2 = IDOMs.getRequiredElementValue((Element)e, (String)"mold-uri");
                String z2c = e.getElementValue("z2c-uri", true);
                compdef.addMold(nm2, val2, z2c != null && z2c.length() > 0 ? z2c : null);
            }
            Iterator e = DefinitionLoaders.parseCustAttrs(el).entrySet().iterator();
            while (e.hasNext()) {
                me = e.next();
                compdef.addCustomAttribute((String)me.getKey(), (String)me.getValue());
            }
            e = DefinitionLoaders.parseProps(el).entrySet().iterator();
            while (e.hasNext()) {
                me = e.next();
                compdef.addProperty((String)me.getKey(), (String)me.getValue());
            }
            DefinitionLoaders.parseAnnots(compdef, el);
        }
    }

    private static Class locateClass(String clsnm) throws Exception {
        return Classes.forNameByThread((String)clsnm);
    }

    private static void noEL(String nm, String val, Element el) throws UiException {
        if (val != null && val.indexOf("${") >= 0) {
            throw new UiException(nm + " does not support EL expressions, " + el.getLocator());
        }
    }

    private static void parsePI(LanguageDefinition langdef, Document doc) throws Exception {
        Iterator it = doc.getChildren().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof ProcessingInstruction)) continue;
            ProcessingInstruction pi = (ProcessingInstruction)o;
            String target = pi.getTarget();
            Map params = pi.parseData();
            if ("taglib".equals(target)) {
                String uri = (String)params.remove("uri");
                String prefix = (String)params.remove("prefix");
                if (!params.isEmpty()) {
                    log.warning("Ignored unknown attribute: " + params + ", " + pi.getLocator());
                }
                if (uri == null || prefix == null) {
                    throw new UiException("Both uri and prefix attribute are required, " + pi.getLocator());
                }
                if (log.debugable()) {
                    log.debug("taglib: prefix=" + prefix + " uri=" + uri);
                }
                langdef.addTaglib(new Taglib(prefix, uri));
                continue;
            }
            log.warning("Unknown processing instruction: " + target);
        }
    }

    private static void parseLabelTemplate(LanguageDefinition langdef, Element el) {
        if ((el = el.getElement("label-template")) != null) {
            Element raw = el.getElement("raw");
            langdef.setLabelTemplate(IDOMs.getRequiredElementValue((Element)el, (String)"component-name"), IDOMs.getRequiredElementValue((Element)el, (String)"component-attribute"), raw != null && !"false".equals(raw.getText(true)));
        }
    }

    private static void parseMacroTemplate(LanguageDefinition langdef, Element el) throws Exception {
        if ((el = el.getElement("macro-template")) != null) {
            langdef.setMacroTemplate(DefinitionLoaders.locateClass(IDOMs.getRequiredElementValue((Element)el, (String)"macro-class")), IDOMs.getRequiredElementValue((Element)el, (String)"macro-uri"));
        }
    }

    private static void parseNativeTemplate(LanguageDefinition langdef, Element el) throws Exception {
        if ((el = el.getElement("native-template")) != null) {
            langdef.setNativeTemplate(DefinitionLoaders.locateClass(IDOMs.getRequiredElementValue((Element)el, (String)"native-class")));
        }
    }

    private static void parseDynamicTag(LanguageDefinition langdef, Element el) throws ClassNotFoundException {
        if ((el = el.getElement("dynamic-tag")) != null) {
            String compnm = IDOMs.getRequiredElementValue((Element)el, (String)"component-name");
            HashSet<String> reservedAttrs = new HashSet<String>(8);
            Iterator it = el.getElements("reserved-attribute").iterator();
            while (it.hasNext()) {
                reservedAttrs.add(((Element)it.next()).getText(true));
            }
            langdef.setDynamicTagInfo(compnm, reservedAttrs);
        }
    }

    private static List parseExtensions(Element elm) {
        LinkedList<String> exts = new LinkedList<String>();
        Iterator it = elm.getElements("extension").iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            String ext = el.getText(true);
            if (ext.length() == 0) continue;
            int len = ext.length();
            for (int j = 0; j < len; ++j) {
                char cc = ext.charAt(j);
                if (cc >= 'a' && cc <= 'z' || cc >= 'A' && cc <= 'Z' || cc >= '0' && cc <= '9') continue;
                throw new UiException("Invalid extension; only letters and numbers are allowed: " + ext);
            }
            exts.add(ext);
        }
        return exts;
    }

    private static Map parseProps(Element elm) {
        return IDOMs.parseParams((Element)elm, (String)"property", (String)"property-name", (String)"property-value");
    }

    private static Map parseSimpleMolds(Element elm) {
        return IDOMs.parseParams((Element)elm, (String)"mold", (String)"mold-name", (String)"mold-uri");
    }

    private static Map parseCustAttrs(Element elm) {
        return IDOMs.parseParams((Element)elm, (String)"custom-attribute", (String)"attribute-name", (String)"attribute-value");
    }

    private static Map parseAttrs(Element elm) {
        return IDOMs.parseParams((Element)elm, (String)"attribute", (String)"attribute-name", (String)"attribute-value");
    }

    private static void parseAnnots(ComponentDefinitionImpl compdef, Element top) {
        Iterator it = top.getElements("annotation").iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            String annotName = IDOMs.getRequiredElementValue((Element)el, (String)"annotation-name");
            Map annotAttrs = DefinitionLoaders.parseAttrs(el);
            String prop = el.getElementValue("property-name", true);
            if (prop == null || prop.length() == 0) {
                compdef.addAnnotation(annotName, annotAttrs);
                continue;
            }
            compdef.addAnnotation(prop, annotName, annotAttrs);
        }
    }

    private static Integer parseInteger(Element el, String subnm, boolean positiveOnly) throws UiException {
        String val = el.getElementValue(subnm, true);
        if (val != null && val.length() > 0) {
            try {
                int v = Integer.parseInt(val);
                if (!positiveOnly || v > 0) {
                    return new Integer(v);
                }
                log.warning("Ignored: the " + subnm + " element must be a positive number, not " + val + ", at " + el.getLocator());
            }
            catch (NumberFormatException ex) {
                log.warning("Ignored: the " + subnm + " element must be a number, not " + val + ", at " + el.getLocator());
            }
        }
        return null;
    }

    private static class Addon {
        private final Document document;
        private final int priority;

        private Addon(Document document) {
            this.document = document;
            String p = document.getRootElement().getElementValue("priority", true);
            this.priority = p != null && p.length() > 0 ? Integer.parseInt(p) : 0;
        }

        private static void add(List addons, Document document) {
            Addon addon = new Addon(document);
            ListIterator<Addon> it = addons.listIterator();
            while (it.hasNext()) {
                Addon a = (Addon)it.next();
                if (a.priority >= addon.priority) continue;
                it.previous();
                it.add(addon);
                return;
            }
            addons.add(addon);
        }
    }
}

