/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.util.Collection;
import java.util.Iterator;
import org.zkoss.lang.Classes;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.ExValue;

public class FunctionMapperInfo {
    private final Object _mapper;
    private final ExValue[] _args;
    static /* synthetic */ Class class$java$lang$Object;

    public FunctionMapperInfo(Class cls, Collection args) {
        FunctionMapperInfo.checkClass(cls);
        this._mapper = cls;
        this._args = FunctionMapperInfo.toExValues(args);
    }

    public FunctionMapperInfo(Class cls) {
        this(cls, null);
    }

    private static void checkClass(Class cls) {
        if (!FunctionMapper.class.isAssignableFrom(cls)) {
            throw new UiException(FunctionMapper.class + " must be implemented: " + cls);
        }
    }

    public FunctionMapperInfo(String clsnm, Collection args) throws ClassNotFoundException {
        if (clsnm == null || clsnm.length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        if (clsnm.indexOf("${") < 0) {
            try {
                Class cls = Classes.forNameByThread((String)clsnm);
                FunctionMapperInfo.checkClass(cls);
                this._mapper = cls;
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException("Class not found: " + clsnm, ex);
            }
        } else {
            this._mapper = new ExValue(clsnm, String.class);
        }
        this._args = FunctionMapperInfo.toExValues(args);
    }

    public FunctionMapperInfo(String clsnm) throws ClassNotFoundException {
        this(clsnm, null);
    }

    public FunctionMapperInfo(FunctionMapper mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("null");
        }
        this._mapper = mapper;
        this._args = new ExValue[0];
    }

    private static ExValue[] toExValues(Collection args) {
        if (args == null || args.isEmpty()) {
            return new ExValue[0];
        }
        ExValue[] evals = new ExValue[args.size()];
        int j = 0;
        Iterator it = args.iterator();
        while (it.hasNext()) {
            evals[j++] = new ExValue((String)it.next(), class$java$lang$Object == null ? FunctionMapperInfo.class$("java.lang.Object") : class$java$lang$Object);
        }
        return evals;
    }

    public FunctionMapper newFunctionMapper(PageDefinition pgdef, Page page) throws Exception {
        Class cls;
        if (this._mapper instanceof FunctionMapper) {
            return (FunctionMapper)this._mapper;
        }
        if (this._mapper instanceof ExValue) {
            String clsnm = (String)((ExValue)this._mapper).getValue(pgdef.getEvaluator(), page);
            if (clsnm == null || clsnm.length() == 0) {
                return null;
            }
            try {
                cls = Classes.forNameByThread((String)clsnm);
                FunctionMapperInfo.checkClass(cls);
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException("Class not found: " + clsnm + " (" + this._mapper + ")", ex);
            }
        } else {
            cls = (Class)this._mapper;
        }
        return (FunctionMapper)(this._args.length == 0 ? cls.newInstance() : Classes.newInstance((Class)cls, (Object[])this.resolveArguments(pgdef, page)));
    }

    private Object[] resolveArguments(PageDefinition pgdef, Page page) {
        Evaluator eval = pgdef.getEvaluator();
        Object[] args = new Object[this._args.length];
        for (int j = 0; j < args.length; ++j) {
            args[j] = this._args[j].getValue(eval, page);
        }
        return args;
    }

    public String toString() {
        return "[function-mapper " + this._mapper + "]";
    }
}

