/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.DynamicPropertied;
import org.zkoss.zk.ui.ext.Native;
import org.zkoss.zk.ui.metainfo.EvalRefStub;
import org.zkoss.zk.ui.metainfo.NativeInfo;
import org.zkoss.zk.ui.metainfo.PropertyNotFoundException;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Condition;
import org.zkoss.zk.ui.util.ConditionImpl;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.ExValue;
import org.zkoss.zk.xel.impl.EvaluatorRef;

public class Property
extends EvalRefStub
implements Condition,
Serializable {
    private static final Log log = Log.lookup((Class)Property.class);
    private static final long serialVersionUID = 20060622L;
    private final String _name;
    private final ExValue _value;
    private final NativeInfo _navval;
    private final ConditionImpl _cond;
    private transient Class _lastcls;
    private transient Method _mtd;
    private transient Method[] _mtds;

    public Property(EvaluatorRef evalr, String name, String value, ConditionImpl cond) {
        this(evalr, name, value, null, cond);
    }

    public Property(EvaluatorRef evalr, String name, NativeInfo value, ConditionImpl cond) {
        this(evalr, name, null, value, cond);
    }

    private Property(EvaluatorRef evalr, String name, String value, NativeInfo navval, ConditionImpl cond) {
        if (name == null || evalr == null) {
            throw new IllegalArgumentException();
        }
        this._evalr = evalr;
        this._name = name;
        this._cond = cond;
        this._navval = navval;
        this._value = navval != null ? null : new ExValue(value, Object.class);
    }

    public String getName() {
        return this._name;
    }

    public String getRawValue() {
        if (this._value == null) {
            throw new UnsupportedOperationException("native content");
        }
        return this._value.getRawValue();
    }

    public void setRawValue(String value) {
        if (this._value == null) {
            throw new UnsupportedOperationException("native content");
        }
        this._value.setRawValue(value);
    }

    public Object getValue(Component comp) {
        Page page;
        if (this._value != null) {
            return this._value.getValue((Evaluator)this._evalr, comp);
        }
        Desktop desktop = comp.getDesktop();
        if (desktop == null) {
            Execution exec = Executions.getCurrent();
            if (exec == null) {
                throw new IllegalStateException("Not attached, nor execution");
            }
            desktop = exec.getDesktop();
            page = ((ExecutionCtrl)((Object)exec)).getCurrentPage();
        } else {
            page = comp.getPage();
        }
        return ((WebAppCtrl)((Object)desktop.getWebApp())).getUiEngine().getNativeContent(comp, this._navval.getChildren(), ((Native)((Object)this._navval.newInstance(page, comp))).getHelper());
    }

    public Object getValue(Page page) {
        if (this._value == null) {
            throw new UnsupportedOperationException("native content");
        }
        return this._value.getValue((Evaluator)this._evalr, page);
    }

    public void assign(Component comp) {
        if (this.isEffective(comp)) {
            try {
                this.assign0(comp);
            }
            catch (Exception ex) {
                log.error("Failed to assign " + this + " to " + comp + "\n" + Exceptions.getMessage((Throwable)ex));
                throw UiException.Aide.wrap(ex);
            }
        }
    }

    private Object[] resolve(Class cls) {
        Method mtd = null;
        Method[] mtds = null;
        String mtdnm = Classes.toMethodName((String)this._name, (String)"set");
        if (this._value != null && this._value.isExpression()) {
            mtds = Classes.getCloseMethods((Class)cls, (String)mtdnm, (Class[])new Class[]{null});
            if (mtds.length == 0) {
                if (!DynamicPropertied.class.isAssignableFrom(cls)) {
                    throw new PropertyNotFoundException("Method " + mtdnm + " not found for " + cls);
                }
                mtds = null;
            } else if (mtds.length == 1) {
                mtd = mtds[0];
                mtds = null;
            }
        } else {
            mtd = Property.resolveMethod0(cls, mtdnm);
        }
        return new Object[]{mtd, mtds};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assign0(Component comp) throws Exception {
        Method m;
        Class type;
        Method[] mtds;
        Method mtd;
        Class<?> cls = comp.getClass();
        if (this._lastcls == null) {
            Property property = this;
            synchronized (property) {
                if (this._lastcls == null) {
                    Object[] mi = this.resolve(cls);
                    this._mtd = (Method)mi[0];
                    this._mtds = (Method[])mi[1];
                    this._lastcls = cls;
                }
            }
        }
        if (this._lastcls == cls) {
            mtd = this._mtd;
            mtds = this._mtds;
        } else {
            Object[] mi = this.resolve(cls);
            mtd = (Method)mi[0];
            mtds = (Method[])mi[1];
        }
        Class clazz = mtd != null ? mtd.getParameterTypes()[0] : (type = Object.class);
        if (this._value != null) {
            this._value.setExpectedType(type);
        }
        Object val = this.getValue(comp);
        if (mtd != null) {
            m = mtd;
        } else {
            if (mtds == null) {
                ((DynamicPropertied)((Object)comp)).setDynamicProperty(this._name, val);
                return;
            }
            if (val == null) {
                m = mtds[0];
                val = Classes.coerce(m.getParameterTypes()[0], (Object)val);
            } else {
                int j = 0;
                while (true) {
                    if (j == mtds.length) {
                        m = mtds[0];
                        val = Classes.coerce(m.getParameterTypes()[0], (Object)val);
                        break;
                    }
                    if (mtds[j].getParameterTypes()[0].isInstance(val)) {
                        m = mtds[j];
                        break;
                    }
                    ++j;
                }
            }
        }
        m.invoke((Object)comp, val);
    }

    public boolean isEffective(Component comp) {
        return this._cond == null || this._cond.isEffective((Evaluator)this._evalr, comp);
    }

    public boolean isEffective(Page page) {
        return this._cond == null || this._cond.isEffective((Evaluator)this._evalr, page);
    }

    public String toString() {
        return "[" + this._name + (this._navval != null ? "" : "=" + this._value) + ']';
    }

    public static final Method resolveMethod(Class cls, String name) throws PropertyNotFoundException {
        return Property.resolveMethod0(cls, Classes.toMethodName((String)name, (String)"set"));
    }

    private static final Method resolveMethod0(Class cls, String mtdnm) throws PropertyNotFoundException {
        try {
            return Classes.getCloseMethod((Class)cls, (String)mtdnm, (Class[])new Class[]{String.class});
        }
        catch (NoSuchMethodException ex) {
            try {
                return Classes.getCloseMethod((Class)cls, (String)mtdnm, (Class[])new Class[]{null});
            }
            catch (NoSuchMethodException e2) {
                if (!DynamicPropertied.class.isAssignableFrom(cls)) {
                    throw new PropertyNotFoundException("Method, " + mtdnm + ", not found for " + cls);
                }
                return null;
            }
        }
    }

    public static final void assign(Component comp, String name, String value) {
        Method mtd = Property.resolveMethod(comp.getClass(), name);
        if (mtd != null) {
            try {
                Object val = Classes.coerce(mtd.getParameterTypes()[0], (Object)value);
                mtd.invoke((Object)comp, val);
            }
            catch (Exception ex) {
                log.error("Failed to assign " + value + " to " + comp + "\n" + Exceptions.getMessage((Throwable)ex));
                throw UiException.Aide.wrap(ex);
            }
        } else {
            ((DynamicPropertied)((Object)comp)).setDynamicProperty(name, value);
        }
    }
}

