/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.util.Collection;
import java.util.Iterator;
import org.zkoss.lang.Classes;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.ExValue;

public class VariableResolverInfo {
    private final Object _resolver;
    private final ExValue[] _args;
    static /* synthetic */ Class class$java$lang$Object;

    public VariableResolverInfo(Class cls, Collection args) {
        VariableResolverInfo.checkClass(cls);
        this._resolver = cls;
        this._args = VariableResolverInfo.toExValues(args);
    }

    public VariableResolverInfo(Class cls) {
        this(cls, null);
    }

    private static void checkClass(Class cls) {
        if (!VariableResolver.class.isAssignableFrom(cls)) {
            throw new UiException(VariableResolver.class + " must be implemented: " + cls);
        }
    }

    public VariableResolverInfo(String clsnm, Collection args) throws ClassNotFoundException {
        if (clsnm == null || clsnm.length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        if (clsnm.indexOf("${") < 0) {
            try {
                Class cls = Classes.forNameByThread((String)clsnm);
                VariableResolverInfo.checkClass(cls);
                this._resolver = cls;
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException("Class not found: " + clsnm, ex);
            }
        } else {
            this._resolver = new ExValue(clsnm, String.class);
        }
        this._args = VariableResolverInfo.toExValues(args);
    }

    public VariableResolverInfo(String clsnm) throws ClassNotFoundException {
        this(clsnm, null);
    }

    public VariableResolverInfo(VariableResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException("null");
        }
        this._resolver = resolver;
        this._args = new ExValue[0];
    }

    private static ExValue[] toExValues(Collection args) {
        if (args == null || args.isEmpty()) {
            return new ExValue[0];
        }
        ExValue[] evals = new ExValue[args.size()];
        int j = 0;
        Iterator it = args.iterator();
        while (it.hasNext()) {
            evals[j++] = new ExValue((String)it.next(), class$java$lang$Object == null ? VariableResolverInfo.class$("java.lang.Object") : class$java$lang$Object);
        }
        return evals;
    }

    public VariableResolver newVariableResolver(PageDefinition pgdef, Page page) throws Exception {
        Class cls;
        if (this._resolver instanceof VariableResolver) {
            return (VariableResolver)this._resolver;
        }
        if (this._resolver instanceof ExValue) {
            String clsnm = (String)((ExValue)this._resolver).getValue(pgdef.getEvaluator(), page);
            if (clsnm == null || clsnm.length() == 0) {
                return null;
            }
            try {
                cls = Classes.forNameByThread((String)clsnm);
                VariableResolverInfo.checkClass(cls);
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException("Class not found: " + clsnm + " (" + this._resolver + ")", ex);
            }
        } else {
            cls = (Class)this._resolver;
        }
        return (VariableResolver)(this._args.length == 0 ? cls.newInstance() : Classes.newInstance((Class)cls, (Object[])this.resolveArguments(pgdef, page)));
    }

    private Object[] resolveArguments(PageDefinition pgdef, Page page) {
        Evaluator eval = pgdef.getEvaluator();
        Object[] args = new Object[this._args.length];
        for (int j = 0; j < args.length; ++j) {
            args[j] = this._args[j].getValue(eval, page);
        }
        return args;
    }

    public String toString() {
        return "[variable-resolver " + this._resolver + "]";
    }
}

