/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.PotentialDeadLockException;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.util.FastReadArray;
import org.zkoss.util.WaitLock;
import org.zkoss.util.logging.Log;
import org.zkoss.xel.Expressions;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventThreadCleanup;
import org.zkoss.zk.ui.event.EventThreadInit;
import org.zkoss.zk.ui.event.EventThreadResume;
import org.zkoss.zk.ui.event.EventThreadSuspend;
import org.zkoss.zk.ui.impl.EventInterceptors;
import org.zkoss.zk.ui.impl.RichletConfigImpl;
import org.zkoss.zk.ui.sys.DesktopCacheProvider;
import org.zkoss.zk.ui.sys.FailoverManager;
import org.zkoss.zk.ui.sys.IdGenerator;
import org.zkoss.zk.ui.sys.SessionCache;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.CharsetFinder;
import org.zkoss.zk.ui.util.DesktopCleanup;
import org.zkoss.zk.ui.util.DesktopInit;
import org.zkoss.zk.ui.util.EventInterceptor;
import org.zkoss.zk.ui.util.ExecutionCleanup;
import org.zkoss.zk.ui.util.ExecutionInit;
import org.zkoss.zk.ui.util.Monitor;
import org.zkoss.zk.ui.util.PerformanceMeter;
import org.zkoss.zk.ui.util.RequestInterceptor;
import org.zkoss.zk.ui.util.SessionCleanup;
import org.zkoss.zk.ui.util.SessionInit;
import org.zkoss.zk.ui.util.ThemeProvider;
import org.zkoss.zk.ui.util.URIInterceptor;
import org.zkoss.zk.ui.util.UiLifeCycle;
import org.zkoss.zk.ui.util.WebAppCleanup;
import org.zkoss.zk.ui.util.WebAppInit;

public class Configuration {
    private static final Log log = Log.lookup((Class)Configuration.class);
    private static final String PROP_EXPRESS_FACTORY = "org.zkoss.xel.ExpressionFactory.class";
    private WebApp _wapp;
    private final FastReadArray _evtInits = new FastReadArray(Class.class);
    private final FastReadArray _evtCleans = new FastReadArray(Class.class);
    private final FastReadArray _evtSusps = new FastReadArray(Class.class);
    private final FastReadArray _evtResus = new FastReadArray(Class.class);
    private final FastReadArray _appInits = new FastReadArray(Class.class);
    private final FastReadArray _appCleans = new FastReadArray(Class.class);
    private final FastReadArray _sessInits = new FastReadArray(Class.class);
    private final FastReadArray _sessCleans = new FastReadArray(Class.class);
    private final FastReadArray _dtInits = new FastReadArray(Class.class);
    private final FastReadArray _dtCleans = new FastReadArray(Class.class);
    private final FastReadArray _execInits = new FastReadArray(Class.class);
    private final FastReadArray _execCleans = new FastReadArray(Class.class);
    private FastReadArray _uiCycles = new FastReadArray(UiLifeCycle.class);
    private final FastReadArray _uriIntcps = new FastReadArray(URIInterceptor.class);
    private final FastReadArray _reqIntcps = new FastReadArray(RequestInterceptor.class);
    private final Map _prefs = Collections.synchronizedMap(new HashMap());
    private final Map _errURIs = Collections.synchronizedMap(new HashMap());
    private final Map _richlets = new HashMap();
    private final Map _richletmaps = new HashMap();
    private final Map _errpgs = new HashMap(3);
    private Monitor _monitor;
    private PerformanceMeter _pfmeter;
    private final FastReadArray _themeURIs = new FastReadArray(String.class);
    private ThemeProvider _themeProvider;
    private Set _disThemeURIs;
    private Class _wappcls;
    private Class _uiengcls;
    private Class _dcpcls;
    private Class _uiftycls;
    private Class _failmancls;
    private Class _idgencls;
    private Class _sesscachecls;
    private int _dtTimeout = 3600;
    private int _sessDktMax = 15;
    private int _sessReqMax = 5;
    private int _sessTimeout = 0;
    private int _sparThdMax = 100;
    private int _suspThdMax = -1;
    private int _maxUploadSize = 5120;
    private int _maxProcTime = 3000;
    private int _promptDelay = 900;
    private int _tooltipDelay = 800;
    private int _resendDelay;
    private int _clkFilterDelay = 0;
    private String _charsetResp = "UTF-8";
    private String _charsetUpload = "UTF-8";
    private CharsetFinder _charsetFinderUpload;
    private final EventInterceptors _eis = new EventInterceptors();
    private boolean _useEvtThd = true;
    private boolean _keepDesktop;
    private boolean _disableBehindModal;
    private boolean _timerKeepAlive;
    private boolean _debugJS;
    private boolean _repeatUuid;
    static /* synthetic */ Class class$org$zkoss$zk$ui$Component;
    static /* synthetic */ Class class$org$zkoss$zk$ui$event$Event;
    static /* synthetic */ Class class$org$zkoss$zk$ui$Session;
    static /* synthetic */ Class class$org$zkoss$zk$ui$Desktop;

    public Configuration() {
        this._resendDelay = Configuration.getInitResendDelay();
    }

    private static int getInitResendDelay() {
        String s = Library.getProperty((String)"org.zkoss.zk.au.resendDelay");
        try {
            if (s != null) {
                return Integer.parseInt(s);
            }
        }
        catch (Throwable t) {
            log.warning("Failed to parse org.zkoss.zk.au.resendDelay=" + s);
        }
        return -1;
    }

    public WebApp getWebApp() {
        return this._wapp;
    }

    public void setWebApp(WebApp wapp) {
        this._wapp = wapp;
    }

    public void addListener(Class klass) throws Exception {
        boolean added = false;
        Object listener = null;
        if (Monitor.class.isAssignableFrom(klass)) {
            if (this._monitor != null) {
                throw new UiException("Monitor listener can be assigned only once");
            }
            listener = Configuration.getInstance(klass, listener);
            this._monitor = (Monitor)listener;
            added = true;
        }
        if (PerformanceMeter.class.isAssignableFrom(klass)) {
            if (this._pfmeter != null) {
                throw new UiException("PerformanceMeter listener can be assigned only once");
            }
            listener = Configuration.getInstance(klass, listener);
            this._pfmeter = (PerformanceMeter)listener;
            added = true;
        }
        if (EventThreadInit.class.isAssignableFrom(klass)) {
            this._evtInits.add((Object)klass);
            added = true;
        }
        if (EventThreadCleanup.class.isAssignableFrom(klass)) {
            this._evtCleans.add((Object)klass);
            added = true;
        }
        if (EventThreadSuspend.class.isAssignableFrom(klass)) {
            this._evtSusps.add((Object)klass);
            added = true;
        }
        if (EventThreadResume.class.isAssignableFrom(klass)) {
            this._evtResus.add((Object)klass);
            added = true;
        }
        if (WebAppInit.class.isAssignableFrom(klass)) {
            this._appInits.add((Object)klass);
            added = true;
        }
        if (WebAppCleanup.class.isAssignableFrom(klass)) {
            this._appCleans.add((Object)klass);
            added = true;
        }
        if (SessionInit.class.isAssignableFrom(klass)) {
            this._sessInits.add((Object)klass);
            added = true;
        }
        if (SessionCleanup.class.isAssignableFrom(klass)) {
            this._sessCleans.add((Object)klass);
            added = true;
        }
        if (DesktopInit.class.isAssignableFrom(klass)) {
            this._dtInits.add((Object)klass);
            added = true;
        }
        if (DesktopCleanup.class.isAssignableFrom(klass)) {
            this._dtCleans.add((Object)klass);
            added = true;
        }
        if (ExecutionInit.class.isAssignableFrom(klass)) {
            this._execInits.add((Object)klass);
            added = true;
        }
        if (ExecutionCleanup.class.isAssignableFrom(klass)) {
            this._execCleans.add((Object)klass);
            added = true;
        }
        if (URIInterceptor.class.isAssignableFrom(klass)) {
            try {
                listener = Configuration.getInstance(klass, listener);
                this._uriIntcps.add(listener);
            }
            catch (Throwable ex) {
                log.error("Failed to instantiate " + klass, ex);
            }
            added = true;
        }
        if (RequestInterceptor.class.isAssignableFrom(klass)) {
            try {
                listener = Configuration.getInstance(klass, listener);
                this._reqIntcps.add(listener);
            }
            catch (Throwable ex) {
                log.error("Failed to instantiate " + klass, ex);
            }
            added = true;
        }
        if (EventInterceptor.class.isAssignableFrom(klass)) {
            try {
                listener = Configuration.getInstance(klass, listener);
                this._eis.addEventInterceptor((EventInterceptor)listener);
            }
            catch (Throwable ex) {
                log.error("Failed to instantiate " + klass, ex);
            }
            added = true;
        }
        if (UiLifeCycle.class.isAssignableFrom(klass)) {
            try {
                listener = Configuration.getInstance(klass, listener);
                this._uiCycles.add(listener);
            }
            catch (Throwable ex) {
                log.error("Failed to instantiate " + klass, ex);
            }
            added = true;
        }
        if (!added) {
            throw new UiException("Unknown listener: " + klass);
        }
    }

    private static Object getInstance(Class klass, Object listener) throws Exception {
        return listener != null ? listener : klass.newInstance();
    }

    public void removeListener(Class klass) {
        if (this._monitor != null && this._monitor.getClass().equals(klass)) {
            this._monitor = null;
        }
        if (this._pfmeter != null && this._pfmeter.getClass().equals(klass)) {
            this._pfmeter = null;
        }
        this._evtInits.remove((Object)klass);
        this._evtCleans.remove((Object)klass);
        this._evtSusps.remove((Object)klass);
        this._evtResus.remove((Object)klass);
        this._appInits.remove((Object)klass);
        this._appCleans.remove((Object)klass);
        this._sessInits.remove((Object)klass);
        this._sessCleans.remove((Object)klass);
        this._dtInits.remove((Object)klass);
        this._dtCleans.remove((Object)klass);
        this._execInits.remove((Object)klass);
        this._execCleans.remove((Object)klass);
        SameClass sc = new SameClass(klass);
        this._uriIntcps.removeBy((Comparable)sc, true);
        this._reqIntcps.removeBy((Comparable)sc, true);
        this._uiCycles.removeBy((Comparable)sc, true);
        this._eis.removeEventInterceptor(klass);
    }

    public List newEventThreadInits(Component comp, Event evt) throws UiException {
        Class[] ary = (Class[])this._evtInits.toArray();
        if (ary.length == 0) {
            return null;
        }
        LinkedList<EventThreadInit> inits = new LinkedList<EventThreadInit>();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                EventThreadInit init = (EventThreadInit)klass.newInstance();
                init.prepare(comp, evt);
                inits.add(init);
                continue;
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        return inits;
    }

    public boolean invokeEventThreadInits(List inits, Component comp, Event evt) throws UiException {
        if (inits == null || inits.isEmpty()) {
            return true;
        }
        Iterator it = inits.iterator();
        while (it.hasNext()) {
            EventThreadInit fn = (EventThreadInit)it.next();
            try {
                try {
                    if (fn.init(comp, evt)) continue;
                    return false;
                }
                catch (AbstractMethodError ex) {
                    Method m = fn.getClass().getMethod("init", class$org$zkoss$zk$ui$Component == null ? Configuration.class$("org.zkoss.zk.ui.Component") : class$org$zkoss$zk$ui$Component, class$org$zkoss$zk$ui$event$Event == null ? Configuration.class$("org.zkoss.zk.ui.event.Event") : class$org$zkoss$zk$ui$event$Event);
                    Fields.setAccessible((AccessibleObject)m, (boolean)true);
                    m.invoke((Object)fn, comp, evt);
                }
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        return true;
    }

    public List newEventThreadCleanups(Component comp, Event evt, List errs) {
        Class[] ary = (Class[])this._evtCleans.toArray();
        if (ary.length == 0) {
            return null;
        }
        LinkedList<EventThreadCleanup> cleanups = new LinkedList<EventThreadCleanup>();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                EventThreadCleanup cleanup = (EventThreadCleanup)klass.newInstance();
                cleanup.cleanup(comp, evt, errs);
                cleanups.add(cleanup);
                continue;
            }
            catch (Throwable t) {
                if (errs != null) {
                    errs.add(t);
                }
                log.error("Failed to invoke " + klass, t);
            }
        }
        return cleanups.isEmpty() ? null : cleanups;
    }

    public void invokeEventThreadCompletes(List cleanups, Component comp, Event evt, List errs) {
        if (cleanups == null || cleanups.isEmpty()) {
            return;
        }
        Iterator it = cleanups.iterator();
        while (it.hasNext()) {
            EventThreadCleanup fn = (EventThreadCleanup)it.next();
            try {
                fn.complete(comp, evt);
            }
            catch (Throwable ex) {
                if (errs != null) {
                    errs.add(ex);
                }
                log.error("Failed to invoke " + fn, ex);
            }
        }
    }

    public List newEventThreadSuspends(Component comp, Event evt, Object obj) {
        Class[] ary = (Class[])this._evtSusps.toArray();
        if (ary.length == 0) {
            return null;
        }
        LinkedList<EventThreadSuspend> suspends = new LinkedList<EventThreadSuspend>();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                EventThreadSuspend suspend = (EventThreadSuspend)klass.newInstance();
                suspend.beforeSuspend(comp, evt, obj);
                suspends.add(suspend);
                continue;
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        return suspends;
    }

    public void invokeEventThreadSuspends(List suspends, Component comp, Event evt) throws UiException {
        if (suspends == null || suspends.isEmpty()) {
            return;
        }
        Iterator it = suspends.iterator();
        while (it.hasNext()) {
            EventThreadSuspend fn = (EventThreadSuspend)it.next();
            try {
                fn.afterSuspend(comp, evt);
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + fn + " after suspended", ex);
            }
        }
    }

    public List newEventThreadResumes(Component comp, Event evt) throws UiException {
        Class[] ary = (Class[])this._evtResus.toArray();
        if (ary.length == 0) {
            return null;
        }
        LinkedList<EventThreadResume> resumes = new LinkedList<EventThreadResume>();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                EventThreadResume resume = (EventThreadResume)klass.newInstance();
                resume.beforeResume(comp, evt);
                resumes.add(resume);
                continue;
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        return resumes;
    }

    public void invokeEventThreadResumes(List resumes, Component comp, Event evt) throws UiException {
        if (resumes == null || resumes.isEmpty()) {
            return;
        }
        Iterator it = resumes.iterator();
        while (it.hasNext()) {
            EventThreadResume fn = (EventThreadResume)it.next();
            try {
                fn.afterResume(comp, evt);
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
    }

    public void invokeEventThreadResumeAborts(Component comp, Event evt) {
        Class[] ary = (Class[])this._evtResus.toArray();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                ((EventThreadResume)klass.newInstance()).abortResume(comp, evt);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + klass + " for aborting", ex);
            }
        }
    }

    public void invokeWebAppInits() throws UiException {
        Class[] ary = (Class[])this._appInits.toArray();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                ((WebAppInit)klass.newInstance()).init(this._wapp);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + klass, ex);
            }
        }
    }

    public void invokeWebAppCleanups() {
        Class[] ary = (Class[])this._appCleans.toArray();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                ((WebAppCleanup)klass.newInstance()).cleanup(this._wapp);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + klass, ex);
            }
        }
    }

    public void invokeSessionInits(Session sess, Object request) throws UiException {
        Class[] ary = (Class[])this._sessInits.toArray();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                SessionInit fn = (SessionInit)klass.newInstance();
                try {
                    fn.init(sess, request);
                }
                catch (AbstractMethodError ex) {
                    Method m = klass.getMethod("init", class$org$zkoss$zk$ui$Session == null ? Configuration.class$("org.zkoss.zk.ui.Session") : class$org$zkoss$zk$ui$Session);
                    Fields.setAccessible((AccessibleObject)m, (boolean)true);
                    m.invoke((Object)fn, sess);
                }
                continue;
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
    }

    public void invokeSessionCleanups(Session sess) {
        Class[] ary = (Class[])this._sessCleans.toArray();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                ((SessionCleanup)klass.newInstance()).cleanup(sess);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + klass, ex);
            }
        }
    }

    public void invokeDesktopInits(Desktop desktop, Object request) throws UiException {
        Class[] ary = (Class[])this._dtInits.toArray();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                DesktopInit fn = (DesktopInit)klass.newInstance();
                try {
                    fn.init(desktop, request);
                }
                catch (AbstractMethodError ex) {
                    Method m = klass.getMethod("init", class$org$zkoss$zk$ui$Desktop == null ? Configuration.class$("org.zkoss.zk.ui.Desktop") : class$org$zkoss$zk$ui$Desktop);
                    Fields.setAccessible((AccessibleObject)m, (boolean)true);
                    m.invoke((Object)fn, desktop);
                }
                continue;
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
    }

    public void invokeDesktopCleanups(Desktop desktop) {
        Class[] ary = (Class[])this._dtCleans.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ((DesktopCleanup)ary[j].newInstance()).cleanup(desktop);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + ary[j], ex);
            }
        }
    }

    public void invokeExecutionInits(Execution exec, Execution parent) throws UiException {
        Class[] ary = (Class[])this._execInits.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ((ExecutionInit)ary[j].newInstance()).init(exec, parent);
                continue;
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
    }

    public void invokeExecutionCleanups(Execution exec, Execution parent, List errs) {
        Class[] ary = (Class[])this._execCleans.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ((ExecutionCleanup)ary[j].newInstance()).cleanup(exec, parent, errs);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + ary[j], ex);
                if (errs == null) continue;
                errs.add(ex);
            }
        }
    }

    public void invokeURIInterceptors(String uri) {
        URIInterceptor[] ary = (URIInterceptor[])this._uriIntcps.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ary[j].request(uri);
                continue;
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
    }

    public void invokeRequestInterceptors(Session sess, Object request, Object response) {
        RequestInterceptor[] ary = (RequestInterceptor[])this._reqIntcps.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ary[j].request(sess, request, response);
                continue;
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
    }

    public void afterComponentAttached(Component comp, Page page) {
        UiLifeCycle[] ary = (UiLifeCycle[])this._uiCycles.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ary[j].afterComponentAttached(comp, page);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + ary[j], ex);
            }
        }
    }

    public void afterComponentDetached(Component comp, Page prevpage) {
        UiLifeCycle[] ary = (UiLifeCycle[])this._uiCycles.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ary[j].afterComponentDetached(comp, prevpage);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + ary[j], ex);
            }
        }
    }

    public void afterComponentMoved(Component parent, Component child, Component prevparent) {
        UiLifeCycle[] ary = (UiLifeCycle[])this._uiCycles.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ary[j].afterComponentMoved(parent, child, prevparent);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + ary[j], ex);
            }
        }
    }

    public void afterPageAttached(Page page, Desktop desktop) {
        UiLifeCycle[] ary = (UiLifeCycle[])this._uiCycles.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ary[j].afterPageAttached(page, desktop);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + ary[j], ex);
            }
        }
    }

    public void afterPageDetached(Page page, Desktop prevdesktop) {
        UiLifeCycle[] ary = (UiLifeCycle[])this._uiCycles.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ary[j].afterPageDetached(page, prevdesktop);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + ary[j], ex);
            }
        }
    }

    public void addThemeURI(String uri) {
        if (uri == null || uri.length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        this._themeURIs.add((Object)uri);
    }

    public String[] getThemeURIs() {
        return (String[])this._themeURIs.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisabledThemeURI(String uri) {
        if (uri == null || uri.length() == 0) {
            throw new IllegalArgumentException();
        }
        Configuration configuration = this;
        synchronized (configuration) {
            if (this._disThemeURIs == null) {
                this._disThemeURIs = Collections.synchronizedSet(new HashSet(4));
            }
        }
        this._disThemeURIs.add(uri);
    }

    public Set getDisabledThemeURIs() {
        return this._disThemeURIs != null ? this._disThemeURIs : Collections.EMPTY_SET;
    }

    public ThemeProvider getThemeProvider() {
        return this._themeProvider;
    }

    public void setThemeProvider(ThemeProvider provider) {
        this._themeProvider = provider;
    }

    public void setUiEngineClass(Class cls) {
        if (cls != null && !UiEngine.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("UiEngine not implemented: " + cls);
        }
        this._uiengcls = cls;
    }

    public Class getUiEngineClass() {
        return this._uiengcls;
    }

    public void setWebAppClass(Class cls) {
        if (!(cls == null || WebApp.class.isAssignableFrom(cls) && WebAppCtrl.class.isAssignableFrom(cls))) {
            throw new IllegalArgumentException("WebApp or WebAppCtrl not implemented: " + cls);
        }
        this._wappcls = cls;
    }

    public Class getWebAppClass() {
        return this._wappcls;
    }

    public void setDesktopCacheProviderClass(Class cls) {
        if (cls != null && !DesktopCacheProvider.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("DesktopCacheProvider not implemented: " + cls);
        }
        this._dcpcls = cls;
    }

    public Class getDesktopCacheProviderClass() {
        return this._dcpcls;
    }

    public void setUiFactoryClass(Class cls) {
        if (cls != null && !UiFactory.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("UiFactory not implemented: " + cls);
        }
        this._uiftycls = cls;
    }

    public Class getUiFactoryClass() {
        return this._uiftycls;
    }

    public void setFailoverManagerClass(Class cls) {
        if (cls != null && !FailoverManager.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("FailoverManager not implemented: " + cls);
        }
        this._failmancls = cls;
    }

    public Class getFailoverManagerClass() {
        return this._failmancls;
    }

    public void setIdGeneratorClass(Class cls) {
        if (cls != null && !IdGenerator.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("IdGenerator not implemented: " + cls);
        }
        this._idgencls = cls;
    }

    public Class getIdGeneratorClass() {
        return this._idgencls;
    }

    public void setSessionCacheClass(Class cls) {
        if (cls != null && !SessionCache.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("SessionCache not implemented: " + cls);
        }
        this._sesscachecls = cls;
    }

    public Class getSessionCacheClass() {
        return this._sesscachecls;
    }

    public void setMaxProcessTime(int time) {
        this._maxProcTime = time;
    }

    public int getMaxProcessTime() {
        return this._maxProcTime;
    }

    public void setMaxUploadSize(int sz) {
        this._maxUploadSize = sz;
    }

    public int getMaxUploadSize() {
        return this._maxUploadSize;
    }

    public String getUploadCharset() {
        return this._charsetUpload;
    }

    public void setUploadCharset(String charset) {
        this._charsetUpload = charset != null && charset.length() > 0 ? charset : "UTF-8";
    }

    public CharsetFinder getUploadCharsetFinder() {
        return this._charsetFinderUpload;
    }

    public void setUploadCharsetFinder(CharsetFinder finder) {
        this._charsetFinderUpload = finder;
    }

    public void setDesktopMaxInactiveInterval(int secs) {
        this._dtTimeout = secs;
    }

    public int getDesktopMaxInactiveInterval() {
        return this._dtTimeout;
    }

    public void setProcessingPromptDelay(int minisecs) {
        this._promptDelay = minisecs;
    }

    public int getProcessingPromptDelay() {
        return this._promptDelay;
    }

    public void setClickFilterDelay(int minisecs) {
        this._clkFilterDelay = minisecs;
    }

    public int getClickFilterDelay() {
        return this._clkFilterDelay;
    }

    public void setTooltipDelay(int minisecs) {
        this._tooltipDelay = minisecs;
    }

    public int getTooltipDelay() {
        return this._tooltipDelay;
    }

    public void setResendDelay(int minisecs) {
        this._resendDelay = minisecs;
    }

    public int getResendDelay() {
        return this._resendDelay;
    }

    public String addClientErrorReload(int errCode, String uri) {
        if (uri == null) {
            return this.removeClientErrorReload(errCode);
        }
        return this._errURIs.put(new Integer(errCode), uri);
    }

    public String removeClientErrorReload(int errCode) {
        return (String)this._errURIs.remove(new Integer(errCode));
    }

    public String getClientErrorReload(int errCode) {
        return (String)this._errURIs.get(new Integer(errCode));
    }

    public int[] getClientErrorReloadCodes() {
        Set ks = this._errURIs.keySet();
        int[] cers = new int[ks.size()];
        int j = 0;
        Iterator it = ks.iterator();
        while (j < cers.length && it.hasNext()) {
            cers[j++] = (Integer)it.next();
        }
        return cers;
    }

    public void setSessionMaxInactiveInterval(int secs) {
        this._sessTimeout = secs;
    }

    public int getSessionMaxInactiveInterval() {
        return this._sessTimeout;
    }

    public void setSessionMaxDesktops(int max) {
        this._sessDktMax = max;
    }

    public void setMaxDesktops(int max) {
        this.setSessionMaxDesktops(max);
    }

    public int getSessionMaxDesktops() {
        return this._sessDktMax;
    }

    public int getMaxDesktops() {
        return this.getSessionMaxDesktops();
    }

    public void setSessionMaxRequests(int max) {
        this._sessReqMax = max;
    }

    public int getSessionMaxRequests() {
        return this._sessReqMax;
    }

    public void setMaxSpareThreads(int max) {
        this._sparThdMax = max;
    }

    public int getMaxSpareThreads() {
        return this._sparThdMax;
    }

    public void setMaxSuspendedThreads(int max) {
        this._suspThdMax = max;
    }

    public int getMaxSuspendedThreads() {
        return this._suspThdMax;
    }

    public void enableEventThread(boolean enable) {
        UiEngine engine;
        if (!enable && this._wapp != null && (engine = ((WebAppCtrl)((Object)this._wapp)).getUiEngine()) != null && engine.hasSuspendedThread()) {
            throw new IllegalStateException("Unable to disable due to suspended threads");
        }
        this._useEvtThd = enable;
    }

    public boolean isEventThreadEnabled() {
        return this._useEvtThd;
    }

    public boolean isDisableBehindModalEnabled() {
        return this._disableBehindModal;
    }

    public void enableDisableBehindModal(boolean enable) {
        this._disableBehindModal = enable;
    }

    public Monitor getMonitor() {
        return this._monitor;
    }

    public Monitor setMonitor(Monitor monitor) {
        Monitor old = this._monitor;
        this._monitor = monitor;
        return old;
    }

    public PerformanceMeter getPerformanceMeter() {
        return this._pfmeter;
    }

    public PerformanceMeter setPerformanceMeter(PerformanceMeter meter) {
        PerformanceMeter old = this._pfmeter;
        this._pfmeter = meter;
        return old;
    }

    public String getResponseCharset() {
        return this._charsetResp;
    }

    public void setResponseCharset(String charset) {
        this._charsetResp = charset != null && charset.length() > 0 ? charset : null;
    }

    public String getPreference(String name, String defaultValue) {
        String value = (String)this._prefs.get(name);
        return value != null ? value : defaultValue;
    }

    public void setPreference(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("null");
        }
        this._prefs.put(name, value);
    }

    public Set getPreferenceNames() {
        return this._prefs.keySet();
    }

    public Object addRichlet(String name, Class richletClass, Map params) {
        if (!Richlet.class.isAssignableFrom(richletClass)) {
            throw new IllegalArgumentException("A richlet class, " + richletClass + ", must implement " + Richlet.class.getName());
        }
        return this.addRichlet0(name, richletClass, params);
    }

    public Object addRichlet(String name, String richletClassName, Map params) {
        if (richletClassName == null || richletClassName.length() == 0) {
            throw new IllegalArgumentException("richletClassName is required");
        }
        return this.addRichlet0(name, richletClassName, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object addRichlet0(String name, Object richletClass, Map params) {
        Object[] o;
        Map map = this._richlets;
        synchronized (map) {
            o = this._richlets.put(name, new Object[]{richletClass, params});
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Richlet) {
            Configuration.destroy((Richlet)o);
            return o.getClass();
        }
        return o[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRichletMapping(String name, String path) {
        Map map = this._richlets;
        synchronized (map) {
            if (!this._richlets.containsKey(name)) {
                throw new UiException("Richlet not defined: " + name);
            }
        }
        if (path == null || path.length() == 0 || "/".equals(path)) {
            path = "";
        } else if (!path.startsWith("/")) {
            throw new IllegalArgumentException("path must start with '/', not " + path);
        }
        boolean wildcard = path.endsWith("/*");
        if (wildcard) {
            path = path.substring(0, path.length() - 2);
        }
        Map map2 = this._richletmaps;
        synchronized (map2) {
            this._richletmaps.put(path, new Object[]{name, wildcard});
        }
    }

    private static void destroy(Richlet richlet) {
        try {
            richlet.destroy();
        }
        catch (Throwable ex) {
            log.error("Unable to destroy " + richlet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Richlet getRichlet(String name) {
        Object[] info;
        WaitLock lock;
        block21: {
            lock = null;
            do {
                Map map = this._richlets;
                synchronized (map) {
                    Object o = this._richlets.get(name);
                    if (o == null || o instanceof Richlet) {
                        return (Richlet)o;
                    }
                    if (!(o instanceof WaitLock)) {
                        info = (Object[])o;
                        lock = new WaitLock();
                        this._richlets.put(name, lock);
                        break block21;
                    }
                    lock = (WaitLock)o;
                }
            } while (lock.waitUntilUnlock(300000));
            PotentialDeadLockException ex = new PotentialDeadLockException("Unable to load richlet " + name + "\nCause: conflict too long.");
            log.warningBriefly((Throwable)ex);
            throw ex;
        }
        try {
            Object o;
            if (info[0] instanceof String) {
                try {
                    info[0] = Classes.forNameByThread((String)((String)info[0]));
                }
                catch (Throwable ex) {
                    throw new UiException("Failed to load " + info[0]);
                }
            }
            if (!((o = ((Class)info[0]).newInstance()) instanceof Richlet)) {
                throw new UiException(Richlet.class + " must be implemented by " + info[0]);
            }
            Richlet richlet = (Richlet)o;
            richlet.init(new RichletConfigImpl(this._wapp, (Map)info[1]));
            Object object = this._richlets;
            synchronized (object) {
                this._richlets.put(name, richlet);
            }
            object = richlet;
            return object;
        }
        catch (Throwable ex) {
            Map map = this._richlets;
            synchronized (map) {
                this._richlets.put(name, info);
            }
            throw UiException.Aide.wrap(ex, "Unable to instantiate " + info[0]);
        }
        finally {
            lock.unlock();
        }
    }

    public Richlet getRichletByPath(String path) {
        int len;
        if (path == null || path.length() == 0 || "/".equals(path)) {
            path = "";
        } else if (path.charAt(0) != '/') {
            path = '/' + path;
        }
        int j = len = path.length();
        Richlet richlet;
        while ((richlet = this.getRichletByPath0(path.substring(0, j), j != len)) == null && j != 0) {
            j = path.lastIndexOf(47, j - 1);
        }
        return richlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Richlet getRichletByPath0(String path, boolean wildcardOnly) {
        Object[] info;
        Map map = this._richletmaps;
        synchronized (map) {
            info = (Object[])this._richletmaps.get(path);
        }
        return info != null && (!wildcardOnly || (Boolean)info[1] != false) ? this.getRichlet((String)info[0]) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detroyRichlets() {
        Map map = this._richlets;
        synchronized (map) {
            Iterator it = this._richlets.values().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof Richlet)) continue;
                Configuration.destroy((Richlet)o);
            }
            this._richlets.clear();
        }
    }

    public void setKeepDesktopAcrossVisits(boolean keep) {
        this._keepDesktop = keep;
    }

    public boolean isKeepDesktopAcrossVisits() {
        return this._keepDesktop;
    }

    public void setTimerKeepAlive(boolean alive) {
        this._timerKeepAlive = alive;
    }

    public boolean isTimerKeepAlive() {
        return this._timerKeepAlive;
    }

    public boolean isDebugJS() {
        return this._debugJS;
    }

    public void setDebugJS(boolean debug) {
        this._debugJS = debug;
    }

    public boolean isRepeatUuid() {
        return this._repeatUuid;
    }

    public void setRepeatUuid(boolean repeat) {
        this._repeatUuid = repeat;
    }

    public void setExpressionFactoryClass(Class expfcls) {
        Expressions.setExpressionFactoryClass((Class)expfcls);
    }

    public Class getExpressionFactoryClass() {
        return Expressions.getExpressionFactoryClass();
    }

    public Event beforeSendEvent(Event event) {
        return this._eis.beforeSendEvent(event);
    }

    public Event beforePostEvent(Event event) {
        return this._eis.beforePostEvent(event);
    }

    public Event beforeProcessEvent(Event event) {
        return this._eis.beforeProcessEvent(event);
    }

    public void afterProcessEvent(Event event) {
        this._eis.afterProcessEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addErrorPage(String deviceType, Class type, String location) {
        LinkedList<ErrorPage> l;
        if (!Throwable.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Throwable or derived is required: " + type);
        }
        if (location == null || deviceType == null) {
            throw new IllegalArgumentException();
        }
        Map map = this._errpgs;
        synchronized (map) {
            l = (LinkedList<ErrorPage>)this._errpgs.get(deviceType);
            if (l == null) {
                l = new LinkedList<ErrorPage>();
                this._errpgs.put(deviceType, l);
            }
        }
        String previous = null;
        LinkedList<ErrorPage> linkedList = l;
        synchronized (linkedList) {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                ErrorPage errpg = (ErrorPage)it.next();
                if (!errpg.type.equals(type)) continue;
                previous = errpg.location;
                it.remove();
                break;
            }
            l.add(new ErrorPage(type, location));
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getErrorPage(String deviceType, Throwable error) {
        if (!this._errpgs.isEmpty()) {
            List l;
            Object object = this._errpgs;
            synchronized (object) {
                l = (List)this._errpgs.get(deviceType);
            }
            if (l != null) {
                object = l;
                synchronized (object) {
                    Iterator it = l.iterator();
                    while (it.hasNext()) {
                        ErrorPage errpg = (ErrorPage)it.next();
                        if (!errpg.type.isInstance(error)) continue;
                        return errpg.location;
                    }
                }
            }
        }
        return null;
    }

    private static class SameClass
    implements Comparable {
        private final Class _klass;

        private SameClass(Class klass) {
            this._klass = klass;
        }

        public int compareTo(Object o) {
            return o.getClass().equals(this._klass) ? 0 : 1;
        }
    }

    private static class ErrorPage {
        private final Class type;
        private final String location;

        private ErrorPage(Class type, String location) {
            this.type = type;
            this.location = location;
        }
    }
}

