/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.GenericComposer;

public abstract class GenericAutowireComposer
extends GenericComposer
implements ComponentCloneListener {
    private static final String COMPOSER_CLONE = "COMPOSER_CLONE";
    private static final String ON_CLONE_DO_AFTER_COMPOSE = "onCLONE_DO_AFTER_COMPOSE";
    protected Component self;
    protected IdSpace spaceOwner;
    protected Page page;
    protected Desktop desktop;
    protected Session session;
    protected WebApp application;
    protected Map componentScope;
    protected Map spaceScope;
    protected Map pageScope;
    protected Map desktopScope;
    protected Map sessionScope;
    protected Map applicationScope;
    protected Map requestScope;
    protected Execution execution;
    protected Map arg;
    protected final char _separator;
    private static Method SHOW;

    protected GenericAutowireComposer() {
        this._separator = (char)36;
    }

    protected GenericAutowireComposer(char separator) {
        this._separator = separator;
    }

    public void doAfterCompose(Component comp) throws Exception {
        super.doAfterCompose(comp);
        Components.wireVariables(comp, (Object)this, this._separator);
    }

    protected void alert(String m) {
        try {
            if (SHOW == null) {
                Class mboxcls = Classes.forNameByThread((String)"org.zkoss.zul.Messagebox");
                SHOW = mboxcls.getMethod("show", String.class);
            }
            SHOW.invoke(null, m);
        }
        catch (InvocationTargetException e) {
            throw UiException.Aide.wrap(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object clone(Component comp) {
        try {
            Execution exec = Executions.getCurrent();
            int idcode = System.identityHashCode(comp);
            Composer composerClone = (Composer)exec.getAttribute(COMPOSER_CLONE + idcode);
            if (composerClone == null) {
                composerClone = (Composer)Classes.newInstance(this.getClass(), null);
                exec.setAttribute(COMPOSER_CLONE + idcode, composerClone);
                comp.addEventListener(ON_CLONE_DO_AFTER_COMPOSE, new CloneDoAfterCompose());
                Events.postEvent(new Event(ON_CLONE_DO_AFTER_COMPOSE, comp, composerClone));
            }
            return composerClone;
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    private static class CloneDoAfterCompose
    implements EventListener {
        private CloneDoAfterCompose() {
        }

        public void onEvent(Event event) throws Exception {
            Component clone = event.getTarget();
            GenericAutowireComposer composerClone = (GenericAutowireComposer)event.getData();
            composerClone.doAfterCompose(clone);
            clone.removeEventListener(GenericAutowireComposer.ON_CLONE_DO_AFTER_COMPOSE, this);
        }
    }
}

