/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au.http;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.lang.Exceptions;
import org.zkoss.mesg.Messages;
import org.zkoss.util.logging.Log;
import org.zkoss.util.media.Media;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.zk.au.http.AuProcessor;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;

public class AuDynaMediar
implements AuProcessor {
    private static final Log log = Log.lookup((Class)AuDynaMediar.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Session sess, ServletContext ctx, HttpServletRequest request, HttpServletResponse response, String pi) throws ServletException, IOException {
        Media media;
        int l;
        if (sess == null) {
            response.sendError(410, Messages.get((int)MZk.PAGE_NOT_FOUND, (Object)pi));
            return;
        }
        int j = pi.indexOf(47, 1) + 1;
        int k = pi.indexOf(47, j);
        if (j <= 0 || k <= 0) {
            throw new ServletException("Wrong path info: " + pi);
        }
        String dtid = pi.substring(j, k);
        String uuid = (l = pi.indexOf(47, ++k)) >= 0 ? pi.substring(k, l) : pi.substring(k);
        boolean download = false;
        try {
            WebApp wapp = sess.getWebApp();
            WebAppCtrl wappc = (WebAppCtrl)((Object)wapp);
            UiEngine uieng = wappc.getUiEngine();
            Desktop desktop = wappc.getDesktopCache(sess).getDesktop(dtid);
            DesktopCtrl desktopCtrl = (DesktopCtrl)((Object)desktop);
            Execution oldexec = Executions.getCurrent();
            ExecutionImpl exec = new ExecutionImpl(ctx, request, response, desktop, null);
            uieng.activate(exec);
            Configuration config = wapp.getConfiguration();
            boolean err = false;
            try {
                config.invokeExecutionInits(exec, oldexec);
                desktopCtrl.invokeExecutionInits(exec, oldexec);
                media = desktopCtrl.getDownloadMedia(uuid, false);
                if (media != null) {
                    download = true;
                } else {
                    Component comp = desktop.getComponentByUuid(uuid);
                    Object cc = ((ComponentCtrl)((Object)comp)).getExtraCtrl();
                    if (!(cc instanceof DynamicMedia)) {
                        throw new ServletException(DynamicMedia.class + " must be implemented by getExtraCtrl() of " + comp);
                    }
                    media = ((DynamicMedia)cc).getMedia(l >= 0 ? pi.substring(l) : "");
                    if (media == null) {
                        response.sendError(410, Messages.get((int)MZk.PAGE_NOT_FOUND, (Object)(pi + " - " + comp)));
                        return;
                    }
                }
            }
            catch (Throwable ex) {
                err = true;
                LinkedList<Throwable> errs = new LinkedList<Throwable>();
                errs.add(ex);
                desktopCtrl.invokeExecutionCleanups(exec, oldexec, errs);
                config.invokeExecutionCleanups(exec, oldexec, errs);
                StringBuffer errmsg = new StringBuffer(100);
                if (!errs.isEmpty()) {
                    Iterator it = errs.iterator();
                    while (it.hasNext()) {
                        Throwable t = (Throwable)it.next();
                        log.realCauseBriefly("Failed to load media, " + pi, t);
                        errmsg.append('\n').append(Exceptions.getMessage((Throwable)t));
                    }
                }
                response.sendError(410, Messages.get((int)MZk.PAGE_FAILED, (Object[])new Object[]{pi, errmsg, ""}));
                return;
            }
            finally {
                if (!err) {
                    desktopCtrl.invokeExecutionCleanups(exec, oldexec, null);
                    config.invokeExecutionCleanups(exec, oldexec, null);
                }
                uieng.deactivate(exec);
            }
        }
        catch (ComponentNotFoundException ex) {
            response.sendError(410, Messages.get((int)MZk.UPDATE_OBSOLETE_PAGE, (Object)uuid));
            return;
        }
        Https.write((HttpServletRequest)request, (HttpServletResponse)response, (Media)media, (boolean)download, (boolean)false);
    }
}

