/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au.http;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuWriter;
import org.zkoss.zk.au.AuWriters;

public class HttpAuWriter
implements AuWriter {
    protected StringWriter _out;
    private boolean _compress = true;

    public boolean isCompress() {
        return this._compress;
    }

    public void setCompress(boolean compress) {
        this._compress = compress;
    }

    public String getChannel() {
        return "au";
    }

    public AuWriter open(Object request, Object response, int timeout) throws IOException {
        ((HttpServletResponse)response).setContentType("text/xml;charset=UTF-8");
        this._out = new StringWriter();
        this._out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this._out.write("<rs>\n");
        return this;
    }

    public void close(Object request, Object response) throws IOException {
        this._out.write("\n</rs>");
        this.flush((HttpServletRequest)request, (HttpServletResponse)response);
    }

    protected void flush(HttpServletRequest request, HttpServletResponse response) throws IOException {
        byte[] bs;
        byte[] data = this._out.toString().getBytes("UTF-8");
        if (this._compress && data.length > 200 && (bs = Https.gzip((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])data)) != null) {
            data = bs;
        }
        response.setContentType("text/xml;charset=UTF-8");
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
        response.flushBuffer();
    }

    public void writeResponseId(int resId) throws IOException {
        AuWriters.writeResponseId(this._out, resId);
    }

    public void write(AuResponse response) throws IOException {
        AuWriters.write(this._out, response);
    }

    public void write(Collection responses) throws IOException {
        Iterator it = responses.iterator();
        while (it.hasNext()) {
            this.write((AuResponse)it.next());
        }
    }
}

