/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.scripting.util;

import java.util.LinkedList;
import java.util.List;
import org.zkoss.lang.Objects;
import org.zkoss.xel.Function;
import org.zkoss.zk.scripting.Interpreter;
import org.zkoss.zk.scripting.Namespace;
import org.zkoss.zk.scripting.Namespaces;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;

public abstract class GenericInterpreter
implements Interpreter {
    public static final Object UNDEFINED = new Object(){

        public String toString() {
            return "undefined";
        }
    };
    private final List _nss = new LinkedList();
    private Page _owner;
    private String _zslang;

    protected GenericInterpreter() {
    }

    protected abstract void exec(String var1);

    protected boolean contains(String name) {
        return this.get(name) != null;
    }

    protected Object get(String name) {
        return null;
    }

    protected void set(String name, Object value) {
    }

    protected void unset(String name) {
    }

    protected boolean contains(Namespace ns, String name) {
        return this.get(ns, name) != null;
    }

    protected Object get(Namespace ns, String name) {
        return this.get(name);
    }

    protected void set(Namespace ns, String name, Object value) {
        this.set(name, value);
    }

    protected void unset(Namespace ns, String name) {
        this.unset(name);
    }

    protected void beforeInterpret(Namespace ns) {
        this.beforeExec();
        this.push(ns);
    }

    protected void afterInterpret(Namespace ns) {
        this.pop();
        this.afterExec();
    }

    protected void beforeExec() {
    }

    protected void afterExec() {
    }

    protected Object getFromNamespace(String name) {
        Object val;
        Namespace ns = this.getCurrent();
        if (ns != null && ((val = ns.getVariable(name, false)) != null || ns.containsVariable(name, false))) {
            return val;
        }
        return GenericInterpreter.getImplicit(name);
    }

    protected static Object getImplicit(String name) {
        Execution exec;
        if ("execution".equals(name) && (exec = Executions.getCurrent()) != null) {
            return exec;
        }
        return Namespaces.getImplicit(name, UNDEFINED);
    }

    protected Object getFromNamespace(Namespace ns, String name, boolean localOnly) {
        Object val;
        if (this.getCurrent() != null && ((val = ns.getVariable(name, localOnly)) != null || ns.containsVariable(name, localOnly))) {
            return val;
        }
        return GenericInterpreter.getImplicit(name);
    }

    protected Object getFromNamespace(Namespace ns, String name) {
        return this.getFromNamespace(ns, name, false);
    }

    public void init(Page owner, String zslang) {
        this._owner = owner;
        this._zslang = zslang;
    }

    public void destroy() {
        this._owner = null;
    }

    public Page getOwner() {
        return this._owner;
    }

    public String getLanguage() {
        return this._zslang;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interpret(String script, Namespace ns) {
        String each = this._owner.getLanguageDefinition().getEachTimeScript(this._zslang);
        if (each != null) {
            script = each + '\n' + script;
        }
        this.beforeInterpret(ns);
        try {
            this.exec(script);
        }
        finally {
            this.afterInterpret(ns);
        }
    }

    public Class getClass(String clsnm) {
        return null;
    }

    public Function getFunction(String name, Class[] argTypes) {
        return null;
    }

    public Function getFunction(Namespace ns, String name, Class[] argTypes) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsVariable(String name) {
        this.beforeExec();
        this.push(Objects.UNKNOWN);
        try {
            boolean bl = this.contains(name);
            return bl;
        }
        finally {
            this.pop();
            this.afterExec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getVariable(String name) {
        this.beforeExec();
        this.push(Objects.UNKNOWN);
        try {
            Object object = this.get(name);
            return object;
        }
        finally {
            this.pop();
            this.afterExec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVariable(String name, Object value) {
        this.beforeExec();
        try {
            this.set(name, value);
        }
        finally {
            this.afterExec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unsetVariable(String name) {
        this.beforeExec();
        try {
            this.unset(name);
        }
        finally {
            this.afterExec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsVariable(Namespace ns, String name) {
        this.beforeExec();
        this.push(Objects.UNKNOWN);
        try {
            boolean bl = this.contains(ns, name);
            return bl;
        }
        finally {
            this.pop();
            this.afterExec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getVariable(Namespace ns, String name) {
        this.beforeExec();
        this.push(Objects.UNKNOWN);
        try {
            Object object = this.get(ns, name);
            return object;
        }
        finally {
            this.pop();
            this.afterExec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVariable(Namespace ns, String name, Object value) {
        this.beforeExec();
        try {
            this.set(ns, name, value);
        }
        finally {
            this.afterExec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unsetVariable(Namespace ns, String name) {
        this.beforeExec();
        try {
            this.unset(ns, name);
        }
        finally {
            this.afterExec();
        }
    }

    private void push(Object ns) {
        this._nss.add(0, ns);
    }

    private void pop() {
        this._nss.remove(0);
    }

    protected Namespace getCurrent() {
        if (!this._nss.isEmpty()) {
            Object o = this._nss.get(0);
            if (o == Objects.UNKNOWN) {
                return null;
            }
            if (o != null) {
                return (Namespace)o;
            }
        }
        return Namespaces.getCurrent(this._owner);
    }
}

