/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletSession;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import org.zkoss.util.CollectionsX;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.xel.AttributesMap;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.http.WebManagerActivationListener;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.SessionsCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.Monitor;
import org.zkoss.zk.ui.util.SessionActivationListener;
import org.zkoss.zk.ui.util.SessionSerializationListener;

public class SimpleSession
implements Session,
SessionCtrl {
    private static final Log log = Log.lookup((Class)SimpleSession.class);
    private static final String ATTR_PRIVATE = "javax.zkoss.ui.session.private";
    private WebApp _wapp;
    private Object _navsess;
    private String _devType = "ajax";
    private Map _attrs;
    private String _remoteAddr;
    private String _remoteHost;
    private String _serverName;
    private String _localAddr;
    private String _localName;
    private DesktopCache _cache;
    private int _nextUuid;
    private long _tmLastReq = System.currentTimeMillis();
    private boolean _invalid;
    private boolean _invalidated;

    public SimpleSession(WebApp wapp, HttpSession hsess, Object request) {
        this(wapp, (Object)hsess, request);
    }

    public SimpleSession(WebApp wapp, Object navsess, Object request) {
        if (wapp == null || navsess == null) {
            throw new IllegalArgumentException();
        }
        this._wapp = wapp;
        this._navsess = navsess;
        this.cleanSessAttrs();
        if (request instanceof ServletRequest) {
            ServletRequest req = (ServletRequest)request;
            this._remoteAddr = req.getRemoteAddr();
            this._remoteHost = req.getRemoteHost();
            this._serverName = req.getServerName();
            if (Servlets.isServlet24()) {
                this._localAddr = req.getLocalAddr();
                this._localName = req.getLocalName();
            } else {
                this._localName = "";
                this._localAddr = "";
            }
        }
        this.init();
        Configuration config = this.getWebApp().getConfiguration();
        config.invokeSessionInits(this, request);
        Monitor monitor = config.getMonitor();
        if (monitor != null) {
            try {
                monitor.sessionCreated(this);
            }
            catch (Throwable ex) {
                log.error(ex);
            }
        }
    }

    private final void init() {
        this._attrs = new AttributesMap(){

            protected Enumeration getKeys() {
                return SimpleSession.this.getAttrNames();
            }

            protected Object getValue(String key) {
                return SimpleSession.this.getAttribute(key);
            }

            protected void setValue(String key, Object val) {
                SimpleSession.this.setAttribute(key, val);
            }

            protected void removeValue(String key) {
                SimpleSession.this.removeAttribute(key);
            }
        };
    }

    private final void cleanSessAttrs() {
        Object names = this.getAttribute(ATTR_PRIVATE);
        if (names instanceof Set) {
            Iterator it = ((Set)names).iterator();
            while (it.hasNext()) {
                this.rmAttr((String)it.next());
            }
        }
        this.rmAttr(ATTR_PRIVATE);
    }

    private final Enumeration getAttrNames() {
        return this._navsess instanceof HttpSession ? ((HttpSession)this._navsess).getAttributeNames() : (this._navsess != null ? ((PortletSession)this._navsess).getAttributeNames(1) : CollectionsX.EMPTY_ENUMERATION);
    }

    public String getDeviceType() {
        return this._devType;
    }

    public void setDeviceType(String deviceType) {
        if (deviceType == null || deviceType.length() == 0) {
            throw new IllegalArgumentException();
        }
        this._devType = deviceType;
    }

    public Object getAttribute(String name) {
        return this._navsess instanceof HttpSession ? ((HttpSession)this._navsess).getAttribute(name) : (this._navsess != null ? ((PortletSession)this._navsess).getAttribute(name, 1) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        if (!(this instanceof Serializable) && !(this instanceof Externalizable)) {
            boolean bStore = value instanceof Serializable || value instanceof Externalizable;
            SimpleSession simpleSession = this;
            synchronized (simpleSession) {
                this.setAttr(name, value);
                HashSet prv = this.getAttribute(ATTR_PRIVATE);
                if (bStore) {
                    if (!(prv instanceof Set)) {
                        prv = new HashSet();
                        this.setAttr(ATTR_PRIVATE, prv);
                    }
                    ((Set)prv).add(name);
                } else if (prv instanceof Set) {
                    ((Set)prv).remove(name);
                }
            }
        } else {
            this.setAttr(name, value);
        }
    }

    private void setAttr(String name, Object value) {
        if (this._navsess instanceof HttpSession) {
            ((HttpSession)this._navsess).setAttribute(name, value);
        } else if (this._navsess != null) {
            ((PortletSession)this._navsess).setAttribute(name, value, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        if (!(this instanceof Serializable) && !(this instanceof Externalizable)) {
            SimpleSession simpleSession = this;
            synchronized (simpleSession) {
                this.rmAttr(name);
                Object prv = this.getAttribute(ATTR_PRIVATE);
                if (prv instanceof Set) {
                    ((Set)prv).remove(name);
                }
            }
        } else {
            this.rmAttr(name);
        }
    }

    private void rmAttr(String name) {
        if (this._navsess instanceof HttpSession) {
            ((HttpSession)this._navsess).removeAttribute(name);
        } else if (this._navsess != null) {
            ((PortletSession)this._navsess).removeAttribute(name, 1);
        }
    }

    public Map getAttributes() {
        return this._attrs;
    }

    public String getRemoteAddr() {
        return this._remoteAddr;
    }

    public String getRemoteHost() {
        return this._remoteHost;
    }

    public String getServerName() {
        return this._serverName;
    }

    public String getLocalName() {
        return this._localName;
    }

    public String getLocalAddr() {
        return this._localAddr;
    }

    public String getClientAddr() {
        return this.getRemoteAddr();
    }

    public String getClientHost() {
        return this.getRemoteHost();
    }

    public void invalidateNow() {
        this._invalid = true;
        if (!this._invalidated) {
            this._invalidated = true;
            this.rmAttr("org.zkoss.zk.ui.renewNativeSession");
            if (this._navsess instanceof HttpSession) {
                ((HttpSession)this._navsess).invalidate();
            } else {
                ((PortletSession)this._navsess).invalidate();
            }
        }
    }

    public void setMaxInactiveInterval(int interval) {
        if (this._navsess instanceof HttpSession) {
            ((HttpSession)this._navsess).setMaxInactiveInterval(interval);
        } else if (this._navsess != null) {
            ((PortletSession)this._navsess).setMaxInactiveInterval(interval);
        }
    }

    public int getMaxInactiveInterval() {
        return this._navsess instanceof HttpSession ? ((HttpSession)this._navsess).getMaxInactiveInterval() : (this._navsess != null ? ((PortletSession)this._navsess).getMaxInactiveInterval() : -1);
    }

    public Object getNativeSession() {
        return this._navsess;
    }

    public void notifyClientRequest(boolean keepAlive) {
        long now = System.currentTimeMillis();
        if (keepAlive) {
            this._tmLastReq = now;
        } else {
            int tmout = this.getMaxInactiveInterval();
            if (tmout >= 0 && (now - this._tmLastReq) / 1000L > (long)tmout) {
                this.invalidate();
            }
        }
    }

    public final WebApp getWebApp() {
        return this._wapp;
    }

    public final void invalidate() {
        this._invalid = true;
    }

    public final boolean isInvalidated() {
        return this._invalid;
    }

    public DesktopCache getDesktopCache() {
        return this._cache;
    }

    public void setDesktopCache(DesktopCache cache) {
        this._cache = cache;
    }

    public void recover(Object nativeSession) {
        if (this._invalidated) {
            log.info("Recover an invalidated session, " + this);
        }
        this._invalid = false;
        this._invalidated = false;
        if (this._navsess == null) {
            this.sessionDidActivate((HttpSession)nativeSession);
        } else {
            this._navsess = nativeSession;
        }
    }

    public void onDestroyed() {
        this._invalid = true;
        this._invalidated = true;
        Configuration config = this.getWebApp().getConfiguration();
        config.invokeSessionCleanups(this);
        this.cleanSessAttrs();
        Monitor monitor = config.getMonitor();
        if (monitor != null) {
            try {
                monitor.sessionDestroyed(this);
            }
            catch (Throwable ex) {
                log.error(ex);
            }
        }
        this._navsess = null;
    }

    protected SimpleSession() {
    }

    protected void writeThis(ObjectOutputStream s) throws IOException {
        s.writeObject(this._remoteAddr);
        s.writeObject(this._remoteHost);
        s.writeObject(this._serverName);
        s.writeObject(this._localAddr);
        s.writeObject(this._localName);
        s.writeObject(this._cache);
        s.writeInt(this._nextUuid);
        Enumeration en = this.getAttrNames();
        while (en.hasMoreElements()) {
            String nm = (String)en.nextElement();
            this.willSerialize(this.getAttribute(nm));
        }
    }

    private void willSerialize(Object o) {
        if (o instanceof SessionSerializationListener) {
            ((SessionSerializationListener)o).willSerialize(this);
        }
    }

    protected void readThis(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.init();
        this._remoteAddr = (String)s.readObject();
        this._remoteHost = (String)s.readObject();
        this._serverName = (String)s.readObject();
        this._localAddr = (String)s.readObject();
        this._localName = (String)s.readObject();
        this._cache = (DesktopCache)s.readObject();
        this._nextUuid = s.readInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sessionWillPassivate() {
        Session old = SessionsCtrl.getCurrent();
        SessionsCtrl.setCurrent(this);
        try {
            ((WebAppCtrl)((Object)this._wapp)).sessionWillPassivate(this);
            Enumeration en = this.getAttrNames();
            while (en.hasMoreElements()) {
                String nm = (String)en.nextElement();
                this.willPassivate(this.getAttribute(nm));
            }
        }
        finally {
            SessionsCtrl.setCurrent(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sessionDidActivate(HttpSession hsess) {
        Session old = SessionsCtrl.getCurrent();
        SessionsCtrl.setCurrent(this);
        try {
            this._navsess = hsess;
            WebManager.addActivationListener(hsess.getServletContext(), new WebManagerActivationListener(){

                public void didActivate(WebManager webman) {
                    SimpleSession.this._wapp = webman.getWebApp();
                    ((WebAppCtrl)((Object)SimpleSession.this._wapp)).sessionDidActivate(SimpleSession.this);
                }
            });
            Enumeration en = this.getAttrNames();
            while (en.hasMoreElements()) {
                String nm = (String)en.nextElement();
                this.didActivate(this.getAttribute(nm));
            }
        }
        finally {
            SessionsCtrl.setCurrent(old);
        }
    }

    private void willPassivate(Object o) {
        if (o instanceof SessionActivationListener) {
            try {
                ((SessionActivationListener)o).willPassivate(this);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
    }

    private void didActivate(Object o) {
        if (o instanceof SessionActivationListener) {
            try {
                ((SessionActivationListener)o).didActivate(this);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
    }
}

