/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.ArgumentInfo;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.ExValue;

public class FunctionMapperInfo
extends ArgumentInfo {
    private final Object _mapper;

    public FunctionMapperInfo(Class cls, Map args) {
        super(args);
        FunctionMapperInfo.checkClass(cls);
        this._mapper = cls;
    }

    public FunctionMapperInfo(Class cls) {
        this(cls, null);
    }

    private static void checkClass(Class cls) {
        if (!FunctionMapper.class.isAssignableFrom(cls)) {
            throw new UiException(FunctionMapper.class + " must be implemented: " + cls);
        }
    }

    public FunctionMapperInfo(String clsnm, Map args) throws ClassNotFoundException {
        super(args);
        if (clsnm == null || clsnm.length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        if (clsnm.indexOf("${") < 0) {
            try {
                Class cls = Classes.forNameByThread((String)clsnm);
                FunctionMapperInfo.checkClass(cls);
                this._mapper = cls;
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException("Class not found: " + clsnm, ex);
            }
        } else {
            this._mapper = new ExValue(clsnm, String.class);
        }
    }

    public FunctionMapperInfo(String clsnm) throws ClassNotFoundException {
        this(clsnm, null);
    }

    public FunctionMapperInfo(FunctionMapper mapper) {
        super(null);
        if (mapper == null) {
            throw new IllegalArgumentException("null");
        }
        this._mapper = mapper;
    }

    public FunctionMapper newFunctionMapper(PageDefinition pgdef, Page page) throws Exception {
        return this.newFunctionMapper(pgdef.getEvaluator(), page);
    }

    public FunctionMapper newFunctionMapper(Evaluator eval, Page page) throws Exception {
        Class cls;
        if (this._mapper instanceof FunctionMapper) {
            return (FunctionMapper)this._mapper;
        }
        if (this._mapper instanceof ExValue) {
            String clsnm = (String)((ExValue)this._mapper).getValue(eval, page);
            if (clsnm == null || clsnm.length() == 0) {
                return null;
            }
            try {
                cls = Classes.forNameByThread((String)clsnm);
                FunctionMapperInfo.checkClass(cls);
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException("Class not found: " + clsnm + " (" + this._mapper + ")", ex);
            }
        } else {
            cls = (Class)this._mapper;
        }
        return (FunctionMapper)this.newInstance(cls, eval, page);
    }

    public String toString() {
        return "[function-mapper " + this._mapper + "]";
    }
}

