/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.servlet.ServletContext;
import org.zkoss.idom.Document;
import org.zkoss.util.resource.Loader;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.ResourceCache;
import org.zkoss.web.util.resource.ResourceCaches;
import org.zkoss.web.util.resource.ResourceLoader;
import org.zkoss.web.util.resource.ServletContextLocator;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.Parser;

public class PageDefinitions {
    private static final String ATTR_PAGE_CACHE = "org.zkoss.zk.ui.PageCache";

    public static final PageDefinition getPageDefinitionDirectly(WebApp wapp, Locator locator, String content, String extension) {
        try {
            return PageDefinitions.getPageDefinitionDirectly(wapp, locator, new StringReader(content), extension);
        }
        catch (IOException ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    public static final PageDefinition getPageDefinitionDirectly(WebApp wapp, Locator locator, Reader reader, String extension) throws IOException {
        try {
            return new Parser(wapp, locator).parse(reader, extension);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    public static final PageDefinition getPageDefinitionDirectly(WebApp wapp, Locator locator, Document doc, String extension) {
        try {
            return new Parser(wapp, locator).parse(doc, extension);
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    public static final PageDefinition getPageDefinition(WebApp wapp, Locator locator, String path) {
        wapp.getConfiguration().invokeURIInterceptors(path);
        Object ctx = wapp.getNativeContext();
        if (ctx instanceof ServletContext) {
            return (PageDefinition)ResourceCaches.get((ResourceCache)PageDefinitions.getCache(wapp), (ServletContext)((ServletContext)ctx), (String)path, (Object)locator);
        }
        throw new UnsupportedOperationException("Unknown context: " + ctx);
    }

    public static final Locator getLocator(WebApp wapp, String path) {
        if (wapp == null) {
            throw new IllegalArgumentException("null");
        }
        if (path != null && path.length() > 0 && path.charAt(0) == '/') {
            int j = path.lastIndexOf(47);
            path = j > 0 ? path.substring(0, j + 1) : "/";
        } else {
            Execution exec = Executions.getCurrent();
            if (exec != null) {
                path = exec.getDesktop().getCurrentDirectory();
            }
        }
        Object ctx = wapp.getNativeContext();
        if (ctx instanceof ServletContext) {
            return new ServletContextLocator((ServletContext)ctx, path);
        }
        throw new UnsupportedOperationException("Unknown context: " + ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ResourceCache getCache(WebApp wapp) {
        ResourceCache cache = (ResourceCache)wapp.getAttribute(ATTR_PAGE_CACHE);
        if (cache == null) {
            Class clazz = PageDefinitions.class;
            synchronized (clazz) {
                cache = (ResourceCache)wapp.getAttribute(ATTR_PAGE_CACHE);
                if (cache == null) {
                    cache = new ResourceCache((Loader)new MyLoader(wapp), 167);
                    cache.setMaxSize(1024);
                    cache.setLifetime(3600000);
                    wapp.setAttribute(ATTR_PAGE_CACHE, cache);
                }
            }
        }
        return cache;
    }

    private static class MyLoader
    extends ResourceLoader {
        private final WebApp _wapp;

        private MyLoader(WebApp wapp) {
            this._wapp = wapp;
        }

        protected Object parse(String path, File file, Object extra) throws Exception {
            Locator locator = extra != null ? (Locator)extra : PageDefinitions.getLocator(this._wapp, path);
            return new Parser(this._wapp, locator).parse(file, path);
        }

        protected Object parse(String path, URL url, Object extra) throws Exception {
            Locator locator = extra != null ? (Locator)extra : PageDefinitions.getLocator(this._wapp, path);
            return new Parser(this._wapp, locator).parse(url, path);
        }
    }
}

