/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.sys;

import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.sys.SessionCache;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;

public class SessionsCtrl
extends Sessions {
    private static final String ATTR_REQUEST_COUNT = "org.zkoss.zk.ui.sys.RequestCount";

    protected SessionsCtrl() {
    }

    public static final void setCurrent(Session sess) {
        _sess.set(sess);
    }

    public static final SessionCtrl getCurrentCtrl() {
        return (SessionCtrl)((Object)SessionsCtrl.getCurrent());
    }

    public static boolean requestEnter(Session sess) {
        Integer v = (Integer)sess.getAttribute(ATTR_REQUEST_COUNT);
        int i = v != null ? v + 1 : 1;
        int max = sess.getWebApp().getConfiguration().getSessionMaxRequests();
        if (max < 0 || i <= max) {
            sess.setAttribute(ATTR_REQUEST_COUNT, new Integer(i));
            return true;
        }
        return false;
    }

    public static void requestExit(Session sess) {
        Integer v = (Integer)sess.getAttribute(ATTR_REQUEST_COUNT);
        int i = v != null ? v - 1 : 0;
        sess.setAttribute(ATTR_REQUEST_COUNT, new Integer(i >= 0 ? i : 0));
    }

    public static final Session getSession(WebApp wapp, Object navsess) {
        SessionCache sc = ((WebAppCtrl)((Object)wapp)).getSessionCache();
        if (sc == null) {
            return null;
        }
        Session sess = sc.get(navsess);
        if (sess != null && sess.getNativeSession() != navsess) {
            ((SessionCtrl)((Object)sess)).recover(navsess);
        }
        return sess;
    }

    public static final Session newSession(WebApp wapp, Object navsess, Object request) {
        WebAppCtrl wappc = (WebAppCtrl)((Object)wapp);
        Session sess = wappc.getUiFactory().newSession(wapp, navsess, request);
        wappc.getSessionCache().put(sess);
        int v = wapp.getConfiguration().getSessionMaxInactiveInterval();
        if (v != 0) {
            sess.setMaxInactiveInterval(v);
        }
        return sess;
    }
}

