/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.xel.impl;

import java.util.Collections;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.XelException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.sys.ExecutionCtrl;

public class ExecutionResolver
implements VariableResolver {
    private final VariableResolver _parent;
    private final Execution _exec;
    private Object _self;

    public ExecutionResolver(Execution exec, VariableResolver parent) {
        if (exec == null) {
            throw new NullPointerException();
        }
        this._exec = exec;
        this._parent = parent;
    }

    public void setSelf(Object self) {
        this._self = self;
    }

    public Object getSelf() {
        return this._self;
    }

    public Object resolveVariable(String name) throws XelException {
        if (name == null || name.length() == 0) {
            return null;
        }
        switch (name.charAt(0)) {
            case 'a': {
                if (!"arg".equals(name)) break;
                return this._exec.getArg();
            }
            case 'c': {
                if (!"componentScope".equals(name)) break;
                if (this._self instanceof Component) {
                    return ((Component)this._self).getAttributes(0);
                }
                return Collections.EMPTY_MAP;
            }
            case 'd': {
                if ("desktopScope".equals(name)) {
                    return this._exec.getDesktop().getAttributes();
                }
                if (!"desktop".equals(name)) break;
                return this._exec.getDesktop();
            }
            case 'e': {
                if (!"execution".equals(name)) break;
                return this._exec;
            }
            case 'p': {
                if ("pageScope".equals(name)) {
                    if (this._self instanceof Component) {
                        return ((Component)this._self).getAttributes(2);
                    }
                    if (this._self instanceof Page) {
                        return ((Page)this._self).getAttributes();
                    }
                    Page page = ((ExecutionCtrl)((Object)this._exec)).getCurrentPage();
                    return page != null ? page.getAttributes() : Collections.EMPTY_MAP;
                }
                if (!"page".equals(name)) break;
                if (this._self instanceof Component) {
                    return ((Component)this._self).getPage();
                }
                if (this._self instanceof Page) {
                    return (Page)this._self;
                }
                return ((ExecutionCtrl)((Object)this._exec)).getCurrentPage();
            }
            case 'r': {
                if (!"requestScope".equals(name)) break;
                return this._exec.getAttributes();
            }
            case 's': {
                if ("self".equals(name)) {
                    return this._self;
                }
                if ("sessionScope".equals(name)) {
                    return this._exec.getDesktop().getSession().getAttributes();
                }
                if ("session".equals(name)) {
                    return this._exec.getDesktop().getSession();
                }
                if ("spaceOwner".equals(name)) {
                    if (this._self instanceof Component) {
                        return ((Component)this._self).getSpaceOwner();
                    }
                    if (this._self instanceof Page) {
                        return (Page)this._self;
                    }
                    return null;
                }
                if (!"spaceScope".equals(name)) break;
                if (this._self instanceof Component) {
                    return ((Component)this._self).getAttributes(1);
                }
                if (this._self instanceof Page) {
                    return ((Page)this._self).getAttributes();
                }
                return Collections.EMPTY_MAP;
            }
        }
        if (this._self instanceof Component) {
            Object o;
            Component comp = (Component)this._self;
            Page page = comp.getPage();
            if (page != null && (o = page.getZScriptVariable(comp.getNamespace(), name)) != null) {
                return o;
            }
            o = comp.getVariable(name, false);
            if (o != null) {
                return o;
            }
        } else {
            Page page = this._self instanceof Page ? (Page)this._self : ((ExecutionCtrl)((Object)this._exec)).getCurrentPage();
            if (page != null) {
                Object o = page.getZScriptVariable(name);
                if (o != null) {
                    return o;
                }
                o = page.getVariable(name);
                if (o != null) {
                    return o;
                }
            }
        }
        return this._parent != null ? this._parent.resolveVariable(name) : null;
    }

    public String toString() {
        return "[ExecutionResolver: " + this._self + ']';
    }
}

