/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au.http;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.mesg.Messages;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.Charsets;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.util.resource.ClassWebResource;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuWriter;
import org.zkoss.zk.au.AuWriters;
import org.zkoss.zk.au.CommandNotFoundException;
import org.zkoss.zk.au.http.AuDynaMediar;
import org.zkoss.zk.au.http.AuProcessor;
import org.zkoss.zk.au.http.AuUploader;
import org.zkoss.zk.au.out.AuAlert;
import org.zkoss.zk.au.out.AuObsolete;
import org.zkoss.zk.au.out.AuSendRedirect;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.I18Ns;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.FailoverManager;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.URIInfo;

public class DHtmlUpdateServlet
extends HttpServlet {
    private static final Log log = Log.lookup((Class)DHtmlUpdateServlet.class);
    private static final String ATTR_UPDATE_SERVLET = "org.zkoss.zk.au.http.updateServlet";
    private static final String ATTR_AU_PROCESSORS = "org.zkoss.zk.au.http.auProcessors";
    private boolean _compress = true;
    private ServletContext _ctx;
    private long _lastModified;
    private Map _procs = new HashMap(4);
    static /* synthetic */ Class class$org$zkoss$zk$au$http$AuProcessor;

    public static DHtmlUpdateServlet getUpdateServlet(WebApp wapp) {
        return (DHtmlUpdateServlet)((Object)((ServletContext)wapp.getNativeContext()).getAttribute(ATTR_UPDATE_SERVLET));
    }

    public void init(ServletConfig config) throws ServletException {
        String param;
        String param2;
        this._ctx = config.getServletContext();
        int j = 0;
        while ((param2 = config.getInitParameter("processor" + j++)) != null) {
            int k = param2.indexOf(61);
            if (k < 0) {
                log.warning("Ignore init-param: illegal format, " + param2);
                continue;
            }
            String prefix = param2.substring(0, k).trim();
            String clsnm = param2.substring(k + 1).trim();
            try {
                this.addAuProcessor(prefix, (AuProcessor)Classes.newInstanceByThread((String)clsnm));
            }
            catch (ClassNotFoundException ex) {
                log.warning("Ignore init-param: class not found, " + clsnm);
            }
            catch (ClassCastException ex) {
                log.warning("Ignore: " + clsnm + " not implement " + (class$org$zkoss$zk$au$http$AuProcessor == null ? DHtmlUpdateServlet.class$("org.zkoss.zk.au.http.AuProcessor") : class$org$zkoss$zk$au$http$AuProcessor));
            }
            catch (Throwable ex) {
                log.warning("Ignore init-param: failed to add an AU processor, " + param2, ex);
            }
        }
        WebManager webman = WebManager.getWebManager(this._ctx);
        WebApp wapp = webman.getWebApp();
        Map procs = (Map)wapp.getAttribute(ATTR_AU_PROCESSORS);
        if (procs != null) {
            Iterator it = procs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                this.addAuProcessor((String)me.getKey(), (AuProcessor)me.getValue());
            }
            wapp.removeAttribute(ATTR_AU_PROCESSORS);
        }
        boolean bl = this._compress = (param = config.getInitParameter("compress")) == null || param.length() == 0 || "true".equals(param);
        if (!this._compress) {
            webman.getClassWebResource().setCompress(null);
        }
        if (this.getAuProcessor("/upload") == null) {
            try {
                this.addAuProcessor("/upload", new AuUploader());
            }
            catch (Throwable ex) {
                String msg = " Make sure commons-fileupload.jar is installed.";
                log.warningBriefly("Failed to configure fileupload. Make sure commons-fileupload.jar is installed.", ex);
                this.addAuProcessor("/upload", new AuProcessor(){

                    public void process(Session sess, ServletContext ctx, HttpServletRequest request, HttpServletResponse response, String pi) throws ServletException, IOException {
                        if (sess != null) {
                            throw new ServletException("Failed to upload. Make sure commons-fileupload.jar is installed.");
                        }
                    }
                });
            }
        }
        if (this.getAuProcessor("/view") == null) {
            this.addAuProcessor("/view", new AuDynaMediar());
        }
        this._ctx.setAttribute(ATTR_UPDATE_SERVLET, (Object)this);
    }

    public ServletContext getServletContext() {
        return this._ctx;
    }

    public static final AuProcessor getAuProcessor(WebApp wapp, String prefix) {
        DHtmlUpdateServlet upsv = DHtmlUpdateServlet.getUpdateServlet(wapp);
        return upsv != null ? upsv.getAuProcessor(prefix) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final AuProcessor addAuProcessor(WebApp wapp, String prefix, AuProcessor processor) {
        DHtmlUpdateServlet upsv = DHtmlUpdateServlet.getUpdateServlet(wapp);
        if (upsv == null) {
            Class clazz = DHtmlUpdateServlet.class;
            synchronized (clazz) {
                upsv = DHtmlUpdateServlet.getUpdateServlet(wapp);
                if (upsv == null) {
                    DHtmlUpdateServlet.checkAuProcesor(prefix, processor);
                    HashMap<String, AuProcessor> procs = (HashMap<String, AuProcessor>)wapp.getAttribute(ATTR_AU_PROCESSORS);
                    if (procs == null) {
                        procs = new HashMap<String, AuProcessor>(4);
                        wapp.setAttribute(ATTR_AU_PROCESSORS, procs);
                    }
                    return procs.put(prefix, processor);
                }
            }
        }
        return upsv.addAuProcessor(prefix, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuProcessor addAuProcessor(String prefix, AuProcessor processor) {
        AuProcessor old;
        DHtmlUpdateServlet.checkAuProcesor(prefix, processor);
        if (this._procs.get(prefix) == processor) {
            return processor;
        }
        DHtmlUpdateServlet dHtmlUpdateServlet = this;
        synchronized (dHtmlUpdateServlet) {
            HashMap<String, AuProcessor> ps = new HashMap<String, AuProcessor>(this._procs);
            old = ps.put(prefix, processor);
            this._procs = ps;
        }
        return old;
    }

    private static void checkAuProcesor(String prefix, AuProcessor processor) {
        if (prefix == null || !prefix.startsWith("/") || prefix.length() < 2 || processor == null) {
            throw new IllegalArgumentException();
        }
        if ("/web".equalsIgnoreCase(prefix)) {
            throw new IllegalArgumentException("/web is reserved");
        }
    }

    public AuProcessor getAuProcessor(String prefix) {
        return (AuProcessor)this._procs.get(prefix);
    }

    private AuProcessor getAuProcessorByPath(String path) {
        Iterator it = this._procs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            if (!path.startsWith((String)me.getKey())) continue;
            return (AuProcessor)me.getValue();
        }
        return null;
    }

    protected long getLastModified(HttpServletRequest request) {
        String ext;
        String pi = Https.getThisPathInfo((ServletRequest)request);
        if (pi != null && pi.startsWith("/web") && pi.indexOf(42) < 0 && !Servlets.isIncluded((ServletRequest)request) && ((ext = Servlets.getExtension((String)pi, (boolean)false)) == null || this.getClassWebResource().getExtendlet(ext) == null)) {
            if (this._lastModified == 0L) {
                this._lastModified = new Date().getTime();
            }
            return this._lastModified;
        }
        return -1L;
    }

    private ClassWebResource getClassWebResource() {
        return WebManager.getWebManager(this._ctx).getClassWebResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean withpi;
        String pi = Https.getThisPathInfo((ServletRequest)request);
        boolean bl = withpi = pi != null && pi.length() != 0;
        if (withpi && pi.startsWith("/web")) {
            ClassWebResource cwr = this.getClassWebResource();
            HttpSession sess = DHtmlUpdateServlet.shallSession(cwr, pi) ? request.getSession(false) : null;
            Object old = sess != null ? I18Ns.setup(sess, (ServletRequest)request, (ServletResponse)response, "UTF-8") : Charsets.setup((HttpSession)sess, (ServletRequest)request, (ServletResponse)response, (String)"UTF-8");
            try {
                cwr.service(request, response, pi.substring("/web".length()));
            }
            finally {
                if (sess != null) {
                    I18Ns.cleanup((ServletRequest)request, old);
                } else {
                    Charsets.cleanup((ServletRequest)request, (Object)old);
                }
            }
            return;
        }
        Session sess = WebManager.getSession(this._ctx, request, false);
        if (sess == null) {
            if (withpi) {
                AuProcessor proc = this.getAuProcessorByPath(pi);
                if (proc != null) {
                    try {
                        proc.process(null, this._ctx, request, response, pi);
                    }
                    catch (AbstractMethodError ex) {}
                }
            } else {
                response.setIntHeader("ZK-Error", 410);
                String dtid = request.getParameter("dtid");
                if (dtid != null) {
                    this.sessionTimeout(request, response, WebManager.getWebManager(this._ctx).getWebApp().getConfiguration(), dtid);
                }
            }
            return;
        }
        Object old = I18Ns.setup(sess, (ServletRequest)request, (ServletResponse)response, "UTF-8");
        try {
            if (withpi) {
                AuProcessor proc = this.getAuProcessorByPath(pi);
                if (proc != null) {
                    proc.process(sess, this._ctx, request, response, pi);
                    return;
                }
                response.setIntHeader("ZK-Error", 404);
                log.warning("Unknown path info: " + pi);
            } else {
                this.process(sess, request, response);
            }
        }
        finally {
            I18Ns.cleanup((ServletRequest)request, old);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private static boolean shallSession(ClassWebResource cwr, String pi) {
        return cwr.getExtendlet(Servlets.getExtension((String)pi, (boolean)false)) != null;
    }

    protected void process(Session sess, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String dtid;
        String errClient = request.getHeader("ZK-Error-Report");
        if (errClient != null && log.debugable()) {
            log.debug("Error found at client: " + errClient + "\n" + Servlets.getDetail((ServletRequest)request));
        }
        if ((dtid = request.getParameter("dtid")) == null) {
            if (log.debugable()) {
                String msg = "Incomplete request\n" + Servlets.getDetail((ServletRequest)request);
                log.debug(msg);
            }
            response.sendError(467, "Incomplete request");
            return;
        }
        WebApp wapp = sess.getWebApp();
        WebAppCtrl wappc = (WebAppCtrl)((Object)wapp);
        Configuration config = wapp.getConfiguration();
        Desktop desktop = wappc.getDesktopCache(sess).getDesktopIfAny(dtid);
        if (desktop == null) {
            String cmdId = request.getParameter("cmd.0");
            if (!"rmDesktop".equals(cmdId)) {
                desktop = this.recover(sess, request, response, wappc, dtid);
            }
            if (desktop == null) {
                this.sessionTimeout(request, response, config, dtid);
                return;
            }
        }
        WebManager.setDesktop(request, desktop);
        String sid = request.getHeader("ZK-SID");
        if (sid != null) {
            response.setHeader("ZK-SID", sid);
        }
        LinkedList<AuRequest> aureqs = new LinkedList<AuRequest>();
        boolean timerKeepAlive = config.isTimerKeepAlive();
        boolean keepAlive = false;
        try {
            String cmdId;
            int j = 0;
            while ((cmdId = request.getParameter("cmd." + j)) != null) {
                keepAlive = keepAlive || (timerKeepAlive || !"onTimer".equals(cmdId)) && !"dummy".equals(cmdId);
                String uuid = request.getParameter("uuid." + j);
                String[] data = request.getParameterValues("data." + j);
                if (data != null) {
                    int k = data.length;
                    while (--k >= 0) {
                        if (!"_z~nil".equals(data[k])) continue;
                        data[k] = null;
                    }
                }
                aureqs.add(uuid == null || uuid.length() == 0 ? new AuRequest(desktop, AuRequest.getCommand(cmdId), data) : new AuRequest(desktop, uuid, cmdId, data));
                ++j;
            }
        }
        catch (Throwable ex) {
            String errmsg = Exceptions.getMessage((Throwable)ex);
            if (ex instanceof CommandNotFoundException) {
                log.debug(errmsg);
            } else {
                log.warningBriefly(ex);
            }
            DHtmlUpdateServlet.responseError(request, response, errmsg);
            return;
        }
        if (aureqs.isEmpty()) {
            String errmsg = "Illegal request: cmd required";
            log.debug("Illegal request: cmd required");
            DHtmlUpdateServlet.responseError(request, response, "Illegal request: cmd required");
            return;
        }
        sess.setAttribute("_z_gae_fix", new Integer(0));
        ((SessionCtrl)((Object)sess)).notifyClientRequest(keepAlive);
        ExecutionImpl exec = new ExecutionImpl(this._ctx, request, response, desktop, null);
        if (sid != null) {
            ((ExecutionCtrl)exec).setRequestId(sid);
        }
        AuWriter out = AuWriters.newInstance();
        out.setCompress(this._compress);
        out.open(request, response, desktop.getDevice().isSupported(1) ? DHtmlUpdateServlet.getProcessTimeout(config.getResendDelay()) : 0);
        wappc.getUiEngine().execUpdate(exec, aureqs, out);
        out.close(request, response);
    }

    private static int getProcessTimeout(int resendDelay) {
        if (resendDelay > 0 && (resendDelay = resendDelay * 3 >> 2) <= 0) {
            resendDelay = 1;
        }
        return resendDelay;
    }

    private void sessionTimeout(HttpServletRequest request, HttpServletResponse response, Configuration config, String dtid) throws ServletException, IOException {
        String cmdId;
        String sid = request.getHeader("ZK-SID");
        if (sid != null) {
            response.setHeader("ZK-SID", sid);
        }
        AuWriter out = AuWriters.newInstance().open(request, response, 0);
        int j = 0;
        while ((cmdId = request.getParameter("cmd." + j)) != null) {
            if (!("rmDesktop".equals(cmdId) || "onRender".equals(cmdId) || "onTimer".equals(cmdId) || "onClientInfo".equals(cmdId) || "onMove".equals(cmdId) || "onSize".equals(cmdId) || "onZIndex".equals(cmdId) || "dummy".equals(cmdId) && !DHtmlUpdateServlet.isDummyTimeout(request.getParameterValues("data." + j)))) {
                AuResponse resp;
                String uri;
                URIInfo ui = config.getTimeoutURI(DHtmlUpdateServlet.getDeviceType(request));
                String string = uri = ui != null ? ui.uri : null;
                if (uri != null) {
                    if (uri.length() != 0) {
                        uri = Encodes.encodeURL((ServletContext)this._ctx, (ServletRequest)request, (ServletResponse)response, (String)uri);
                    }
                    resp = new AuSendRedirect(uri, null);
                } else {
                    resp = new AuObsolete(dtid, Messages.get((int)MZk.UPDATE_OBSOLETE_PAGE, (Object)dtid));
                }
                out.write(resp);
                break;
            }
            ++j;
        }
        out.close(request, response);
    }

    private static boolean isDummyTimeout(String[] data) {
        return data != null && data.length > 0 && "timeout".equals(data[0]);
    }

    private static String getDeviceType(HttpServletRequest request) {
        String agt = request.getHeader("user-agent");
        if (agt != null && agt.length() > 0) {
            try {
                return Devices.getDeviceByClient(agt).getType();
            }
            catch (Throwable ex) {
                log.warning("Unknown device for " + agt);
            }
        }
        return "ajax";
    }

    private Desktop recover(Session sess, HttpServletRequest request, HttpServletResponse response, WebAppCtrl wappc, String dtid) {
        block5: {
            FailoverManager failover = wappc.getFailoverManager();
            if (failover != null) {
                Desktop desktop = null;
                try {
                    if (failover.isRecoverable(sess, dtid)) {
                        desktop = WebManager.getWebManager(this._ctx).getDesktop(sess, (ServletRequest)request, (ServletResponse)response, null, true);
                        if (desktop == null) {
                            throw new IllegalStateException("sendRediect or forward not allowed in recovering");
                        }
                        wappc.getUiEngine().execRecover(new ExecutionImpl(this._ctx, request, response, desktop, null), failover);
                        return desktop;
                    }
                }
                catch (Throwable ex) {
                    log.error("Unable to recover " + dtid, ex);
                    if (desktop == null) break block5;
                    ((DesktopCtrl)((Object)desktop)).recoverDidFail(ex);
                }
            }
        }
        return null;
    }

    private static void responseError(HttpServletRequest request, HttpServletResponse response, String errmsg) throws IOException {
        AuWriter out = AuWriters.newInstance().open(request, response, 0);
        out.write(new AuAlert(errmsg));
        out.close(request, response);
    }
}

