/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.fn;

import java.util.Calendar;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.lang.Library;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.fn.ZkFns;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;

public class JspFns {
    private static final Log log = Log.lookup((Class)JspFns.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String outZkHtmlTags(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, String deviceType) {
        Execution old = Executions.getCurrent();
        ExecutionImpl exec = new ExecutionImpl(ctx, request, response, null, null);
        ExecutionsCtrl.setCurrent(exec);
        ((ExecutionCtrl)exec).onActivate();
        try {
            String string = ZkFns.outZkHtmlTags(exec, WebManager.getWebManager(ctx).getWebApp(), deviceType != null ? deviceType : "ajax");
            return string;
        }
        finally {
            ((ExecutionCtrl)exec).onDeactivate();
            ExecutionsCtrl.setCurrent(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String outDeviceStyleSheets(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, String deviceType) {
        Execution old = Executions.getCurrent();
        ExecutionImpl exec = new ExecutionImpl(ctx, request, response, null, null);
        ExecutionsCtrl.setCurrent(exec);
        ((ExecutionCtrl)exec).onActivate();
        try {
            String string = ZkFns.outDeviceStyleSheets(exec, WebManager.getWebManager(ctx).getWebApp(), deviceType != null ? deviceType : "ajax");
            return string;
        }
        finally {
            ((ExecutionCtrl)exec).onDeactivate();
            ExecutionsCtrl.setCurrent(old);
        }
    }

    public static void setCacheControl(HttpServletResponse response, String prop, int hours) {
        if (prop == null || !"false".equals(Library.getProperty((String)prop))) {
            response.setHeader("Cache-Control", "public, max-age=" + hours * 3600);
            Calendar cal = Calendar.getInstance();
            cal.add(10, hours);
            response.setDateHeader("Expires", cal.getTime().getTime());
        }
    }

    public static void setCSSCacheControl(HttpServletResponse response) {
        int hours = 8760;
        String PROP = "org.zkoss.web.classWebResource.cache.CSS.hours";
        String s = Library.getProperty((String)"org.zkoss.web.classWebResource.cache.CSS.hours");
        if (s != null) {
            try {
                hours = Integer.parseInt(s);
                if (hours <= 0) {
                    return;
                }
            }
            catch (Throwable ex) {
                log.warning("Ingored property org.zkoss.web.classWebResource.cache.CSS.hours: an integer is expected");
            }
        }
        JspFns.setCacheControl(response, "org.zkoss.web.classWebResource.cache", hours);
    }

    public static void setCWRCacheControl(HttpServletResponse response) {
        JspFns.setCacheControl(response, "org.zkoss.web.classWebResource.cache", 8760);
    }
}

