/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.zkoss.idom.Document;
import org.zkoss.lang.Classes;
import org.zkoss.util.CollectionsX;
import org.zkoss.util.logging.Log;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Path;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.xel.Evaluator;

public class Components {
    private static final Log log = Log.lookup((Class)Components.class);
    private static final Set IMPLICIT_NAMES = new HashSet();
    public static final Exec EXECUTION_PROXY;
    public static final RequestScope REQUEST_SCOPE_PROXY;
    static /* synthetic */ Class class$java$lang$Object;

    protected Components() {
    }

    public static void sort(List list, Comparator cpr) {
        Components.sort(list, 0, list.size(), cpr);
    }

    public static void replace(Component oldc, Component newc) {
        Component p = oldc.getParent();
        Component sib = oldc.getNextSibling();
        if (p != null) {
            oldc.detach();
            p.insertBefore(newc, sib);
        } else {
            Page page = oldc.getPage();
            if (page == null) {
                throw new IllegalArgumentException("Neither child nor attached, " + oldc);
            }
            oldc.detach();
            if (newc.getParent() != null) {
                newc.detach();
            }
            newc.setPageBefore(page, sib);
        }
    }

    public static void replaceChildren(Component parent, Collection newChildren) {
        List children = parent.getChildren();
        children.clear();
        children.addAll(newChildren);
    }

    public static void sort(List list, int from, int to, Comparator cpr) {
        Object[] ary = CollectionsX.toArray((Collection)list, (int)from, (int)to);
        Arrays.sort(ary, cpr);
        ListIterator it = list.listIterator(from);
        int j = 0;
        int k = to - from;
        while (it.hasNext() && --k >= 0) {
            if (it.next() != ary[j]) {
                it.remove();
                if (!it.hasNext() || --k < 0) break;
                if (it.next() != ary[j]) {
                    it.previous();
                    ++k;
                    break;
                }
            }
            ++j;
        }
        while (it.hasNext() && --k >= 0) {
            it.next();
            it.remove();
        }
        while (j < ary.length) {
            list.add(from + j, ary[j]);
            ++j;
        }
    }

    public static Component getRoot(Component comp) {
        if (comp == null) {
            return null;
        }
        Component p;
        while ((p = comp.getParent()) != null) {
            comp = p;
        }
        return comp;
    }

    public static boolean isAncestor(Component node1, Component node2) {
        while (node2 != null) {
            if (node1 == node2) {
                return true;
            }
            node2 = node2.getParent();
        }
        return false;
    }

    public static void removeAllChildren(Component comp) {
        List children = comp.getChildren();
        if (children.isEmpty()) {
            return;
        }
        Iterator it = new ArrayList(children).iterator();
        while (it.hasNext()) {
            ((Component)it.next()).setParent(null);
        }
    }

    public static boolean isRealVisible(Component comp) {
        while (comp != null) {
            if (!comp.isVisible()) {
                return false;
            }
            comp = comp.getParent();
        }
        return true;
    }

    public static Collection getVisibleChildren(Component comp) {
        final List children = comp.getChildren();
        return new AbstractCollection(){

            public int size() {
                int size = 0;
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    if (!((Component)it.next()).isVisible()) continue;
                    ++size;
                }
                return size;
            }

            public Iterator iterator() {
                return new Iterator(){
                    final Iterator _it;
                    Component _next;
                    {
                        this._it = children.iterator();
                    }

                    public boolean hasNext() {
                        if (this._next != null) {
                            return true;
                        }
                        this._next = this.getNextVisible(false);
                        return this._next != null;
                    }

                    public Object next() {
                        if (this._next != null) {
                            Component c = this._next;
                            this._next = null;
                            return c;
                        }
                        return this.getNextVisible(true);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private Component getNextVisible(boolean blind) {
                        while (blind || this._it.hasNext()) {
                            Component c = (Component)this._it.next();
                            if (!c.isVisible()) continue;
                            return c;
                        }
                        return null;
                    }
                };
            }
        };
    }

    public static final int getScope(String scope) {
        if ("component".equals(scope)) {
            return 0;
        }
        if ("space".equals(scope)) {
            return 1;
        }
        if ("page".equals(scope)) {
            return 2;
        }
        if ("desktop".equals(scope)) {
            return 3;
        }
        if ("session".equals(scope)) {
            return 4;
        }
        if ("application".equals(scope)) {
            return 5;
        }
        if ("request".equals(scope)) {
            return 6;
        }
        throw new IllegalArgumentException("Unknown scope: " + scope);
    }

    public static final String scopeToString(int scope) {
        switch (scope) {
            case 0: {
                return "component";
            }
            case 1: {
                return "space";
            }
            case 2: {
                return "page";
            }
            case 3: {
                return "desktop";
            }
            case 4: {
                return "session";
            }
            case 5: {
                return "application";
            }
            case 6: {
                return "request";
            }
        }
        throw new IllegalArgumentException("Unknown scope: " + scope);
    }

    public static final boolean isAutoId(String id) {
        return ComponentsCtrl.isAutoId(id);
    }

    public static final String componentToPath(Component comp, Component ref) {
        if (comp == null) {
            return null;
        }
        if (comp == ref) {
            return ".";
        }
        String id = comp.getId();
        if (!(comp instanceof IdSpace) && Components.isAutoId(id)) {
            throw new UnsupportedOperationException("comp must be assigned with ID or a space owner: " + comp);
        }
        StringBuffer sb = new StringBuffer(128);
        IdSpace space = ref.getSpaceOwner();
        while (comp != space) {
            Component parent;
            if (space.getFellowIfAny(id) == comp) {
                if (sb.length() > 0) {
                    sb.append('/');
                }
                return sb.append(id).toString();
            }
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append("..");
            Component component = parent = space instanceof Component ? ((Component)((Object)space)).getParent() : null;
            if (parent == null) {
                throw new UnsupportedOperationException("Unable to locate " + comp + " from " + ref);
            }
            space = parent.getSpaceOwner();
        }
        return sb.toString();
    }

    public static final Component pathToComponent(String path, Component ref) {
        if (path == null) {
            return null;
        }
        if (".".equals(path)) {
            return ref;
        }
        if ("".equals(path)) {
            IdSpace owner = ref.getSpaceOwner();
            if (!(owner instanceof Component)) {
                throw new IllegalStateException("The component is moved after serialized: " + ref);
            }
            return (Component)((Object)owner);
        }
        return Path.getComponent(ref.getSpaceOwner(), path);
    }

    public static final void wireFellows(IdSpace idspace, Object controller) {
        new Wire(controller).wireFellows(idspace);
    }

    public static final void wireFellows(IdSpace idspace, Object controller, char separator) {
        new Wire(controller, separator).wireFellows(idspace);
    }

    public static final void wireVariables(Component comp, Object controller) {
        new Wire(controller).wireVariables(comp);
    }

    public static final void wireVariables(Component comp, Object controller, char separator) {
        new Wire(controller, separator).wireVariables(comp);
    }

    public static final void wireVariables(Page page, Object controller) {
        new Wire(controller).wireVariables(page);
    }

    public static final void wireVariables(Page page, Object controller, char separator) {
        new Wire(controller, separator).wireVariables(page);
    }

    public static final void wireController(Component comp, Object controller) {
        new Wire(controller).wireController(comp, comp.getId());
    }

    public static final void wireController(Component comp, Object controller, char separator) {
        new Wire(controller, separator).wireController(comp, comp.getId());
    }

    public static void addForwards(Component comp, Object controller) {
        Components.addForwards(comp, controller, '$');
    }

    public static void addForwards(Component comp, Object controller, char separator) {
        Class<?> cls = controller.getClass();
        Method[] mtds = cls.getMethods();
        block0: for (int j = 0; j < mtds.length; ++j) {
            Method md = mtds[j];
            String mdname = md.getName();
            if (mdname.length() <= 5 || !mdname.startsWith("on") || !Character.isUpperCase(mdname.charAt(2))) continue;
            Component xcomp = comp;
            int k = 0;
            do {
                if ((k = mdname.lastIndexOf(separator)) < 3) continue;
                String srcevt = mdname.substring(0, k);
                if (k + 1 < mdname.length()) {
                    String srccompid = mdname.substring(k + 1);
                    Object srccomp = xcomp.getVariable(srccompid, false);
                    if (srccomp == null || !(srccomp instanceof Component)) {
                        if (!log.debugable()) continue block0;
                        log.debug("Cannot find the associated component to forward event: " + mdname);
                        continue block0;
                    }
                    ((Component)srccomp).addForward(srcevt, xcomp, mdname);
                    xcomp = (Component)srccomp;
                    mdname = srcevt;
                    continue;
                }
                throw new UiException("Illegal event method name(component id not specified or consecutive '" + separator + "'): " + md.getName());
            } while (k >= 3);
        }
    }

    public static boolean isImplicit(String id) {
        return IMPLICIT_NAMES.contains(id);
    }

    public static Object getImplicit(Component comp, String fdname) {
        if ("self".equals(fdname)) {
            return comp;
        }
        if ("spaceOwner".equals(fdname)) {
            return comp.getSpaceOwner();
        }
        if ("page".equals(fdname)) {
            return Components.getPage(comp);
        }
        if ("desktop".equals(fdname)) {
            return Components.getDesktop(comp);
        }
        if ("session".equals(fdname)) {
            return Components.getSession(comp);
        }
        if ("application".equals(fdname)) {
            return Components.getWebApp(comp);
        }
        if ("componentScope".equals(fdname)) {
            return comp.getAttributes();
        }
        if ("spaceScope".equals(fdname)) {
            IdSpace spaceOwner = comp.getSpaceOwner();
            return spaceOwner instanceof Page ? ((Page)spaceOwner).getAttributes() : (spaceOwner instanceof Component ? ((Component)((Object)spaceOwner)).getAttributes() : Collections.EMPTY_MAP);
        }
        if ("pageScope".equals(fdname)) {
            Page page = Components.getPage(comp);
            return page != null ? page.getAttributes() : Collections.EMPTY_MAP;
        }
        if ("desktopScope".equals(fdname)) {
            Desktop dt = Components.getDesktop(comp);
            return dt != null ? dt.getAttributes() : Collections.EMPTY_MAP;
        }
        if ("sessionScope".equals(fdname)) {
            Session sess = Components.getSession(comp);
            return sess != null ? sess.getAttributes() : Collections.EMPTY_MAP;
        }
        if ("applicationScope".equals(fdname)) {
            WebApp app = Components.getWebApp(comp);
            return app != null ? app.getAttributes() : Collections.EMPTY_MAP;
        }
        if ("requestScope".equals(fdname)) {
            return REQUEST_SCOPE_PROXY;
        }
        if ("execution".equals(fdname)) {
            return EXECUTION_PROXY;
        }
        if ("arg".equals(fdname)) {
            Execution exec = Executions.getCurrent();
            return exec != null ? exec.getArg() : null;
        }
        if ("param".equals(fdname)) {
            Execution exec = Executions.getCurrent();
            return exec != null ? exec.getParameterMap() : null;
        }
        return null;
    }

    private static Desktop getDesktop(Component comp) {
        Desktop dt = comp.getDesktop();
        if (dt != null) {
            return dt;
        }
        Execution exec = Executions.getCurrent();
        return exec != null ? exec.getDesktop() : null;
    }

    private static WebApp getWebApp(Component comp) {
        Desktop dt = Components.getDesktop(comp);
        return dt != null ? dt.getWebApp() : null;
    }

    private static Session getSession(Component comp) {
        Desktop dt = Components.getDesktop(comp);
        return dt != null ? dt.getSession() : null;
    }

    private static Page getPage(Component comp) {
        Page page = comp.getPage();
        if (page != null) {
            return page;
        }
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            Collection pgs;
            page = ((ExecutionCtrl)((Object)exec)).getCurrentPage();
            if (page != null) {
                return page;
            }
            Desktop dt = exec.getDesktop();
            if (dt != null && (pgs = dt.getPages()) != null && !pgs.isEmpty()) {
                return (Page)pgs.iterator().next();
            }
        }
        return null;
    }

    public static Object getImplicit(Page page, String fdname) {
        if ("self".equals(fdname)) {
            return page;
        }
        if ("spaceOwner".equals(fdname)) {
            return page;
        }
        if ("page".equals(fdname)) {
            return page;
        }
        if ("desktop".equals(fdname)) {
            return page.getDesktop();
        }
        if ("session".equals(fdname)) {
            return page.getDesktop().getSession();
        }
        if ("application".equals(fdname)) {
            return page.getDesktop().getWebApp();
        }
        if ("componentScope".equals(fdname)) {
            return new HashMap(0);
        }
        if ("spaceScope".equals(fdname)) {
            return page.getAttributes();
        }
        if ("pageScope".equals(fdname)) {
            return page.getAttributes();
        }
        if ("desktopScope".equals(fdname)) {
            return page.getDesktop().getAttributes();
        }
        if ("sessionScope".equals(fdname)) {
            return page.getDesktop().getSession().getAttributes();
        }
        if ("applicationScope".equals(fdname)) {
            return page.getDesktop().getWebApp().getAttributes();
        }
        if ("requestScope".equals(fdname)) {
            return REQUEST_SCOPE_PROXY;
        }
        if ("execution".equals(fdname)) {
            return EXECUTION_PROXY;
        }
        if ("arg".equals(fdname)) {
            Execution exec = Executions.getCurrent();
            return exec != null ? exec.getArg() : null;
        }
        if ("param".equals(fdname)) {
            Execution exec = Executions.getCurrent();
            return exec != null ? exec.getParameterMap() : null;
        }
        return null;
    }

    static {
        IMPLICIT_NAMES.add("application");
        IMPLICIT_NAMES.add("applicationScope");
        IMPLICIT_NAMES.add("arg");
        IMPLICIT_NAMES.add("componentScope");
        IMPLICIT_NAMES.add("desktop");
        IMPLICIT_NAMES.add("desktopScope");
        IMPLICIT_NAMES.add("execution");
        IMPLICIT_NAMES.add("event");
        IMPLICIT_NAMES.add("self");
        IMPLICIT_NAMES.add("session");
        IMPLICIT_NAMES.add("sessionScope");
        IMPLICIT_NAMES.add("spaceOwner");
        IMPLICIT_NAMES.add("spaceScope");
        IMPLICIT_NAMES.add("page");
        IMPLICIT_NAMES.add("pageScope");
        IMPLICIT_NAMES.add("requestScope");
        IMPLICIT_NAMES.add("param");
        EXECUTION_PROXY = new Exec();
        REQUEST_SCOPE_PROXY = new RequestScope();
    }

    private static class RequestScope
    implements Map {
        private RequestScope() {
        }

        protected Map req() {
            return Executions.getCurrent().getAttributes();
        }

        public void clear() {
            this.req().clear();
        }

        public boolean containsKey(Object key) {
            return this.req().containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.req().containsValue(value);
        }

        public Set entrySet() {
            return this.req().entrySet();
        }

        public Object get(Object key) {
            return this.req().get(key);
        }

        public boolean isEmpty() {
            return this.req().isEmpty();
        }

        public Set keySet() {
            return this.req().keySet();
        }

        public Object put(Object key, Object value) {
            return this.req().put(key, value);
        }

        public void putAll(Map arg0) {
            this.req().putAll(arg0);
        }

        public Object remove(Object key) {
            return this.req().remove(key);
        }

        public int size() {
            return this.req().size();
        }

        public Collection values() {
            return this.req().values();
        }
    }

    private static class Exec
    implements Execution {
        private Exec() {
        }

        private static final Execution exec() {
            return Executions.getCurrent();
        }

        public void addAuResponse(String key, AuResponse response) {
            Exec.exec().addAuResponse(key, response);
        }

        public Component createComponents(PageDefinition pagedef, Component parent, Map arg) {
            return Exec.exec().createComponents(pagedef, parent, arg);
        }

        public Component createComponents(String uri, Component parent, Map arg) {
            return Exec.exec().createComponents(uri, parent, arg);
        }

        public Component[] createComponents(PageDefinition pagedef, Map arg) {
            return Exec.exec().createComponents(pagedef, arg);
        }

        public Component[] createComponents(String uri, Map arg) {
            return Exec.exec().createComponents(uri, arg);
        }

        public Component createComponentsDirectly(String content, String extension, Component parent, Map arg) {
            return Exec.exec().createComponentsDirectly(content, extension, parent, arg);
        }

        public Component createComponentsDirectly(Document content, String extension, Component parent, Map arg) {
            return Exec.exec().createComponentsDirectly(content, extension, parent, arg);
        }

        public Component createComponentsDirectly(Reader reader, String extension, Component parent, Map arg) throws IOException {
            return Exec.exec().createComponentsDirectly(reader, extension, parent, arg);
        }

        public Component[] createComponentsDirectly(String content, String extension, Map arg) {
            return Exec.exec().createComponentsDirectly(content, extension, arg);
        }

        public Component[] createComponentsDirectly(Document content, String extension, Map arg) {
            return Exec.exec().createComponentsDirectly(content, extension, arg);
        }

        public Component[] createComponentsDirectly(Reader reader, String extension, Map arg) throws IOException {
            return Exec.exec().createComponentsDirectly(reader, extension, arg);
        }

        public String encodeURL(String uri) {
            return Exec.exec().encodeURL(uri);
        }

        public Object evaluate(Component comp, String expr, Class expectedType) {
            return Exec.exec().evaluate(comp, expr, expectedType);
        }

        public Object evaluate(Page page, String expr, Class expectedType) {
            return Exec.exec().evaluate(page, expr, expectedType);
        }

        public void forward(Writer writer, String page, Map params, int mode) throws IOException {
            Exec.exec().forward(writer, page, params, mode);
        }

        public void forward(String page) throws IOException {
            Exec.exec().forward(page);
        }

        public Map getArg() {
            return Exec.exec().getArg();
        }

        public Object getAttribute(String name) {
            return Exec.exec().getAttribute(name);
        }

        public Map getAttributes() {
            return Exec.exec().getAttributes();
        }

        public String getContextPath() {
            return Exec.exec().getContextPath();
        }

        public Desktop getDesktop() {
            return Exec.exec().getDesktop();
        }

        public Evaluator getEvaluator(Page page, Class expfcls) {
            return Exec.exec().getEvaluator(page, expfcls);
        }

        public Evaluator getEvaluator(Component comp, Class expfcls) {
            return Exec.exec().getEvaluator(comp, expfcls);
        }

        public String getLocalAddr() {
            return Exec.exec().getLocalAddr();
        }

        public String getLocalName() {
            return Exec.exec().getLocalName();
        }

        public int getLocalPort() {
            return Exec.exec().getLocalPort();
        }

        public Object getNativeRequest() {
            return Exec.exec().getNativeRequest();
        }

        public Object getNativeResponse() {
            return Exec.exec().getNativeResponse();
        }

        public PageDefinition getPageDefinition(String uri) {
            return Exec.exec().getPageDefinition(uri);
        }

        public PageDefinition getPageDefinitionDirectly(String content, String extension) {
            return Exec.exec().getPageDefinitionDirectly(content, extension);
        }

        public PageDefinition getPageDefinitionDirectly(Document content, String extension) {
            return Exec.exec().getPageDefinitionDirectly(content, extension);
        }

        public PageDefinition getPageDefinitionDirectly(Reader reader, String extension) throws IOException {
            return Exec.exec().getPageDefinitionDirectly(reader, extension);
        }

        public String getParameter(String name) {
            return Exec.exec().getParameter(name);
        }

        public Map getParameterMap() {
            return Exec.exec().getParameterMap();
        }

        public String[] getParameterValues(String name) {
            return Exec.exec().getParameterValues(name);
        }

        public String getRemoteAddr() {
            return Exec.exec().getRemoteAddr();
        }

        public String getRemoteHost() {
            return Exec.exec().getRemoteHost();
        }

        public String getRemoteName() {
            return Exec.exec().getRemoteName();
        }

        public String getRemoteUser() {
            return Exec.exec().getRemoteUser();
        }

        public String getServerName() {
            return Exec.exec().getServerName();
        }

        public int getServerPort() {
            return Exec.exec().getServerPort();
        }

        public String getScheme() {
            return Exec.exec().getScheme();
        }

        public String getUserAgent() {
            return Exec.exec().getUserAgent();
        }

        public Principal getUserPrincipal() {
            return Exec.exec().getUserPrincipal();
        }

        public VariableResolver getVariableResolver() {
            return Exec.exec().getVariableResolver();
        }

        public void include(Writer writer, String page, Map params, int mode) throws IOException {
            Exec.exec().include(writer, page, params, mode);
        }

        public void include(String page) throws IOException {
            Exec.exec().include(page);
        }

        public String locate(String path) {
            return Exec.exec().locate(path);
        }

        public boolean isAsyncUpdate(Page page) {
            return Exec.exec().isAsyncUpdate(page);
        }

        public boolean isBrowser() {
            return Exec.exec().isBrowser();
        }

        public boolean isBrowser(String type) {
            return Exec.exec().isBrowser(type);
        }

        public boolean isExplorer() {
            return Exec.exec().isExplorer();
        }

        public boolean isExplorer7() {
            return Exec.exec().isExplorer7();
        }

        public boolean isOpera() {
            return Exec.exec().isOpera();
        }

        public boolean isForwarded() {
            return Exec.exec().isForwarded();
        }

        public boolean isGecko() {
            return Exec.exec().isGecko();
        }

        public boolean isGecko3() {
            return Exec.exec().isGecko3();
        }

        public boolean isHilDevice() {
            return Exec.exec().isHilDevice();
        }

        public boolean isIncluded() {
            return Exec.exec().isIncluded();
        }

        public boolean isMilDevice() {
            return Exec.exec().isMilDevice();
        }

        public boolean isRobot() {
            return Exec.exec().isRobot();
        }

        public boolean isSafari() {
            return Exec.exec().isSafari();
        }

        public boolean isUserInRole(String role) {
            return Exec.exec().isUserInRole(role);
        }

        public boolean isVoided() {
            return Exec.exec().isVoided();
        }

        public void popArg() {
            Exec.exec().popArg();
        }

        public void postEvent(Event evt) {
            Exec.exec().postEvent(evt);
        }

        public void postEvent(int priority, Event evt) {
            Exec.exec().postEvent(priority, evt);
        }

        public void pushArg(Map arg) {
            Exec.exec().pushArg(arg);
        }

        public void removeAttribute(String name) {
            Exec.exec().removeAttribute(name);
        }

        public void sendRedirect(String uri) {
            Exec.exec().sendRedirect(uri);
        }

        public void sendRedirect(String uri, String target) {
            Exec.exec().sendRedirect(uri, target);
        }

        public void setAttribute(String name, Object value) {
            Exec.exec().setAttribute(name, value);
        }

        public void setVoided(boolean voided) {
            Exec.exec().setVoided(voided);
        }

        public String toAbsoluteURI(String uri, boolean skipInclude) {
            return Exec.exec().toAbsoluteURI(uri, skipInclude);
        }

        public void addResponseHeader(String name, String value) {
            Exec.exec().addResponseHeader(name, value);
        }

        public boolean containsResponseHeader(String name) {
            return Exec.exec().containsResponseHeader(name);
        }

        public String getHeader(String name) {
            return Exec.exec().getHeader(name);
        }

        public Iterator getHeaderNames() {
            return Exec.exec().getHeaderNames();
        }

        public Iterator getHeaders(String name) {
            return Exec.exec().getHeaders(name);
        }

        public void setResponseHeader(String name, String value) {
            Exec.exec().setResponseHeader(name, value);
        }
    }

    private static class Wire {
        private final Object _controller;
        private final Set _injected;
        private final Map _fldMaps;
        private final char _separator;

        public Wire(Object controller) {
            this(controller, '$');
        }

        public Wire(Object controller, char separator) {
            this._controller = controller;
            this._separator = separator;
            this._injected = new HashSet();
            this._fldMaps = new LinkedHashMap(64);
            Class<?> cls = this._controller.getClass();
            do {
                Field[] flds = cls.getDeclaredFields();
                for (int j = 0; j < flds.length; ++j) {
                    Field fd = flds[j];
                    String fdname = fd.getName();
                    if (this._fldMaps.containsKey(fdname)) continue;
                    this._fldMaps.put(fdname, fd);
                }
            } while ((cls = cls.getSuperclass()) != null && !(class$java$lang$Object == null ? Components.class$("java.lang.Object") : class$java$lang$Object).equals(cls));
        }

        public void wireController(Component comp, String id) {
            String composerid = id + this._separator + "composer";
            if (!comp.containsVariable(composerid, true)) {
                comp.setVariable(composerid, this._controller, true);
            }
            comp.setVariable(this.varname(id, this._controller.getClass()), this._controller, true);
        }

        public void wireController(Page page, String id) {
            String composerid = id + this._separator + "composer";
            if (!page.containsVariable(composerid)) {
                page.setVariable(composerid, this._controller);
            }
            page.setVariable(this.varname(id, this._controller.getClass()), this._controller);
        }

        public void wireFellows(IdSpace idspace) {
            block5: {
                Collection fellows = idspace.getFellows();
                Iterator it = fellows.iterator();
                while (it.hasNext()) {
                    Component xcomp = (Component)it.next();
                    this.injectFellow(xcomp);
                }
                IdSpace xidspace = idspace;
                if (xidspace instanceof Component) {
                    this.wireController((Component)((Object)xidspace), ((Component)((Object)idspace)).getId());
                    while (true) {
                        Component parent;
                        if ((parent = ((Component)((Object)xidspace)).getParent()) == null) {
                            Page page = ((Component)((Object)xidspace)).getPage();
                            if (page != null) {
                                this.injectFellow(page);
                            }
                            break block5;
                        }
                        xidspace = parent.getSpaceOwner();
                        this.injectFellow(xidspace);
                    }
                }
                this.wireController((Page)xidspace, ((Component)((Object)idspace)).getId());
                this.injectFellow((Page)idspace);
            }
        }

        public void wireVariables(Page page) {
            this.wireController(page, page.getId());
            this.myWireVariables(page);
        }

        public void wireVariables(Component comp) {
            this.wireController(comp, comp.getId());
            this.myWireVariables(comp);
        }

        private void myWireVariables(Object x) {
            this.wireImplicit(x);
            this.wireOthers(x);
        }

        private void wireImplicit(Object x) {
            Iterator it = IMPLICIT_NAMES.iterator();
            while (it.hasNext()) {
                String fdname = (String)it.next();
                if ("event".equals(fdname)) continue;
                HashMap arg = this.myGetImplicit(x, fdname);
                if ("param".equals(fdname) && arg != null) {
                    arg = new HashMap(arg);
                }
                this.injectByName(arg, fdname);
            }
        }

        private void wireOthers(Object x) {
            Class<?> cls = this._controller.getClass();
            Method[] mtds = cls.getMethods();
            for (int j = 0; j < mtds.length; ++j) {
                Class<?>[] parmcls;
                String fdname;
                Method md = mtds[j];
                String mdname = md.getName();
                if (mdname.length() <= 3 || !mdname.startsWith("set") || !Character.isUpperCase(mdname.charAt(3)) || this._injected.contains(fdname = Classes.toAttributeName((String)mdname)) || (parmcls = md.getParameterTypes()).length != 1 || !this.containsVariable(x, fdname)) continue;
                Object arg = this.getVariable(x, fdname);
                Class<?> argcls = arg == null ? null : arg.getClass();
                this.injectByMethod(md, parmcls[0], argcls, arg, fdname);
            }
            Iterator it = this._fldMaps.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String fdname = (String)entry.getKey();
                if (this._injected.contains(fdname) || !this.containsVariable(x, fdname)) continue;
                Object arg = this.getVariable(x, fdname);
                Class<?> argcls = arg == null ? null : arg.getClass();
                Field fd = (Field)entry.getValue();
                this.injectField(arg, argcls, fd);
            }
        }

        private boolean containsVariable(Object x, String fdname) {
            if (x instanceof Page) {
                Page pg = (Page)x;
                return pg.getZScriptVariable(fdname) != null || pg.containsVariable(fdname);
            }
            Component cmp = (Component)x;
            Page page = Components.getPage(cmp);
            return page != null && page.getZScriptVariable(cmp, fdname) != null || cmp.containsVariable(fdname, false);
        }

        private Object getVariable(Object x, String fdname) {
            Object arg;
            if (x instanceof Page) {
                Page pg = (Page)x;
                Object arg2 = pg.getZScriptVariable(fdname);
                if (arg2 == null) {
                    arg2 = pg.getVariable(fdname);
                }
                return arg2;
            }
            Component cmp = (Component)x;
            Page page = Components.getPage(cmp);
            Object object = arg = page != null ? page.getZScriptVariable(cmp, fdname) : null;
            if (arg == null) {
                arg = cmp.getVariable(fdname, false);
            }
            return arg;
        }

        private void injectFellow(Object arg) {
            String fdname;
            String string = fdname = arg instanceof Page ? ((Page)arg).getId() : ((Component)arg).getId();
            if (!Components.isAutoId(fdname)) {
                this.injectByName(arg, fdname);
            }
        }

        private void injectByName(Object arg, String fdname) {
            if (arg != null) {
                String mdname = Classes.toMethodName((String)fdname, (String)"set");
                Class<?> parmcls = arg.getClass();
                Class<?> tgtcls = this._controller.getClass();
                try {
                    Method md = Classes.getCloseMethod(tgtcls, (String)mdname, (Class[])new Class[]{parmcls});
                    if (!this.injectByMethod(md, parmcls, parmcls, arg, fdname)) {
                        this.injectFieldByName(arg, tgtcls, parmcls, fdname);
                    }
                }
                catch (NoSuchMethodException ex) {
                    this.injectFieldByName(arg, tgtcls, parmcls, fdname);
                }
                catch (Exception ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
        }

        private void injectFieldByName(Object arg, Class tgtcls, Class parmcls, String fdname) {
            try {
                Field fd = Classes.getAnyField((Class)tgtcls, (String)fdname);
                this.injectField(arg, parmcls, fd);
            }
            catch (NoSuchFieldException e) {
            }
            catch (Exception ex2) {
                throw UiException.Aide.wrap(ex2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean injectByMethod(Method md, Class parmcls, Class argcls, Object arg, String fdname) {
            if (argcls != null && !parmcls.isAssignableFrom(argcls)) return false;
            Field fd = (Field)this._fldMaps.get(fdname);
            if (fd != null) {
                boolean old = fd.isAccessible();
                try {
                    fd.setAccessible(true);
                    Object value = fd.get(this._controller);
                    if (value != null) return false;
                    md.invoke(this._controller, arg);
                    if (fd.get(this._controller) == null) return false;
                    this._injected.add(fdname);
                    boolean bl = true;
                    return bl;
                }
                catch (Exception ex) {
                    throw UiException.Aide.wrap(ex);
                }
                finally {
                    fd.setAccessible(old);
                }
            } else {
                try {
                    md.invoke(this._controller, arg);
                    this._injected.add(fdname);
                    return true;
                }
                catch (Exception ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
        }

        private boolean injectField(Object arg, Class argcls, Field fd) {
            boolean old = fd.isAccessible();
            try {
                Object value;
                fd.setAccessible(true);
                Class<?> fdcls = fd.getType();
                if (argcls != null && fdcls.isAssignableFrom(argcls) && (value = fd.get(this._controller)) == null) {
                    fd.set(this._controller, arg);
                    this._injected.add(fd.getName());
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                throw UiException.Aide.wrap(e);
            }
            finally {
                fd.setAccessible(old);
            }
            return false;
        }

        private Object myGetImplicit(Object x, String fdname) {
            return x instanceof Page ? Components.getImplicit((Page)x, fdname) : Components.getImplicit((Component)x, fdname);
        }

        private String varname(String id, Class cls) {
            String clsname = cls.getName();
            int j = clsname.lastIndexOf(46);
            return id + this._separator + (j >= 0 ? clsname.substring(j + 1) : clsname);
        }
    }
}

