/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.idom.Namespace;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.fn.ZkFns;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.DynamicTag;
import org.zkoss.zk.ui.ext.Native;
import org.zkoss.zk.ui.impl.NativeHelpers;
import org.zkoss.zk.ui.sys.ComponentsCtrl;

public class HtmlNativeComponent
extends AbstractComponent
implements DynamicTag,
Native {
    private static Native.Helper _helper = new HtmlHelper();
    private static final String ATTR_ZKHEAD_FOUND = "org.zkoss.zk.ui.zkheadFound";
    private String _tag;
    private String _prolog = "";
    private String _epilog = "";
    private Map _props;
    private List _dns;
    private static final Set _noLFs;
    private static final Set _begNoLFs;

    public HtmlNativeComponent() {
    }

    public HtmlNativeComponent(String tag) {
        this.setTag(tag);
    }

    public HtmlNativeComponent(String tag, String prolog, String epilog) {
        this(tag);
        this._prolog = prolog != null ? prolog : "";
        this._epilog = epilog != null ? epilog : "";
    }

    public String getTag() {
        return this._tag;
    }

    public List getDeclaredNamespaces() {
        return this._dns != null ? this._dns : Collections.EMPTY_LIST;
    }

    public void addDeclaredNamespace(Namespace ns) {
        if (ns == null) {
            throw new IllegalArgumentException();
        }
        if (this._dns == null) {
            this._dns = new LinkedList();
        }
        this._dns.add(ns);
    }

    public String getPrologContent() {
        return this._prolog;
    }

    public void setPrologContent(String prolog) {
        this._prolog = prolog != null ? prolog : "";
    }

    public String getEpilogContent() {
        return this._epilog;
    }

    public void setEpilogContent(String epilog) {
        this._epilog = epilog != null ? epilog : "";
    }

    public Native.Helper getHelper() {
        return _helper;
    }

    public void setId(String id) {
        super.setId(id);
        this.setDynamicProperty("id", id);
    }

    public boolean setVisible(boolean visible) {
        throw new UnsupportedOperationException("Use client-dependent attribute, such as display:none");
    }

    public void redraw(Writer out) throws IOException {
        String zktags;
        int j;
        String tn;
        StringBuffer sb = new StringBuffer(128);
        Native.Helper helper = this.getHelper();
        helper.getFirstHalf(sb, this._tag, this._props, this._dns);
        sb.append(this._prolog);
        boolean zktagGened = this.replaceZkhead(sb, false);
        String string = tn = this._tag != null ? this._tag.toLowerCase() : "";
        if (!zktagGened && ("html".equals(tn) || "body".equals(tn) || "head".equals(tn)) && (j = HtmlNativeComponent.indexOfHead(sb)) >= 0) {
            zktagGened = true;
            zktags = ZkFns.outZkHeadHtmlTags(this.getPage());
            if (zktags != null) {
                sb.insert(j, zktags);
            }
        }
        HtmlNativeComponent.write(out, sb);
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            ((Component)it.next()).redraw(out);
        }
        sb.append(this._epilog);
        helper.getSecondHalf(sb, this._tag);
        zktagGened = this.replaceZkhead(sb, zktagGened);
        if (!zktagGened && ("html".equals(tn) || "body".equals(tn)) && (j = sb.lastIndexOf("</" + this._tag)) >= 0 && (zktags = ZkFns.outZkHeadHtmlTags(this.getPage())) != null) {
            sb.insert(j, zktags);
        }
        out.write(sb.toString());
    }

    private boolean replaceZkhead(StringBuffer sb, boolean zktagGened) {
        int j;
        Execution exec = Executions.getCurrent();
        if ((exec == null || exec.getAttribute(ATTR_ZKHEAD_FOUND) == null) && (j = sb.indexOf("<zkhead/>")) >= 0) {
            if (exec != null) {
                exec.setAttribute(ATTR_ZKHEAD_FOUND, Boolean.TRUE);
            }
            if (!zktagGened) {
                String zktags = ZkFns.outZkHeadHtmlTags(this.getPage());
                if (zktags != null) {
                    sb.replace(j, j + 9, zktags);
                    return true;
                }
                zktagGened = true;
            }
            sb.delete(j, j + 9);
        }
        return zktagGened;
    }

    private static void write(Writer out, StringBuffer sb) throws IOException {
        out.write(sb.toString());
        sb.setLength(0);
    }

    private static int indexOfHead(StringBuffer sb) {
        int j = 0;
        int len = sb.length();
        while ((j = sb.indexOf("<", j)) >= 0 && j + 6 <= len) {
            char cc;
            if ((cc = sb.charAt(++j)) != 'h' && cc != 'H' || (cc = sb.charAt(++j)) != 'e' && cc != 'E' || (cc = sb.charAt(++j)) != 'a' && cc != 'A' || (cc = sb.charAt(++j)) != 'd' && cc != 'D') continue;
            return (j = sb.indexOf(">", j + 1)) >= 0 ? j + 1 : -1;
        }
        return -1;
    }

    public void setTag(String tag) throws WrongValueException {
        this._tag = tag != null && tag.length() > 0 ? tag : null;
    }

    public boolean hasTag(String tag) {
        return true;
    }

    public boolean hasDynamicProperty(String name) {
        return ComponentsCtrl.isReservedAttribute(name);
    }

    public Object getDynamicProperty(String name) {
        return this._props != null ? this._props.get(name) : null;
    }

    public void setDynamicProperty(String name, Object value) throws WrongValueException {
        if (name == null) {
            throw new WrongValueException("name required");
        }
        if (value == null) {
            if (this._props != null) {
                this._props.remove(name);
            }
        } else {
            if (this._props == null) {
                this._props = new LinkedHashMap();
            }
            this._props.put(name, value);
        }
    }

    static {
        String[] noLFs = new String[]{"a", "abbr", "acronym", "address", "b", "basefont", "bdo", "big", "blink", "cite", "code", "del", "dfn", "dir", "em", "font", "i", "img", "input", "ins", "kbd", "q", "s", "samp", "small", "strike", "strong", "style", "sub", "sup", "u"};
        _noLFs = new HashSet((noLFs.length << 2) / 5);
        int j = noLFs.length;
        while (--j >= 0) {
            _noLFs.add(noLFs[j]);
        }
        String[] begNoLFs = new String[]{"caption", "dd", "div", "dt", "legend", "li", "p", "pre", "span", "td", "tfoot", "th", "title"};
        _begNoLFs = new HashSet((begNoLFs.length << 2) / 5);
        int j2 = begNoLFs.length;
        while (--j2 >= 0) {
            _begNoLFs.add(begNoLFs[j2]);
        }
    }

    public static class HtmlHelper
    implements Native.Helper {
        public Component newNative(String text) {
            HtmlNativeComponent nc = new HtmlNativeComponent();
            if (text != null) {
                nc.setPrologContent(text);
            }
            return nc;
        }

        public void getFirstHalf(StringBuffer sb, String tag, Map props, Collection namespaces) {
            if (tag != null) {
                sb.append('<').append(tag);
            }
            NativeHelpers.getAttributes(sb, props, namespaces);
            if (tag != null) {
                String tn = tag.toLowerCase();
                if ("zkhead".equals(tn) || HTMLs.isOrphanTag((String)tn)) {
                    sb.append('/');
                }
                sb.append('>');
                if (!_noLFs.contains(tn) && !_begNoLFs.contains(tn)) {
                    sb.append('\n');
                }
            }
        }

        public void getSecondHalf(StringBuffer sb, String tag) {
            if (tag != null) {
                String tn = tag.toLowerCase();
                if ("zkhead".equals(tn) || HTMLs.isOrphanTag((String)tn)) {
                    return;
                }
                sb.append("</").append(tag).append('>');
                if (!_noLFs.contains(tn)) {
                    sb.append('\n');
                }
            }
        }

        public void appendText(StringBuffer sb, String text) {
            sb.append(text);
        }
    }
}

