/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.lang.Exceptions;
import org.zkoss.mesg.Messages;
import org.zkoss.util.logging.Log;
import org.zkoss.web.portlet.Portlets;
import org.zkoss.web.portlet.RenderHttpServletRequest;
import org.zkoss.web.portlet.RenderHttpServletResponse;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.DHtmlLayoutServlet;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.impl.RequestInfoImpl;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinitions;
import org.zkoss.zk.ui.sys.RequestInfo;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.SessionsCtrl;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;

public class DHtmlLayoutPortlet
extends GenericPortlet {
    private static final Log log = Log.lookup((Class)DHtmlLayoutPortlet.class);
    private static final String ATTR_PAGE = "zk_page";
    private static final String ATTR_RICHLET = "zk_richlet";
    private String _defpage;

    public void init(PortletConfig conf) throws PortletException {
        super.init(conf);
        this._defpage = conf.getInitParameter(ATTR_PAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        Session sess;
        PortletPreferences prefs;
        boolean bRichlet = false;
        String path = request.getParameter(ATTR_PAGE);
        if (path == null && (path = (String)request.getAttribute(ATTR_PAGE)) == null && (path = (prefs = request.getPreferences()).getValue(ATTR_PAGE, null)) == null) {
            path = request.getParameter(ATTR_RICHLET);
            boolean bl = bRichlet = path != null;
            if (!bRichlet) {
                path = (String)request.getAttribute(ATTR_RICHLET);
                boolean bl2 = bRichlet = path != null;
                if (!bRichlet) {
                    path = prefs.getValue(ATTR_RICHLET, null);
                    boolean bl3 = bRichlet = path != null;
                    if (!bRichlet) {
                        path = this._defpage;
                    }
                }
            }
        }
        if (!SessionsCtrl.requestEnter(sess = this.getSession(request))) {
            this.handleError(sess, request, response, path, null, Messages.get((int)MZk.TOO_MANY_REQUESTS));
            return;
        }
        SessionsCtrl.setCurrent(sess);
        try {
            if (!this.process(sess, request, response, path, bRichlet)) {
                this.handleError(sess, request, response, path, null, null);
            }
        }
        catch (Throwable ex) {
            this.handleError(sess, request, response, path, ex, null);
        }
        finally {
            SessionsCtrl.requestExit(sess);
            SessionsCtrl.setCurrent(null);
        }
    }

    private Session getSession(RenderRequest request) throws PortletException {
        PortletSession psess;
        WebApp wapp = this.getWebManager().getWebApp();
        Session sess = SessionsCtrl.getSession(wapp, psess = request.getPortletSession());
        return sess != null ? sess : SessionsCtrl.newSession(wapp, psess, request);
    }

    protected boolean process(Session sess, RenderRequest request, RenderResponse response, String path, boolean bRichlet) throws PortletException, IOException {
        HttpServletResponse httpres;
        if (log.debugable()) {
            log.debug("Creates from " + path);
        }
        WebManager webman = this.getWebManager();
        WebApp wapp = webman.getWebApp();
        WebAppCtrl wappc = (WebAppCtrl)((Object)wapp);
        HttpServletRequest httpreq = RenderHttpServletRequest.getInstance((RenderRequest)request);
        Desktop desktop = webman.getDesktop(sess, (ServletRequest)httpreq, (ServletResponse)(httpres = RenderHttpServletResponse.getInstance((RenderResponse)response)), path, true);
        if (desktop == null) {
            return true;
        }
        RequestInfoImpl ri = new RequestInfoImpl(wapp, sess, desktop, httpreq, PageDefinitions.getLocator(wapp, path));
        ((SessionCtrl)((Object)sess)).notifyClientRequest(true);
        UiFactory uf = wappc.getUiFactory();
        if (uf.isRichlet(ri, bRichlet)) {
            Richlet richlet = uf.getRichlet(ri, path);
            if (richlet == null) {
                return false;
            }
            Page page = WebManager.newPage(uf, (RequestInfo)ri, richlet, (ServletResponse)httpres, path);
            ExecutionImpl exec = new ExecutionImpl((ServletContext)wapp.getNativeContext(), httpreq, httpres, desktop, page);
            if (response.getContentType() == null) {
                response.setContentType("text/html;charset=UTF-8");
            }
            wappc.getUiEngine().execNewPage((Execution)exec, richlet, page, (Writer)response.getWriter());
        } else if (path != null) {
            PageDefinition pagedef = uf.getPageDefinition(ri, path);
            if (pagedef == null) {
                return false;
            }
            Page page = WebManager.newPage(uf, (RequestInfo)ri, pagedef, (ServletResponse)httpres, path);
            ExecutionImpl exec = new ExecutionImpl((ServletContext)wapp.getNativeContext(), httpreq, httpres, desktop, page);
            if (response.getContentType() == null) {
                response.setContentType("text/html;charset=UTF-8");
            }
            wappc.getUiEngine().execNewPage((Execution)exec, pagedef, page, (Writer)response.getWriter());
        }
        return true;
    }

    private final WebManager getWebManager() throws PortletException {
        WebManager webman = (WebManager)this.getPortletContext().getAttribute("javax.zkoss.zk.ui.WebManager");
        if (webman == null) {
            throw new PortletException("The Layout Servlet not found. Make sure <load-on-startup> is specified for " + DHtmlLayoutServlet.class.getName());
        }
        return webman;
    }

    private void handleError(Session sess, RenderRequest request, RenderResponse response, String path, Throwable err, String msg) throws PortletException, IOException {
        if (err != null) {
            String errpg = sess.getWebApp().getConfiguration().getErrorPage(sess.getDeviceType(), err);
            if (errpg != null) {
                try {
                    request.setAttribute("javax.servlet.error.message", (Object)Exceptions.getMessage((Throwable)err));
                    request.setAttribute("javax.servlet.error.exception", (Object)err);
                    request.setAttribute("javax.servlet.error.exception_type", err.getClass());
                    request.setAttribute("javax.servlet.error.status_code", (Object)new Integer(500));
                    if (this.process(sess, request, response, errpg, false)) {
                        return;
                    }
                    log.warning("The error page not found: " + errpg);
                }
                catch (IOException ex) {
                }
                catch (Throwable ex) {
                    log.warning("Failed to load the error page: " + errpg, ex);
                }
            }
            if (msg == null) {
                msg = Messages.get((int)MZk.PAGE_FAILED, (Object[])new Object[]{path, Exceptions.getMessage((Throwable)err), Exceptions.formatStackTrace(null, (Throwable)err, null, (int)6)});
            }
        } else if (msg == null) {
            msg = path != null ? Messages.get((int)MZk.PAGE_NOT_FOUND, (Object[])new Object[]{path}) : Messages.get((int)MZk.PORTLET_PAGE_REQUIRED);
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("px_alert_type", "error");
        attrs.put("px_alert", msg);
        Portlets.include((PortletContext)this.getPortletContext(), (RenderRequest)request, (RenderResponse)response, (String)"~./html/alert.dsp", attrs, (int)0);
    }
}

