/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.InputStream;
import org.zkoss.io.Files;
import org.zkoss.util.Utils;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.SimpleSessionCache;
import org.zkoss.zk.ui.http.SimpleUiFactory;
import org.zkoss.zk.ui.impl.SessionDesktopCacheProvider;
import org.zkoss.zk.ui.impl.UiEngineImpl;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.DesktopCacheProvider;
import org.zkoss.zk.ui.sys.FailoverManager;
import org.zkoss.zk.ui.sys.IdGenerator;
import org.zkoss.zk.ui.sys.SessionCache;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;

public abstract class AbstractWebApp
implements WebApp,
WebAppCtrl {
    private static final Log log = Log.lookup((Class)AbstractWebApp.class);
    private String _appnm = "ZK";
    private Configuration _config;
    private UiEngine _engine;
    private DesktopCacheProvider _provider;
    private UiFactory _factory;
    private FailoverManager _failover;
    private IdGenerator _idgen;
    private SessionCache _sesscache;
    private static String _build;

    protected AbstractWebApp() {
    }

    public String getAppName() {
        return this._appnm;
    }

    public void setAppName(String name) {
        this._appnm = name != null ? name : "";
    }

    public final String getVersion() {
        return "3.6.4";
    }

    public final String getBuild() {
        return _build == null ? AbstractWebApp.loadBuild() : _build;
    }

    public int getSubversion(int portion) {
        return Utils.getSubversion((String)this.getVersion(), (int)portion);
    }

    public final Configuration getConfiguration() {
        return this._config;
    }

    public void init(Object context, Configuration config) {
        if (this._config != null) {
            throw new IllegalStateException("Cannot be initialized twice");
        }
        if (config == null) {
            throw new IllegalArgumentException("null");
        }
        WebApp oldwapp = config.getWebApp();
        if (oldwapp != null && oldwapp != this) {
            throw new IllegalArgumentException("config already belongs to other Web app, " + oldwapp);
        }
        this._config = config;
        this._config.setWebApp(this);
        Class cls = this._config.getUiEngineClass();
        if (cls == null) {
            this._engine = new UiEngineImpl();
        } else {
            try {
                this._engine = (UiEngine)cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        cls = this._config.getDesktopCacheProviderClass();
        if (cls == null) {
            this._provider = new SessionDesktopCacheProvider();
        } else {
            try {
                this._provider = (DesktopCacheProvider)cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        cls = this._config.getUiFactoryClass();
        if (cls == null) {
            this._factory = new SimpleUiFactory();
        } else {
            try {
                this._factory = (UiFactory)cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        cls = this._config.getFailoverManagerClass();
        if (cls != null) {
            try {
                this._failover = (FailoverManager)cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        if ((cls = this._config.getIdGeneratorClass()) != null) {
            try {
                this._idgen = (IdGenerator)cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        if ((cls = this._config.getSessionCacheClass()) == null) {
            this._sesscache = new SimpleSessionCache();
        } else {
            try {
                this._sesscache = (SessionCache)cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        this._engine.start(this);
        this._provider.start(this);
        this._factory.start(this);
        if (this._failover != null) {
            try {
                this._failover.start(this);
            }
            catch (AbstractMethodError ex) {
                // empty catch block
            }
        }
        this._sesscache.init(this);
        this._config.invokeWebAppInits();
    }

    public void destroy() {
        this._config.invokeWebAppCleanups();
        this._config.detroyRichlets();
        try {
            this._sesscache.destroy(this);
        }
        catch (AbstractMethodError ex) {
            // empty catch block
        }
        this._factory.stop(this);
        this._provider.stop(this);
        this._engine.stop(this);
        if (this._failover != null) {
            try {
                this._failover.stop(this);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
            this._failover = null;
        }
        this._factory = null;
        this._provider = null;
        this._engine = null;
        this._sesscache = null;
    }

    public final UiEngine getUiEngine() {
        return this._engine;
    }

    public void setUiEngine(UiEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        this._engine.stop(this);
        this._engine = engine;
        this._engine.start(this);
    }

    public DesktopCache getDesktopCache(Session sess) {
        return this._provider.getDesktopCache(sess);
    }

    public DesktopCacheProvider getDesktopCacheProvider() {
        return this._provider;
    }

    public void setDesktopCacheProvider(DesktopCacheProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        this._provider.stop(this);
        this._provider = provider;
        this._provider.start(this);
    }

    public UiFactory getUiFactory() {
        return this._factory;
    }

    public void setUiFactory(UiFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        this._factory.stop(this);
        this._factory = factory;
        this._factory.start(this);
    }

    public FailoverManager getFailoverManager() {
        return this._failover;
    }

    public void setFailoverManager(FailoverManager failover) {
        if (this._failover != null) {
            this._failover.stop(this);
        }
        this._failover = failover;
        if (this._failover != null) {
            this._failover.start(this);
        }
    }

    public IdGenerator getIdGenerator() {
        return this._idgen;
    }

    public void setIdGenerator(IdGenerator idgen) {
        this._idgen = idgen;
    }

    public SessionCache getSessionCache() {
        return this._sesscache;
    }

    public void setSessionCache(SessionCache cache) {
        if (cache == null) {
            throw new IllegalArgumentException();
        }
        this._sesscache.destroy(this);
        this._sesscache = cache;
        this._sesscache.init(this);
    }

    public void sessionWillPassivate(Session sess) {
        if (this._provider != null) {
            this._provider.sessionWillPassivate(sess);
        }
    }

    public void sessionDidActivate(Session sess) {
        this._provider.sessionDidActivate(sess);
    }

    public void sessionDestroyed(Session sess) {
        try {
            this.getDesktopCacheProvider().sessionDestroyed(sess);
        }
        catch (Throwable ex) {
            log.warning("Failed to cleanup session", ex);
        }
        try {
            this.getSessionCache().remove(sess);
        }
        catch (Throwable ex) {
            log.warning("Failed to cleanup session", ex);
        }
        try {
            ((SessionCtrl)((Object)sess)).onDestroyed();
        }
        catch (Throwable ex) {
            log.warning("Failed to cleanup session", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String loadBuild() {
        if (_build == null) {
            String FILE = "/metainfo/zk/build";
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("/metainfo/zk/build");
            if (is == null && (is = AbstractWebApp.class.getResourceAsStream("/metainfo/zk/build")) == null) {
                _build = "";
                return "";
            }
            try {
                _build = new String(Files.readAll((InputStream)is)).trim();
            }
            catch (Exception ex) {
                _build = "error";
            }
            finally {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return _build;
    }
}

