/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.util.CacheMap;
import org.zkoss.util.logging.Log;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.out.AuBookmark;
import org.zkoss.zk.device.Device;
import org.zkoss.zk.device.DeviceNotFoundException;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.DesktopUnavailableException;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.impl.EventInterceptors;
import org.zkoss.zk.ui.impl.PhantomExecution;
import org.zkoss.zk.ui.impl.RequestQueueImpl;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.EventProcessingThread;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.IdGenerator;
import org.zkoss.zk.ui.sys.PageCtrl;
import org.zkoss.zk.ui.sys.RequestQueue;
import org.zkoss.zk.ui.sys.ServerPush;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.Visualizer;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.DesktopActivationListener;
import org.zkoss.zk.ui.util.DesktopCleanup;
import org.zkoss.zk.ui.util.DesktopSerializationListener;
import org.zkoss.zk.ui.util.EventInterceptor;
import org.zkoss.zk.ui.util.ExecutionCleanup;
import org.zkoss.zk.ui.util.ExecutionInit;
import org.zkoss.zk.ui.util.Monitor;
import org.zkoss.zk.ui.util.UiLifeCycle;

public class DesktopImpl
implements Desktop,
DesktopCtrl,
Serializable {
    private static final Log log = Log.lookup((Class)DesktopImpl.class);
    private static final long serialVersionUID = 20080509L;
    private static final String DOWNLOAD_PREFIX = "dwnmed-";
    private static final String ATTR_PUSH_COUNT = "org.zkoss.zk.ui.pushes.count";
    private transient WebApp _wapp;
    private transient Session _sess;
    private String _id;
    private String _dir = "";
    private final String _path;
    private final String _updateURI;
    private final Map _pages = new LinkedHashMap(3);
    private transient Map _comps;
    private transient Map _attrs;
    private transient Execution _exec;
    private int _nextKey;
    private int _nextUuid;
    private String _uuidPrefix;
    private transient RequestQueue _rque;
    private String _bookmark = "";
    private String _devType = "ajax";
    private transient Device _dev;
    private CacheMap _meds;
    private int _medId;
    private transient ServerPush _spush;
    private final EventInterceptors _eis = new EventInterceptors();
    private transient List _dtCleans;
    private transient List _execInits;
    private transient List _execCleans;
    private transient List _uiCycles;
    private transient Visualizer _uv;
    private transient Object _uvLock;
    private transient Map _lastRes;
    private static final int MAX_RESPONSE_ID = 999;
    private int _resId;
    private boolean _piggybackListened;
    private boolean _spushShallStop;
    private static int _keyWithoutDC;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DesktopImpl(WebApp wapp, String updateURI, String path, String deviceType, Object request) {
        if (updateURI == null || wapp == null) {
            throw new IllegalArgumentException("null");
        }
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            ((ExecutionCtrl)((Object)exec)).setDesktop(this);
        }
        this._wapp = wapp;
        this._updateURI = updateURI;
        this.init();
        this._sess = Sessions.getCurrent();
        String dir = null;
        if (path != null) {
            this._path = path;
            int j = path.lastIndexOf(47);
            if (j >= 0) {
                dir = path.substring(0, j + 1);
            }
        } else {
            this._path = "";
        }
        this.setCurrentDirectory(dir);
        if (deviceType != null && deviceType.length() != 0) {
            this.setDeviceType(deviceType);
        }
        Configuration config = this._wapp.getConfiguration();
        this._exec = exec;
        try {
            Monitor monitor;
            WebAppCtrl wappc = (WebAppCtrl)((Object)this._wapp);
            DesktopCache dc = this._sess != null ? wappc.getDesktopCache(this._sess) : null;
            IdGenerator idgen = wappc.getIdGenerator();
            if (idgen != null) {
                this._id = idgen.nextDesktopId(this);
            }
            if (this._id == null) {
                this._id = DesktopImpl.nextDesktopId(dc);
            }
            this.updateUuidPrefix();
            config.invokeDesktopInits(this, request);
            if (exec != null && exec.isVoided()) {
                return;
            }
            if (dc != null) {
                dc.addDesktop(this);
            }
            if ((monitor = config.getMonitor()) != null) {
                try {
                    monitor.desktopCreated(this);
                }
                catch (Throwable ex) {
                    log.error(ex);
                }
            }
        }
        finally {
            this._exec = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String nextDesktopId(DesktopCache dc) {
        int v;
        if (dc != null) {
            return Strings.encode((StringBuffer)new StringBuffer(12).append("g"), (int)dc.getNextKey()).toString();
        }
        Class clazz = DesktopImpl.class;
        synchronized (clazz) {
            v = _keyWithoutDC++;
        }
        return Strings.encode((StringBuffer)new StringBuffer(12).append("_g"), (int)v).toString();
    }

    private void init() {
        this._uvLock = new Object();
        this._rque = this.newRequestQueue();
        this._comps = new HashMap(64);
        this._attrs = new HashMap();
        this._lastRes = new HashMap(4);
    }

    private void updateUuidPrefix() {
        this._uuidPrefix = this._id.substring(1, this._id.length() <= 2 ? 2 : 3);
    }

    public String getId() {
        return this._id;
    }

    protected RequestQueue newRequestQueue() {
        return new RequestQueueImpl();
    }

    public String getDeviceType() {
        return this._devType;
    }

    public Device getDevice() {
        if (this._dev == null) {
            this._dev = Devices.getDevice(this._devType);
        }
        return this._dev;
    }

    public void setDeviceType(String deviceType) {
        if (!this._devType.equals(deviceType)) {
            if (deviceType == null || deviceType.length() == 0) {
                throw new IllegalArgumentException("empty");
            }
            if (!Devices.exists(deviceType)) {
                throw new DeviceNotFoundException(deviceType, MZk.NOT_FOUND, deviceType);
            }
            if (!this._comps.isEmpty()) {
                throw new UiException("Unable to change the device type since some components are attached.");
            }
            this._devType = deviceType;
            this._dev = null;
            if (this._sess != null) {
                ((SessionCtrl)((Object)this._sess)).setDeviceType(this._devType);
            }
        }
    }

    public Execution getExecution() {
        return this._exec;
    }

    public final Session getSession() {
        return this._sess;
    }

    public String getUpdateURI(String pathInfo) {
        String uri;
        if (pathInfo == null || pathInfo.length() == 0) {
            uri = this._updateURI;
        } else {
            if (pathInfo.charAt(0) != '/') {
                pathInfo = '/' + pathInfo;
            }
            uri = this._updateURI + pathInfo;
        }
        return this._exec.encodeURL(uri);
    }

    public String getDynamicMediaURI(Component comp, String pathInfo) {
        if (!(((ComponentCtrl)((Object)comp)).getExtraCtrl() instanceof DynamicMedia)) {
            throw new UiException(DynamicMedia.class + " not implemented by getExtraCtrl() of " + comp);
        }
        StringBuffer sb = new StringBuffer(64).append("/view/").append(this.getId()).append('/').append(comp.getUuid());
        if (pathInfo != null && pathInfo.length() > 0) {
            if (!pathInfo.startsWith("/")) {
                sb.append('/');
            }
            sb.append(pathInfo);
        }
        return this.getUpdateURI(sb.toString());
    }

    public String getDownloadMediaURI(Media media, String pathInfo) {
        if (media == null) {
            throw new IllegalArgumentException("null media");
        }
        if (this._meds == null) {
            this._meds = new CacheMap();
            this._meds.setMaxSize(1024);
            this._meds.setLifetime(900000);
        } else {
            this.housekeep();
        }
        String medId = Strings.encode((StringBuffer)new StringBuffer(12).append(DOWNLOAD_PREFIX), (int)this._medId++).toString();
        this._meds.put((Object)medId, (Object)media);
        StringBuffer sb = new StringBuffer(64).append("/view/").append(this.getId()).append('/').append(medId);
        if (pathInfo != null && pathInfo.length() > 0) {
            if (!pathInfo.startsWith("/")) {
                sb.append('/');
            }
            sb.append(pathInfo);
        }
        return this.getUpdateURI(sb.toString());
    }

    public Media getDownloadMedia(String medId, boolean reserved) {
        return this._meds != null ? (Media)this._meds.get((Object)medId) : null;
    }

    private void housekeep() {
        if (this._meds != null) {
            this._meds.expunge();
        }
    }

    public Page getPage(String pageId) {
        Page page = this.getPageIfAny(pageId);
        if (page == null) {
            throw new ComponentNotFoundException("Page not found: " + pageId);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getPageIfAny(String pageId) {
        Map map = this._pages;
        synchronized (map) {
            return (Page)this._pages.get(pageId);
        }
    }

    public boolean hasPage(String pageId) {
        return this._pages.containsKey(pageId);
    }

    public Collection getPages() {
        return this._pages.values();
    }

    public String getBookmark() {
        return this._bookmark;
    }

    public void setBookmark(String name) {
        this.setBookmark(name, false);
    }

    public void setBookmark(String name, boolean replace) {
        if (this._exec == null) {
            throw new IllegalStateException("Not the current desktop: " + this);
        }
        if (name.indexOf(35) >= 0 || name.indexOf(63) >= 0) {
            throw new IllegalArgumentException("Illegal character: # ?");
        }
        this._bookmark = name;
        ((WebAppCtrl)((Object)this._wapp)).getUiEngine().addResponse("bookmark", new AuBookmark(name, replace));
    }

    public Collection getComponents() {
        return this._comps.values();
    }

    public Component getComponentByUuid(String uuid) {
        Component comp = (Component)this._comps.get(uuid);
        if (comp == null) {
            throw new ComponentNotFoundException("Component not found: " + uuid);
        }
        return comp;
    }

    public Component getComponentByUuidIfAny(String uuid) {
        return (Component)this._comps.get(uuid);
    }

    public void addComponent(Component comp) {
        LanguageDefinition langdef = comp.getDefinition().getLanguageDefinition();
        if (langdef != null && !this._devType.equals(langdef.getDeviceType())) {
            throw new UiException("Component, " + comp + ", does not belong to the same device type of the desktop, " + this._devType);
        }
        Component old = this._comps.put(comp.getUuid(), comp);
        if (old != comp && old != null) {
            this._comps.put(old.getUuid(), old);
            throw new InternalError("Caller shall prevent it: Register a component twice: " + comp);
        }
    }

    public void removeComponent(Component comp) {
        this._comps.remove(comp.getUuid());
    }

    public Map getAttributes() {
        return this._attrs;
    }

    public Object getAttribute(String name) {
        return this._attrs.get(name);
    }

    public Object setAttribute(String name, Object value) {
        return value != null ? this._attrs.put(name, value) : this.removeAttribute(name);
    }

    public Object removeAttribute(String name) {
        return this._attrs.remove(name);
    }

    public WebApp getWebApp() {
        return this._wapp;
    }

    public String getRequestPath() {
        return this._path;
    }

    public String getCurrentDirectory() {
        return this._dir;
    }

    public void setCurrentDirectory(String dir) {
        if (dir == null) {
            dir = "";
        } else {
            int len = dir.length() - 1;
            if (len >= 0 && dir.charAt(len) != '/') {
                dir = dir + '/';
            }
        }
        this._dir = dir;
    }

    public RequestQueue getRequestQueue() {
        this.housekeep();
        return this._rque;
    }

    public void setExecution(Execution exec) {
        this._exec = exec;
    }

    public Visualizer getVisualizer() {
        return this._uv;
    }

    public void setVisualizer(Visualizer uv) {
        this._uv = uv;
    }

    public Object getActivationLock() {
        return this._uvLock;
    }

    public int getNextKey() {
        return this._nextKey++;
    }

    public String getNextUuid() {
        return ComponentsCtrl.toAutoId(this._uuidPrefix, this._nextUuid++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPage(Page page) {
        Map map = this._pages;
        synchronized (map) {
            Page old = this._pages.put(page.getId(), page);
            if (old != null) {
                this._pages.put(old.getId(), old);
                log.warning(page == old ? "Register a page twice: " + page : "Replicated ID: " + page + "; already used by " + old);
                return;
            }
        }
        this.afterPageAttached(page, this);
        this._wapp.getConfiguration().afterPageAttached(page, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePage(Page page) {
        Map map = this._pages;
        synchronized (map) {
            if (this._pages.remove(page.getId()) == null) {
                log.warning("Removing non-exist page: " + page + "\nCurrent pages: " + this._pages.values());
                return;
            }
        }
        this.removeComponents(page.getRoots());
        this.afterPageDetached(page, this);
        this._wapp.getConfiguration().afterPageDetached(page, this);
        ((PageCtrl)((Object)page)).destroy();
    }

    private void removeComponents(Collection comps) {
        Iterator it = comps.iterator();
        while (it.hasNext()) {
            Component comp = (Component)it.next();
            this.removeComponents(comp.getChildren());
            this.removeComponent(comp);
        }
    }

    public void setBookmarkByClient(String name) {
        this._bookmark = name != null ? name : "";
    }

    public void setId(String id) {
        DesktopCache dc;
        if (!((ExecutionCtrl)((Object)this._exec)).isRecovering()) {
            throw new IllegalStateException("Callable only in recovring");
        }
        if (id == null || id.length() <= 1 || id.charAt(0) != 'g') {
            throw new IllegalArgumentException("Invalid desktop ID. You have to recover to the original value, not creating a new value: " + id);
        }
        DesktopCache desktopCache = dc = this._sess != null ? ((WebAppCtrl)((Object)this._wapp)).getDesktopCache(this._sess) : null;
        if (dc != null) {
            dc.removeDesktop(this);
        }
        this._id = id;
        this.updateUuidPrefix();
        if (dc != null) {
            dc.addDesktop(this);
        }
    }

    public void recoverDidFail(Throwable ex) {
        ((WebAppCtrl)((Object)this._wapp)).getDesktopCache(this._sess).removeDesktop(this);
    }

    public void destroy() {
        if (this._spush != null) {
            try {
                this._spush.stop();
            }
            catch (Throwable ex) {
                log.error("Failed to stop server-push, " + this._spush, ex);
            }
            this._spush = null;
        }
        Iterator it = this._pages.values().iterator();
        while (it.hasNext()) {
            PageCtrl pgc = (PageCtrl)it.next();
            try {
                pgc.destroy();
            }
            catch (Throwable ex) {
                log.error("Failed to destroy " + pgc, ex);
            }
        }
        this._pages.clear();
        this._attrs.clear();
        this._comps = new HashMap(2);
        this._meds = null;
        this._rque = null;
    }

    public boolean isAlive() {
        return this._rque != null;
    }

    public Collection getSuspendedThreads() {
        return ((WebAppCtrl)((Object)this._wapp)).getUiEngine().getSuspendedThreads(this);
    }

    public boolean ceaseSuspendedThread(EventProcessingThread evtthd, String cause) {
        return ((WebAppCtrl)((Object)this._wapp)).getUiEngine().ceaseSuspendedThread(this, evtthd, cause);
    }

    public String toString() {
        return "[Desktop " + this._id + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionWillPassivate(Session sess) {
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            this.sessWillPassivate();
        } else {
            exec = new PhantomExecution(this);
            UiEngine uieng = ((WebAppCtrl)((Object)this._wapp)).getUiEngine();
            uieng.activate(exec);
            try {
                this.sessWillPassivate();
            }
            finally {
                uieng.deactivate(exec);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDidActivate(Session sess) {
        this._sess = sess;
        this._wapp = sess.getWebApp();
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            this.sessDidActivate();
        } else {
            exec = new PhantomExecution(this);
            UiEngine uieng = ((WebAppCtrl)((Object)this._wapp)).getUiEngine();
            uieng.activate(exec);
            try {
                this.sessDidActivate();
            }
            finally {
                uieng.deactivate(exec);
            }
        }
    }

    private void sessWillPassivate() {
        Iterator it = this._pages.values().iterator();
        while (it.hasNext()) {
            ((PageCtrl)it.next()).sessionWillPassivate(this);
        }
        if (this._dev != null) {
            this._dev.sessionWillPassivate(this);
        }
        this.willPassivate(this._attrs.values());
        this.willPassivate(this._dtCleans);
        this.willPassivate(this._execInits);
        this.willPassivate(this._execCleans);
        this.willPassivate(this._uiCycles);
    }

    private void sessDidActivate() {
        if (this._dev != null) {
            this._dev.sessionDidActivate(this);
        }
        Iterator it = this._pages.values().iterator();
        while (it.hasNext()) {
            ((PageCtrl)it.next()).sessionDidActivate(this);
        }
        this.didActivate(this._attrs.values());
        this.didActivate(this._dtCleans);
        this.didActivate(this._execInits);
        this.didActivate(this._execCleans);
        this.didActivate(this._uiCycles);
    }

    private void willPassivate(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.willPassivate(it.next());
            }
        }
    }

    private void willPassivate(Object o) {
        if (o instanceof DesktopActivationListener) {
            ((DesktopActivationListener)o).willPassivate(this);
        }
    }

    private void didActivate(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.didActivate(it.next());
            }
        }
    }

    private void didActivate(Object o) {
        if (o instanceof DesktopActivationListener) {
            ((DesktopActivationListener)o).didActivate(this);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.willSerialize(this._attrs.values());
        Serializables.smartWrite((ObjectOutputStream)s, (Map)this._attrs);
        this.willSerialize(this._dtCleans);
        Serializables.smartWrite((ObjectOutputStream)s, (Collection)this._dtCleans);
        this.willSerialize(this._execInits);
        Serializables.smartWrite((ObjectOutputStream)s, (Collection)this._execInits);
        this.willSerialize(this._execCleans);
        Serializables.smartWrite((ObjectOutputStream)s, (Collection)this._execCleans);
        this.willSerialize(this._uiCycles);
        Serializables.smartWrite((ObjectOutputStream)s, (Collection)this._uiCycles);
        s.writeBoolean(this._spush != null);
    }

    private void willSerialize(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.willSerialize(it.next());
            }
        }
    }

    private void willSerialize(Object o) {
        if (o instanceof DesktopSerializationListener) {
            ((DesktopSerializationListener)o).willSerialize(this);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        Iterator it = this._pages.values().iterator();
        while (it.hasNext()) {
            Iterator e = ((Page)it.next()).getRoots().iterator();
            while (e.hasNext()) {
                this.addAllComponents((Component)e.next());
            }
        }
        Serializables.smartRead((ObjectInputStream)s, (Map)this._attrs);
        this._dtCleans = (List)Serializables.smartRead((ObjectInputStream)s, (Collection)this._dtCleans);
        this._execInits = (List)Serializables.smartRead((ObjectInputStream)s, (Collection)this._execInits);
        this._execCleans = (List)Serializables.smartRead((ObjectInputStream)s, (Collection)this._execCleans);
        this._uiCycles = (List)Serializables.smartRead((ObjectInputStream)s, (Collection)this._uiCycles);
        this.didDeserialize(this._attrs.values());
        this.didDeserialize(this._dtCleans);
        this.didDeserialize(this._execInits);
        this.didDeserialize(this._execCleans);
        this.didDeserialize(this._uiCycles);
        if (s.readBoolean()) {
            this.enableServerPush(true);
        }
    }

    private void didDeserialize(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.didDeserialize(it.next());
            }
        }
    }

    private void didDeserialize(Object o) {
        if (o instanceof DesktopSerializationListener) {
            ((DesktopSerializationListener)o).didDeserialize(this);
        }
    }

    private void addAllComponents(Component comp) {
        this.addComponent(comp);
        Iterator it = comp.getChildren().iterator();
        while (it.hasNext()) {
            this.addAllComponents((Component)it.next());
        }
    }

    public void addListener(Object listener) {
        boolean added = false;
        if (listener instanceof EventInterceptor) {
            this._eis.addEventInterceptor((EventInterceptor)listener);
            added = true;
        }
        if (listener instanceof DesktopCleanup) {
            this._dtCleans = this.addListener0(this._dtCleans, listener);
            added = true;
        }
        if (listener instanceof ExecutionInit) {
            this._execInits = this.addListener0(this._execInits, listener);
            added = true;
        }
        if (listener instanceof ExecutionCleanup) {
            this._execCleans = this.addListener0(this._execCleans, listener);
            added = true;
        }
        if (listener instanceof UiLifeCycle) {
            this._uiCycles = this.addListener0(this._uiCycles, listener);
            added = true;
        }
        if (!added) {
            throw new IllegalArgumentException("Unknown listener: " + listener);
        }
    }

    private List addListener0(List list, Object listener) {
        if (list == null) {
            list = new LinkedList<Object>();
        }
        list.add(listener);
        return list;
    }

    public boolean removeListener(Object listener) {
        boolean found = false;
        if (listener instanceof EventInterceptor && this._eis.removeEventInterceptor((EventInterceptor)listener)) {
            found = true;
        }
        if (listener instanceof DesktopCleanup && this.removeListener0(this._dtCleans, listener)) {
            found = true;
        }
        if (listener instanceof ExecutionInit && this.removeListener0(this._execInits, listener)) {
            found = true;
        }
        if (listener instanceof ExecutionCleanup && this.removeListener0(this._execCleans, listener)) {
            found = true;
        }
        if (listener instanceof UiLifeCycle && this.removeListener0(this._uiCycles, listener)) {
            found = true;
        }
        return found;
    }

    private boolean removeListener0(List list, Object listener) {
        if (list != null && listener != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                if (!it.next().equals(listener)) continue;
                it.remove();
                return true;
            }
        }
        return false;
    }

    public void addEventInterceptor(EventInterceptor ei) {
        this.addListener(ei);
    }

    public boolean removeEventInterceptor(EventInterceptor ei) {
        return this.removeListener(ei);
    }

    public Event beforeSendEvent(Event event) {
        if ((event = this._eis.beforeSendEvent(event)) != null) {
            event = this._wapp.getConfiguration().beforeSendEvent(event);
        }
        return event;
    }

    public Event beforePostEvent(Event event) {
        if ((event = this._eis.beforePostEvent(event)) != null) {
            event = this._wapp.getConfiguration().beforePostEvent(event);
        }
        return event;
    }

    public Event beforeProcessEvent(Event event) {
        if ((event = this._eis.beforeProcessEvent(event)) != null) {
            event = this._wapp.getConfiguration().beforeProcessEvent(event);
        }
        return event;
    }

    public void afterProcessEvent(Event event) {
        this._eis.afterProcessEvent(event);
        this._wapp.getConfiguration().afterProcessEvent(event);
    }

    public void invokeDesktopCleanups() {
        if (this._dtCleans != null) {
            Iterator it = this._dtCleans.iterator();
            while (it.hasNext()) {
                DesktopCleanup listener = (DesktopCleanup)it.next();
                try {
                    listener.cleanup(this);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + listener, ex);
                }
            }
        }
    }

    public void invokeExecutionInits(Execution exec, Execution parent) throws UiException {
        if (this._execInits != null) {
            Iterator it = this._execInits.iterator();
            while (it.hasNext()) {
                try {
                    ((ExecutionInit)it.next()).init(exec, parent);
                }
                catch (Throwable ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
        }
    }

    public void invokeExecutionCleanups(Execution exec, Execution parent, List errs) {
        if (this._execCleans != null) {
            Iterator it = this._execCleans.iterator();
            while (it.hasNext()) {
                ExecutionCleanup listener = (ExecutionCleanup)it.next();
                try {
                    listener.cleanup(exec, parent, errs);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + listener, ex);
                    if (errs == null) continue;
                    errs.add(ex);
                }
            }
        }
    }

    public void afterComponentAttached(Component comp, Page page) {
        if (this._uiCycles != null) {
            Iterator it = this._uiCycles.iterator();
            while (it.hasNext()) {
                UiLifeCycle listener = (UiLifeCycle)it.next();
                try {
                    listener.afterComponentAttached(comp, page);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + listener, ex);
                }
            }
        }
    }

    public void afterComponentDetached(Component comp, Page prevpage) {
        if (this._uiCycles != null) {
            Iterator it = this._uiCycles.iterator();
            while (it.hasNext()) {
                UiLifeCycle listener = (UiLifeCycle)it.next();
                try {
                    listener.afterComponentDetached(comp, prevpage);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + listener, ex);
                }
            }
        }
    }

    public void afterComponentMoved(Component parent, Component child, Component prevparent) {
        if (this._uiCycles != null) {
            Iterator it = this._uiCycles.iterator();
            while (it.hasNext()) {
                UiLifeCycle listener = (UiLifeCycle)it.next();
                try {
                    listener.afterComponentMoved(parent, child, prevparent);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + listener, ex);
                }
            }
        }
    }

    private void afterPageAttached(Page page, Desktop desktop) {
        if (this._uiCycles != null) {
            Iterator it = this._uiCycles.iterator();
            while (it.hasNext()) {
                UiLifeCycle listener = (UiLifeCycle)it.next();
                try {
                    listener.afterPageAttached(page, desktop);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + listener, ex);
                }
            }
        }
    }

    private void afterPageDetached(Page page, Desktop prevdesktop) {
        if (this._uiCycles != null) {
            Iterator it = this._uiCycles.iterator();
            while (it.hasNext()) {
                UiLifeCycle listener = (UiLifeCycle)it.next();
                try {
                    listener.afterPageDetached(page, prevdesktop);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + listener, ex);
                }
            }
        }
    }

    public boolean enableServerPush(boolean enable) {
        boolean old;
        if (this._sess == null) {
            throw new IllegalStateException("Server push cannot be enabled in a working thread");
        }
        boolean bl = old = this._spush != null;
        if (old != enable) {
            int cnt;
            Integer icnt = (Integer)this._sess.getAttribute(ATTR_PUSH_COUNT);
            int n = cnt = icnt != null ? icnt : 0;
            if (enable) {
                int maxcnt = this._wapp.getConfiguration().getSessionMaxPushes();
                if (maxcnt >= 0 && cnt >= maxcnt) {
                    throw new UiException(cnt > 0 ? "Too many concurrent push connections per session: " + cnt : "Server push is disabled");
                }
                Class cls = this.getDevice().getServerPushClass();
                if (cls == null) {
                    throw new UiException("No server push defined. Make sure you are using the professional or enterprise edition, or you configured your own implementation");
                }
                try {
                    this._spush = (ServerPush)cls.newInstance();
                }
                catch (Throwable ex) {
                    throw UiException.Aide.wrap(ex, "Unable to instantiate " + cls);
                }
                this._spush.start(this);
                ++cnt;
            } else if (this._spush.isActive()) {
                this._spushShallStop = true;
                --cnt;
            } else {
                this._spush.stop();
                this._spush = null;
                --cnt;
            }
            this._sess.setAttribute(ATTR_PUSH_COUNT, new Integer(cnt));
        }
        return old;
    }

    public boolean enableServerPush(ServerPush serverpush) {
        boolean old;
        if (serverpush == null) {
            return this.enableServerPush(false);
        }
        boolean bl = old = this._spush != null;
        if (!old || serverpush != this._spush) {
            if (old) {
                this.enableServerPush(false);
            }
            this._spush = serverpush;
            this._spush.start(this);
        }
        return old;
    }

    public boolean isServerPushEnabled() {
        return this._spush != null;
    }

    public ServerPush getServerPush() {
        return this._spush;
    }

    public boolean activateServerPush(long timeout) throws InterruptedException {
        if (this._spush == null) {
            if (this.isAlive()) {
                throw new IllegalStateException("Before activation, the server push must be enabled for " + this);
            }
            throw new DesktopUnavailableException("Stopped");
        }
        if (Events.inEventListener()) {
            throw new IllegalStateException("No need to invoke Executions.activate() in an event listener");
        }
        return this._spush.activate(timeout);
    }

    public void deactivateServerPush() {
        if (this._spush != null && this._spush.deactivate(this._spushShallStop)) {
            this._spushShallStop = false;
            this._spush = null;
        }
    }

    public void setServerPushDelay(int min, int max, int factor) {
        if (this._spush == null) {
            throw new IllegalStateException("Not started");
        }
        this._spush.setDelay(min, max, factor);
    }

    public void onPiggybackListened(Component comp, boolean listen) {
        if (listen) {
            this._piggybackListened = true;
        }
    }

    public void onPiggyback() {
        if (this._piggybackListened) {
            Iterator it = this._pages.values().iterator();
            while (it.hasNext()) {
                Page p = (Page)it.next();
                if (!Executions.getCurrent().isAsyncUpdate(p)) continue;
                Iterator e = p.getRoots().iterator();
                while (e.hasNext()) {
                    Component c = (Component)e.next();
                    if (!Events.isListened(c, "onPiggyback", false)) continue;
                    Events.postEvent(new Event("onPiggyback", c));
                }
            }
        }
        if (this._spush != null) {
            this._spush.onPiggyback();
        }
    }

    public void responseSent(String channel, String reqId, Object response) {
        if (reqId != null) {
            this._lastRes.put(channel, new Object[]{reqId, response});
        }
    }

    public Object getLastResponse(String channel, String reqId) {
        Object[] info = (Object[])this._lastRes.get(channel);
        return info != null && Objects.equals((Object)reqId, (Object)info[0]) ? info[1] : null;
    }

    public int getResponseId(boolean advance) {
        if (advance && ++this._resId > 999) {
            this._resId = 1;
        }
        return this._resId;
    }

    public void setResponseId(int resId) {
        if (resId > 999) {
            throw new IllegalArgumentException("Invalid response ID: " + resId);
        }
        this._resId = resId < 0 ? 0 : resId;
    }

    public void invalidate() {
        Iterator it = this._pages.values().iterator();
        while (it.hasNext()) {
            Page page = (Page)it.next();
            if (((PageCtrl)((Object)page)).getOwner() != null) continue;
            page.invalidate();
        }
    }
}

